/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.chronos;

import com.csi.ctfclient.tools.devices.generic.ExcecaoPortaSerial;
import com.csi.ctfclient.tools.devices.generic.PortaSerial;
import com.csi.ctfclient.tools.services.exceptions.ExcecaoLocal;
import java.io.IOException;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;

final class ProtocoloChronos
implements SerialPortEventListener {
    public static final int LEITOR_EM_USO = 1;
    public static final int LEITOR_LIVRE = 0;
    public static PortaSerial porta = new PortaSerial();
    private static ProtocoloChronos instancia = null;
    private static boolean comunicacaoAberta = false;
    private static Integer qtdAberturas = 0;
    private final String baudRatio;
    private final String dataBits;
    private final String parity;
    private final String serial;
    private final String stopBits;
    private boolean cancelaEnvioComando;
    private int usandoProtocolo = 0;

    private ProtocoloChronos(String serial, String baudRatio, String dataBits, String parity, String stopBits) throws ExcecaoLocal {
        this.serial = serial;
        this.baudRatio = baudRatio;
        this.dataBits = dataBits;
        this.parity = parity;
        this.stopBits = stopBits;
        this.abrirComunicacao();
    }

    public static synchronized ProtocoloChronos getInstanciaProtocolo(String serial, String baudRatio, String dataBits, String parity, String stopBits) throws ExcecaoLocal {
        if (instancia == null) {
            instancia = new ProtocoloChronos(serial, baudRatio, dataBits, parity, stopBits);
        }
        return instancia;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void fecharComunicacao() {
        Integer n = qtdAberturas;
        synchronized (n) {
            int qtd = qtdAberturas;
            if (qtd == 0) {
                return;
            }
            qtdAberturas = --qtd;
            if (qtd == 0) {
                porta.fecharPortaSerial();
                comunicacaoAberta = false;
            }
        }
    }

    @Override
    public void serialEvent(SerialPortEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void abrirComunicacao() throws ExcecaoPortaSerial {
        Integer n = qtdAberturas;
        synchronized (n) {
            qtdAberturas = qtdAberturas + 1;
            if (comunicacaoAberta) {
                return;
            }
            porta.abrirPortaSerial(this, this.serial, this.baudRatio, this.dataBits, this.parity, this.stopBits);
            ProtocoloChronos.porta.port.setRTS(true);
            ProtocoloChronos.porta.port.setDTR(true);
            ProtocoloChronos.porta.port.setInputBufferSize(2048);
            ProtocoloChronos.porta.port.setOutputBufferSize(2048);
            comunicacaoAberta = true;
            try {
                this.limpaSerial();
            }
            catch (IOException e) {
                throw new ExcecaoPortaSerial("PER83", e);
            }
        }
    }

    public void cmdCheque(byte cmd) throws IOException {
        this.limpaSerial();
        ProtocoloChronos.porta.out.write(27);
        ProtocoloChronos.porta.out.write(cmd);
    }

    protected boolean getCancelaEnvioComando() {
        return this.cancelaEnvioComando;
    }

    protected void setCancelaEnvioComando(boolean cancela) {
        this.cancelaEnvioComando = cancela;
    }

    public int getUsandoProtocolo() {
        return this.usandoProtocolo;
    }

    public void setUsandoProtocolo(int uso) {
        this.usandoProtocolo = uso;
    }

    public void limpaSerial() throws IOException {
        while (ProtocoloChronos.porta.in.available() > 0) {
            ProtocoloChronos.porta.in.read();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized byte[] recebeCMC7(int timeout) {
        long marcador = System.currentTimeMillis();
        try {
            long tempoDecorrido = 0L;
            while ((long)timeout > tempoDecorrido && ProtocoloChronos.porta.in.available() == 0 && !this.getCancelaEnvioComando()) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                tempoDecorrido = System.currentTimeMillis() - marcador;
            }
            if (this.getCancelaEnvioComando()) {
                return null;
            }
            int aux = -1;
            if (ProtocoloChronos.porta.in.available() > 0) {
                aux = (byte)porta.receberByteTimeout(100);
            }
            int numBytesLidos = 0;
            byte[] bufferLeitura = new byte[50];
            if (aux == -1) {
                return null;
            }
            if (aux > 0) {
                bufferLeitura[0] = aux;
                numBytesLidos = 1;
            }
            while (true) {
                byte by = (byte)porta.receberByteTimeout(800);
                aux = by;
                if (by < 0) return null;
                if (aux != 0 && aux != 10 && aux != 13) {
                    bufferLeitura[numBytesLidos] = aux;
                    ++numBytesLidos;
                    continue;
                }
                if (aux == 13) return bufferLeitura;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public int statusImpressora() {
        try {
            ProtocoloChronos.porta.out.write(0);
            ProtocoloChronos.porta.out.flush();
        }
        catch (IOException e) {
            return -1;
        }
        return porta.receberByteTimeout(1000);
    }
}

