/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.chronos;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoLeitorDocumento;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.LeitorDocumento;
import com.csi.ctfclient.tools.devices.chronos.ProtocoloChronos;
import com.csi.ctfclient.tools.devices.generic.ExcecaoPortaSerial;
import com.csi.ctfclient.tools.services.exceptions.ExcecaoLocal;
import java.io.IOException;

public class LeitorDocumentoChronos
extends LeitorDocumento
implements Runnable {
    private final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(LeitorDocumentoChronos.class);
    private boolean leitorFinalizado = false;
    private Thread leitorThread;
    private final ProtocoloChronos protocolo;
    private volatile boolean threadPronta = false;

    public LeitorDocumentoChronos(String porta, String speed, String databits, String parity, String stopbits) throws ExcecaoPerifericos {
        try {
            this.protocolo = ProtocoloChronos.getInstanciaProtocolo(porta, speed, databits, parity, stopbits);
        }
        catch (ExcecaoLocal e) {
            throw new ExcecaoPerifericos("LDC01", String.format("Erro na instanciacao do protocolo (%s, %s, %s, %s, %s)", porta, speed, databits, parity, stopbits), e.getMessage());
        }
        if (this.protocolo.statusImpressora() == -1) {
            throw new ExcecaoPerifericos("LDC02", String.format("Timeout na comunicacao com o leitor (%s, %s, %s, %s, %s)", porta, speed, databits, parity, stopbits));
        }
        this.leitorThread = new Thread(this);
        this.leitorThread.start();
        while (!this.threadPronta) {
        }
    }

    @Override
    public void liberaRecursos() throws ExcecaoPerifericos {
        this.desabilita();
        this.leitorFinalizado = true;
        this.leitorThread = null;
        super.liberaRecursos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.leitorFinalizado) {
            while (!this.getHabilitado()) {
                this.threadPronta = true;
                LeitorDocumentoChronos leitorDocumentoChronos = this;
                synchronized (leitorDocumentoChronos) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this.leitorFinalizado) continue;
                return;
            }
            try {
                this.protocolo.cmdCheque((byte)89);
                this.protocolo.cmdCheque((byte)90);
            }
            catch (IOException e) {
                this.erroOcorrido("PER83", 0);
            }
            byte[] CMC7 = this.protocolo.recebeCMC7(40000);
            try {
                if (CMC7 != null) {
                    String str = new String(CMC7);
                    this.codigoLido(str, 0);
                } else {
                    EventoLeitorDocumento evt = new EventoLeitorDocumento(this, "", 0, true, true, "PER83");
                    this.eventoOcorrido(evt);
                }
                this.protocolo.cmdCheque((byte)83);
                this.protocolo.cmdCheque((byte)87);
            }
            catch (IOException e) {
                this.erroOcorrido("PER83", 0);
            }
            this.setHabilitado(false);
        }
    }

    @Override
    public synchronized void desabilita() throws ExcecaoPerifericos {
        if (this.protocolo.getUsandoProtocolo() == 1) {
            this.protocolo.setCancelaEnvioComando(true);
            this.protocolo.setUsandoProtocolo(0);
        }
        if (this.getHabilitado()) {
            try {
                this.protocolo.cmdCheque((byte)83);
                this.protocolo.cmdCheque((byte)87);
            }
            catch (IOException e) {
                this.logger.warn("N\u00e3o foi poss\u00edvel enviar comandos para desabilitar: " + e.getMessage());
            }
            this.protocolo.fecharComunicacao();
            this.protocolo.setUsandoProtocolo(0);
            this.setHabilitado(false);
            this.notifyAll();
        }
    }

    @Override
    public synchronized void habilita() throws ExcecaoPerifericos {
        try {
            this.protocolo.abrirComunicacao();
            this.setHabilitado(true);
            this.protocolo.setCancelaEnvioComando(false);
            this.protocolo.setUsandoProtocolo(1);
            if ((this.protocolo.statusImpressora() & 4) == 0) {
                this.erroOcorrido("PER83", 0);
            }
            this.notifyAll();
        }
        catch (ExcecaoPortaSerial e) {
            throw new ExcecaoPerifericos("LDC03", "Erro na configuracao da porta serial", e.getMessage());
        }
    }
}

