/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.PerifericoEntradaDadosListener;
import com.csi.ctfclient.tools.util.ClassUtil;
import java.text.MessageFormat;
import java.util.Vector;

public abstract class PerifericoEntradaDados
extends Periferico {
    public static final long TIMEOUT_SUSPENSAO_DEFAULT = 50L;
    private final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(PerifericoEntradaDados.class);
    private boolean emSuspensao;
    FilaEventos filaEventos = new FilaEventos();
    ThreadDisparaEventos threadEventos = new ThreadDisparaEventos();
    boolean emLeituraSincrona = false;
    EventoDispositivoEntrada evtLeValor = null;
    private final Vector<PerifericoEntradaDadosListener> ouvintesBuf = new Vector();
    private final Vector<PerifericoEntradaDadosListener> ouvintesNaoBuf = new Vector();

    public void setEmSuspensao(boolean emSuspensao) {
        this.emSuspensao = emSuspensao;
    }

    public boolean isEmSuspensao() {
        return this.emSuspensao;
    }

    public synchronized void addListener(PerifericoEntradaDadosListener ouvinte) {
        this.addListener(ouvinte, true);
    }

    public synchronized void addListener(PerifericoEntradaDadosListener ouvinte, boolean utilizarBuffer) {
        if (utilizarBuffer) {
            this.ouvintesBuf.add(ouvinte);
            this.logger.debug(MessageFormat.format("{0}: adicionado ouvinte bufferizado {1}", ClassUtil.getSimpleClassName(this), ouvinte));
        } else {
            this.ouvintesNaoBuf.add(ouvinte);
            this.logger.debug(MessageFormat.format("{0}: adicionado ouvinte nao-bufferizado {1}", ClassUtil.getSimpleClassName(this), ouvinte));
        }
    }

    protected synchronized void eventoOcorrido(EventoDispositivoEntrada evt) {
        String thisSimpleClassName = ClassUtil.getSimpleClassName(this);
        String evtSimpleClassName = ClassUtil.getSimpleClassName(evt);
        this.logger.debug(MessageFormat.format("{0}: ocorrido o evento {1}", thisSimpleClassName, evtSimpleClassName));
        if (this.emLeituraSincrona) {
            this.logger.debug(MessageFormat.format("{0}: notificando leitura sincrona", thisSimpleClassName));
            this.evtLeValor = evt;
            this.notifyAll();
            return;
        }
        if (this.ouvintesBuf.size() > 0) {
            this.logger.debug(MessageFormat.format("{0}: inserindo {1} na fila e notificando ouvintes", thisSimpleClassName, evtSimpleClassName));
            this.filaEventos.inserirEvento(evt);
            this.threadEventos.prossegue();
        }
        if (this.ouvintesNaoBuf.size() > 0) {
            this.logger.debug("Classes a serem notificadas, nao-bufferizadas: {}", this.ouvintesNaoBuf);
            for (PerifericoEntradaDadosListener listener : this.ouvintesNaoBuf) {
                this.logger.debug(MessageFormat.format("{0}: notificando ouvinte nao-bufferizado {1}", thisSimpleClassName, listener));
                listener.eventoOcorrido(evt);
            }
        }
    }

    public synchronized EventoDispositivoEntrada leValor() throws ExcecaoPerifericos {
        EventoDispositivoEntrada evt = this.filaEventos.obterProximoEvento();
        if (evt == null) {
            this.logger.debug(MessageFormat.format("{0}: nenhum evento na fila, chamando leitura direta", ClassUtil.getSimpleClassName(this)));
            evt = this.leValorDireto(true);
        }
        this.logger.debug(MessageFormat.format("{0}: obtido {1}", ClassUtil.getSimpleClassName(this), ClassUtil.getSimpleClassName(evt)));
        return evt;
    }

    public synchronized void limpaFilaEventos() {
        this.logger.debug(MessageFormat.format("{0}: limpando fila de eventos", ClassUtil.getSimpleClassName(this)));
        this.filaEventos.limparEventos();
    }

    @Override
    public synchronized void desabilita() throws ExcecaoPerifericos {
        this.logger.debug(MessageFormat.format("{0}: desabilitando", ClassUtil.getSimpleClassName(this)));
        this.limpaFilaEventos();
    }

    @Override
    public synchronized void liberaRecursos() throws ExcecaoPerifericos {
        this.logger.debug(MessageFormat.format("{0}: liberando recursos...", ClassUtil.getSimpleClassName(this)));
        if (this.getHabilitado()) {
            this.desabilita();
        } else {
            this.logger.debug(MessageFormat.format("{0}: estava desabilitado", ClassUtil.getSimpleClassName(this)));
        }
        this.logger.debug(MessageFormat.format("{0}: finalizando thread", ClassUtil.getSimpleClassName(this)));
        this.threadEventos.finaliza();
        this.logger.debug(MessageFormat.format("{0}: recursos liberados", ClassUtil.getSimpleClassName(this)));
    }

    public synchronized void removeListener(PerifericoEntradaDadosListener ouvinte) {
        if (this.ouvintesBuf.remove(ouvinte)) {
            this.logger.debug("{}: removido ouvinte bufferizado {}", ClassUtil.getSimpleClassName(this), ouvinte);
        }
        if (this.ouvintesNaoBuf.remove(ouvinte)) {
            this.logger.debug("{}: removido ouvinte nao-bufferizado {}", ClassUtil.getSimpleClassName(this), ouvinte);
        }
    }

    public synchronized EventoDispositivoEntrada leValorDireto(boolean paralisaFila) throws ExcecaoPerifericos {
        String thisSimpleClassName = ClassUtil.getSimpleClassName(this);
        boolean isDebugEnabled = this.logger.isDebugEnabled();
        this.logger.debug("{}: lendo valor diretamente, paralisaFila = {}", thisSimpleClassName, paralisaFila);
        if (!this.getHabilitado()) {
            this.logger.debug(MessageFormat.format("{0}: nao habilitado", thisSimpleClassName));
            throw new ExcecaoPerifericos("PED01", thisSimpleClassName + " nao esta habilitado");
        }
        this.emLeituraSincrona = true;
        if (paralisaFila) {
            this.threadEventos.pausa();
        }
        EventoDispositivoEntrada retorno = this.evtLeValor;
        while (retorno == null) {
            try {
                this.logger.debug("{}: esperando notificacao...", thisSimpleClassName);
                this.wait();
                this.logger.debug("saiu do wait do leValorDireto");
            }
            catch (Exception e) {
                this.logger.debug("{}: erro em leitura direta: {}", thisSimpleClassName, e.getMessage());
            }
            retorno = this.evtLeValor;
            if (!isDebugEnabled) continue;
            this.logger.debug("{}: recebido {}", thisSimpleClassName, ClassUtil.getSimpleClassName(retorno));
        }
        if (paralisaFila) {
            this.threadEventos.prossegue();
        }
        this.emLeituraSincrona = false;
        this.evtLeValor = null;
        return retorno;
    }

    protected void esperaSeEmSuspensao() {
        this.esperaSeEmSuspensao(50L);
    }

    protected void esperaSeEmSuspensao(long timeout) {
        boolean suspendeu = this.isEmSuspensao();
        while (this.isEmSuspensao()) {
            this.logger.trace("Em suspens\u00e3o");
            try {
                Thread.sleep(timeout);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (suspendeu) {
            this.logger.debug(MessageFormat.format("{0}: fim da suspensao", ClassUtil.getSimpleClassName(this)));
        }
    }

    private class ThreadDisparaEventos
    extends Thread {
        private boolean finalizada = false;
        private boolean pausada = false;

        public ThreadDisparaEventos() {
            PerifericoEntradaDados.this.logger.debug("Iniciada a thread ThreadDisparaEventos");
            this.start();
        }

        public synchronized void finaliza() {
            if (PerifericoEntradaDados.this.logger.isDebugEnabled()) {
                PerifericoEntradaDados.this.logger.debug("Finaliza thread e notifica todos nesse objeto {}", this);
            }
            if (this.finalizada) {
                PerifericoEntradaDados.this.logger.error("Thread j\u00e1 est\u00e1 finalizada e precisa ser recriada para que o finalizada tenha efeito");
            } else {
                this.finalizada = true;
                this.notifyAll();
            }
        }

        public void pausa() {
            if (PerifericoEntradaDados.this.logger.isDebugEnabled()) {
                PerifericoEntradaDados.this.logger.debug("Pausa thread nesse objeto {}", this);
            }
            if (this.finalizada) {
                PerifericoEntradaDados.this.logger.error("Thread j\u00e1 est\u00e1 finalizada e precisa ser recriada para que o pausa tenha efeito");
            } else {
                this.pausada = true;
            }
        }

        public synchronized void prossegue() {
            if (PerifericoEntradaDados.this.logger.isDebugEnabled()) {
                PerifericoEntradaDados.this.logger.debug("Notifica outras threads nesse objeto {}", this);
            }
            if (this.finalizada) {
                PerifericoEntradaDados.this.logger.error("Thread j\u00e1 est\u00e1 finalizada e precisa ser recriada para que o prossegue tenha efeito");
            } else {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PerifericoEntradaDados.this.logger.debug("Iniciando run da thread");
            boolean isDebugEnabled = PerifericoEntradaDados.this.logger.isDebugEnabled();
            while (!this.finalizada) {
                EventoDispositivoEntrada evt;
                do {
                    if ((evt = PerifericoEntradaDados.this.filaEventos.obterProximoEvento()) == null || PerifericoEntradaDados.this.ouvintesBuf.size() <= 0) continue;
                    PerifericoEntradaDados.this.logger.debug("Classes a serem notificadas, bufferizadas: {}", PerifericoEntradaDados.this.ouvintesBuf);
                    for (PerifericoEntradaDadosListener perifericoEntradaDadosListener : PerifericoEntradaDados.this.ouvintesBuf) {
                        perifericoEntradaDadosListener.eventoOcorrido(evt);
                    }
                } while (!this.finalizada && !this.pausada && evt != null);
                if (this.finalizada) continue;
                if (isDebugEnabled) {
                    PerifericoEntradaDados.this.logger.debug("Pausada ou com evento? pausada={}, evt={}", String.valueOf(this.pausada), evt);
                }
                ThreadDisparaEventos threadDisparaEventos = this;
                synchronized (threadDisparaEventos) {
                    try {
                        this.wait();
                        PerifericoEntradaDados.this.logger.debug("saiu do wait do ThreadDisparaEventos");
                    }
                    catch (Exception e) {
                        PerifericoEntradaDados.this.logger.warn("saiu do wait do ThreadDisparaEventos atav\u00e9s da exce\u00e7\u00e3o: {}", e.getMessage());
                    }
                }
                this.pausada = false;
            }
            PerifericoEntradaDados.this.logger.debug("Thread finalizada por completo");
        }
    }

    private class FilaEventos {
        private final Vector<EventoDispositivoEntrada> fila = new Vector();

        private FilaEventos() {
        }

        public void inserirEvento(EventoDispositivoEntrada evt) {
            this.fila.add(evt);
        }

        public void limparEventos() {
            this.fila.clear();
        }

        public EventoDispositivoEntrada obterProximoEvento() {
            if (this.fila.isEmpty()) {
                PerifericoEntradaDados.this.logger.debug(MessageFormat.format("{0}: sem eventos na fila", ClassUtil.getSimpleClassName(this)));
                return null;
            }
            EventoDispositivoEntrada event = this.fila.remove(0);
            PerifericoEntradaDados.this.logger.debug(MessageFormat.format("{0}: {1} obtido da fila", ClassUtil.getSimpleClassName(this), ClassUtil.getSimpleClassName(event)));
            return event;
        }

        public int tamanho() {
            return this.fila.size();
        }
    }
}

