/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices;

import com.csi.ctfclient.excecoes.ExcecaoMascaraInvalida;
import com.csi.ctfclient.excecoes.ExcecaoMascaraNaoAplicavel;

public class ParametrosEdicaoTeclado {
    public static final char DIGITO_DEFAULT = '\u00ad';
    public static final char ALPHA_DEFAULT = '\u00ac';
    public static final char CARAC_DEFAULT = '\u00ab';
    public static final char CARAC_SENHA_DEFAULT = '\u00aa';
    private static final int maxFinalizadoras = 200;
    public int numFinalizadoras;
    private boolean aceitaZerosEsquerda;
    private boolean separadorDecimalObrigatorio;
    private String mascara;
    private int linhaEdicao;
    private int colunaEdicao;
    private String separadorDecimal;
    private String separadorMilhares;
    private boolean autoSkip;
    private String mensagemPrompt;
    private int linhaMensagem;
    private int colunaMensagem;
    private String valorDefaultString;
    private char[] valorDefault;
    private final String[] teclasFinalizadoras = new String[200];
    private boolean limparDisplayAoDefinir;
    private char caractereSenha;
    private char[] mascarasBuffer;
    private int[] mascarasPosicoes;
    private boolean modoEdicaoTeclado;
    private char[] bufferMascara;
    private boolean emEdicao;
    private static final char MASK_CASE_SENSITIVE = '&';
    private static final char MASK_ALFA_NUMERIC = '@';
    private static final char MASK_MONETARY = 'Z';
    private static final char MASK_NUMERIC = '9';

    public ParametrosEdicaoTeclado(boolean aceitaZerosEsquerda, boolean separadorDecimalObrigatorio, boolean modoEdicaoTeclado, String mascara, int linhaEdicao, int colunaEdicao, String separadorDecimal, String separadorMilhares, boolean autoSkip, String mensagemPrompt, int linhaMensagem, int colunaMensagem, String valorDefault, String[] teclasFinalizadoras, boolean limparDisplayAoDefinir) throws ExcecaoMascaraInvalida {
        this.setParametros(aceitaZerosEsquerda, separadorDecimalObrigatorio, modoEdicaoTeclado, mascara, linhaEdicao, colunaEdicao, separadorDecimal, separadorMilhares, autoSkip, mensagemPrompt, linhaMensagem, colunaMensagem, valorDefault, teclasFinalizadoras, limparDisplayAoDefinir);
    }

    public String apliqueMascara(char[] bufferTeclado) throws ExcecaoMascaraNaoAplicavel {
        StringBuilder ret = null;
        int buf_cont = 0;
        boolean flag_in_escape = false;
        boolean flag_in_cerquilha = false;
        boolean flag_skip_separadores = true;
        int caracterSubstituicao = 32;
        if (!this.getPossuiCampoEditavel()) {
            ret = new StringBuilder(this.mascara);
        } else if (bufferTeclado != null && this.getTamanhoEntrada() == bufferTeclado.length) {
            ret = new StringBuilder();
            for (int cont = 0; cont < this.mascara.length(); ++cont) {
                char c = this.bufferMascara[cont];
                if (flag_in_escape) {
                    flag_in_escape = false;
                    ret.append(c);
                    flag_skip_separadores = true;
                    continue;
                }
                if (c == '/') {
                    flag_in_escape = true;
                    caracterSubstituicao = 32;
                    flag_skip_separadores = true;
                    continue;
                }
                if (c == '#') {
                    flag_in_cerquilha = true;
                    continue;
                }
                if (flag_in_cerquilha) {
                    caracterSubstituicao = this.bufferMascara[cont];
                    flag_in_cerquilha = false;
                    continue;
                }
                char buf_c = bufferTeclado[buf_cont];
                if (c == 'Z') {
                    if (!this.isDigit(buf_c) && buf_c != '\u00ad') {
                        throw new ExcecaoMascaraNaoAplicavel();
                    }
                    if (flag_skip_separadores && buf_c == '\u00ad') {
                        ret.append(this.getCaractereSubstituicao('Z', false, (char)caracterSubstituicao));
                        caracterSubstituicao = 32;
                    } else {
                        if (this.caractereSenha != '\u00aa') {
                            ret.append(this.caractereSenha);
                        } else {
                            ret.append(buf_c);
                        }
                        flag_skip_separadores = false;
                    }
                    ++buf_cont;
                    continue;
                }
                if (c == '9') {
                    if (!this.isDigit(buf_c) && buf_c != '\u00ad') {
                        throw new ExcecaoMascaraNaoAplicavel();
                    }
                    if (buf_c == '\u00ad') {
                        ret.append(this.getCaractereSubstituicao('9', false, (char)caracterSubstituicao));
                        caracterSubstituicao = 32;
                    } else if (this.caractereSenha != '\u00aa') {
                        ret.append(this.caractereSenha);
                    } else {
                        ret.append(buf_c);
                    }
                    ++buf_cont;
                    flag_skip_separadores = true;
                    continue;
                }
                if (c == '@') {
                    if (!this.isAlphaNumeric(buf_c) && buf_c != '\u00ac') {
                        throw new ExcecaoMascaraNaoAplicavel();
                    }
                    if ((buf_c = Character.toUpperCase(buf_c)) == '\u00ac') {
                        ret.append(this.getCaractereSubstituicao('@', false, (char)caracterSubstituicao));
                        caracterSubstituicao = 32;
                    } else if (this.caractereSenha != '\u00aa') {
                        ret.append(this.caractereSenha);
                    } else {
                        ret.append(buf_c);
                    }
                    ++buf_cont;
                    flag_skip_separadores = true;
                    continue;
                }
                if (c == '&') {
                    if (buf_c == '\u00ab') {
                        ret.append(this.getCaractereSubstituicao('&', false, (char)caracterSubstituicao));
                        caracterSubstituicao = 32;
                    } else if (this.caractereSenha != '\u00aa') {
                        ret.append(this.caractereSenha);
                    } else {
                        ret.append(buf_c);
                    }
                    ++buf_cont;
                    flag_skip_separadores = true;
                    continue;
                }
                if (c == ',') {
                    if (flag_skip_separadores && cont > 0 && cont < this.mascara.length() - 1) {
                        if (this.bufferMascara[cont - 1] == 'Z' && (this.bufferMascara[cont + 1] == 'Z' || this.bufferMascara[cont + 1] == '9')) {
                            if (buf_cont > 0) {
                                if (bufferTeclado[buf_cont - 1] == '\u00ad') {
                                    ret.append(" ");
                                    continue;
                                }
                                ret.append(this.separadorDecimal);
                                continue;
                            }
                            ret.append(this.separadorDecimal);
                            continue;
                        }
                        ret.append(this.separadorDecimal);
                        continue;
                    }
                    ret.append(this.separadorDecimal);
                    continue;
                }
                if (c == '.') {
                    if (flag_skip_separadores && cont > 0 && cont < this.mascara.length() - 1) {
                        if (this.bufferMascara[cont - 1] == 'Z' && (this.bufferMascara[cont + 1] == 'Z' || this.bufferMascara[cont + 1] == '9')) {
                            if (buf_cont > 0) {
                                if (bufferTeclado[buf_cont - 1] == '\u00ad') {
                                    ret.append(" ");
                                    continue;
                                }
                                ret.append(this.separadorMilhares);
                                continue;
                            }
                            ret.append(this.separadorMilhares);
                            continue;
                        }
                        ret.append(this.separadorMilhares);
                        continue;
                    }
                    ret.append(this.separadorMilhares);
                    continue;
                }
                ret.append(c);
                flag_skip_separadores = true;
            }
        }
        return ret != null ? ret.toString() : null;
    }

    public String apliqueMascara(String bufferTeclado) throws ExcecaoMascaraNaoAplicavel {
        return this.apliqueMascara(bufferTeclado.toCharArray());
    }

    public void ativeSenha(char carac) {
        this.caractereSenha = carac;
    }

    public boolean getAceitaZerosEsquerda() {
        return this.aceitaZerosEsquerda;
    }

    public boolean getAutoSkip() {
        return this.autoSkip;
    }

    public char getCaractereSenha() {
        return this.caractereSenha;
    }

    private char getCaractereSubstituicao(char carac_ctrl, boolean paraRetorno, char caracterSubstituicaoAvulso) {
        int ret = 32;
        if (!paraRetorno) {
            if (this.caractereSenha != '\u00aa') {
                ret = 32;
            } else if (caracterSubstituicaoAvulso == ' ') {
                if (carac_ctrl == 'Z') {
                    ret = 32;
                } else if (carac_ctrl == '9') {
                    ret = 48;
                } else if (carac_ctrl == '@') {
                    ret = 32;
                } else if (carac_ctrl == '&') {
                    ret = 32;
                }
            } else {
                ret = caracterSubstituicaoAvulso;
            }
        } else if (caracterSubstituicaoAvulso == ' ') {
            if (carac_ctrl == 'Z') {
                ret = 32;
                if (this.modoEdicaoTeclado) {
                    ret = 48;
                }
            } else if (carac_ctrl == '9') {
                ret = 48;
            } else if (carac_ctrl == '@') {
                ret = 32;
            } else if (carac_ctrl == '&') {
                ret = 32;
            }
        } else {
            ret = caracterSubstituicaoAvulso;
        }
        return (char)ret;
    }

    public int getColunaEdicao() {
        return this.colunaEdicao;
    }

    public int getColunaMensagem() {
        return this.colunaMensagem;
    }

    public boolean getLimparDisplayAoDefinir() {
        return this.limparDisplayAoDefinir;
    }

    public int getLinhaEdicao() {
        return this.linhaEdicao;
    }

    public int getLinhaMensagem() {
        return this.linhaMensagem;
    }

    public String getMascara() {
        return this.mascara;
    }

    public boolean getMascaraTipoNumerica() {
        boolean ret = true;
        for (int cont = 0; cont < this.mascarasBuffer.length; ++cont) {
            if (this.mascarasBuffer[cont] == 'Z' || this.mascarasBuffer[cont] == '9') continue;
            ret = false;
            break;
        }
        return ret;
    }

    public String getMensagemPrompt() {
        return this.mensagemPrompt;
    }

    public boolean getModoNumerico() {
        return this.modoEdicaoTeclado;
    }

    public int getNumCaracteresDigitados(char[] buffer) {
        int ret = 0;
        for (int cont = 0; cont < buffer.length; ++cont) {
            if (buffer[cont] == '\u00ad' || buffer[cont] == '\u00ac' || buffer[cont] == '\u00ab') continue;
            ++ret;
        }
        return ret;
    }

    public int getNumCasasDecimais() {
        int cont;
        int ret = 0;
        boolean flag_escape = false;
        for (cont = 0; cont < this.bufferMascara.length; ++cont) {
            if (flag_escape) {
                flag_escape = false;
                continue;
            }
            if (this.bufferMascara[cont] == '/') {
                flag_escape = true;
                continue;
            }
            if (this.bufferMascara[cont] != ',') continue;
            ++cont;
            break;
        }
        while (cont < this.bufferMascara.length && (this.bufferMascara[cont] == 'Z' || this.bufferMascara[cont] == '9')) {
            ++ret;
            ++cont;
        }
        return ret;
    }

    public int getNumFinalizadoras() {
        return this.numFinalizadoras;
    }

    public char getPosicaoValorInicial(int posicao) {
        int c = posicao >= 0 && posicao <= this.mascarasBuffer.length ? this.mascarasBuffer[posicao] : 38;
        if (c == 90) {
            c = 173;
        } else if (c == 57) {
            c = 173;
        } else if (c == 38) {
            c = 171;
        } else if (c == 64) {
            c = 172;
        }
        return (char)c;
    }

    public boolean getPossuiCampoEditavel() {
        return this.getTamanhoEntrada() != 0;
    }

    public String getSeparadorDecimal() {
        return this.separadorDecimal;
    }

    public boolean getSeparadorDecimalObrigatorio() {
        return this.separadorDecimalObrigatorio;
    }

    public String getSeparadorMilhares() {
        return this.separadorMilhares;
    }

    public int getTamanhoEntrada() {
        int ret = 0;
        for (int cont = 0; cont < this.mascara.length(); ++cont) {
            if (!this.testePosicaoMascara(cont)) continue;
            ++ret;
        }
        return ret;
    }

    public String[] getTeclasFinalizadoras() {
        return this.teclasFinalizadoras;
    }

    public char[] getValorDefault() {
        return this.valorDefault;
    }

    public String getValorDefaultString() {
        return this.valorDefaultString;
    }

    private void inicializeMascaras() {
        int idx_Buffer = 0;
        int pos = 0;
        int idx_Pos = 0;
        boolean flag_escape = false;
        this.bufferMascara = this.mascara.toCharArray();
        int tam = this.getTamanhoEntrada();
        this.mascarasBuffer = new char[tam];
        this.mascarasPosicoes = new int[tam];
        for (int cont = 0; cont < this.bufferMascara.length; ++cont) {
            if (flag_escape) {
                ++pos;
                flag_escape = false;
                continue;
            }
            if (this.bufferMascara[cont] == '/') {
                flag_escape = true;
                continue;
            }
            if (this.bufferMascara[cont] == ',') {
                pos += this.separadorDecimal.length();
                continue;
            }
            if (this.bufferMascara[cont] == '.') {
                pos += this.separadorMilhares.length();
                continue;
            }
            if (this.testePosicaoMascara(cont)) {
                this.mascarasBuffer[idx_Buffer++] = this.bufferMascara[cont];
                this.mascarasPosicoes[idx_Pos++] = pos;
            }
            ++pos;
        }
    }

    private boolean isAlphaNumeric(char character) {
        return Character.isLetter(character) || Character.isSpaceChar(character) || this.isDigit(character);
    }

    private boolean isCaseSensitive(char character) {
        return !Character.isLetter(character) || this.isAlphaNumeric(character);
    }

    private boolean isDigit(char character) {
        return Character.isDigit(character);
    }

    public char[] monteValorDefault() {
        char[] ret;
        block7: {
            ret = this.monteValorVazio();
            if (this.valorDefault == null) break block7;
            if (!this.getMascaraTipoNumerica() | !this.modoEdicaoTeclado) {
                for (int cont = 0; cont < this.valorDefault.length; ++cont) {
                    ret[cont] = this.valorDefault[cont];
                }
            } else if (this.separadorDecimalObrigatorio) {
                for (int cont = 0; cont < this.valorDefault.length; ++cont) {
                    ret[ret.length - 1 - cont] = this.valorDefault[this.valorDefault.length - 1 - cont];
                }
            } else {
                for (int cont = 0; cont < this.valorDefault.length; ++cont) {
                    ret[ret.length - 1 - cont] = this.valorDefault[this.valorDefault.length - 1 - cont];
                }
            }
        }
        return ret;
    }

    public char[] monteValorVazio() {
        char[] ret = new char[this.mascarasBuffer.length];
        for (int cont = 0; cont < ret.length; ++cont) {
            ret[cont] = this.getPosicaoValorInicial(cont);
        }
        return ret;
    }

    protected char[] removaDefaults(char[] buffer, boolean paraRetorno) {
        char[] ret = buffer;
        int iBufferMascara = 0;
        if (buffer != null && buffer.length == this.mascarasBuffer.length) {
            ret = new char[buffer.length];
            for (int cont = 0; cont < buffer.length; ++cont) {
                char caracterSubstituicao;
                if (this.bufferMascara[iBufferMascara] == '/') {
                    iBufferMascara += 2;
                }
                if (this.bufferMascara[iBufferMascara] == '#') {
                    caracterSubstituicao = this.bufferMascara[++iBufferMascara];
                    ++iBufferMascara;
                } else {
                    caracterSubstituicao = ' ';
                }
                ++iBufferMascara;
                if (buffer[cont] == '\u00ad') {
                    if (this.mascarasBuffer[cont] == 'Z') {
                        ret[cont] = this.getCaractereSubstituicao('Z', paraRetorno, caracterSubstituicao);
                        continue;
                    }
                    if (this.mascarasBuffer[cont] == '9') {
                        ret[cont] = this.getCaractereSubstituicao('9', paraRetorno, caracterSubstituicao);
                        continue;
                    }
                    ret[cont] = 42;
                    continue;
                }
                if (buffer[cont] == '\u00ac') {
                    if (this.mascarasBuffer[cont] == '@') {
                        ret[cont] = this.getCaractereSubstituicao('@', paraRetorno, caracterSubstituicao);
                        continue;
                    }
                    ret[cont] = 42;
                    continue;
                }
                if (buffer[cont] == '\u00ab') {
                    if (this.mascarasBuffer[cont] == '&') {
                        ret[cont] = this.getCaractereSubstituicao('&', paraRetorno, caracterSubstituicao);
                        continue;
                    }
                    ret[cont] = 42;
                    continue;
                }
                ret[cont] = buffer[cont];
            }
        }
        return ret;
    }

    public synchronized void setParametros(String mascara, String mensagemPrompt, String[] teclasFinalizadoras) throws ExcecaoMascaraInvalida {
        this.setParametros(this.aceitaZerosEsquerda, this.separadorDecimalObrigatorio, this.modoEdicaoTeclado, mascara, this.linhaEdicao, this.colunaEdicao, this.separadorDecimal, this.separadorMilhares, this.autoSkip, mensagemPrompt, this.linhaMensagem, this.colunaMensagem, this.valorDefaultString, teclasFinalizadoras, teclasFinalizadoras == null ? 0 : teclasFinalizadoras.length, this.limparDisplayAoDefinir);
    }

    public synchronized void setParametros(boolean aceitaZerosEsquerda, boolean separadorDecimalObrigatorio, boolean modoEdicaoTeclado, String mascara, int linhaEdicao, int colunaEdicao, String separadorDecimal, String separadorMilhares, boolean autoSkip, String mensagemPrompt, int linhaMensagem, int colunaMensagem, String valorDefault, String[] teclasFinalizadoras, int numFinalizadoras, boolean limparDisplayAoDefinir) throws ExcecaoMascaraInvalida {
        while (this.isEmEdicao()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.aceitaZerosEsquerda = aceitaZerosEsquerda;
        this.separadorDecimalObrigatorio = separadorDecimalObrigatorio;
        this.modoEdicaoTeclado = modoEdicaoTeclado;
        if (mascara == null) {
            mascara = "";
        }
        if (mensagemPrompt == null) {
            mensagemPrompt = "";
        }
        this.mascara = mascara;
        this.linhaEdicao = linhaEdicao;
        this.colunaEdicao = colunaEdicao;
        if (separadorDecimal == null) {
            separadorDecimal = "";
        }
        this.separadorDecimal = separadorDecimal;
        if (separadorMilhares == null) {
            separadorMilhares = "";
        }
        this.separadorMilhares = separadorMilhares;
        this.autoSkip = autoSkip;
        this.mensagemPrompt = mensagemPrompt;
        this.linhaMensagem = linhaMensagem;
        this.colunaMensagem = colunaMensagem;
        this.valorDefault = null;
        this.valorDefaultString = valorDefault;
        if (valorDefault != null) {
            this.valorDefault = valorDefault.toCharArray();
        }
        this.numFinalizadoras = 0;
        if (teclasFinalizadoras != null) {
            this.numFinalizadoras = numFinalizadoras > 200 ? 200 : numFinalizadoras;
            System.arraycopy(teclasFinalizadoras, 0, this.teclasFinalizadoras, 0, this.numFinalizadoras);
        }
        this.inicializeMascaras();
        if (valorDefault != null) {
            try {
                this.apliqueMascara(valorDefault);
            }
            catch (ExcecaoMascaraNaoAplicavel e) {
                throw new ExcecaoMascaraInvalida();
            }
        }
        this.caractereSenha = (char)170;
        this.limparDisplayAoDefinir = limparDisplayAoDefinir;
    }

    public synchronized void setParametros(boolean aceitaZerosEsquerda, boolean separadorDecimalObrigatorio, boolean modoEdicaoTeclado, String mascara, int linhaEdicao, int colunaEdicao, String separadorDecimal, String separadorMilhares, boolean autoSkip, String mensagemPrompt, int linhaMensagem, int colunaMensagem, String valorDefault, String[] teclasFinalizadoras, boolean limparDisplayAoDefinir) throws ExcecaoMascaraInvalida {
        this.setParametros(aceitaZerosEsquerda, separadorDecimalObrigatorio, modoEdicaoTeclado, mascara, linhaEdicao, colunaEdicao, separadorDecimal, separadorMilhares, autoSkip, mensagemPrompt, linhaMensagem, colunaMensagem, valorDefault, teclasFinalizadoras, teclasFinalizadoras == null ? 0 : teclasFinalizadoras.length, limparDisplayAoDefinir);
    }

    private boolean testePosicaoMascara(int posicao) {
        boolean ret = false;
        if (posicao >= 0 && posicao < this.mascara.length()) {
            char c = this.bufferMascara[posicao];
            boolean bl = ret = c == 'Z' || c == '9' || c == '&' || c == '@';
            if (ret && posicao > 0) {
                for (int cont = posicao - 1; cont >= 0 && this.bufferMascara[cont] == '/'; --cont) {
                    ret = !ret;
                }
            }
        }
        return ret;
    }

    public boolean testePosicaoMascara(int posicao, char car) {
        boolean ret = false;
        if (posicao >= 0 && posicao < this.mascarasBuffer.length) {
            char c = this.mascarasBuffer[posicao];
            if (c == 'Z') {
                ret = this.isDigit(car);
            } else if (c == '9') {
                ret = this.isDigit(car);
            } else if (c == '@') {
                ret = this.isAlphaNumeric(car);
            } else if (c == '&') {
                ret = this.isCaseSensitive(car);
            }
        }
        return ret;
    }

    public synchronized void setParametros(String[] teclasFinalizadoras) throws ExcecaoMascaraInvalida {
        this.setParametros(this.aceitaZerosEsquerda, this.separadorDecimalObrigatorio, this.modoEdicaoTeclado, this.mascara, this.linhaEdicao, this.colunaEdicao, this.separadorDecimal, this.separadorMilhares, this.autoSkip, this.mensagemPrompt, this.linhaMensagem, this.colunaMensagem, this.valorDefaultString, teclasFinalizadoras, teclasFinalizadoras == null ? 0 : teclasFinalizadoras.length, this.limparDisplayAoDefinir);
    }

    public boolean isEmEdicao() {
        return this.emEdicao;
    }

    public synchronized void setEmEdicao(boolean newEmEdicao) {
        this.emEdicao = newEmEdicao;
    }
}

