/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices;

import br.com.auttar.util.factories.PinpadDriverFactory;
import com.csi.ctfclient.excecoes.ExcecaoInteiroInvalido;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.PerifericoEntradaDadosListener;
import com.csi.ctfclient.tools.devices.emv.LeitorCartao;
import com.csi.ctfclient.tools.devices.emvfull.GenericPinpadController;

public class LeitorCartaoHandler
extends Periferico
implements ILeitorCartaoHandler {
    private final GenericPinpadController protocolo;
    private final LeitorCartao leitorCartao;
    private int redeAdquirente = 0;
    private String indiceAID = null;

    public LeitorCartaoHandler(String serial, String msgCartao, String msgOcioso) throws ExcecaoPerifericos {
        this.protocolo = PinpadDriverFactory.getInstance(serial, false);
        this.leitorCartao = LeitorCartao.getInstance(this.protocolo);
        this.leitorCartao.setIdRedeAdquirente(this.redeAdquirente);
        this.leitorCartao.setIndiceAID(this.indiceAID);
    }

    @Override
    public LeitorCartao getLeitorCartao() {
        return this.leitorCartao;
    }

    @Override
    public int getRedeAdquirente() {
        return this.redeAdquirente;
    }

    @Override
    public void setRedeAdquirente(int redeAdquirente) {
        this.redeAdquirente = redeAdquirente;
        this.leitorCartao.setIdRedeAdquirente(redeAdquirente);
    }

    @Override
    public boolean isLeitura() {
        return this.leitorCartao != null && this.leitorCartao.isLeitura();
    }

    @Override
    public boolean isHabilitado() {
        return this.getHabilitado();
    }

    @Override
    public void habilita() throws ExcecaoPerifericos {
        this.leitorCartao.habilita();
        this.setHabilitado(true);
    }

    @Override
    public void habilitaTrilha(int numTrilha) throws ExcecaoInteiroInvalido {
        this.leitorCartao.habilitaTrilha(numTrilha);
    }

    @Override
    public int getSolicitaCargaTabelas() {
        return this.leitorCartao.getSolicitaCargaTabelas();
    }

    @Override
    public void setSolicitaCargaTabelas(int atualizandoTabelas) {
        this.leitorCartao.setSolicitaCargaTabelas(atualizandoTabelas);
    }

    @Override
    public void desabilita() throws ExcecaoPerifericos {
        this.leitorCartao.desabilita();
        this.setHabilitado(false);
    }

    @Override
    public void addListener(PerifericoEntradaDadosListener ouvinte, boolean utilizarBuffer) {
        this.leitorCartao.addListener(ouvinte, utilizarBuffer);
    }

    @Override
    public void liberaRecursos() throws ExcecaoPerifericos {
        if (this.leitorCartao != null) {
            this.leitorCartao.liberaRecursos();
        }
    }

    @Override
    public void removeListener(PerifericoEntradaDadosListener ouvinte) {
        this.leitorCartao.removeListener(ouvinte);
    }

    @Override
    public long getTipoPeriferico() {
        return this.leitorCartao.getTipoPeriferico();
    }

    @Override
    public int iniciaCargaTabelas(String timeStamp) throws ExcecaoPerifericos {
        return this.leitorCartao.iniciaCargaTabelas(timeStamp);
    }

    @Override
    public int executaCargaTabelas(String tabela) throws ExcecaoPerifericos {
        return this.leitorCartao.executaCargaTabelas(tabela);
    }

    @Override
    public int finalizaCargaTabelas() throws ExcecaoPerifericos {
        return this.leitorCartao.finalizaCargaTabelas();
    }

    @Override
    public String getIndiceAID() {
        return this.indiceAID;
    }

    @Override
    public void setIndiceAID(String indiceAID) {
        this.indiceAID = indiceAID;
        this.leitorCartao.setIndiceAID(indiceAID);
    }

    @Override
    public String getTableVersion() {
        return this.protocolo.getTableVersionPinpad();
    }

    @Override
    public void setTableVersion(String tableVersion) {
        this.protocolo.setTableVersionPinpad(tableVersion);
    }
}

