/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.excecoes.ExcecaoValorInvalido;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoGenericoEntradaDados;
import com.csi.ctfclient.tools.devices.EventoLeitorDocumento;
import com.csi.ctfclient.tools.devices.EventoPin;
import com.csi.ctfclient.tools.devices.EventoScanner;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.LeitorDocumento;
import com.csi.ctfclient.tools.devices.PerifericoEntradaDadosListener;
import com.csi.ctfclient.tools.devices.Pin;
import com.csi.ctfclient.tools.devices.Scanner;
import com.csi.ctfclient.tools.devices.Teclado;
import com.csi.ctfclient.tools.devices.constants.TiposPerifericos;
import com.csi.ctfclient.tools.devices.emv.EventoLeitorCartao;
import com.csi.ctfclient.tools.devices.postef.EventoPOSTef;
import com.csi.ctfclient.tools.util.ClassUtil;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

public class EntradaDeDados
implements TiposPerifericos,
PerifericoEntradaDadosListener {
    private final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(EntradaDeDados.class);
    private Pin pin;
    private boolean pinHabilitado;
    private Teclado teclado;
    private boolean tecladoHabilitado;
    private Scanner scanner;
    private boolean scannerHabilitado;
    private ILeitorCartaoHandler leitorCartao;
    private boolean leitorCartaoHabilitado;
    private final FilaEntradaDeDados filaEventos = new FilaEntradaDeDados();
    private final ConjuntoListener ouvintesTeclado = new ConjuntoListener();
    private final ConjuntoListener ouvintesScanner = new ConjuntoListener();
    private final ConjuntoListener ouvintesLeitorCartao = new ConjuntoListener();
    private final ConjuntoListener ouvintesPin = new ConjuntoListener();
    private final ConjuntoListener ouvintesBalanca = new ConjuntoListener();
    private EventoDispositivoEntrada evtLeValor;
    private boolean leitorCartaoSinc;
    private boolean leitorDocumentoSinc;
    private final ConjuntoListener ouvintesGenerico = new ConjuntoListener();
    private boolean pinSinc;
    private boolean scannerSinc;
    private boolean tecladoSinc;
    private LeitorDocumento leitorDocumento;
    private boolean leitorDocumentoHabilitado;
    private final ConjuntoListener ouvintesLeitorDocumento = new ConjuntoListener();
    private final ThreadDisparaEventos threadEventos = new ThreadDisparaEventos();

    public EntradaDeDados() {
        this(null, null, null, null);
    }

    public EntradaDeDados(Teclado teclado) {
        this(teclado, null, null, null);
    }

    public EntradaDeDados(Teclado teclado, Scanner scanner, ILeitorCartaoHandler leitor, Pin pin) {
        this.setTeclado(teclado);
        this.setScanner(scanner);
        this.setLeitorCartao(leitor);
        this.setPin(pin);
    }

    public void desabilitaLeitorCartao() {
        this.logger.debug("Desabilitando ouvinte do leitor de cart\u00f5es");
        this.leitorCartaoHabilitado = false;
        this.limpaFilaEventosLeitorCartao();
    }

    public void desabilitaPin() {
        this.logger.debug("Desabilitando ouvinte do pin");
        this.pinHabilitado = false;
        this.limpaFilaEventosPin();
    }

    public void desabilitaScanner() {
        this.logger.debug("Desabilitando ouvinte do scanner de cart\u00f5es");
        this.scannerHabilitado = false;
        this.limpaFilaEventosScanner();
    }

    public void desabilitaTeclado() {
        this.logger.debug("Desabilitando ouvinte do teclado");
        this.tecladoHabilitado = false;
        this.limpaFilaEventosTeclado();
    }

    public synchronized ILeitorCartaoHandler getLeitorCartao() {
        return this.leitorCartao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLeitorCartao(ILeitorCartaoHandler leitorCartao) {
        this.logger.debug(MessageFormat.format("Prestes a atribuir leitor de cartoes {0}", leitorCartao));
        EntradaDeDados entradaDeDados = this;
        synchronized (entradaDeDados) {
            if (this.leitorCartao != null) {
                this.leitorCartao.removeListener(this);
            }
            this.leitorCartao = leitorCartao;
            this.leitorCartaoHabilitado = false;
            if (leitorCartao != null) {
                leitorCartao.addListener(this, false);
            }
            this.limpaFilaEventosLeitorCartao();
            this.logger.debug("Leitor de cartoes {} atribuido com sucesso", leitorCartao);
        }
    }

    public synchronized Pin getPin() {
        return this.pin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPin(Pin pin) {
        this.logger.debug(MessageFormat.format("Prestes a atribuir pin {0}", pin));
        EntradaDeDados entradaDeDados = this;
        synchronized (entradaDeDados) {
            if (this.pin != null) {
                this.pin.removeListener(this);
            }
            this.pin = pin;
            this.pinHabilitado = false;
            if (pin != null) {
                pin.addListener(this, false);
            }
            this.limpaFilaEventosPin();
            this.logger.debug("Pin {} atribuido com sucesso", pin);
        }
    }

    public synchronized Scanner getScanner() {
        return this.scanner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScanner(Scanner scanner) {
        this.logger.debug(MessageFormat.format("Prestes a atribuir scanner {0}", scanner));
        EntradaDeDados entradaDeDados = this;
        synchronized (entradaDeDados) {
            if (this.scanner != null) {
                this.scanner.removeListener(this);
            }
            this.scanner = scanner;
            this.scannerHabilitado = false;
            if (scanner != null) {
                scanner.addListener(this, false);
            }
            this.limpaFilaEventosScanner();
            this.logger.debug(MessageFormat.format("Scanner {0} atribuido com sucesso", scanner));
        }
    }

    public synchronized Teclado getTeclado() {
        return this.teclado;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTeclado(Teclado teclado) {
        this.logger.debug(MessageFormat.format("Prestes a atribuir teclado {0}", teclado));
        EntradaDeDados entradaDeDados = this;
        synchronized (entradaDeDados) {
            if (this.teclado != null) {
                this.teclado.removeListener(this);
            }
            this.teclado = teclado;
            this.tecladoHabilitado = false;
            if (teclado != null) {
                teclado.addListener(this, false);
            }
            this.limpaFilaEventosTeclado();
            this.logger.debug(MessageFormat.format("Teclado {0} atribuido com sucesso", teclado));
        }
    }

    public void habilitaLeitorCartao() {
        this.logger.debug("Habilitando ouvinte do leitor de cart\u00f5es");
        this.leitorCartaoHabilitado = true;
        this.limpaFilaEventosLeitorCartao();
    }

    public void habilitaPin() {
        this.logger.debug("Habilitando ouvinte do pin");
        this.pinHabilitado = true;
        this.limpaFilaEventosPin();
    }

    public void habilitaScanner() {
        this.logger.debug("Habilitando ouvinte do scanner");
        this.scannerHabilitado = true;
        this.limpaFilaEventosScanner();
    }

    public void habilitaTeclado() {
        this.logger.debug("Habilitando ouvinte do teclado");
        this.tecladoHabilitado = true;
        this.limpaFilaEventosTeclado();
    }

    public EventoDispositivoEntrada leValor(long[] perifericos) throws ExcecaoValorInvalido {
        return this.leValor(perifericos, -1L);
    }

    public EventoDispositivoEntrada leValor(long[] perifericos, long timeout) throws ExcecaoValorInvalido {
        long aux = 0L;
        for (long periferico : perifericos) {
            if (periferico != 1L && periferico != 2L && periferico != 8L && periferico != 32L && periferico != 16L && periferico != 4L) {
                this.logger.warn(MessageFormat.format("Periferico {0} invalido em leitura de valor", periferico));
                throw new ExcecaoValorInvalido();
            }
            aux |= periferico;
        }
        return this.leValor(aux, timeout);
    }

    public EventoDispositivoEntrada leValor(long perifericos) {
        EventoDispositivoEntrada retorno = this.leValor(perifericos, -1L);
        if (retorno == null) {
            retorno = new EventoGenericoEntradaDados(null, null, null);
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventoDispositivoEntrada leValor(long perifericos, long timeout) {
        boolean isTeclado = (perifericos & 1L) != 0L;
        boolean isScanner = (perifericos & 2L) != 0L;
        boolean isLeitorCartao = (perifericos & 8L) != 0L || (perifericos & 0x20L) != 0L;
        boolean isPin = (perifericos & 4L) != 0L;
        boolean isLeitorDocumento = (perifericos & 0x10L) != 0L;
        this.logger.debug(MessageFormat.format("Prestes a ler valor, teclado={0}, scanner={1}, leitorCartoes={2}, pin={3}, leitorDocumento={4}", isTeclado, isScanner, isLeitorCartao, isPin, isLeitorCartao));
        EntradaDeDados entradaDeDados = this;
        synchronized (entradaDeDados) {
            EventoDispositivoEntrada evt = this.filaEventos.proximoEvento(isTeclado, isScanner, isLeitorCartao, isPin, isLeitorDocumento, false);
            if (evt != null) {
                this.logger.debug(MessageFormat.format("Leu {0} a partir da fila", ClassUtil.getSimpleClassName(evt)));
            } else {
                this.logger.debug("Evento nao encontrado na fila, lendo direto...");
                evt = this.leValorDireto(perifericos, true, timeout);
            }
            if (this.tecladoHabilitado) {
                this.logger.debug("Desabilitando edicao no teclado");
                this.teclado.getParametros().setEmEdicao(false);
            }
            return evt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void limpaFilaEventosLeitorCartao() {
        this.logger.debug("Limpando filas de eventos do leitor de cart\u00f5es");
        EntradaDeDados entradaDeDados = this;
        synchronized (entradaDeDados) {
            this.filaEventos.limpaEventosLeitorCartao();
            this.logger.debug("Notificando ouvintes");
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void limpaFilaEventosPin() {
        this.logger.debug("Limpando filas de eventos do pin");
        EntradaDeDados entradaDeDados = this;
        synchronized (entradaDeDados) {
            this.filaEventos.limpaEventosPin();
            this.logger.debug("Notificando ouvintes");
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void limpaFilaEventosScanner() {
        this.logger.debug("Limpando filas de eventos do scanner");
        EntradaDeDados entradaDeDados = this;
        synchronized (entradaDeDados) {
            this.filaEventos.limpaEventosScanner();
            this.logger.debug("Notificando ouvintes");
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void limpaFilaEventosTeclado() {
        this.logger.debug("Limpando filas de eventos do teclado");
        EntradaDeDados entradaDeDados = this;
        synchronized (entradaDeDados) {
            this.filaEventos.limpaEventosTeclado();
            this.logger.debug("Notificando ouvintes");
            this.notifyAll();
        }
    }

    public void desabilitaLeitorDocumento() {
        this.logger.debug("Desabilitando ouvinte do leitor de documentos");
        this.leitorDocumentoHabilitado = false;
        this.limpaFilaEventosLeitorDocumento();
    }

    public void habilitaLeitorDocumento() {
        this.logger.debug("Habilitando ouvinte do leitor de documentos");
        this.leitorDocumentoHabilitado = true;
        this.limpaFilaEventosLeitorDocumento();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void limpaFilaEventosLeitorDocumento() {
        this.logger.debug("Limpando fila de eventos do leitor de documentos");
        EntradaDeDados entradaDeDados = this;
        synchronized (entradaDeDados) {
            this.filaEventos.limpaEventosLeitorDocumento();
            this.logger.debug("Notificando ouvintes");
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void limpaTodasFilasEventos() {
        this.logger.debug("Prestes a limpar todas as filas de eventos...");
        EntradaDeDados entradaDeDados = this;
        synchronized (entradaDeDados) {
            this.filaEventos.limpaEventosLeitorCartao();
            this.filaEventos.limpaEventosLeitorDocumento();
            this.filaEventos.limpaEventosPin();
            this.filaEventos.limpaEventosScanner();
            this.filaEventos.limpaEventosTeclado();
            this.notifyAll();
            this.logger.debug("Filas de eventos limpas com sucesso");
        }
    }

    public void addBalancaListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Adicionando ouvinte da balan\u00e7a {0}", ouvinte));
        this.ouvintesBalanca.inclui(ouvinte);
    }

    public void addLeitorCartaoListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Adicionando ouvinte do leitor de cart\u00f5es {0}", ouvinte));
        this.ouvintesLeitorCartao.inclui(ouvinte);
    }

    public void addLeitorDocumentoListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Adicionando ouvinte do leitor de documentos {0}", ouvinte));
        this.ouvintesLeitorDocumento.inclui(ouvinte);
    }

    public void addPinListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Adicionando ouvinte do pin {0}", ouvinte));
        this.ouvintesPin.inclui(ouvinte);
    }

    public void addScannerListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Adicionando ouvinte do scanner {0}", ouvinte));
        this.ouvintesScanner.inclui(ouvinte);
    }

    public void addTecladoListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Adicionando ouvinte do teclado {0}", ouvinte));
        this.ouvintesTeclado.inclui(ouvinte);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventoOcorrido(EventoDispositivoEntrada evt) {
        this.logger.debug(MessageFormat.format("Prestes a receber novo {0}...", ClassUtil.getSimpleClassName(evt)));
        EntradaDeDados entradaDeDados = this;
        synchronized (entradaDeDados) {
            this.logger.debug(MessageFormat.format("Recebendo novo {0}", ClassUtil.getSimpleClassName(evt)));
            if (evt instanceof EventoScanner) {
                this.trataEventoOcorrido(evt, this.scannerSinc, this.scannerHabilitado);
            } else if (evt instanceof EventoTeclado) {
                this.trataEventoOcorrido(evt, this.tecladoSinc, this.tecladoHabilitado);
            } else if (evt instanceof EventoLeitorCartao) {
                this.trataEventoOcorrido(evt, this.leitorCartaoSinc, this.leitorCartaoHabilitado);
            } else if (evt instanceof EventoPin) {
                this.trataEventoOcorrido(evt, this.pinSinc, this.pinHabilitado);
            } else if (evt instanceof EventoLeitorDocumento) {
                this.trataEventoOcorrido(evt, this.leitorDocumentoSinc, this.leitorDocumentoHabilitado);
            } else if (evt instanceof EventoPOSTef) {
                this.trataEventoOcorrido(evt, true, true);
            } else {
                this.logger.error("Tipo de evento desconhecido: {}", ClassUtil.getSimpleClassName(evt));
            }
        }
    }

    private void trataEventoOcorrido(EventoDispositivoEntrada evt, boolean isLeituraSinc, boolean perifHabilitado) {
        if (isLeituraSinc) {
            this.evtLeValor = evt;
            this.logger.debug("Leitor direto notificado");
            this.notifyAll();
        } else if (perifHabilitado) {
            this.logger.debug("Evento inserido na fila");
            this.filaEventos.inclui(evt);
            this.threadEventos.prossegue();
        } else {
            this.logger.info("Entrada desabilitada para este tipo de evento");
        }
    }

    public void removeBalancaListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Removendo ouvinte {0} da balan\u00e7a", ouvinte));
        this.ouvintesBalanca.deleta(ouvinte);
    }

    public void removeLeitorCartaoListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Removendo ouvinte {0} do leitor de cart\u00f5es", ouvinte));
        this.ouvintesLeitorCartao.deleta(ouvinte);
    }

    public void removeLeitorDocumentoListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Removendo ouvinte {0} do leitor de documentos", ouvinte));
        this.ouvintesLeitorDocumento.deleta(ouvinte);
    }

    public void removePinListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Removendo ouvinte {0} do pin", ouvinte));
        this.ouvintesPin.deleta(ouvinte);
    }

    public void removeScannerListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Removendo ouvinte {0} do scanner", ouvinte));
        this.ouvintesScanner.deleta(ouvinte);
    }

    public void removeTecladoListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Removendo ouvinte {0} do teclado", ouvinte));
        this.ouvintesTeclado.deleta(ouvinte);
    }

    public void addEventoGenericoListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Adicionando ouvinte generico {0}", ouvinte));
        this.ouvintesGenerico.inclui(ouvinte);
    }

    public synchronized LeitorDocumento getLeitorDocumento() {
        return this.leitorDocumento;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLeitorDocumento(LeitorDocumento leitorDocumento) {
        this.logger.debug(MessageFormat.format("Prestes a atribuir leitor de documentos {0}", leitorDocumento));
        EntradaDeDados entradaDeDados = this;
        synchronized (entradaDeDados) {
            if (this.leitorDocumento != null) {
                this.leitorDocumento.removeListener(this);
            }
            this.leitorDocumento = leitorDocumento;
            this.leitorDocumentoHabilitado = false;
            if (leitorDocumento != null) {
                leitorDocumento.addListener(this, false);
            }
            this.limpaFilaEventosLeitorDocumento();
            this.logger.debug(MessageFormat.format("Leitor de documentos {0} atribuido com sucesso", leitorDocumento));
        }
    }

    public int getNumEventosLeitorCartao() {
        return this.filaEventos.getNumEventosLeitorCartao();
    }

    public int getNumEventosLeitorDocumento() {
        return this.filaEventos.getNumEventosLeitorDocumento();
    }

    public int getNumEventosPin() {
        return this.filaEventos.getNumEventosPin();
    }

    public int getNumEventosScanner() {
        return this.filaEventos.getNumEventosScanner();
    }

    public int getNumEventosTeclado() {
        return this.filaEventos.getNumEventosTeclado();
    }

    public void insereEventoComoGenerico(EventoDispositivoEntrada ev, String id) {
        this.logger.debug(MessageFormat.format("Adicionando {0} como generico", ClassUtil.getSimpleClassName(ev)));
        EventoGenericoEntradaDados evt = new EventoGenericoEntradaDados(this, id, ev);
        evt.modificaInstanteCriacao(ev.getInstanteCriacao());
        this.filaEventos.inclui(evt);
        this.threadEventos.prossegue();
    }

    public boolean isListenerBalanca(PerifericoEntradaDadosListener ouvinte) {
        return this.ouvintesBalanca.contem(ouvinte);
    }

    public boolean isListenerLeitorCartao(PerifericoEntradaDadosListener ouvinte) {
        return this.ouvintesLeitorCartao.contem(ouvinte);
    }

    public boolean isListenerLeitorDocumento(PerifericoEntradaDadosListener ouvinte) {
        return this.ouvintesLeitorDocumento.contem(ouvinte);
    }

    public boolean isListenerPin(PerifericoEntradaDadosListener ouvinte) {
        return this.ouvintesPin.contem(ouvinte);
    }

    public boolean isListenerScanner(PerifericoEntradaDadosListener ouvinte) {
        return this.ouvintesScanner.contem(ouvinte);
    }

    public boolean isListenerTeclado(PerifericoEntradaDadosListener ouvinte) {
        return this.ouvintesTeclado.contem(ouvinte);
    }

    public EventoDispositivoEntrada leValorDireto(long[] perifericos) throws ExcecaoValorInvalido {
        long aux = 0L;
        for (long periferico : perifericos) {
            if (periferico != 1L && periferico != 2L && periferico != 8L && periferico != 32L && periferico != 16L && periferico != 4L) {
                this.logger.warn(MessageFormat.format("Periferico {0} invalido em leitura de valor direto", periferico));
                throw new ExcecaoValorInvalido();
            }
            aux |= periferico;
        }
        return this.leValorDireto(aux);
    }

    public EventoDispositivoEntrada leValorDireto(long[] perifericos, boolean paralisaFila) throws ExcecaoValorInvalido {
        long aux = 0L;
        for (long periferico : perifericos) {
            if (periferico != 1L && periferico != 2L && periferico != 8L && periferico != 32L && periferico != 16L && periferico != 4L) {
                this.logger.warn(MessageFormat.format("Periferico {0} invalido em leitura de valor direto", periferico));
                throw new ExcecaoValorInvalido();
            }
            aux |= periferico;
        }
        return this.leValorDireto(aux, paralisaFila);
    }

    public EventoDispositivoEntrada leValorDireto(long perifericos) {
        return this.leValorDireto(perifericos, true);
    }

    public EventoDispositivoEntrada leValorDireto(long perifericos, boolean paralisaFila) {
        EventoDispositivoEntrada retorno = this.leValorDireto(perifericos, paralisaFila, -1L);
        if (retorno == null) {
            retorno = new EventoGenericoEntradaDados(null, null, null);
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventoDispositivoEntrada leValorDireto(long perifericos, boolean paralisaFila, long timeout) {
        this.logger.debug(MessageFormat.format("Prestes a ler valor direto: paralisaFila={0}, timeout={1}", paralisaFila, timeout));
        EntradaDeDados entradaDeDados = this;
        synchronized (entradaDeDados) {
            EventoDispositivoEntrada retorno;
            boolean leitorDocumentoOk;
            boolean pinOk;
            boolean leitorCartaoOk;
            boolean scannerOk;
            boolean tecladoOk;
            this.tecladoSinc = (perifericos & 1L) != 0L;
            this.scannerSinc = (perifericos & 2L) != 0L;
            this.leitorCartaoSinc = (perifericos & 0x28L) != 0L;
            this.pinSinc = (perifericos & 4L) != 0L;
            boolean bl = this.leitorDocumentoSinc = (perifericos & 0x10L) != 0L;
            if (!(this.tecladoSinc || this.scannerSinc || this.leitorCartaoSinc || this.pinSinc || this.leitorDocumentoSinc)) {
                this.logger.debug("Tentativa de leitura direta sem perifericos de entrada selecionados!");
                return new EventoGenericoEntradaDados(null, null, null);
            }
            boolean bl2 = tecladoOk = !this.tecladoSinc || this.teclado != null && this.teclado.getHabilitado();
            if (!tecladoOk) {
                this.logger.debug("Teclado selecionado mas nao habilitado!");
            }
            boolean bl3 = scannerOk = !this.scannerSinc || this.scanner != null && this.scanner.getHabilitado();
            if (!scannerOk) {
                this.logger.debug("Scanner selecionado mas nao habilitado!");
            }
            boolean bl4 = leitorCartaoOk = !this.leitorCartaoSinc || this.leitorCartao != null && this.leitorCartao.getLeitorCartao().getHabilitado();
            if (!leitorCartaoOk) {
                this.logger.debug("Leitor cartao selecionado mas nao habilitado!");
            }
            boolean bl5 = pinOk = !this.pinSinc || this.pin != null && this.pin.getHabilitado();
            if (!pinOk) {
                this.logger.debug("Pin selecionado mas nao habilitado!");
            }
            boolean bl6 = leitorDocumentoOk = !this.leitorDocumentoSinc || this.leitorDocumento != null && this.leitorDocumento.getHabilitado();
            if (!leitorDocumentoOk) {
                this.logger.debug("Leitor documento selecionado mas nao habilitado!");
            }
            if (!(tecladoOk || scannerOk || leitorCartaoOk || pinOk || leitorDocumentoOk)) {
                this.logger.debug("Tentativa de leitura direta sem perifericos aptos a gerar eventos!");
                this.leitorDocumentoSinc = false;
                this.pinSinc = false;
                this.leitorCartaoSinc = false;
                this.scannerSinc = false;
                this.tecladoSinc = false;
                return new EventoGenericoEntradaDados(null, null, null);
            }
            if (paralisaFila) {
                this.threadEventos.pausa();
            }
            if ((retorno = this.evtLeValor) == null) {
                if (timeout > 0L) {
                    this.logger.debug("Aguardando novo evento (temporizado)...");
                    try {
                        this.wait(timeout);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    retorno = this.evtLeValor;
                } else {
                    while (retorno == null) {
                        this.logger.debug("Aguardando novo evento...");
                        try {
                            this.wait();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        retorno = this.evtLeValor;
                    }
                }
            }
            if (retorno == null) {
                this.logger.debug("Nenhum evento recebido, saindo por timeout");
            } else {
                this.logger.debug(MessageFormat.format("Evento obtido (leitura direta): {0}", ClassUtil.getSimpleClassName(retorno)));
            }
            this.evtLeValor = null;
            this.leitorDocumentoSinc = false;
            this.pinSinc = false;
            this.leitorCartaoSinc = false;
            this.scannerSinc = false;
            this.tecladoSinc = false;
            if (paralisaFila) {
                this.threadEventos.prossegue();
            }
            return retorno;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void limpaFilaEventosGenericos() {
        this.logger.debug("Limpando fila de eventos genericos");
        EntradaDeDados entradaDeDados = this;
        synchronized (entradaDeDados) {
            this.filaEventos.limpaEventosGenericos();
            this.logger.debug("Notificando ouvintes");
            this.notifyAll();
        }
    }

    public void removeEventoGenericoListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Removendo ouvinte gen\u00e9rico {0}", ouvinte));
        this.ouvintesGenerico.deleta(ouvinte);
    }

    public class FilaEntradaDeDados {
        private final SortedSet<EventoDispositivoEntrada> elementos = Collections.synchronizedSortedSet(new TreeSet());

        public synchronized int getNumEventosLeitorCartao() {
            return this.getNumEventos(EventoLeitorCartao.class);
        }

        private int getNumEventos(Class klass) {
            int retorno = 0;
            for (EventoDispositivoEntrada aux : this.elementos) {
                if (!klass.isInstance(aux)) continue;
                ++retorno;
            }
            return retorno;
        }

        public synchronized int getNumEventosPin() {
            return this.getNumEventos(EventoPin.class);
        }

        public synchronized int getNumEventosScanner() {
            return this.getNumEventos(EventoScanner.class);
        }

        public synchronized int getNumEventosTeclado() {
            return this.getNumEventos(EventoTeclado.class);
        }

        public synchronized void inclui(EventoDispositivoEntrada elemento) {
            EntradaDeDados.this.logger.trace(MessageFormat.format("FilaEntradaDeDados: inclui({0})", elemento));
            this.elementos.add(elemento);
        }

        public void limpaEventosGenericos() {
            this.limpaEventos(EventoGenericoEntradaDados.class);
        }

        public void limpaEventosLeitorCartao() {
            this.limpaEventos(EventoLeitorCartao.class);
        }

        public void limpaEventosLeitorDocumento() {
            this.limpaEventos(EventoLeitorDocumento.class);
        }

        public void limpaEventosPin() {
            this.limpaEventos(EventoPin.class);
        }

        public void limpaEventosScanner() {
            this.limpaEventos(EventoScanner.class);
        }

        public void limpaEventosTeclado() {
            this.limpaEventos(EventoTeclado.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void limpaEventos(Class<?> tipoEvt) {
            EntradaDeDados.this.logger.debug(MessageFormat.format("Prestes a limpar eventos tipo {0}...", ClassUtil.getSimpleClassName(tipoEvt)));
            FilaEntradaDeDados filaEntradaDeDados = this;
            synchronized (filaEntradaDeDados) {
                Vector<EventoDispositivoEntrada> v = new Vector<EventoDispositivoEntrada>();
                for (EventoDispositivoEntrada evt : this.elementos) {
                    if (!evt.getClass().isInstance(tipoEvt)) continue;
                    v.add(evt);
                }
                v.forEach(this.elementos::remove);
                EntradaDeDados.this.logger.debug(MessageFormat.format("{0} eventos tipo {1} foram removidos", v.size(), ClassUtil.getSimpleClassName(tipoEvt)));
            }
        }

        public synchronized EventoDispositivoEntrada proximoEvento() {
            EntradaDeDados.this.logger.trace("FilaEntradaDeDados: proximoEvento: Inicio");
            if (this.vazia()) {
                EntradaDeDados.this.logger.trace("FilaEntradaDeDados: proximoEvento: null");
                return null;
            }
            EventoDispositivoEntrada result = this.elementos.first();
            EntradaDeDados.this.logger.trace("FilaEntradaDeDados: proximoEvento: result: " + result);
            if (result != null) {
                this.removeEvento(result);
            }
            return result;
        }

        public synchronized void removeEvento(EventoDispositivoEntrada ev) {
            try {
                EntradaDeDados.this.logger.trace(MessageFormat.format("FilaEntradaDeDados: removeEvento: removendo evento {0}", ev));
                this.elementos.remove(ev);
                EntradaDeDados.this.logger.trace(MessageFormat.format(":FilaEntradaDeDados: removeEvento: evento {0} removido", ev));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        public int tamanho() {
            return this.elementos.size();
        }

        public boolean vazia() {
            EntradaDeDados.this.logger.trace("FilaEntradaDeDados: vazia: quantidade de elementos: " + this.elementos.size());
            return this.elementos.size() == 0;
        }

        public synchronized int getNumEventosLeitorDocumento() {
            return this.getNumEventos(EventoLeitorDocumento.class);
        }

        public synchronized EventoDispositivoEntrada proximoEvento(boolean teclado, boolean scanner, boolean leitorCartao, boolean pin, boolean leitorDocumento, boolean generico) {
            EventoDispositivoEntrada result = null;
            Iterator set = this.elementos.iterator();
            EntradaDeDados.this.logger.trace(MessageFormat.format("FilaEntradaDeDados: proximoEvento: Teclado {0}, Scanner {1}, LeitorCartao {2}, Pin {3}, LeitorDocumento {4}, Generico {5} ", teclado, scanner, leitorCartao, pin, leitorDocumento, generico));
            while (set.hasNext()) {
                EventoDispositivoEntrada aux = (EventoDispositivoEntrada)set.next();
                if (teclado && aux instanceof EventoTeclado) {
                    result = aux;
                    break;
                }
                if (scanner && aux instanceof EventoScanner) {
                    result = aux;
                    break;
                }
                if (leitorCartao && aux instanceof EventoLeitorCartao) {
                    result = aux;
                    break;
                }
                if (pin && aux instanceof EventoPin) {
                    result = aux;
                    break;
                }
                if (leitorDocumento && aux instanceof EventoLeitorDocumento) {
                    result = aux;
                    break;
                }
                if (generico && aux instanceof EventoGenericoEntradaDados) {
                    result = aux;
                    break;
                }
                EntradaDeDados.this.logger.error(MessageFormat.format("FilaEntradaDeDados: proximoEvento: Evento Desconhecido {0} ", aux));
            }
            if (result != null) {
                this.removeEvento(result);
            }
            return result;
        }
    }

    public class ConjuntoListener {
        private final Vector<PerifericoEntradaDadosListener> elementos = new Vector();

        public Enumeration<PerifericoEntradaDadosListener> elementos() {
            return this.elementos.elements();
        }

        public boolean contem(Object o) {
            return this.elementos.contains(o);
        }

        public int tamanho() {
            return this.elementos.size();
        }

        public boolean consulta(PerifericoEntradaDadosListener elemento) {
            EntradaDeDados.this.logger.trace("ConjuntoListener: consulta: Cosultando Elemento" + elemento);
            return this.elementos.contains(elemento);
        }

        public void deleta(PerifericoEntradaDadosListener elemento) {
            this.elementos.removeElement(elemento);
            EntradaDeDados.this.logger.trace("ConjuntoListener: deleta: Elemento Deletado " + elemento);
        }

        public void inclui(PerifericoEntradaDadosListener elemento) {
            EntradaDeDados.this.logger.trace(MessageFormat.format("ConjuntoListener: inclui({0})", elemento));
            if (!this.elementos.contains(elemento)) {
                this.elementos.addElement(elemento);
                EntradaDeDados.this.logger.trace("ConjuntoListener: Elemento Incluido: " + elemento);
            }
        }
    }

    private class ThreadDisparaEventos
    extends Thread {
        private boolean finalizada = false;
        private boolean pausada = false;

        public ThreadDisparaEventos() {
            this.start();
        }

        public void pausa() {
            this.pausada = true;
        }

        private ConjuntoListener getConjuntoListener(EventoDispositivoEntrada evt) {
            if (evt instanceof EventoScanner) {
                return EntradaDeDados.this.ouvintesScanner;
            }
            if (evt instanceof EventoTeclado) {
                return EntradaDeDados.this.ouvintesTeclado;
            }
            if (evt instanceof EventoLeitorCartao) {
                return EntradaDeDados.this.ouvintesLeitorCartao;
            }
            if (evt instanceof EventoPin) {
                return EntradaDeDados.this.ouvintesPin;
            }
            if (evt instanceof EventoLeitorDocumento) {
                return EntradaDeDados.this.ouvintesLeitorDocumento;
            }
            if (evt instanceof EventoGenericoEntradaDados) {
                return EntradaDeDados.this.ouvintesGenerico;
            }
            return null;
        }

        private boolean distribuiEventoOuvintes(EventoDispositivoEntrada evt) {
            if (evt == null) {
                return true;
            }
            int tentativa = 0;
            String evtSimpleClassName = ClassUtil.getSimpleClassName(evt);
            do {
                ConjuntoListener c;
                if ((c = this.getConjuntoListener(evt)) == null) {
                    EntradaDeDados.this.logger.debug(MessageFormat.format("Tipo de evento desconhecido: {0}", evtSimpleClassName));
                    break;
                }
                if (c.tamanho() > 0) {
                    Enumeration<PerifericoEntradaDadosListener> e = c.elementos();
                    while (e.hasMoreElements()) {
                        PerifericoEntradaDadosListener pedl = e.nextElement();
                        try {
                            pedl.eventoOcorrido(evt);
                        }
                        catch (Throwable t) {
                            EntradaDeDados.this.logger.error(MessageFormat.format("Erro tratamento {0} pelo ouvinte {1}!", evtSimpleClassName, pedl));
                            EntradaDeDados.this.logger.error(t);
                        }
                    }
                    return true;
                }
                if (++tentativa > 3) continue;
                EntradaDeDados.this.logger.debug("Aguardando ouvintes para {}. Tentativa {}.", evtSimpleClassName, tentativa);
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (tentativa <= 3);
            EntradaDeDados.this.logger.debug(MessageFormat.format("Sem ouvintes para {0}, evento descartado", evtSimpleClassName));
            return false;
        }

        public synchronized void prossegue() {
            this.pausada = false;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.finalizada) {
                EventoDispositivoEntrada evt;
                do {
                    evt = EntradaDeDados.this.filaEventos.proximoEvento();
                    this.distribuiEventoOuvintes(evt);
                } while (!this.finalizada && !this.pausada && evt != null);
                if (this.finalizada) continue;
                ThreadDisparaEventos threadDisparaEventos = this;
                synchronized (threadDisparaEventos) {
                    try {
                        this.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.pausada = false;
            }
        }
    }
}

