/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EntradaDeDados;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoLeitorDocumento;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.ByteUtil;
import com.csi.ctfclient.tools.util.ClassUtil;
import com.csi.ctfclient.tools.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ControladorTranslator {
    public static final int VERSAO_BIBLIOTECA_LEGADO = 100;
    public static final int VERSAO_BIBLIOTECA_HEADER_RETORNO_3_BYTES = 200;
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(ControladorTranslator.class);
    private static final int MAX_RETRY = 3;
    private static ControladorTranslator controladorTranslator = null;
    private static int versaoBibliotecaIntegracao = 100;
    int colunasDisplayOpe = 20;
    int linhasDisplayOpe = 2;
    private OutputStream os;
    private InputStream is;
    private boolean started = false;

    private ControladorTranslator() {
        try {
            ConfCTFClient confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
            String[] params = confCTFClient.getDisplayOperador().getParametros();
            this.linhasDisplayOpe = Integer.parseInt(params[0]);
            this.colunasDisplayOpe = Integer.parseInt(params[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ControladorTranslator getInstancia() {
        if (controladorTranslator == null) {
            controladorTranslator = new ControladorTranslator();
        }
        return controladorTranslator;
    }

    public static void setVersaoBibliotecaIntegracao(int versaoBibliotecaIntegracao) {
        ControladorTranslator.versaoBibliotecaIntegracao = versaoBibliotecaIntegracao;
    }

    public static void montaPossaida(OutputStream os, StringBuffer possaida) {
        logger.trace("montaPossaida: Inicio");
        try {
            String msg = possaida.toString();
            if (versaoBibliotecaIntegracao == 100) {
                byte[] resp = new byte[4 + msg.length()];
                os.write(ByteUtil.shortToByteArray(resp.length - 2));
            } else if (versaoBibliotecaIntegracao >= 200) {
                byte[] resp = new byte[5 + msg.length()];
                os.write(ByteUtil.intTo3BytesArray(resp.length - 3));
            }
            os.write(1);
            os.write(4);
            os.write(msg.getBytes());
            os.flush();
            logger.trace("montaPossaida: Fim");
        }
        catch (IOException e) {
            logger.error((Object)("Erro ao montar POSSAIDA: " + e.getMessage()), e);
        }
    }

    public void bindSocketTranslator(InputStream is, OutputStream os) {
        this.os = os;
        this.is = is;
        this.started = true;
    }

    public void clearSocketTranslator() {
        this.started = false;
    }

    public void limpaDisplay() throws ExcecaoNaoLocal {
        logger.trace("limpaDisplay: Inicio");
        byte tipoDisplay = 3;
        this.limpaDisplay(tipoDisplay);
        logger.trace("limpaDisplay: Fim");
    }

    private void limpaDisplay(byte display) throws ExcecaoNaoLocal {
        logger.debug("limpaDisplay: Inicio");
        byte versao = 1;
        byte tipoMsg = 2;
        byte tipoComando = 3;
        byte[] comando = null;
        int i = 0;
        if (versaoBibliotecaIntegracao == 100) {
            comando = new byte[6];
            comando[i] = 0;
            comando[++i] = 4;
            ++i;
        } else if (versaoBibliotecaIntegracao >= 200) {
            comando = new byte[7];
            comando[i] = 0;
            comando[++i] = 0;
            comando[++i] = 4;
            ++i;
        }
        comando[i] = versao;
        comando[++i] = tipoMsg;
        comando[++i] = tipoComando;
        comando[++i] = display;
        ++i;
        int retray = 0;
        boolean comandoOK = false;
        while (!comandoOK && retray < 3) {
            logger.trace("limpaDisplay: executa comando");
            byte[] resposta = this.executaComando(comando);
            if (resposta.length != 3) {
                ++retray;
                continue;
            }
            if (resposta[2] != 3) {
                logger.debug("limpaDisplay: erro na execucao do comando");
                ++retray;
                continue;
            }
            logger.debug("limpaDisplay: executado com sucesso");
            comandoOK = true;
        }
        logger.debug("limpaDisplay: Versao: {} TipoMsg: {} TipoComando: {} Display: {}", versao, tipoMsg, tipoComando, display);
        logger.trace("limpaDisplay: Fim");
    }

    public int exibeDisplay(LayoutDisplay displayModel) throws ExcecaoNaoLocal {
        byte[] tamComando;
        logger.trace("exibeDisplay: Inicio");
        int tamHeard = 0;
        if (versaoBibliotecaIntegracao == 100) {
            tamHeard = 6;
        } else if (versaoBibliotecaIntegracao >= 200) {
            tamHeard = 7;
        }
        byte versao = 1;
        byte tipoMsg = 2;
        byte tipoComando = 1;
        byte tipoDisplay = (byte)displayModel.getTipo();
        this.limpaDisplay(tipoDisplay);
        StringBuilder textoDisplay = new StringBuilder();
        List<Linha> linhas = displayModel.getLinhas();
        for (int i = 1; i <= linhas.size(); ++i) {
            Linha linha = linhas.get(i - 1);
            String textoLinha = linha.getTexto();
            if (linha.getColuna() > 0) {
                textoLinha = StringUtil.completaString(textoLinha, textoLinha.length() + linha.getColuna(), ' ', 3);
            }
            if (linha.getPularLinha() > 0) {
                textoLinha = StringUtil.completaString(textoLinha, textoLinha.length() + linha.getPularLinha(), ';', 4);
            }
            textoDisplay.append(textoLinha);
            if (i == linhas.size()) continue;
            textoDisplay.append(";");
        }
        if (displayModel.getTipo() == 1) {
            if (displayModel.getLinhas().size() == 1) {
                Linha linha = displayModel.getLinhas().get(0);
                String texto = linha.getTexto().trim();
                if (texto.length() > this.colunasDisplayOpe) {
                    StringBuffer buffer = new StringBuffer();
                    for (int i = 0; i < texto.length(); ++i) {
                        char c = texto.charAt(i);
                        if (c == ' ' && i + 1 != texto.length() && texto.charAt(i + 1) == ' ') continue;
                        buffer.append(c);
                    }
                    if (textoDisplay.length() > this.colunasDisplayOpe) {
                        tipoDisplay = 2;
                    }
                    textoDisplay = new StringBuilder(buffer.toString());
                }
            } else {
                String[] arrayDisplay = textoDisplay.toString().split(";");
                if (arrayDisplay.length == this.linhasDisplayOpe + 1 && arrayDisplay[arrayDisplay.length - 1].length() < this.colunasDisplayOpe) {
                    String ultimaLinha = arrayDisplay[arrayDisplay.length - 1];
                    if (ultimaLinha.endsWith("...")) {
                        ultimaLinha = ultimaLinha.substring(0, ultimaLinha.length() - 3);
                    }
                    if (arrayDisplay[arrayDisplay.length - 2].length() + ultimaLinha.length() <= this.colunasDisplayOpe) {
                        String penultimaLinha = arrayDisplay[arrayDisplay.length - 2];
                        arrayDisplay[arrayDisplay.length - 2] = penultimaLinha + " " + ultimaLinha;
                        textoDisplay = new StringBuilder();
                        String[] array = new String[arrayDisplay.length - 1];
                        for (int i = 0; i < arrayDisplay.length - 1; ++i) {
                            array[i] = arrayDisplay[i];
                            textoDisplay.append(arrayDisplay[i]);
                            if (i == arrayDisplay.length - 2) continue;
                            textoDisplay.append(";");
                        }
                        arrayDisplay = array;
                    }
                }
                if (arrayDisplay.length > this.linhasDisplayOpe) {
                    tipoDisplay = 2;
                }
            }
        }
        byte[] comando = new byte[tamHeard + (textoDisplay == null ? 0 : textoDisplay.length())];
        int i = 0;
        if (versaoBibliotecaIntegracao == 100) {
            tamComando = ByteUtil.shortToByteArray(comando.length - 2);
            comando[i] = tamComando[0];
            comando[++i] = tamComando[1];
            ++i;
        } else if (versaoBibliotecaIntegracao >= 200) {
            tamComando = ByteUtil.intTo3BytesArray(comando.length - 3);
            comando[i] = tamComando[0];
            comando[++i] = tamComando[1];
            comando[++i] = tamComando[2];
            ++i;
        }
        comando[i] = versao;
        comando[++i] = tipoMsg;
        comando[++i] = tipoComando;
        comando[++i] = tipoDisplay;
        ++i;
        if (textoDisplay != null) {
            byte[] arrayMsg = textoDisplay.toString().getBytes();
            int x = 0;
            int iHeader = tamHeard;
            while (iHeader < comando.length) {
                comando[iHeader] = arrayMsg[x];
                ++iHeader;
                ++x;
            }
        }
        int retray = 0;
        boolean comandoOK = false;
        while (!comandoOK && retray < 3) {
            logger.trace("exibeDisplay: executa comando");
            byte[] resposta = this.executaComando(comando);
            if (resposta.length != 3) {
                ++retray;
                continue;
            }
            if (resposta[2] != 1) {
                logger.trace("exibeDisplay: erro na execucao do comando");
                ++retray;
                continue;
            }
            logger.trace("exibeDisplay:: executado com sucesso");
            comandoOK = true;
            if (displayModel.getDelay() <= 0L) continue;
            try {
                Thread.sleep(displayModel.getDelay());
            }
            catch (InterruptedException interruptedException) {}
        }
        logger.debug("exibeDisplay: Versao: {} TipoMsg: {} TipoComando: {} TipoDisplay: {} TextoDisplay: {}", versao, tipoMsg, tipoComando, tipoDisplay, textoDisplay.toString());
        logger.trace("exibeDisplay: Fim");
        return 0;
    }

    protected void exibeTextoMenu(LayoutMenu displayModel) throws ExcecaoNaoLocal {
        byte[] tamComando;
        logger.debug("exibeTextoMenu: Inicio");
        int tamHeard = 0;
        if (versaoBibliotecaIntegracao == 100) {
            tamHeard = 6;
        } else if (versaoBibliotecaIntegracao >= 200) {
            tamHeard = 7;
        }
        byte versao = 1;
        byte tipoMsg = 2;
        byte tipoComando = 2;
        byte tipoDisplay = 3;
        StringBuilder textoTitulo = new StringBuilder();
        String[] titulo = displayModel.getTitulo();
        for (int i = 0; i < titulo.length; ++i) {
            textoTitulo.append(titulo[i]);
            if (i == titulo.length - 1) continue;
            textoTitulo.append(";");
        }
        byte[] comando = new byte[tamHeard + textoTitulo.length()];
        int i = 0;
        if (versaoBibliotecaIntegracao == 100) {
            tamComando = ByteUtil.shortToByteArray(comando.length - 2);
            comando[i] = tamComando[0];
            comando[++i] = tamComando[1];
            ++i;
        } else if (versaoBibliotecaIntegracao >= 200) {
            tamComando = ByteUtil.intTo3BytesArray(comando.length - 3);
            comando[i] = tamComando[0];
            comando[++i] = tamComando[1];
            comando[++i] = tamComando[2];
            ++i;
        }
        comando[i] = versao;
        comando[++i] = tipoMsg;
        comando[++i] = tipoComando;
        comando[++i] = tipoDisplay;
        ++i;
        if (textoTitulo != null) {
            byte[] arrayMsg = textoTitulo.toString().getBytes();
            int x = 0;
            int iHeader = tamHeard;
            while (iHeader < comando.length) {
                comando[iHeader] = arrayMsg[x];
                ++iHeader;
                ++x;
            }
        }
        int retray = 0;
        boolean comandoOK = false;
        while (!comandoOK && retray < 3) {
            byte[] resposta = this.executaComando(comando);
            if (resposta.length != 3) {
                ++retray;
                continue;
            }
            if (resposta[2] != 2) {
                ++retray;
                continue;
            }
            comandoOK = true;
        }
        logger.debug("exibeTextoMenu: Versao: {} TipoMsg: {} TipoComando: {} TipoDisplay: {} TextoDisplay: {}", versao, tipoMsg, tipoComando, tipoDisplay, textoTitulo.toString());
        logger.trace("exibeTextoMenu: Fim");
    }

    public EventoTeclado exibeMenu(LayoutMenu displayModel) throws ExcecaoNaoLocal {
        Object idxSelecionado;
        byte[] tamComando;
        this.limpaDisplay();
        this.exibeTextoMenu(displayModel);
        logger.debug("exibeMenu: executa comando");
        int tamHeard = 0;
        if (versaoBibliotecaIntegracao == 100) {
            tamHeard = 5;
        } else if (versaoBibliotecaIntegracao >= 200) {
            tamHeard = 6;
        }
        byte versao = 1;
        byte tipoMsg = 2;
        byte tipoComando = 5;
        StringBuilder opcoesMenu = new StringBuilder();
        ArrayList<String> indices = new ArrayList<String>();
        List<ItemMenu> itens = displayModel.getItens();
        for (int i = 0; i < itens.size(); ++i) {
            ItemMenu item = itens.get(i);
            indices.add(item.getTeclaFinalizadora());
            opcoesMenu.append(item.getTeclaFinalizadora()).append(":").append(item.getTexto());
            if (i == itens.size() - 1) continue;
            opcoesMenu.append(";");
        }
        byte[] comando = new byte[tamHeard + opcoesMenu.length()];
        int i = 0;
        if (versaoBibliotecaIntegracao == 100) {
            tamComando = ByteUtil.shortToByteArray(comando.length - 2);
            comando[i] = tamComando[0];
            comando[++i] = tamComando[1];
            ++i;
        } else if (versaoBibliotecaIntegracao >= 200) {
            tamComando = ByteUtil.intTo3BytesArray(comando.length - 3);
            comando[i] = tamComando[0];
            comando[++i] = tamComando[1];
            comando[++i] = tamComando[2];
            ++i;
        }
        comando[i] = versao;
        comando[++i] = tipoMsg;
        comando[++i] = tipoComando;
        ++i;
        if (opcoesMenu != null) {
            byte[] arrayMsg = opcoesMenu.toString().getBytes();
            int x = 0;
            int iHeader = tamHeard;
            while (iHeader < comando.length) {
                comando[iHeader] = arrayMsg[x];
                ++iHeader;
                ++x;
            }
        }
        int retray = 0;
        boolean comandoOK = false;
        byte[] resposta = new byte[3];
        while (!comandoOK && retray < 3) {
            resposta = this.executaComando(comando);
            if (resposta[2] == 8 && resposta.length != 3 && resposta[2] == 5 && resposta.length != 4) {
                ++retray;
                continue;
            }
            if (resposta[2] != 5 && resposta[2] != 8) {
                ++retray;
                continue;
            }
            if (resposta[2] == 5 && !indices.contains(idxSelecionado = new String(ByteUtil.copyOfRange(resposta, 3, resposta.length)))) continue;
            comandoOK = true;
        }
        logger.debug("exibeMenu: Versao: {} TipoMsg: {} TipoComando: {} OpcaoMenu: {} Resposta: {} isComandoOK: {}", versao, tipoMsg, tipoComando, opcoesMenu.toString(), resposta, comandoOK);
        if (comandoOK) {
            if (resposta[2] == 8) {
                return new EventoTeclado("", "VOLTA", 0);
            }
            idxSelecionado = ByteUtil.copyOfRange(resposta, 3, resposta.length);
            String stringLida = new String((byte[])idxSelecionado);
            return new EventoTeclado(stringLida, stringLida.trim(), stringLida.length());
        }
        throw new ExcecaoNaoLocal("CT01", "Erro ao enviar comando", "");
    }

    public EventoDispositivoEntrada confirmaDado(LayoutDisplay displayModel) throws ExcecaoNaoLocal {
        this.exibeDisplay(displayModel);
        logger.debug("confirmaDado: executa comando");
        byte versao = 1;
        byte tipoMsg = 2;
        byte tipoComando = 6;
        byte[] comando = null;
        int i = 0;
        if (versaoBibliotecaIntegracao == 100) {
            comando = new byte[5];
            comando[i] = 0;
            comando[++i] = 3;
            ++i;
        } else if (versaoBibliotecaIntegracao >= 200) {
            comando = new byte[6];
            comando[i] = 0;
            comando[++i] = 0;
            comando[++i] = 3;
            ++i;
        }
        comando[i] = versao;
        comando[++i] = tipoMsg;
        comando[++i] = tipoComando;
        ++i;
        int retray = 0;
        boolean comandoOK = false;
        byte[] resposta = new byte[3];
        while (!comandoOK && retray < 3) {
            resposta = this.executaComando(comando);
            if (resposta.length != 3) {
                ++retray;
                continue;
            }
            if (resposta[2] != 6 && resposta[2] != 8) {
                ++retray;
                continue;
            }
            comandoOK = true;
        }
        logger.debug("confirmaDado: Versao: {} TipoMsg: {} TipoComando: {} Resposta: {} ComandoOK: {} ", versao, tipoMsg, tipoComando, resposta, comandoOK);
        if (comandoOK) {
            if (resposta[2] == 8) {
                return new EventoTeclado("", "VOLTA", 0);
            }
            return new EventoTeclado("", "ENTRA", 0);
        }
        throw new ExcecaoNaoLocal("CT02", "Erro ao confirmar dado", "");
    }

    public EventoDispositivoEntrada capturaDado(LayoutDisplay displayModel, ConstantesApiAc.TipoCampo tipoCampo, boolean aceitaZerosEsquerda, long[] perifericos, EntradaDeDados entradaDeDados, EventoNaoEsperadoHandler eventoHandler) throws ExcecaoNaoLocal {
        byte[] tamComando;
        if (displayModel != null) {
            this.exibeDisplay(displayModel);
        }
        logger.trace("capturaDado: executa comando");
        boolean ouvindoPinpad = false;
        long aux = 0L;
        for (long periferico : perifericos) {
            aux |= periferico;
            if (periferico != 8L && periferico != 32L) continue;
            ouvindoPinpad = true;
        }
        logger.debug("capturaDado: ouvindoPinpad: {}", ouvindoPinpad);
        if (tipoCampo.equals(ConstantesApiAc.CAP_CODIGO_BARRAS_CONVENIO_BL1) || tipoCampo.equals(ConstantesApiAc.CAP_CODIGO_BARRAS_TITULO_BL1)) {
            tipoCampo = ConstantesApiAc.CAP_CODIGO_BARRAS;
        }
        logger.debug("capturaDado: tipoCampo: {}", tipoCampo);
        boolean capturaCartaoPinpad = tipoCampo.equals(ConstantesApiAc.CAP_CARTAO_DIGITADO) && entradaDeDados.getLeitorCartao() != null && ouvindoPinpad;
        logger.debug("capturaDado: capturaCartaoPinpad: {}", capturaCartaoPinpad);
        if (capturaCartaoPinpad || tipoCampo.equals(ConstantesApiAc.CAP_LEITURA_PIN) || ConstantesApiAc.CAP_GENERIC_COMMAND.equals(tipoCampo)) {
            EventoDispositivoEntrada ev;
            logger.trace("capturaDado: vou inicializar thread de abort");
            VerificaAbort verificaAbort = new VerificaAbort(this, entradaDeDados);
            verificaAbort.start();
            logger.trace("capturaDado: thread de abort iniciada");
            logger.trace("capturaDado: inicializa espera evento");
            if (eventoHandler != null && eventoHandler.getEvento() != null) {
                logger.trace("capturaDado: evento externo identificado...");
                ev = eventoHandler.getEvento();
            } else {
                logger.trace("capturaDado: leValor()...");
                ev = entradaDeDados.leValor(aux);
            }
            logger.debug("evento lido: {}", ClassUtil.getSimpleClassName(ev));
            verificaAbort.cancelaVerificacao();
            logger.debug("abort da verificacao de cancelamento.");
            return ev;
        }
        int tamHeard = 0;
        if (versaoBibliotecaIntegracao == 100) {
            tamHeard = 12;
        } else if (versaoBibliotecaIntegracao >= 200) {
            tamHeard = 13;
        }
        byte versao = 1;
        byte tipoMsg = 2;
        byte tipoComando = 7;
        int i = 0;
        byte[] comando = new byte[tamHeard];
        if (versaoBibliotecaIntegracao == 100) {
            tamComando = ByteUtil.shortToByteArray(comando.length - 2);
            comando[i] = tamComando[0];
            comando[++i] = tamComando[1];
            ++i;
        } else if (versaoBibliotecaIntegracao >= 200) {
            tamComando = ByteUtil.intTo3BytesArray(comando.length - 3);
            comando[i] = tamComando[0];
            comando[++i] = tamComando[1];
            comando[++i] = tamComando[2];
            ++i;
        }
        byte[] campo = tipoCampo.getCodigo().getBytes();
        byte[] maxDigitos = ByteUtil.shortToByteArray(this.calculaMaxDigitos(tipoCampo.getMascaraEdicao()));
        comando[i] = versao;
        comando[++i] = tipoMsg;
        comando[++i] = tipoComando;
        comando[++i] = campo[0];
        comando[++i] = campo[1];
        comando[++i] = campo[2];
        comando[++i] = campo[3];
        comando[++i] = maxDigitos[0];
        comando[++i] = maxDigitos[1];
        ++i;
        if (aceitaZerosEsquerda) {
            comando[i] = 1;
            ++i;
        } else {
            comando[i] = 2;
            ++i;
        }
        int retray = 0;
        boolean comandoOK = false;
        byte[] resposta = new byte[3];
        while (!comandoOK && retray < 3) {
            resposta = this.executaComando(comando);
            if (resposta[2] == 8 && resposta.length != 3 && resposta[2] == 7) {
                ++retray;
                continue;
            }
            if (resposta[2] != 7 && resposta[2] != 8) {
                ++retray;
                continue;
            }
            comandoOK = true;
        }
        logger.debug("capturaDado: Versao: {} TipoMsg: {} TipoComando: {} Resposta: {} ComandoOK: {}", versao, tipoMsg, tipoComando, resposta, comandoOK);
        if (comandoOK) {
            if (resposta[2] == 8) {
                return new EventoTeclado("", "VOLTA", 0);
            }
            byte[] valor = ByteUtil.copyOfRange(resposta, 3, resposta.length);
            String stringLida = new String(valor);
            if (tipoCampo.equals(ConstantesApiAc.CAP_CMC7)) {
                String cmc7 = stringLida.substring(1);
                if (stringLida.subSequence(0, 1).equals("1")) {
                    return new EventoLeitorDocumento(cmc7, 0, false, false, "");
                }
                return new EventoTeclado(cmc7, "", cmc7.length());
            }
            if (tipoCampo.equals(ConstantesApiAc.CAP_CODIGO_BARRAS)) {
                String documento = stringLida.substring(1);
                if (stringLida.subSequence(0, 1).equals("1")) {
                    return new EventoLeitorDocumento(documento, 1, false, false, "");
                }
                return new EventoTeclado(documento, "", documento.length());
            }
            return new EventoTeclado(stringLida, "ENTRA", stringLida.length());
        }
        throw new ExcecaoNaoLocal("CT03", "Erro ao capturar dado", "");
    }

    protected final synchronized byte[] executaComando(byte[] comando) throws ExcecaoNaoLocal {
        logger.trace("executaComando: Inicio");
        try {
            this.os.write(comando);
            this.os.flush();
        }
        catch (IOException e) {
            logger.error("Nao foi possivel enviar o comando: " + e.getMessage());
            throw new ExcecaoNaoLocal(e, "CT04", "Erro ao executar comando");
        }
        byte[] tamResp = new byte[2];
        logger.debug("executaComando: started: {} ", this.started);
        while (this.started) {
            try {
                this.is.read(tamResp, 0, tamResp.length);
                short tam = ByteUtil.byteArrayToShort(tamResp);
                if (tam > 0) {
                    byte[] resp = new byte[tam];
                    this.is.read(resp, 0, resp.length);
                    tamResp = resp;
                    break;
                }
                try {
                    logger.trace("executaComando: Entrou no sleep de 500 mili");
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    logger.info("executaComando: Espera da execucao do comando: " + e.getMessage());
                }
            }
            catch (IOException e) {
                this.started = false;
                logger.error("executaComando: erro na execucao do comando: started: false ");
            }
        }
        logger.trace("executaComando: Fim");
        return tamResp;
    }

    private int calculaMaxDigitos(String mascaraEdicao) {
        int resultMaxDigitos = StringUtil.count('@', mascaraEdicao) + StringUtil.count('Z', mascaraEdicao) + StringUtil.count('9', mascaraEdicao) + StringUtil.count('&', mascaraEdicao);
        if (resultMaxDigitos == 0) {
            resultMaxDigitos = mascaraEdicao.length();
        }
        logger.debug("calculaMaxDigitos: Mascara Edicao: {} Tamanho da Mascara: {} Tamanho do dado: {} ", '\"' + mascaraEdicao + '\"', mascaraEdicao.length(), resultMaxDigitos > 0 ? resultMaxDigitos : mascaraEdicao.length());
        return resultMaxDigitos;
    }

    static class VerificaAbort
    extends Thread {
        private final EntradaDeDados entradaDeDados;
        private final ControladorTranslator controlador;
        private boolean abort = false;
        private final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(VerificaAbort.class);

        public VerificaAbort(ControladorTranslator controlador, EntradaDeDados entradaDeDados) {
            this.entradaDeDados = entradaDeDados;
            this.controlador = controlador;
        }

        public boolean isAbort() {
            return this.abort;
        }

        public void cancelaVerificacao() {
            this.abort = true;
        }

        @Override
        public void run() {
            this.logger.trace("Thread: inicio");
            byte versao = 1;
            byte tipoMsg = 2;
            byte tipoComando = 8;
            byte[] comando = null;
            int i = 0;
            if (versaoBibliotecaIntegracao == 100) {
                comando = new byte[5];
                comando[i] = 0;
                comando[++i] = 3;
                ++i;
            } else if (versaoBibliotecaIntegracao >= 200) {
                comando = new byte[6];
                comando[i] = 0;
                comando[++i] = 0;
                comando[++i] = 3;
                ++i;
            }
            comando[i] = versao;
            comando[++i] = tipoMsg;
            comando[++i] = tipoComando;
            ++i;
            this.logger.debug("Thread: abort: {} ", this.abort);
            while (!this.abort) {
                int retry = 0;
                boolean comandoOK = false;
                byte[] resposta = new byte[3];
                while (!comandoOK && retry < 3) {
                    try {
                        resposta = this.controlador.executaComando(comando);
                    }
                    catch (ExcecaoNaoLocal e) {
                        this.abort = true;
                        EventoTeclado evTeclado = new EventoTeclado("", "VOLTA", 0);
                        this.entradaDeDados.eventoOcorrido(evTeclado);
                    }
                    if (resposta.length != 3) {
                        ++retry;
                        continue;
                    }
                    if (resposta[2] != 0 && resposta[2] != 8) {
                        ++retry;
                        continue;
                    }
                    comandoOK = true;
                }
                this.logger.debug("Thread: Versao: {} TipoMsg: {} TipoComando: {} Resposta: {} ComandoOK: {}", versao, tipoMsg, tipoComando, resposta, comandoOK);
                this.logger.debug("Thread: ComandoOK: {} ", comandoOK);
                if (comandoOK && resposta[2] == 8) {
                    this.abort = true;
                    EventoTeclado evTeclado = new EventoTeclado("", "VOLTA", 0);
                    this.entradaDeDados.eventoOcorrido(evTeclado);
                }
                try {
                    this.logger.trace("Thread: Entrou no sleep de 1000 mili");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.logger.info("Thread: Espera do abort interrompida: " + e.getMessage());
                }
                this.logger.trace("Thread: Fim");
            }
        }
    }

    public static interface EventoNaoEsperadoHandler {
        public EventoDispositivoEntrada getEvento();
    }

    static interface ComunicacaoHandler {
        public void send(byte[] var1);

        public void read(byte[] var1);
    }
}

