/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.Display;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.LeitorDocumento;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.Scanner;
import com.csi.ctfclient.tools.devices.Teclado;
import com.csi.ctfclient.tools.devices.config.ConfPeriferico;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Objects;

public class ConfiguracaoPerifericos {
    public static final String DRIVER_TECLADO = "DRIVER_TECLADO";
    public static final String DRIVER_SCANNER = "DRIVER_SCANNER";
    public static final String DRIVER_LEITOR_DOCUMENTO = "DRIVER_LEITOR_DOCUMENTO";
    public static final String DRIVER_DISPLAY_CLIENTE = "DRIVER_DISPLAY_CLIENTE";
    public static final String DRIVER_DISPLAY_OPERADOR = "DRIVER_DISPLAY_OPERADOR";
    public static final String DRIVER_LEITOR_CARTAO = "com.csi.ctfclient.tools.devices.LeitorCartaoHandler";
    public static final String DRIVER_PINPAD = "com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad";
    public static final String DRIVER_POSTEF = "DRIVER_POSTEF";
    public static final String CONFIG_PINPAD = "CONFIG_PINPAD";
    public static final String PARAMS_LEITOR_CARTAO = "PARAMS_LEITOR_CARTAO";
    public static final String PARAMS_PINPAD = "PARAMS_PINPAD";
    public static final String PARAMS_POSTEF = "PARAMS_POSTEF";
    public static final String TIPO_TECLADO_PC = "TECLADO_PC";
    public static final String TIPO_TECLADO_JAVAPOS = "TECLADO_JAVAPOS";
    public static final String TIPO_TECLADO_TOUCH_LINX = "TECLADO_TOUCH_LINX";
    public static final String TIPO_TECLADO_TOUCH = "TECLADO_TOUCH";
    public static final String TIPO_DISPLAY_AUTTAR = "DISPLAY_AUTTAR";
    public static final String TIPO_DISPLAY_CSI = "DISPLAY_CSI";
    public static final String TIPO_DISPLAY_JAVAPOS = "DISPLAY_JAVAPOS";
    public static final String TIPO_DISPLAY_CTFCLIENT = "DISPLAY_CTFCLIENT";
    public static final String TIPO_DISPLAY_OPERADOR = "DISPLAY_OPERADOR";
    public static final String TIPO_LEITOR_CARTAO_BIB_COMPARTILHADA = "LEITOR_CARTAO_BIB_COMPARTILHADA";
    public static final String TIPO_PINPAD_BIB_COMPARTILHADA = "PINPAD_BIB_COMPARTILHADA";
    public static final String TIPO_POSTEF = "TIPO_POSTEF";
    public static final String TIPO_SCANNER_JAVAPOS = "SCANNER_JAVAPOS";
    public static final String TIPO_SCANNER_SERIAL = "SCANNER_SERIAL";
    public static final String TIPO_LEITOR_DOCUMENTO_CHRONOS = "LEITOR_DOCUMENTO_CHRONOS";
    public static final String TIPO_LEITOR_DOCUMENTO_LOGGER2 = "LEITOR_DOCUMENTO_LOGGER2";
    public static final String TIPO_LEITOR_DOCUMENTO_TECPOINTTL840 = "LEITOR_DOCUMENTO_TECPOINTTL840";
    private static final String MSG_ERRO_TECLADO = "N\u00e3o foi encontrado nenhum tecladoconfigurado, teclado obrigat\u00f3rio";
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);
    private static ConfiguracaoPerifericos instancia;
    private HashMap<String, Object> confPerifericos;
    private ConfPeriferico displayCliente;

    public ConfiguracaoPerifericos(boolean carregarDisplay) {
        this.initialize(carregarDisplay);
    }

    public static ConfiguracaoPerifericos getInstancia() {
        if (instancia == null) {
            instancia = new ConfiguracaoPerifericos(true);
        }
        return instancia;
    }

    private static Object getInstancia(String nomeClasse, String[] parametros) throws ExcecaoPerifericos {
        Object result;
        StringBuilder buffer = new StringBuilder();
        buffer.append("Carregando inst\u00e2ncia '").append(nomeClasse).append("' ");
        for (String parametro : parametros) {
            buffer.append("'").append(parametro).append("' ");
        }
        logger.info(buffer.toString());
        try {
            Class<?> c = Class.forName(nomeClasse);
            Class[] classeParams = new Class[parametros.length];
            for (int i = 0; i < parametros.length; ++i) {
                classeParams[i] = String.class;
            }
            Constructor<?> cons = c.getConstructor(classeParams);
            result = cons.newInstance(parametros);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new ExcecaoPerifericos("CP01", "Erro na carga do periferico " + nomeClasse, e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof ExcecaoPerifericos) {
                throw (ExcecaoPerifericos)t;
            }
            throw new ExcecaoPerifericos("CP02", "Erro de invocacao no periferico " + nomeClasse, t);
        }
        logger.info(nomeClasse + ", carregado...");
        return result;
    }

    private ConfCTFClient getConfigCTFClient() throws ExcecaoPerifericos {
        try {
            return Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        }
        catch (ExcecaoApiAc e) {
            throw new ExcecaoPerifericos("CP03", "Erro na leitura da configuracao", e.getMessage());
        }
    }

    private void initialize(boolean carregarDisplay) {
        logger.info("Inicializando mapa de perifericos...");
        this.confPerifericos = new HashMap();
        if (carregarDisplay) {
            this.displayCliente = new ConfPeriferico("DRIVE_DISPLAY_CLIENTE");
            this.displayCliente.setNomeClasse("com.csi.ctfclient.tools.devices.generic.JPanelDisplay");
            this.displayCliente.setParametros("40,35".split(","));
        }
        logger.info("Mapa de perifericos inicializado...");
        this.carregarDrives();
    }

    private void carregarDrives() {
        logger.info("Inicializando drivers...");
    }

    public Display getPerifericoDisplayCliente() throws ExcecaoPerifericos {
        if (this.confPerifericos.get(DRIVER_DISPLAY_CLIENTE) == null) {
            Display display = this.carregaDriveDisplay(this.displayCliente);
            this.confPerifericos.put(DRIVER_DISPLAY_CLIENTE, display);
            return display;
        }
        return (Display)this.confPerifericos.get(DRIVER_DISPLAY_CLIENTE);
    }

    public Display getPerifericoDisplayOperador() throws ExcecaoPerifericos {
        if (this.confPerifericos.get(DRIVER_DISPLAY_OPERADOR) == null) {
            if (this.getConfigCTFClient().getDisplayOperador() != null) {
                Display display = this.carregaDriveDisplay(this.getConfigCTFClient().getDisplayOperador());
                this.confPerifericos.put(DRIVER_DISPLAY_OPERADOR, display);
                return display;
            }
            return null;
        }
        return (Display)this.confPerifericos.get(DRIVER_DISPLAY_OPERADOR);
    }

    public boolean isDisplayExterno() {
        try {
            if (this.getConfigCTFClient().getDisplayOperador() != null && TIPO_DISPLAY_AUTTAR.equals(this.getConfigCTFClient().getDisplayOperador().getNomeLogico())) {
                return true;
            }
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            // empty catch block
        }
        return false;
    }

    public Teclado getPerifericoTeclado() throws ExcecaoPerifericos {
        if (this.confPerifericos.get(DRIVER_TECLADO) == null) {
            if (this.getConfigCTFClient().getTeclado() != null) {
                if (this.getConfigCTFClient().getMapaTeclado() != null) {
                    logger.info("mapaTeclado configurado para -> " + this.getConfigCTFClient().getMapaTeclado());
                    System.setProperty("com.csi.mapateclado.path", this.getConfigCTFClient().getMapaTeclado());
                } else if (this.getConfigCTFClient().getTeclado().getNomeLogico().equals(TIPO_TECLADO_JAVAPOS)) {
                    logger.info("mapaTeclado configurado para -> mapatecladoCTFClientJPOS.xml");
                    System.setProperty("com.csi.mapateclado.path", "mapatecladoCTFClientJPOS.xml");
                }
                Periferico periferico = this.carregaDriverPeriferico(this.getConfigCTFClient().getTeclado());
                this.confPerifericos.put(DRIVER_TECLADO, periferico);
                return (Teclado)periferico;
            }
            logger.error(MSG_ERRO_TECLADO);
            throw new ExcecaoPerifericos("CP04", MSG_ERRO_TECLADO);
        }
        return (Teclado)this.confPerifericos.get(DRIVER_TECLADO);
    }

    public Scanner getPerifericoScanner() throws ExcecaoPerifericos {
        if (this.confPerifericos.get(DRIVER_SCANNER) == null) {
            if (this.getConfigCTFClient().getScanner() != null) {
                Periferico periferico = this.carregaDriverPeriferico(this.getConfigCTFClient().getScanner());
                this.confPerifericos.put(DRIVER_SCANNER, periferico);
                return (Scanner)periferico;
            }
            return null;
        }
        return (Scanner)this.confPerifericos.get(DRIVER_SCANNER);
    }

    public PinEMV getPerifericoPin() throws ExcecaoPerifericos {
        if (this.confPerifericos.get(DRIVER_PINPAD) == null) {
            if (this.getConfigCTFClient().getPinPad() != null) {
                this.getConfigCTFClient().getPinPad().setNomeClasse(DRIVER_PINPAD);
                Periferico periferico = this.carregaDriverPeriferico(this.getConfigCTFClient().getPinPad());
                this.confPerifericos.put(DRIVER_PINPAD, periferico);
                return (PinEMV)periferico;
            }
            return null;
        }
        return (PinEMV)this.confPerifericos.get(DRIVER_PINPAD);
    }

    public ILeitorCartaoHandler getPerifericoLeitorCartao() throws ExcecaoPerifericos {
        if (this.confPerifericos.get(DRIVER_LEITOR_CARTAO) == null) {
            if (this.getConfigCTFClient().getLeitorCartao() != null) {
                this.getConfigCTFClient().getPinPad().setNomeClasse(DRIVER_LEITOR_CARTAO);
                Periferico periferico = this.carregaDriverPeriferico(this.getConfigCTFClient().getLeitorCartao());
                this.confPerifericos.put(DRIVER_LEITOR_CARTAO, periferico);
                return (ILeitorCartaoHandler)((Object)periferico);
            }
            return null;
        }
        return (ILeitorCartaoHandler)this.confPerifericos.get(DRIVER_LEITOR_CARTAO);
    }

    public LeitorDocumento getPerifericoLeitorDocumento() throws ExcecaoPerifericos {
        if (this.confPerifericos.get(DRIVER_LEITOR_DOCUMENTO) == null) {
            if (this.getConfigCTFClient().getLeitorDocumento() != null) {
                Periferico periferico = this.carregaDriverPeriferico(this.getConfigCTFClient().getLeitorDocumento());
                this.confPerifericos.put(DRIVER_LEITOR_DOCUMENTO, periferico);
                return (LeitorDocumento)periferico;
            }
            return null;
        }
        return (LeitorDocumento)this.confPerifericos.get(DRIVER_LEITOR_DOCUMENTO);
    }

    public boolean perifericoCarregado(String driver) {
        logger.trace("perifericoCarregado: " + driver);
        return this.confPerifericos.get(driver) != null;
    }

    public void liberaPeriferico(String driver) {
        logger.trace("liberaPeriferico: " + driver);
        this.confPerifericos.remove(driver);
    }

    private Display carregaDriveDisplay(ConfPeriferico confPeriferico) throws ExcecaoPerifericos {
        logger.trace("carregaDriveDisplay: " + confPeriferico.getNomeClasse());
        return (Display)ConfiguracaoPerifericos.getInstancia(confPeriferico.getNomeClasse(), confPeriferico.getParametros());
    }

    private Periferico carregaDriverPeriferico(ConfPeriferico confPeriferico) throws ExcecaoPerifericos {
        logger.trace("carregaDriverPeriferico: " + confPeriferico.getNomeClasse());
        return (Periferico)ConfiguracaoPerifericos.getInstancia(confPeriferico.getNomeClasse(), confPeriferico.getParametros());
    }
}

