/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.communication.access;

import com.csi.ctfclient.excecoes.ExcecaoParametroInvalido;
import com.csi.ctfclient.tools.communication.Servico;
import com.csi.ctfclient.tools.communication.access.ExcecaoConexaoJaEstabelecida;
import com.csi.ctfclient.tools.communication.access.ExcecaoConexaoNaoEstabelecida;
import com.csi.ctfclient.tools.communication.access.ExcecaoConexaoRecusada;
import com.csi.ctfclient.tools.communication.access.ExcecaoImpossivelEncontrarHost;
import com.csi.ctfclient.tools.communication.access.ExcecaoServicoLocalNaoDisponivel;
import com.csi.ctfclient.tools.communication.access.ExcecaoServicoNaoDefinido;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class Conector {
    protected static int TO_CONEXAO_LIVRE = Integer.MAX_VALUE;
    protected Servico servicoLocal = null;
    protected Servico servicoRemoto = null;
    protected InputStream fluxoEntrada = null;
    protected OutputStream fluxoSaida = null;
    protected int timeoutTransmissao = 10000;
    protected int timeoutConexao = 15000;
    protected boolean servLocalAuto = false;

    public Conector(Servico local, Servico remoto) throws ExcecaoParametroInvalido {
        if (local == null || remoto == null) {
            throw new ExcecaoParametroInvalido("COM009");
        }
        this.setServicoLocal(local);
        this.setServicoRemoto(remoto);
        this.servLocalAuto = false;
    }

    public Conector(Servico remoto) throws ExcecaoParametroInvalido {
        if (remoto == null) {
            throw new ExcecaoParametroInvalido("COM009");
        }
        this.servicoLocal = null;
        this.setServicoRemoto(remoto);
        this.servLocalAuto = true;
    }

    protected Conector() {
    }

    public void fechaConexao() throws ExcecaoConexaoNaoEstabelecida {
        if (!this.estabelecida()) {
            throw new ExcecaoConexaoNaoEstabelecida();
        }
        try {
            this.fluxoSaida.flush();
            this.fluxoSaida.close();
            this.fluxoEntrada.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fluxoEntrada = null;
        this.fluxoSaida = null;
        this.implFechaConexao();
    }

    protected abstract void implFechaConexao() throws ExcecaoConexaoNaoEstabelecida;

    public void abreConexao() throws ExcecaoServicoNaoDefinido, ExcecaoImpossivelEncontrarHost, ExcecaoServicoLocalNaoDisponivel, ExcecaoConexaoJaEstabelecida, ExcecaoConexaoRecusada {
        if (this.servicoLocal == null && !this.servLocalAuto) {
            throw new ExcecaoServicoNaoDefinido("COM012");
        }
        if (this.servicoRemoto == null) {
            throw new ExcecaoServicoNaoDefinido("COM013");
        }
        if (this.estabelecida()) {
            throw new ExcecaoConexaoJaEstabelecida();
        }
        this.implAbreConexao(TO_CONEXAO_LIVRE);
    }

    protected abstract void implAbreConexao(int var1) throws ExcecaoServicoNaoDefinido, ExcecaoImpossivelEncontrarHost, ExcecaoServicoLocalNaoDisponivel, ExcecaoConexaoJaEstabelecida, ExcecaoConexaoRecusada;

    public void abreConexao(int timeoutConexao) throws ExcecaoServicoNaoDefinido, ExcecaoImpossivelEncontrarHost, ExcecaoServicoLocalNaoDisponivel, ExcecaoConexaoJaEstabelecida, ExcecaoConexaoRecusada {
        if (this.servicoLocal == null && !this.servLocalAuto) {
            throw new ExcecaoServicoNaoDefinido("COM012");
        }
        if (this.servicoRemoto == null) {
            throw new ExcecaoServicoNaoDefinido("COM013");
        }
        if (this.estabelecida()) {
            throw new ExcecaoConexaoJaEstabelecida();
        }
        if (timeoutConexao < 1000 || timeoutConexao > 300000) {
            timeoutConexao = 15000;
        }
        this.timeoutConexao = timeoutConexao;
        this.implAbreConexao(timeoutConexao);
    }

    public boolean estabelecida() {
        return this.fluxoEntrada != null && this.fluxoSaida != null && this.servicoLocal != null && this.servicoRemoto != null;
    }

    public InputStream getFluxoEntrada() throws ExcecaoConexaoNaoEstabelecida {
        if (!this.estabelecida()) {
            throw new ExcecaoConexaoNaoEstabelecida();
        }
        return this.fluxoEntrada;
    }

    public OutputStream getFluxoSaida() throws ExcecaoConexaoNaoEstabelecida {
        if (!this.estabelecida()) {
            throw new ExcecaoConexaoNaoEstabelecida();
        }
        return this.fluxoSaida;
    }

    public Servico getServicoLocal() throws ExcecaoServicoNaoDefinido {
        if (this.servicoLocal == null) {
            throw new ExcecaoServicoNaoDefinido("COM012");
        }
        return this.servicoLocal;
    }

    public void setServicoLocal(Servico local) throws ExcecaoParametroInvalido {
        if (local == null) {
            throw new ExcecaoParametroInvalido("COM009");
        }
        this.servicoLocal = local;
    }

    public Servico getServicoRemoto() throws ExcecaoServicoNaoDefinido {
        if (this.servicoRemoto == null) {
            throw new ExcecaoServicoNaoDefinido("COM013");
        }
        return this.servicoRemoto;
    }

    public void setServicoRemoto(Servico remoto) throws ExcecaoParametroInvalido {
        if (remoto == null) {
            throw new ExcecaoParametroInvalido("COM009");
        }
        this.servicoRemoto = remoto;
    }

    public int getTimeout() {
        return this.timeoutTransmissao;
    }

    public void setTimeout(int timeout) throws ExcecaoParametroInvalido {
        if (timeout < 0) {
            throw new ExcecaoParametroInvalido("COM014");
        }
        this.timeoutTransmissao = timeout;
        this.implSetTimeout(timeout);
    }

    protected abstract void implSetTimeout(int var1) throws ExcecaoParametroInvalido;
}

