/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.servicos;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.CodingCvvBuilder;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.Apitef;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.ControladorTransacaoInicioDia;
import com.csi.ctfclient.operacoes.model.DadosConfirmacaoDesfazimento;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.operacoes.model.controller.ControladorApitefC;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.EntradaIntertefBypass;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.servicos.SaidaIntertefBypass;
import com.csi.ctfclient.tools.util.NumberUtil;
import com.csi.ctfclient.tools.util.PersistService;
import com.csi.ctfclient.tools.util.StringUtil;
import java.util.Date;

public class IntertefBypass {
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);
    private static IntertefBypass intertefBypass;

    private IntertefBypass() {
    }

    public static synchronized IntertefBypass getInstancia() {
        if (intertefBypass == null) {
            intertefBypass = new IntertefBypass();
        }
        return intertefBypass;
    }

    public SaidaIntertefBypass intertefBypass(EntradaIntertefBypass entradaByPass) throws ExcecaoApiAc {
        try {
            return this.localIntertefBypass(entradaByPass);
        }
        catch (Throwable t) {
            logger.error(String.format("entradaByPass = %s", StringUtil.objectToString(entradaByPass)));
            logger.error(t);
            ExcecaoApiAc e = t instanceof ExcecaoApiAc ? (ExcecaoApiAc)t : new ExcecaoApiAc(t, "EX98", t.getMessage());
            throw e;
        }
    }

    private SaidaIntertefBypass localIntertefBypass(EntradaIntertefBypass entradaByPass) throws ExcecaoApiAc {
        logger.info("solicita\u00e7\u00e3o de transa\u00e7\u00e3o bypass " + entradaByPass.operacao());
        logger.info("solicita\u00e7\u00e3o de transa\u00e7\u00e3o bypass com n\u00famero de transa\u00e7\u00e3o " + entradaByPass.num_trans());
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        boolean integracaoWeb = conf.isIntegracaoWeb();
        EntradaCTFClientCtrl entradaIntegracao = null;
        IdentTerminal identTerminal = null;
        if (integracaoWeb) {
            identTerminal = new IdentTerminal(entradaByPass.num_estab(), entradaByPass.num_loja(), entradaByPass.num_pdv());
            entradaIntegracao = new EntradaCTFClientCtrl();
            entradaIntegracao.setIdentTerminal(identTerminal);
            entradaIntegracao.setDataAbertura(entradaByPass.data_cliente());
        } else {
            identTerminal = new IdentTerminal(conf.getEstabelecimento(), conf.getLoja(), conf.getTerminal());
        }
        if (this.isInicioDiaRequired(identTerminal)) {
            ControladorTransacaoInicioDia controlador = new ControladorTransacaoInicioDia();
            controlador.executaInicioDia(entradaIntegracao);
            SaidaApiTefC saidaInicioDia = controlador.getSaida();
            if (saidaInicioDia.getRetorno() != 0) {
                SaidaIntertefBypass saidaByPassInicioDia = new SaidaIntertefBypass();
                saidaByPassInicioDia.retorno(saidaInicioDia.getRetorno());
                if (saidaInicioDia.getCodigoRespostaAutorizadora().length() == 3) {
                    saidaByPassInicioDia.cod_resp(saidaInicioDia.getCodigoRespostaAutorizadora().substring(1, 3));
                } else {
                    saidaByPassInicioDia.cod_resp(saidaInicioDia.getCodigoRespostaAutorizadora());
                }
                return saidaByPassInicioDia;
            }
        }
        EntradaApiTefC entrada = new EntradaApiTefC();
        if (entradaByPass.operacao() != null) {
            entrada.setOperacao(entradaByPass.operacao());
            if ((entradaByPass.operacao().equalsIgnoreCase("1F") || entradaByPass.operacao().equalsIgnoreCase("1G")) && entradaByPass.bit62() != null && entradaByPass.bit62().length() >= 2) {
                entrada.setOperacaoConsultada(entradaByPass.bit62().substring(0, 2));
            }
        }
        entrada.setAdicionais(entradaByPass.bit62());
        entrada.setWFlags(StringUtil.completaString(Integer.toHexString(entradaByPass.wFlags()), 4, '0', 3));
        entrada.setTimeoutCtf(30);
        if (entradaByPass.data_cliente() != null) {
            entrada.setDataCliente(entradaByPass.data_cliente());
        }
        if (entradaByPass.data_venc() != null) {
            entrada.setDataVencimento(entradaByPass.data_venc());
        }
        if (entradaByPass.info() != null) {
            entrada.setInfo(entradaByPass.info().trim());
        }
        entrada.setModoEntrada(entradaByPass.modo_entrada());
        if (entradaByPass.nome_cli() != null) {
            entrada.setNomeCliente(entradaByPass.nome_cli());
        }
        if (entradaByPass.nsu_ctf() != null && NumberUtil.isNumeric(entradaByPass.nsu_ctf())) {
            entrada.setNsuCtfTransacaoOriginal(Integer.parseInt(entradaByPass.nsu_ctf()));
        }
        if (entradaByPass.num_cupom() != null && NumberUtil.isNumeric(entradaByPass.num_cupom())) {
            entrada.setNumeroCupom(entradaByPass.num_cupom());
        }
        if (entradaByPass.num_aplic() != null) {
            entrada.setNumeroAplicacao(entradaByPass.num_aplic());
        }
        entrada.setNumeroTransacao(entradaByPass.num_trans());
        entrada.setNumeroParcelas(entradaByPass.plano());
        entrada.setTimeoutCtf(entradaByPass.time_out());
        if (entradaByPass.valor() != null) {
            entrada.setValorTransacao(entradaByPass.valor());
        }
        if (entradaByPass.valor_cashback() != null) {
            entrada.setValorCashBack(entradaByPass.valor_cashback());
        }
        if (entradaByPass.valor_entrada() != null) {
            entrada.setValorEntrada(entradaByPass.valor_entrada());
        }
        if (entradaByPass.senha() != null) {
            entrada.setSenha(entradaByPass.senha());
        }
        if (entradaByPass.indiceMasterKey() != null) {
            entrada.setIndiceMasterKey(entradaByPass.indiceMasterKey().charAt(0));
        }
        entrada.setTipoGarantia(2);
        if (entradaByPass.cvv2() != null) {
            entrada.setCvv2(CodingCvvBuilder.buildPresent(entradaByPass.cvv2()));
        }
        if (entradaByPass.trilha1() != null) {
            entrada.setTrilha1(entradaByPass.trilha1());
        }
        if (entradaByPass.tipo_pin() != null) {
            entrada.setTipoPin(entradaByPass.tipo_pin());
        }
        Date timeStamp = new Date();
        entrada.setTimestamp(timeStamp);
        if (entradaByPass.valor_desconto() != null) {
            entrada.setValorDesconto(entradaByPass.valor_desconto());
        }
        if (entradaByPass.valor_acrescimo() != null) {
            entrada.setValorAcrescimo(entradaByPass.valor_acrescimo());
        }
        if (entradaByPass.valor_tx_embarque() != null) {
            entrada.setValorTaxaEmbarque(entradaByPass.valor_tx_embarque());
        }
        if (entradaByPass.valor_tx_servico() != null) {
            entrada.setValorTaxaServico(entradaByPass.valor_tx_servico());
        }
        IdentApiTefC ident = new IdentApiTefC();
        if (entradaByPass.num_estab() != null) {
            ident.setNumeroEstabelecimento(identTerminal.getEstabelecimento());
        }
        if (entradaByPass.num_loja() != null) {
            ident.setNumeroLoja(identTerminal.getLoja());
        }
        if (entradaByPass.num_pdv() != null) {
            ident.setNumeroPdv(identTerminal.getTerminal());
        }
        if (entradaByPass.produto_fp() != null) {
            entrada.setProdutosConvenioFarmacia(entradaByPass.produto_fp());
        }
        if (entradaByPass.dados_pagamento() != null) {
            entrada.setDadosPagamento(entradaByPass.dados_pagamento());
        }
        entrada.setQuantidadeProdutos(entradaByPass.qt_produtos());
        if (entradaByPass.cod_autorizacao_estab() != null) {
            entrada.setCodigoAutorizacaoEstabelecimento(entradaByPass.cod_autorizacao_estab());
        }
        if (entradaByPass.cod_autorizadora() != null) {
            entrada.setCodigoAutorizadora(entradaByPass.cod_autorizadora());
        }
        if (entradaByPass.moeda() > 0) {
            entrada.setMoeda(entradaByPass.moeda());
        }
        if (entradaByPass.header_datasus() != null) {
            entrada.setHeaderDatasus(entradaByPass.header_datasus());
        }
        if (entradaByPass.produto_datasus() != null) {
            entrada.setProdutosConvenioDatasus(entradaByPass.produto_datasus());
        }
        if (entradaByPass.codigo_proxima_transacao() != null) {
            entrada.setCodigoProximaTransacao(entradaByPass.codigo_proxima_transacao());
        }
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        Apitef apitef = ControladorApitefC.newInstancia();
        logger.info("Enviando transa\u00e7\u00e3o...");
        SaidaApiTefC saida = apitef.solicitacao(ident, entrada);
        logger.info("Resposta recebida, c\u00f3digo de retorno: " + saida.getRetorno() + ", c\u00f3digo de resposta: " + saida.getCodigoRespostaAutorizadora());
        SaidaIntertefBypass saidaByPass = new SaidaIntertefBypass();
        saidaByPass.retorno(saida.getRetorno());
        int codigoRetorno = saida.getRetorno();
        saidaByPass.bit62(saida.getAdicionais());
        saidaByPass.cod_aprov(saida.getCodigoAprovacao());
        saidaByPass.cod_autorizadora(saida.getCodigoAutorizadora());
        saidaByPass.cod_erro(saida.getCodigoErro() != null ? (long)Integer.parseInt(saida.getCodigoErro()) : 1L);
        saidaByPass.cod_if(String.valueOf(saida.getCodigoInstituicaoFinanceira()));
        saidaByPass.cod_orig(saida.getCodigoEstabelecimento());
        if (saida.getCodigoRespostaAutorizadora().length() == 3) {
            saidaByPass.cod_resp(saida.getCodigoRespostaAutorizadora().substring(1, 3));
        } else {
            saidaByPass.cod_resp(saida.getCodigoRespostaAutorizadora());
        }
        if (codigoRetorno == 0) {
            saidaByPass.CDC_PRE_habilitado(saida.getQtdMaximaParcelaComJuros());
        }
        saidaByPass.num_trans(entradaByPass.num_trans());
        saidaByPass.tipo_aprov(saida.getTipoAprovacao());
        saidaByPass.indiceMasterKey(saida.getIndiceMasterKey());
        saidaByPass.wkey(saida.getWorkingkey());
        saidaByPass.sol_senha(saida.isPedeSenha());
        saidaByPass.cod_van(String.valueOf(saida.getCodigoVan()));
        Date dataAutorizadora = saida.getDataAutorizadora();
        if (dataAutorizadora == null) {
            dataAutorizadora = new Date();
        }
        saidaByPass.data_autorizadora(dataAutorizadora);
        saidaByPass.msg_display(saida.getDisplayCTF());
        saidaByPass.nome_autorizadora(saida.getNomeAutorizadora());
        saidaByPass.nome_if(saida.getNomeInstituicaoFinanceira());
        saidaByPass.nome_van(saida.getNomeVan());
        saidaByPass.nsu_aut(String.valueOf(saida.getNsuAutorizacao()));
        saidaByPass.nsu_ctf(String.valueOf(saida.getNsuCTF()));
        saidaByPass.saldo_cli(saida.getSaldoCliente());
        saidaByPass.tx_juros(saida.getTaxaJuros());
        saidaByPass.val_trans(saida.getValorTransacao());
        saidaByPass.valor_parcela(saida.getValorParcela());
        saidaByPass.valor_total(saida.getValorTotal());
        saidaByPass.valor_tx_embarque(saida.getTaxaEmbarque());
        saidaByPass.valor_tx_servico(saida.getTaxaServico());
        saidaByPass.min_parc_cj(saida.getQtdMinimaParcelaComJuros());
        saidaByPass.min_parc_sj(saida.getQtdMinimaParcelaSemJuros());
        saidaByPass.max_parc_cj(saida.getQtdMaximaParcelaComJuros());
        saidaByPass.max_parc_sj(saida.getQtdMaximaParcelaSemJuros());
        saidaByPass.valor_min_parcela(saida.getValorMinimoParcelaSemJuros());
        saidaByPass.cod_erro_autorizadora(saida.getCodigoErroAutorizadora());
        saidaByPass.produto_fp(saida.getProdutosConvenioFarmacia());
        saidaByPass.captura4UltimosDigitos(saida.isPede4Digitos());
        saidaByPass.capturaCodigoSeguranca(saida.isPedeCVV2());
        saidaByPass.capturaCodigoSegurancaObrigatorio(saida.isObrigatorioCVV2());
        saidaByPass.header_datasus(saida.getHeaderDatasus());
        saidaByPass.qt_produtos(saida.getQuantidadeProdutos());
        saidaByPass.produto_datasus(saida.getProdutosConvenioDatasus());
        saidaByPass.lista_lotes(saida.getListaLotes());
        if (!(saida.getRetorno() != 0 || entradaByPass.operacao().equals(String.valueOf(OperationEnum.OP_CONFIRMACAO.getKey())) || entradaByPass.operacao().equals(String.valueOf(OperationEnum.OP_DESFAZIMENTO.getKey())) || "1F".equalsIgnoreCase(entradaByPass.operacao()))) {
            apitef.getCupom();
            DadosConfirmacaoDesfazimento dados = new DadosConfirmacaoDesfazimento(entrada.getDadosFinaisChip(), new Date(), entrada.getIssuerScriptResult(), entrada.getNumeroSeriePin(), entrada.getNumeroTransacao(), entrada.getOperacao(), entrada.getTimeoutCtf(), entrada.getTimestamp(), entrada.getTipoResposta());
            String key = String.valueOf(dados.getNumeroTransacao());
            PersistService.getInstance().save(key, dados, identTerminal);
        }
        return saidaByPass;
    }

    private boolean isInicioDiaRequired(IdentTerminal identTerminal) {
        ControladorInicioDia controladorInicioDia = null;
        DadosInicioDia dadosInicioDia = null;
        try {
            controladorInicioDia = ControladorInicioDia.getInstance();
            dadosInicioDia = controladorInicioDia.getDadosInicioDia(identTerminal);
        }
        catch (ExcecaoApiAc e) {
            return true;
        }
        return dadosInicioDia == null || dadosInicioDia.getDataInicioDia() == null || !dadosInicioDia.equalsData(new Date());
    }
}

