/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.servicos;

import br.com.auttar.AuttarLogger;
import br.com.auttar.AuttarLoggerFactory;
import br.com.auttar.QrCodeGenerator;
import br.com.auttar.logger.AuttarLoggerFactoryLog4j2;
import br.com.auttar.logger.AuttarLoggerFactoryNull;
import br.com.auttar.model.constants.CodigoRetornoAutomacao;
import br.com.auttar.model.constants.OperationEnum;
import br.com.auttar.util.operation.TransactionOperationRules;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.CartaoPrepagoDigital;
import com.csi.ctfclient.apitef.model.ConsultaValoresCreditoDigital;
import com.csi.ctfclient.apitef.model.EstabelecimentoMultiEC;
import com.csi.ctfclient.apitef.model.ProdutoPromocional;
import com.csi.ctfclient.apitef.model.ProdutoSimulacaoCrediario;
import com.csi.ctfclient.apitef.model.ValorRecargaTelefone;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoEntradaCTFClient;
import com.csi.ctfclient.integracao.TerminalManager;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessConstructorArguments;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessAdesaoSeguro;
import com.csi.ctfclient.operacoes.action.ProcessAlteracaoPreAutorizacao;
import com.csi.ctfclient.operacoes.action.ProcessAtivacaoSolucaoCerta;
import com.csi.ctfclient.operacoes.action.ProcessAtualizacaoChip;
import com.csi.ctfclient.operacoes.action.ProcessAtualizacaoParticipante;
import com.csi.ctfclient.operacoes.action.ProcessAutenticacaoTerminal;
import com.csi.ctfclient.operacoes.action.ProcessAuto;
import com.csi.ctfclient.operacoes.action.ProcessAutorizacaoIATA;
import com.csi.ctfclient.operacoes.action.ProcessBaixaTecnicaManual;
import com.csi.ctfclient.operacoes.action.ProcessBypass;
import com.csi.ctfclient.operacoes.action.ProcessCancelamento;
import com.csi.ctfclient.operacoes.action.ProcessCancelamentoMultiTerminal;
import com.csi.ctfclient.operacoes.action.ProcessCapturaCredito;
import com.csi.ctfclient.operacoes.action.ProcessCapturaDadosPinpad;
import com.csi.ctfclient.operacoes.action.ProcessCargaProdutosPromocionais;
import com.csi.ctfclient.operacoes.action.ProcessCargaTabelaForcadaTest;
import com.csi.ctfclient.operacoes.action.ProcessCartaoPrepago;
import com.csi.ctfclient.operacoes.action.ProcessCartaoPrepagoDigital;
import com.csi.ctfclient.operacoes.action.ProcessCartaoPresente;
import com.csi.ctfclient.operacoes.action.ProcessCashPrivateLabel;
import com.csi.ctfclient.operacoes.action.ProcessConfigurarTerminal;
import com.csi.ctfclient.operacoes.action.ProcessConfirmacao;
import com.csi.ctfclient.operacoes.action.ProcessConfirmacaoDesfazimentoNSUCTF;
import com.csi.ctfclient.operacoes.action.ProcessConfirmacaoPreAutorizacao;
import com.csi.ctfclient.operacoes.action.ProcessConfirmacaoPreAutorizacaoWEB;
import com.csi.ctfclient.operacoes.action.ProcessConfirmacaoPreVenda;
import com.csi.ctfclient.operacoes.action.ProcessConsultaAnaliticaSpc;
import com.csi.ctfclient.operacoes.action.ProcessConsultaAnaliticaSpcWeb;
import com.csi.ctfclient.operacoes.action.ProcessConsultaAvs;
import com.csi.ctfclient.operacoes.action.ProcessConsultaAvsMultiTerminal;
import com.csi.ctfclient.operacoes.action.ProcessConsultaCPFPromocaoShell;
import com.csi.ctfclient.operacoes.action.ProcessConsultaCartao;
import com.csi.ctfclient.operacoes.action.ProcessConsultaCheque;
import com.csi.ctfclient.operacoes.action.ProcessConsultaContaCartao;
import com.csi.ctfclient.operacoes.action.ProcessConsultaEstabelecimentosMultiEC;
import com.csi.ctfclient.operacoes.action.ProcessConsultaFinanciamentoCredito;
import com.csi.ctfclient.operacoes.action.ProcessConsultaFinanciamentoCreditoWeb;
import com.csi.ctfclient.operacoes.action.ProcessConsultaPendencia;
import com.csi.ctfclient.operacoes.action.ProcessConsultaSaldo;
import com.csi.ctfclient.operacoes.action.ProcessConsultaTelefoneCreditoDigital;
import com.csi.ctfclient.operacoes.action.ProcessConvenioCombustivel;
import com.csi.ctfclient.operacoes.action.ProcessCorrespondenteBancario;
import com.csi.ctfclient.operacoes.action.ProcessCredito;
import com.csi.ctfclient.operacoes.action.ProcessCreditoCartaoQualidade;
import com.csi.ctfclient.operacoes.action.ProcessCreditoCelular;
import com.csi.ctfclient.operacoes.action.ProcessCreditoDebito4All;
import com.csi.ctfclient.operacoes.action.ProcessCreditoDigital;
import com.csi.ctfclient.operacoes.action.ProcessCreditoDigitalMultiTerminal;
import com.csi.ctfclient.operacoes.action.ProcessCreditoIATA;
import com.csi.ctfclient.operacoes.action.ProcessCreditoMultiTerminal;
import com.csi.ctfclient.operacoes.action.ProcessCreditoPrivateLabel;
import com.csi.ctfclient.operacoes.action.ProcessCriptografiaDUKPT;
import com.csi.ctfclient.operacoes.action.ProcessDepositoCartao;
import com.csi.ctfclient.operacoes.action.ProcessDepositoConta;
import com.csi.ctfclient.operacoes.action.ProcessDesbloqueioCartao;
import com.csi.ctfclient.operacoes.action.ProcessDescontoProdutosPromocionais;
import com.csi.ctfclient.operacoes.action.ProcessDesfazimento;
import com.csi.ctfclient.operacoes.action.ProcessDesfazimentoGeral;
import com.csi.ctfclient.operacoes.action.ProcessDotz;
import com.csi.ctfclient.operacoes.action.ProcessECO;
import com.csi.ctfclient.operacoes.action.ProcessEcommerceAutenticado;
import com.csi.ctfclient.operacoes.action.ProcessEmprestimo;
import com.csi.ctfclient.operacoes.action.ProcessEstatisticaManual;
import com.csi.ctfclient.operacoes.action.ProcessFidelidadeMilhas;
import com.csi.ctfclient.operacoes.action.ProcessFuelControl;
import com.csi.ctfclient.operacoes.action.ProcessGeracaoBeneficio;
import com.csi.ctfclient.operacoes.action.ProcessIdentificacaoAssociado;
import com.csi.ctfclient.operacoes.action.ProcessInicioDia;
import com.csi.ctfclient.operacoes.action.ProcessOperacoesDrogao;
import com.csi.ctfclient.operacoes.action.ProcessPagamentoContas;
import com.csi.ctfclient.operacoes.action.ProcessPagamentoDinheiroBrPremmia;
import com.csi.ctfclient.operacoes.action.ProcessPagamentoFaturaCartao;
import com.csi.ctfclient.operacoes.action.ProcessPixPayment;
import com.csi.ctfclient.operacoes.action.ProcessPixQuery;
import com.csi.ctfclient.operacoes.action.ProcessPreAutorizacao;
import com.csi.ctfclient.operacoes.action.ProcessPreAutorizacaoAdicional;
import com.csi.ctfclient.operacoes.action.ProcessPreAutorizacaoWEB;
import com.csi.ctfclient.operacoes.action.ProcessQrCodeGenerico;
import com.csi.ctfclient.operacoes.action.ProcessRecargaCartaoPrePago;
import com.csi.ctfclient.operacoes.action.ProcessRecargaCartaoPrePagoPOSA;
import com.csi.ctfclient.operacoes.action.ProcessReimpressaoComprovante;
import com.csi.ctfclient.operacoes.action.ProcessResgateBrPremmia;
import com.csi.ctfclient.operacoes.action.ProcessResgateCartaoPrePagoPOSA;
import com.csi.ctfclient.operacoes.action.ProcessResgateFacil;
import com.csi.ctfclient.operacoes.action.ProcessResgateFidelidade;
import com.csi.ctfclient.operacoes.action.ProcessResgatePremio;
import com.csi.ctfclient.operacoes.action.ProcessResgatePremiosShell;
import com.csi.ctfclient.operacoes.action.ProcessSaqueCartao;
import com.csi.ctfclient.operacoes.action.ProcessSaqueTransferencia;
import com.csi.ctfclient.operacoes.action.ProcessTefIPFuncoesADM;
import com.csi.ctfclient.operacoes.action.ProcessTefIPOperacoesCheque;
import com.csi.ctfclient.operacoes.action.ProcessTefIPVendaCartao;
import com.csi.ctfclient.operacoes.action.ProcessTefIPVendaQrCode;
import com.csi.ctfclient.operacoes.action.ProcessTefIpEnvioFacil;
import com.csi.ctfclient.operacoes.action.ProcessTesteComunicacao;
import com.csi.ctfclient.operacoes.action.ProcessTransacoesGenericas;
import com.csi.ctfclient.operacoes.action.ProcessTransacoesSAA;
import com.csi.ctfclient.operacoes.action.ProcessTrocaSenha;
import com.csi.ctfclient.operacoes.action.ProcessTroco;
import com.csi.ctfclient.operacoes.action.ProcessUltimoComprovante;
import com.csi.ctfclient.operacoes.action.ProcessValeGas;
import com.csi.ctfclient.operacoes.action.ProcessVcMais;
import com.csi.ctfclient.operacoes.action.ProcessVoucher;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.constantes.FormatoCodigoBarrasEnum;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.contexto.ContextoCTFClient;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.CorrespondenteBancario;
import com.csi.ctfclient.operacoes.model.controller.ControladorApitefC;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.model.controller.ControladorMultiEC;
import com.csi.ctfclient.operacoes.model.controller.ControladorPersistencia;
import com.csi.ctfclient.operacoes.model.controller.IdentificadorMultiECNaoEncontradoException;
import com.csi.ctfclient.operacoes.util.MascaraCartaoUtil;
import com.csi.ctfclient.servicos.CartaoPrepagoDigitalResposta;
import com.csi.ctfclient.servicos.EntradaCTFClient;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.EstabelecimentoMultiECResposta;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.servicos.OrigemTransacaoEnum;
import com.csi.ctfclient.servicos.QrCodeQueryResponse;
import com.csi.ctfclient.servicos.RespostaAtivacaoCartaoPrepago;
import com.csi.ctfclient.servicos.RespostaBypass;
import com.csi.ctfclient.servicos.RespostaCompraCreditoDigital;
import com.csi.ctfclient.servicos.RespostaConsultaAnaliticaSPC;
import com.csi.ctfclient.servicos.RespostaConsultaAvs;
import com.csi.ctfclient.servicos.RespostaConsultaCartaoPrepagoDigital;
import com.csi.ctfclient.servicos.RespostaConsultaEstabelecimentosMultiEC;
import com.csi.ctfclient.servicos.RespostaConsultaTelefoneCreditoDigital;
import com.csi.ctfclient.servicos.RespostaConsultaValoresCreditoDigital;
import com.csi.ctfclient.servicos.RespostaCorrespondenteBancario;
import com.csi.ctfclient.servicos.RespostaOperacaoCheque;
import com.csi.ctfclient.servicos.RespostaPagamentoFaturaCartao;
import com.csi.ctfclient.servicos.RespostaProdutosPromocionais;
import com.csi.ctfclient.servicos.RespostaSimulacaoCrediario;
import com.csi.ctfclient.servicos.RespostaTransacoesSAA;
import com.csi.ctfclient.servicos.RespostaValeGas;
import com.csi.ctfclient.servicos.SaidaCTFClient;
import com.csi.ctfclient.servicos.TransacaoPendente;
import com.csi.ctfclient.tools.devices.ConfiguracaoPerifericos;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emvfull.GenericPinpadController;
import com.csi.ctfclient.tools.devices.postef.POSTef;
import com.csi.ctfclient.tools.devices.postef.servico.POSTefServico;
import com.csi.ctfclient.tools.util.DateUtil;
import com.csi.ctfclient.tools.util.PersistService;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.codigobarras.CodigoBarrasUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.DisplayFisicoCSILanguage;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class CTFClientCore {
    private static AuttarLogger logger;
    private static Date dataAtual;
    private static CTFClientCore instance;
    private static ConfiguracaoPerifericos confPerifericos;
    private static ControladorPerifericos controladorPerifericos;
    private static ControladorConfCTFClient controladorConfCTFClient;
    private static TerminalManager terminalManager;
    private static AuttarLoggerFactory auttarLoggerFactory;
    private final QrCodeGenerator qrCodeGenerator;
    private ContextoCTFClient searchContexto = null;
    private static Boolean log4jHabilitado;

    private CTFClientCore(AuttarLoggerFactory auttarLoggerFactory, QrCodeGenerator qrCodeGenerator) throws ExcecaoApiAc {
        CTFClientCore.auttarLoggerFactory = auttarLoggerFactory;
        this.qrCodeGenerator = qrCodeGenerator;
    }

    public static synchronized AuttarLoggerFactory getAuttarLoggerFactory() {
        if (auttarLoggerFactory == null) {
            return CTFClientCore.getDefaultFactoryLogger();
        }
        return auttarLoggerFactory;
    }

    public static AuttarLoggerFactory getDefaultFactoryLogger() {
        if (log4jHabilitado == null) {
            if (!CTFClientCore.isJUnitTest()) {
                try {
                    Class.forName("org.apache.logging.log4j.LogManager");
                    log4jHabilitado = true;
                }
                catch (ClassNotFoundException e) {
                    log4jHabilitado = false;
                }
            } else {
                log4jHabilitado = false;
            }
        }
        return log4jHabilitado != false ? new AuttarLoggerFactoryLog4j2() : new AuttarLoggerFactoryNull();
    }

    public static boolean isJUnitTest() {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().startsWith("org.junit.")) continue;
            return true;
        }
        return false;
    }

    public static void init() {
        String versao = ControladorConfCTFClient.VERSAO_CLIENT + "-" + ControladorConfCTFClient.VERSAO_CLIENT_DRAFT;
        String versaoCielo = "C0409";
        String versaoRedecard = "C0138";
        String dataVersao = ControladorConfCTFClient.DATA_VERSAO;
        logger.info("#########################################");
        logger.info("#  Certifica\u00e7\u00e3o Cielo    -> " + versaoCielo + "       #");
        logger.info("#  Certifica\u00e7\u00e3o Redecard -> " + versaoRedecard + "       #");
        logger.info("#  CTFClient vers\u00e3o      -> " + versao + " #");
        logger.info("#  Data vers\u00e3o           -> " + dataVersao + "  #");
        logger.info("#########################################");
        String classpath = System.getProperty("java.class.path");
        String[] classpathEntries = classpath.split(File.pathSeparator);
        logger.info("ClassPathEntries: " + Arrays.asList(classpathEntries));
    }

    public static synchronized CTFClientCore getInstancia(AuttarLoggerFactory auttarLoggerFactory, QrCodeGenerator qrCodeGenerator) throws ExcecaoApiAc {
        try {
            if (instance == null) {
                instance = new CTFClientCore(auttarLoggerFactory, qrCodeGenerator);
                dataAtual = new Date();
                logger = auttarLoggerFactory.getLogger(CTFClientCore.class);
                CTFClientCore.init();
                controladorConfCTFClient = ControladorConfCTFClient.getInstance();
                ConfCTFClient config = Objects.requireNonNull(controladorConfCTFClient).getConfig();
                logger.info("Carregando estrutura de perifericos");
                confPerifericos = new ConfiguracaoPerifericos(!config.isIntegracaoWeb());
                InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
                if (confPerifericos.isDisplayExterno()) {
                    inter.setLanguage(new DisplayFisicoCSILanguage());
                }
                logger.info("InternacionalizacaoUtil carregada");
                boolean desabilitarDisplay = config.isIntegracaoDll() || config.isIntegracaoWeb() || config.isIntegracaoAndroid();
                controladorPerifericos = new ControladorPerifericos(confPerifericos, desabilitarDisplay);
                logger.info("Estrutura de perifericos carregada");
                String path = ControladorConfCTFClient.getDiretorioTrabalho();
                if ("".equals(path)) {
                    path = null;
                }
                PersistService.setPathApp(path, config.getVersaoPathTerminal());
                ControladorPersistencia.setPathApp(path, config.getVersaoPathTerminal());
                ControladorInicioDia.setPathApp(path, config.getVersaoPathTerminal());
                if (config.isIntegracaoWeb()) {
                    if (config.isControleTerminais()) {
                        terminalManager = TerminalManager.getInstance();
                    }
                } else if (config.isIntegracaoAndroid()) {
                    CMOSPinPad.setPathApp(ControladorConfCTFClient.getDiretorioTrabalho());
                    GenericPinpadController.setSecureCommunication(config.isComunicacaoSeguraPinpad());
                } else {
                    GenericPinpadController.setSecureCommunication(config.isComunicacaoSeguraPinpad());
                    if (config.getTimeoutPin() != null) {
                        GenericPinpadController.setTimeoutPin(config.getTimeoutPin().getTimeoutDefault(), config.getTimeoutPin().getTimeoutBlocking(), config.getTimeoutPin().getTimeoutNoblocking(), config.getTimeoutPin().getTimeoutStandard());
                    }
                    if (config.getConfClienteServico() != null && config.getConfClienteServico().isHabilitado()) {
                        POSTef.init(POSTefServico.class);
                        POSTef<?> posMovel = POSTef.getInstance();
                        posMovel.conecta();
                    }
                }
                CMOSPinPad.getInstance();
            }
        }
        catch (ExcecaoApiAc e) {
            logger.error(e);
            throw e;
        }
        catch (Throwable e) {
            logger.error(e);
        }
        return instance;
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            System.out.println("op\u00e7\u00f5es deste programa:");
            System.out.println("  -versao\t  vers\u00e3o do CTFClient");
            System.out.println("  -fabricante   fabricante da solu\u00e7\u00e3o CTFClient");
        } else if (args[0].equalsIgnoreCase("-versao")) {
            System.out.println("vers\u00e3o: C0409");
        } else if (args[0].equalsIgnoreCase("-fabricante")) {
            System.out.println("fabricante: AUTTAR PROCESSAMENTO DE DADOS");
        }
        System.exit(0);
    }

    @Deprecated
    public QrCodeGenerator getQrCodeGenerator() {
        return this.qrCodeGenerator;
    }

    protected ControladorPerifericos getControladorPerifericos() {
        return controladorPerifericos;
    }

    protected ControladorConfCTFClient getControladorConfCTFClient() {
        return controladorConfCTFClient;
    }

    public synchronized void config(ConfCTFClient config) throws ExcecaoApiAc {
        ControladorConfCTFClient.getInstance().save(config);
    }

    public synchronized ConfCTFClient getConfig() throws ExcecaoApiAc {
        return Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
    }

    public synchronized SaidaCTFClient efetuarTransacao(IdentTerminal ident, EntradaCTFClient entrada) {
        if (this.searchContexto != null && this.searchContexto.getEntradaIntegracao() != null && this.searchContexto.getEntradaIntegracao().isConsulta()) {
            try {
                controladorPerifericos.liberarRecursos(true);
            }
            catch (ExcecaoPerifericos excecaoPerifericos) {
                excecaoPerifericos.printStackTrace();
            }
        }
        return this.efetuarTransacao(ident, entrada, false, null);
    }

    public synchronized SaidaCTFClient efetuarConsulta(IdentTerminal ident, EntradaCTFClient entrada) {
        if (entrada.getOperacao() == OperationEnum.OP_DEBITO_GENERICO.getKey().intValue() || entrada.getOperacao() == OperationEnum.OP_CREDITO_GENERICO.getKey().intValue()) {
            SaidaCTFClient saida = this.getSaidaCTFClientErro(CodigoRetornoAutomacao.ERRO_INTERNO.getCode(), "5306", new String[]{"OPERACAO  NAO PERMITIDA"}, ident, entrada, false, false);
            logger.warn("consulta n\u00e3o habilitada para essa opera\u00e7\u00e3o.");
            return saida;
        }
        try {
            controladorPerifericos.liberarRecursos(true);
        }
        catch (ExcecaoPerifericos e) {
            logger.error("erro ao liberar recusos");
        }
        return this.efetuarTransacao(ident, entrada, true, null);
    }

    public synchronized SaidaCTFClient efetuarTransacao(IdentTerminal ident, EntradaCTFClient entrada, long identConsulta) {
        SaidaCTFClient saida;
        if (this.searchContexto != null && this.getIdentConsulta(this.searchContexto) == identConsulta) {
            if (this.validaGrupoTransacao(this.searchContexto.getEntradaIntegracao().getOperacao(), entrada.getOperacao())) {
                this.searchContexto.getEntradaApiTefC().setValorTransacao(entrada.getValorTransacao());
                EntradaCTFClientCtrl entradaSearch = this.searchContexto.getEntradaIntegracao();
                if (entradaSearch.getOperacao() == OperationEnum.OP_CREDITO_CELULAR_AVISTA.getKey().intValue() || entradaSearch.getOperacao() == OperationEnum.OP_CREDITO_CELULAR_PARC_ADMINISTRADORA.getKey().intValue() || entradaSearch.getOperacao() == OperationEnum.OP_CREDITO_CELULAR_PARC_LOJISTA.getKey().intValue()) {
                    if (entrada.getOperacao() == OperationEnum.OP_CREDITO.getKey().intValue()) {
                        entrada.setOperacao(OperationEnum.OP_CREDITO_CELULAR_AVISTA.getKey());
                    } else if (entrada.getOperacao() == OperationEnum.OP_CRED_PARC_SEM_JUROS.getKey().intValue()) {
                        entrada.setOperacao(OperationEnum.OP_CREDITO_CELULAR_PARC_LOJISTA.getKey());
                    } else if (entrada.getOperacao() == OperationEnum.OP_CRED_PARC_COM_JUROS.getKey().intValue()) {
                        entrada.setOperacao(OperationEnum.OP_CREDITO_CELULAR_PARC_ADMINISTRADORA.getKey());
                    }
                }
                logger.info("Transa\u00e7\u00e3o consulta " + this.searchContexto.getEntradaIntegracao().getOperacao() + " setada para " + entrada.getOperacao());
                saida = this.efetuarTransacao(ident, entrada, false, this.searchContexto);
            } else {
                logger.info("Execu\u00e7\u00e3o de transa\u00e7\u00e3o: Entrada difere da consulta");
                saida = this.efetuarTransacao(ident, entrada);
            }
        } else {
            logger.info("Execu\u00e7\u00e3o de transa\u00e7\u00e3o: Identificador da consulta n\u00e3o encontrado");
            if (identConsulta != 0L && this.searchContexto != null && OperationEnum.OP_CONSULTA_CARTAO.getDescription().equals(this.searchContexto.getTipoOperacao())) {
                return this.getSaidaCTFClientErro(CodigoRetornoAutomacao.ERRO_INTERNO.getCode(), "5365", "IDENTIFICADOR DA CONSULTA NAO ENCONTRADO", ident, entrada, false, false);
            }
            ControladorCriptografia.limparTabelaCriptografia();
            saida = this.efetuarTransacao(ident, entrada);
        }
        return saida;
    }

    /*
     * Exception decompiling
     */
    private SaidaCTFClient efetuarTransacao(IdentTerminal ident, EntradaCTFClient entrada, boolean isConsulta, ContextoCTFClient contextoCTFClient) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IdentTerminal configuraTerminalMultiEC(ConfCTFClient conf) {
        return ControladorMultiEC.criarTerminalComumMultiEC(conf.getCodigoGrupoMultiEC());
    }

    @Deprecated
    private IdentTerminal determinarTerminalMultiECConfirmacao(EntradaCTFClientCtrl entradaIntegracao) {
        IdentTerminal identTerminal;
        if (entradaIntegracao == null || !entradaIntegracao.isIdentificadorMultiECCtrl() || entradaIntegracao.getIdentificadorMultiEC() == null || entradaIntegracao.getIdentificadorMultiEC().length() == 0) {
            logger.error("Identificador do terminal Multi-EC n\u00e3o enviado, enviar o campo 102");
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.IDENTIFICADOR_TERMINAL_MULTI_EC_NAO_ENVIADO, "IDENTIFICADOR DO TERMINAL MULTI-EC NAO ENVIADO PELA AUTOMACAO"));
            return null;
        }
        ControladorMultiEC controladorMultiEC = ControladorMultiEC.getInstance();
        try {
            identTerminal = controladorMultiEC.determinarTerminal(entradaIntegracao.getIdentificadorMultiEC());
        }
        catch (IdentificadorMultiECNaoEncontradoException e) {
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.IDENTIFICADOR_TERMINAL_MULTI_EC_NAO_ENCONTRADO, "IDENTIFICADOR DO TERMINAL MULTI-EC NAO ENCONTRADO, EC ENVIADO PELA AUTOMACAO: " + entradaIntegracao.getIdentificadorMultiEC()));
            return null;
        }
        return identTerminal;
    }

    private boolean validaIdentTerminal(IdentTerminal ident) {
        try {
            ConfCTFClient conf = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
            if (!StringUtil.isEmpty(conf.getEstabelecimento()) && !ident.getEstabelecimento().equals(conf.getEstabelecimento())) {
                logger.warn("Estabelecimento difere da configura\u00e7\u00e3o. CTFClient -> " + conf.getEstabelecimento() + " / PDV -> " + ident.getEstabelecimento());
                return false;
            }
            if (!StringUtil.isEmpty(conf.getLoja()) && !conf.validaLoja(ident.getLoja())) {
                logger.warn("Loja difere da configura\u00e7\u00e3o. CTFClient -> " + conf.getLoja() + " / PDV -> " + ident.getLoja());
                return false;
            }
            if (!StringUtil.isEmpty(conf.getTerminal()) && !conf.validaTerminal(ident.getTerminal())) {
                logger.warn("Terminal (PDV) difere da configura\u00e7\u00e3o. CTFClient -> " + conf.getTerminal() + " / PDV -> " + ident.getTerminal());
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.warn("Falha ao validar o terminal: " + e.getMessage());
            return false;
        }
    }

    private boolean validaVersaoAc(String versao) {
        try {
            ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
            if (versao == null) {
                logger.warn("Vers\u00e3o difere da configura\u00e7\u00e3o. Vers\u00e3o n\u00e3o informada pela AC");
                return false;
            }
            if (versao.equals(conf.getVersaoAC())) {
                return true;
            }
            logger.warn("Vers\u00e3o difere da configura\u00e7\u00e3o. CTFClient -> " + conf.getVersaoAC() + " / PDV -> " + versao);
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void validaEntrada(EntradaCTFClientCtrl entrada, ConfCTFClient confCTFClient) throws ExcecaoEntradaCTFClient {
        int operacao = entrada.getOperacao();
        if (!entrada.isNumeroTransacaoCtrl() && operacao != OperationEnum.OP_DESFAZIMENTO_TODAS_TRANS.getKey()) {
            throw new ExcecaoEntradaCTFClient(CodigoRetornoAutomacao.ERRO_INTERNO.getCode(), "5323", new String[]{"NUMERO TRANS INVALIDO"});
        }
        if (!entrada.isDataAberturaCtrl()) {
            throw new ExcecaoEntradaCTFClient(CodigoRetornoAutomacao.ERRO_INTERNO.getCode(), "5324", new String[]{"DATA AC INVALIDA"});
        }
        if (confCTFClient.isIntegracaoStandAlone() && operacao != OperationEnum.OP_CONFIGURACAO_TERMINAL.getKey() && !entrada.isVersaoAcCtrl()) {
            throw new ExcecaoEntradaCTFClient(CodigoRetornoAutomacao.ERRO_INTERNO.getCode(), "5325", new String[]{"VERSAO AC INVALIDA"});
        }
    }

    private SaidaCTFClient getSaidaCTFClient(SaidaApiTefC saidaApiTef, int operacao, IdentTerminal ident, EntradaCTFClient entrada, boolean multiplosTerminais, boolean multiTransacao) {
        Plano plano;
        ConfCTFClient config = controladorConfCTFClient.getConfig();
        SaidaCTFClient saidaCTFClient = new SaidaCTFClient();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        saidaCTFClient = this.getSaidaCTFClient(ident, entrada, saidaCTFClient);
        if (saidaApiTef == null) {
            saidaCTFClient = this.getSaidaCTFClientErro(CodigoRetornoAutomacao.ERRO_INTERNO.getCode(), "5306", "OPERACAO NAO PERMITIDA", ident, entrada, multiplosTerminais, multiTransacao);
            return saidaCTFClient;
        }
        if (saidaApiTef.getRetorno() == 0) {
            Object creditoDigital;
            RespostaBypass respostaBypass;
            saidaCTFClient.setCodigoAprovacao(saidaApiTef.getCodigoAprovacao());
            saidaCTFClient.setMaxParcCJuros(saidaApiTef.getQtdMaximaParcelaComJuros());
            saidaCTFClient.setMaxParcSJuros(saidaApiTef.getQtdMaximaParcelaSemJuros());
            saidaCTFClient.setMinParcCJuros(saidaApiTef.getQtdMinimaParcelaComJuros());
            saidaCTFClient.setMinParcSJuros(saidaApiTef.getQtdMinimaParcelaSemJuros());
            saidaCTFClient.setNomeCliente(saidaApiTef.getNomeCliente());
            saidaCTFClient.setNomeInstFinanceira(saidaApiTef.getNomeInstituicaoFinanceira());
            saidaCTFClient.setTaxaJuros(saidaApiTef.getTaxaJuros());
            saidaCTFClient.setValorParcela(saidaApiTef.getValorParcela());
            saidaCTFClient.setValorTotal(saidaApiTef.getValorTotal());
            saidaCTFClient.setValorTransacao(saidaApiTef.getValorTransacao());
            saidaCTFClient.setTipoCapturaPreAutorizacao(saidaApiTef.getTipoCapturaPreAutorizacao());
            saidaCTFClient.setCodigoTransacaoCanceladaCTF(saidaApiTef.getCodigoTransacao());
            saidaCTFClient.setDadosConsultaFinanciamento(saidaApiTef.getDadosConsultaFinanciamento());
            saidaCTFClient.setPixTransactionId(Contexto.getContexto().getSaidaApiTefC().getPixTransactionId());
            saidaCTFClient.setPixReceiverPSP(Contexto.getContexto().getSaidaApiTefC().getPixReceiverPSP());
            if (saidaApiTef.getSplitPagamentoMktTransactionID() != null) {
                saidaCTFClient.setSplitPagamentoMktTransactionID(saidaApiTef.getSplitPagamentoMktTransactionID());
                saidaCTFClient.setSplitPagamentoPaymentID(saidaApiTef.getSplitPagamentoPaymentID());
            }
            saidaCTFClient.setStatusParticipantePromocao(saidaApiTef.getStatusParticipantePromocao());
            if (Contexto.getContexto().getCartao() != null) {
                if (saidaApiTef.getPanMascarado() != null && saidaApiTef.getPanMascarado().trim().length() > 0) {
                    saidaCTFClient.setNumeroCartao(saidaApiTef.getPanMascarado());
                } else if (entradaApiTefC.getPAN() != null) {
                    String numeroCartao = MascaraCartaoUtil.getNumeroMascaradoLegado4UltimosDigitos(entradaApiTefC.getPAN());
                    saidaCTFClient.setNumeroCartao(numeroCartao);
                }
            }
            if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_CREDITO_CELULAR_AVISTA.getDescription())) {
                saidaCTFClient.setNumeroCartao(entradaApiTefC.getDdd() + entradaApiTefC.getTelefone());
            }
            int operacaoTransacaoGenerica = 0;
            if (operacao == OperationEnum.OP_OUTRAS_TRANSACOES.getKey()) {
                operacaoTransacaoGenerica = Contexto.getContexto().getOperacao();
            }
            if (operacao == OperationEnum.OP_CONSULTA_AVS.getKey() || operacaoTransacaoGenerica == OperationEnum.OP_CONSULTA_AVS.getKey()) {
                RespostaConsultaAvs consultaAvs = new RespostaConsultaAvs();
                consultaAvs.setCodigoResposta(saidaApiTef.getCodigoRespostaAvs());
                consultaAvs.setResultadoConsulta(saidaApiTef.getResultadoAvs());
                saidaCTFClient.setRespostaConsultaAvs(consultaAvs);
            } else if (operacao == OperationEnum.OP_CONSULTA_FICHA_COMPENSACAO.getKey() || operacao == OperationEnum.OP_CONSULTA_CONVENIO.getKey() || operacao == OperationEnum.OP_PGTO_FICHA_COMPENSACAO.getKey() || operacao == OperationEnum.OP_PGTO_CONVENIO.getKey() || operacao == OperationEnum.OP_PGTO_FICHA_COMPENSACAO_COM_CONSULTA.getKey() || operacao == OperationEnum.OP_PGTO_CONVENIO_COM_CONSULTA.getKey()) {
                RespostaCorrespondenteBancario respostaCorBan = new RespostaCorrespondenteBancario();
                respostaCorBan.setCorrespondenteBancario(Contexto.getContexto().getCorrespondenteBancario());
                BigDecimal valorTransacao = saidaApiTef.getValorTransacao() != null && !saidaApiTef.getValorTransacao().equals(new BigDecimal(0)) ? saidaApiTef.getValorTransacao() : (entradaApiTefC.getValorTransacao() != null ? entradaApiTefC.getValorTransacao() : new BigDecimal(0));
                respostaCorBan.setValor(valorTransacao);
                if (entradaApiTefC.getValorDesconto() != null) {
                    respostaCorBan.setValorDesconto(entradaApiTefC.getValorDesconto());
                }
                if (entradaApiTefC.getValorAcrescimo() != null) {
                    respostaCorBan.setValorAcrescimo(entradaApiTefC.getValorAcrescimo());
                }
                if (entradaApiTefC.getDataVencimento() != null) {
                    respostaCorBan.setDataVencimento(entradaApiTefC.getDataVencimento());
                }
                if (entradaApiTefC.getDataVencimentoCorBan() != null) {
                    respostaCorBan.setDataVencimento(entradaApiTefC.getDataVencimentoCorBan());
                }
                String codigoBarras = entradaApiTefC.getCodigoBarras();
                int modoEntrada = entradaApiTefC.getFormatoCodigoBarrasEnum().getId();
                if (modoEntrada == FormatoCodigoBarrasEnum.CNAB_LIDO.getId() && config.isCapturaApenasLinhaDigitavel()) {
                    if (CodigoBarrasUtil.identificaTipoConta(codigoBarras) == 1) {
                        codigoBarras = CodigoBarrasUtil.converteCodigoBarrasTitulo(codigoBarras);
                        modoEntrada = FormatoCodigoBarrasEnum.CNAB_DIGITADO.getId();
                    } else if (CodigoBarrasUtil.identificaTipoConta(codigoBarras) == 2) {
                        codigoBarras = CodigoBarrasUtil.converteCodigoBarrasConvenio(codigoBarras);
                        modoEntrada = FormatoCodigoBarrasEnum.CNAB_DIGITADO.getId();
                    }
                }
                respostaCorBan.setCodigoBarras(codigoBarras);
                respostaCorBan.setModoEntrada(modoEntrada);
                respostaCorBan.setModalidadePagamento(Contexto.getContexto().getTipoPagamento());
                if (entradaApiTefC.getCmc7() != null) {
                    respostaCorBan.setCmc7(entradaApiTefC.getCmc7());
                }
                saidaCTFClient.setRespostaCorrespondenteBancario(respostaCorBan);
            } else if (operacao == OperationEnum.OP_BYPASS.getKey() || operacao == OperationEnum.OP_CONSULTA_FINANCIAMENTO_CREDITO.getKey() || operacao == OperationEnum.OP_CONSULTA_CREDITO_DIGITADO.getKey() || operacao == OperationEnum.OP_IDENTIFICACAO_CARTAO_ASSOCIADO.getKey() || operacao == OperationEnum.OP_CONSULTA_FATURA_CARTAO.getKey() || operacao == OperationEnum.OP_CONSULTA_CONTA.getKey()) {
                respostaBypass = new RespostaBypass();
                StringBuilder bypassMsg = new StringBuilder();
                bypassMsg.append(saidaApiTef.getDadosAdicionais() == null ? "" : saidaApiTef.getDadosAdicionais());
                if (saidaApiTef.getDadosComplementaresTef() != null) {
                    bypassMsg.append(saidaApiTef.getDadosComplementaresTef().length());
                    bypassMsg.append(saidaApiTef.getDadosComplementaresTef());
                }
                respostaBypass.setValue(bypassMsg.toString());
                saidaCTFClient.setRespostaBypass(respostaBypass);
            } else if (operacao == OperationEnum.OP_CONSULTA_VALORES_CREDITO_DIGITAL.getKey() || operacaoTransacaoGenerica == OperationEnum.OP_CONSULTA_VALORES_CREDITO_DIGITAL.getKey()) {
                creditoDigital = new RespostaConsultaValoresCreditoDigital();
                ((RespostaConsultaValoresCreditoDigital)creditoDigital).setVersaoLayout(config.getVersaoLayoutCD());
                ((RespostaConsultaValoresCreditoDigital)creditoDigital).setCodigoOperadora(saidaApiTef.getOperadoraTelefonia());
                ((RespostaConsultaValoresCreditoDigital)creditoDigital).setDDD(saidaApiTef.getDDD());
                ((RespostaConsultaValoresCreditoDigital)creditoDigital).setTelefone(saidaApiTef.getTelefone());
                ArrayList<BigDecimal> valores = new ArrayList<BigDecimal>();
                ArrayList<BigDecimal> bonus = new ArrayList<BigDecimal>();
                ((RespostaConsultaValoresCreditoDigital)creditoDigital).setValoresCreditoDigital(valores);
                ((RespostaConsultaValoresCreditoDigital)creditoDigital).setValoresBonus(bonus);
                ConsultaValoresCreditoDigital consultaValores = saidaApiTef.getValoresRecarga();
                if (consultaValores != null) {
                    ((RespostaConsultaValoresCreditoDigital)creditoDigital).setQtdeValores(consultaValores.getQtdeValores());
                    ((RespostaConsultaValoresCreditoDigital)creditoDigital).setQtdeBonus(consultaValores.getQtdeValores());
                    ((RespostaConsultaValoresCreditoDigital)creditoDigital).setValorVariavelMinimo(consultaValores.getValorVariavelMinimo());
                    ((RespostaConsultaValoresCreditoDigital)creditoDigital).setValorVariavelMaximo(consultaValores.getValorVariavelMaximo());
                    if (consultaValores.getValores() != null) {
                        for (ValorRecargaTelefone valorRecarga : consultaValores.getValores()) {
                            valores.add(valorRecarga.getValor());
                            bonus.add(valorRecarga.getBonus());
                        }
                    }
                }
                saidaCTFClient.setRespostaConsultaValoresCreditoDigital((RespostaConsultaValoresCreditoDigital)creditoDigital);
            } else if (operacao == OperationEnum.OP_COMPRA_CREDITO_DIGITAL.getKey()) {
                creditoDigital = new RespostaCompraCreditoDigital();
                ((RespostaCompraCreditoDigital)creditoDigital).setVersaoLayout(config.getVersaoLayoutCD());
                ((RespostaCompraCreditoDigital)creditoDigital).setCodigoOperadora(saidaApiTef.getOperadoraTelefonia());
                ((RespostaCompraCreditoDigital)creditoDigital).setDdd(saidaApiTef.getDDD());
                ((RespostaCompraCreditoDigital)creditoDigital).setTelefone(saidaApiTef.getTelefone());
                saidaCTFClient.setValorTransacao(entradaApiTefC.getValorTransacao());
                saidaCTFClient.setRespostaCompraCreditoDigital((RespostaCompraCreditoDigital)creditoDigital);
            } else if (operacao == OperationEnum.OP_COMPRA_VALE_GAS.getKey()) {
                RespostaValeGas respostaValeGas = new RespostaValeGas();
                if (entradaApiTefC.getOperadoraValeGas() != null) {
                    respostaValeGas.setDescricaoOperadora(entradaApiTefC.getOperadoraValeGas().getNome());
                }
                if (entradaApiTefC.getProdutoValeGas() != null) {
                    respostaValeGas.setCodigoProduto(entradaApiTefC.getProdutoValeGas().getCodigo());
                    respostaValeGas.setDescricaoProduto(entradaApiTefC.getProdutoValeGas().getDescricao());
                }
                respostaValeGas.setNumeroEVale(saidaApiTef.getNumeroEVale());
                saidaCTFClient.setRespostaValeGas(respostaValeGas);
            } else if (operacao == OperationEnum.OP_TEF_IP_CHEQUE.getKey()) {
                RespostaOperacaoCheque respostaCheque = new RespostaOperacaoCheque();
                respostaCheque.setCmc7(entradaApiTefC.getCmc7());
                respostaCheque.setTipoDocumento(entradaApiTefC.getTipoDocumento());
                if (entradaApiTefC.getTipoDocumento() == 1) {
                    respostaCheque.setDocumento(entradaApiTefC.getCnpj());
                } else {
                    respostaCheque.setDocumento(entradaApiTefC.getCpf());
                }
                respostaCheque.setDataCheque(entradaApiTefC.getDataCheque());
                respostaCheque.setBanco(entradaApiTefC.getBanco());
                respostaCheque.setAgencia(entradaApiTefC.getAgencia());
                respostaCheque.setContaCorrente(entradaApiTefC.getContaCorrente());
                saidaCTFClient.setRespostaCheque(respostaCheque);
            } else if (operacao == OperationEnum.OP_PAGAMENTO_FATURA_CARTAO.getKey()) {
                RespostaPagamentoFaturaCartao respostaPagamentoFatura = new RespostaPagamentoFaturaCartao();
                CorrespondenteBancario corban = new CorrespondenteBancario();
                corban.setCedente("");
                corban.setDataContabil(new Date());
                int tipoPagamento = Contexto.getContexto().getTipoPagamento();
                if (tipoPagamento > 0) {
                    switch (tipoPagamento) {
                        case 1: {
                            corban.setPagamentoDinheiro(true);
                            break;
                        }
                        case 2: {
                            corban.setPagamentoCheque(true);
                            break;
                        }
                        case 3: {
                            corban.setPagamentoChequeBanco(true);
                            break;
                        }
                        case 4: {
                            corban.setPagamentoDebito(true);
                            break;
                        }
                        case 5: {
                            corban.setPagamentoCredito(true);
                            break;
                        }
                        case 6: {
                            corban.setPagamentoCartaoProprio(true);
                            break;
                        }
                    }
                }
                corban.setNumeroConvenio("");
                corban.setFiller("");
                corban.setAutenticacao("");
                respostaPagamentoFatura.setCorrespondenteBancario(corban);
                BigDecimal valorTransacao = saidaApiTef.getValorTransacao() != null && !saidaApiTef.getValorTransacao().equals(new BigDecimal(0)) ? saidaApiTef.getValorTransacao() : (entradaApiTefC.getValorTransacao() != null ? entradaApiTefC.getValorTransacao() : new BigDecimal(0));
                respostaPagamentoFatura.setValorDevido(valorTransacao);
                respostaPagamentoFatura.setValorOriginal(valorTransacao);
                respostaPagamentoFatura.setPagamentoMinimo(valorTransacao);
                respostaPagamentoFatura.setNumeroDocumento("0");
                if (entradaApiTefC.getValorDesconto() != null) {
                    respostaPagamentoFatura.setValorDesconto(entradaApiTefC.getValorDesconto());
                }
                if (entradaApiTefC.getValorAcrescimo() != null) {
                    respostaPagamentoFatura.setValorAcrescimo(entradaApiTefC.getValorAcrescimo());
                }
                if (entradaApiTefC.getDataVencimentoCorBan() != null) {
                    respostaPagamentoFatura.setDataVencimento(entradaApiTefC.getDataVencimentoCorBan());
                } else if (entradaApiTefC.getDataVencimento() != null) {
                    respostaPagamentoFatura.setDataVencimento(entradaApiTefC.getDataVencimento());
                }
                String codigoBarras = entradaApiTefC.getCodigoBarras();
                if (codigoBarras != null) {
                    int modoEntrada = entradaApiTefC.getFormatoCodigoBarrasEnum().getId();
                    if (modoEntrada == FormatoCodigoBarrasEnum.CNAB_LIDO.getId() && config.isCapturaApenasLinhaDigitavel()) {
                        if (CodigoBarrasUtil.identificaTipoConta(codigoBarras) == 1) {
                            codigoBarras = CodigoBarrasUtil.converteCodigoBarrasTitulo(codigoBarras);
                            modoEntrada = FormatoCodigoBarrasEnum.CNAB_DIGITADO.getId();
                        } else if (CodigoBarrasUtil.identificaTipoConta(codigoBarras) == 2) {
                            codigoBarras = CodigoBarrasUtil.converteCodigoBarrasConvenio(codigoBarras);
                            modoEntrada = FormatoCodigoBarrasEnum.CNAB_DIGITADO.getId();
                        }
                    }
                    respostaPagamentoFatura.setCodigoBarras(codigoBarras);
                    respostaPagamentoFatura.setModoEntrada(modoEntrada);
                }
                respostaPagamentoFatura.setModalidadePagamento(Contexto.getContexto().getTipoPagamento());
                if (entradaApiTefC.getCmc7() != null) {
                    respostaPagamentoFatura.setCmc7(entradaApiTefC.getCmc7());
                }
                saidaCTFClient.setRespostaPagamentoFaturaCartao(respostaPagamentoFatura);
            } else if (operacao == OperationEnum.OP_CONSULTA_ANALITICA_SPC.getKey()) {
                RespostaConsultaAnaliticaSPC respostaConsultaAnaliticaSPC = new RespostaConsultaAnaliticaSPC();
                if (saidaApiTef.getBit62() != null) {
                    respostaConsultaAnaliticaSPC.setBit62(saidaApiTef.getBit62());
                }
                saidaCTFClient.setRespostaConsultaAnaliticaSPC(respostaConsultaAnaliticaSPC);
            } else if (operacao == OperationEnum.OP_ATIVACAO_CARTAO_PREPAGO.getKey() || operacao == OperationEnum.OP_RECARGA_CARTAO_PREPAGO_POSA.getKey()) {
                RespostaAtivacaoCartaoPrepago respostaAtivacaoCartaoPrepago = new RespostaAtivacaoCartaoPrepago();
                respostaAtivacaoCartaoPrepago.setValorCartaoPrepago(saidaApiTef.getValorCartaoPrepago());
                respostaAtivacaoCartaoPrepago.setValorBonus(saidaApiTef.getValorBonus());
                respostaAtivacaoCartaoPrepago.setValorAtivacao(saidaApiTef.getValorAcrescimo());
                respostaAtivacaoCartaoPrepago.setValorDesconto(saidaApiTef.getValorDesconto());
                respostaAtivacaoCartaoPrepago.setValorPago(saidaApiTef.getValorTransacao());
                if (TransactionOperationRules.isCartaoPrePagoValorVariavel()) {
                    respostaAtivacaoCartaoPrepago.setValorMinimo(Contexto.getContexto().getValorMinimoPrePago());
                    respostaAtivacaoCartaoPrepago.setValorMaximo(Contexto.getContexto().getValorMaximoPrePago());
                    respostaAtivacaoCartaoPrepago.setValorCartaoPrepago(BigDecimal.ZERO);
                    if (Contexto.getContexto().getEntradaIntegracao().isConsulta()) {
                        respostaAtivacaoCartaoPrepago.setValorPago(BigDecimal.ZERO);
                    }
                } else {
                    respostaAtivacaoCartaoPrepago.setValorMinimo(BigDecimal.ZERO);
                    respostaAtivacaoCartaoPrepago.setValorMaximo(BigDecimal.ZERO);
                }
                saidaCTFClient.setRespostaAtivacaoCartaoPrepago(respostaAtivacaoCartaoPrepago);
            } else if (operacao == OperationEnum.OP_CARGA_PRODUTOS_PROMOCIONAIS.getKey() || operacao == OperationEnum.OP_DESCONTO_PRODUTOS_PROMOCIONAIS.getKey()) {
                RespostaProdutosPromocionais respostaProdutosPromocionais = new RespostaProdutosPromocionais();
                respostaProdutosPromocionais.setTimestamp(saidaApiTef.getTimestampProdutosPromocionais());
                ArrayList<ProdutoPromocional> listProdutosPromocionaisResposta = new ArrayList<ProdutoPromocional>();
                List<ProdutoPromocional> listProdutosPromocionais = null;
                if (operacao == OperationEnum.OP_CARGA_PRODUTOS_PROMOCIONAIS.getKey()) {
                    listProdutosPromocionais = saidaApiTef.getProdutosPromocionais();
                } else if (operacao == OperationEnum.OP_DESCONTO_PRODUTOS_PROMOCIONAIS.getKey()) {
                    listProdutosPromocionais = saidaApiTef.getDadosProdutosPromocionais();
                }
                if (listProdutosPromocionais != null) {
                    for (ProdutoPromocional produtoSaidaApiTef : listProdutosPromocionais) {
                        ProdutoPromocional produtoResposta = new ProdutoPromocional();
                        produtoResposta.setCodigoEAN(produtoSaidaApiTef.getCodigoEAN());
                        if (operacao == OperationEnum.OP_DESCONTO_PRODUTOS_PROMOCIONAIS.getKey()) {
                            produtoResposta.setQuantidade(produtoSaidaApiTef.getQuantidade());
                            produtoResposta.setValorDesconto(produtoSaidaApiTef.getValorDesconto());
                        }
                        listProdutosPromocionaisResposta.add(produtoResposta);
                    }
                    respostaProdutosPromocionais.setListProdutosPromocionais(listProdutosPromocionaisResposta);
                    saidaCTFClient.setRespostaProdutosPromocionais(respostaProdutosPromocionais);
                }
            } else if (operacao == OperationEnum.OP_CONSULTA_PENDENCIAS.getKey()) {
                String[] valores;
                String adicionais = saidaApiTef.getDadosAdicionais();
                if (adicionais != null && (valores = StringUtil.splitPorTamanho(adicionais, 6)) != null && valores.length > 0) {
                    ArrayList<TransacaoPendente> transacoesPendentes = new ArrayList<TransacaoPendente>();
                    for (String valore : valores) {
                        transacoesPendentes.add(new TransacaoPendente(Integer.parseInt(valore)));
                    }
                    saidaCTFClient.setTransacoesPendentes(transacoesPendentes);
                }
            } else if (operacao == OperationEnum.OP_SIMULACAO_CREDIARIO_DE_CREDITO.getKey()) {
                RespostaSimulacaoCrediario respostaSimulacaoCrediario = new RespostaSimulacaoCrediario();
                if (saidaApiTef.getDadosFinanciamentoCrediario() != null) {
                    respostaSimulacaoCrediario.setDadosSimulacao(saidaApiTef.getDadosFinanciamentoCrediario());
                } else {
                    ProdutoSimulacaoCrediario produto = Contexto.getContexto().getProdutoSimulacaoCrediarioSelecionado();
                    respostaSimulacaoCrediario.setDadosSimulacao(produto.getCupom(0));
                }
                saidaCTFClient.setRespostaSimulacaoCrediario(respostaSimulacaoCrediario);
            } else if (operacao == OperationEnum.OP_CONSULTA_TELEFONE_CREDITO_DIGITAL.getKey()) {
                creditoDigital = new RespostaConsultaTelefoneCreditoDigital();
                ((RespostaConsultaTelefoneCreditoDigital)creditoDigital).setVersaoLayout(config.getVersaoLayoutCD());
                ((RespostaConsultaTelefoneCreditoDigital)creditoDigital).setDdd(saidaApiTef.getDDD());
                ((RespostaConsultaTelefoneCreditoDigital)creditoDigital).setTelefone(saidaApiTef.getTelefone());
                saidaCTFClient.setRespostaConsultaTelefoneCreditoDigital((RespostaConsultaTelefoneCreditoDigital)creditoDigital);
            } else if (operacao == OperationEnum.OP_CAPTURA_DADO_PINPAD.getKey()) {
                saidaCTFClient.setCapturaDadoPinpad(Contexto.getContexto().getCapturaDadoPinpad());
            } else if (operacao == OperationEnum.OP_EMISSAO_VALE_TROCA.getKey() || operacao == OperationEnum.OP_RESGATE_VALE_TROCA.getKey() || operacao == OperationEnum.OP_CONSULTA_REIMPRESSAO_VALE_TROCA.getKey() || operacao == OperationEnum.OP_REIMPRESSAO_VALE_TROCA.getKey() || operacao == OperationEnum.OP_CONSULTA_GARANTIA_ESTENDIDA.getKey() || operacao == OperationEnum.OP_CONSULTA_GARANTIA_ROUBO_FURTO.getKey() || operacao == OperationEnum.OP_PAGAMENTO_GARANTIA_EXTENDIDA.getKey() || operacao == OperationEnum.OP_PAGAMENTO_GARANTIA_ROUBO_FURTO.getKey() || operacao == OperationEnum.OP_CONSULTA_RESGATE_GARANTIA_NAO_MAGNETICA.getKey() || operacao == OperationEnum.OP_COMPRA_RESGATE_GARANTIA_NAO_MAGNETICA.getKey() || operacao == OperationEnum.OP_CONSULTA_ASSOCIADO.getKey() || operacao == OperationEnum.OP_COMPRA_ASSOCIADO.getKey() || operacao == OperationEnum.OP_CARGA_HABILITACAO_CARTAO_PRESENTE.getKey() || operacao == OperationEnum.OP_RESGATE_CARTAO_PRESENTE_SAA.getKey() || operacao == OperationEnum.OP_CONSULTA_CARTAO_PRESENTE_SAA.getKey() || operacao == OperationEnum.OP_CARGA_HABILITACAO_CUPONAGEM.getKey() || operacao == OperationEnum.OP_CONSULTA_CUPONAGEM.getKey() || operacao == OperationEnum.OP_RESGATE_CUPONAGEM.getKey()) {
                RespostaTransacoesSAA respostaTransacoesSAA = new RespostaTransacoesSAA();
                respostaTransacoesSAA.setBit62(saidaApiTef.getDadosAdicionais());
                saidaCTFClient.setRespostaTransacoesSAA(respostaTransacoesSAA);
                if ((operacao == OperationEnum.OP_EMISSAO_VALE_TROCA.getKey() || operacao == OperationEnum.OP_RESGATE_VALE_TROCA.getKey()) && saidaApiTef.getNumeroCartao() != null & saidaApiTef.getNumeroCartao().length() >= 8) {
                    saidaCTFClient.setNumeroValeTroca(saidaApiTef.getNumeroCartao().substring(saidaApiTef.getNumeroCartao().length() - 8));
                }
            } else if (operacao == OperationEnum.OP_CONSULTA_ESTABELECIMENTOS_MULTI_EC.getKey()) {
                RespostaConsultaEstabelecimentosMultiEC respostaMultiEC = new RespostaConsultaEstabelecimentosMultiEC();
                ArrayList<EstabelecimentoMultiECResposta> listEstabelecimentosResposta = new ArrayList<EstabelecimentoMultiECResposta>();
                ControladorMultiEC controladorMultiEC = ControladorMultiEC.getInstance();
                if (controladorMultiEC.getDadosEstabelecimentosMultiEC() != null && controladorMultiEC.getDadosEstabelecimentosMultiEC().getListEstabelecimentoMultiECs() != null) {
                    for (EstabelecimentoMultiEC estabelecimentoApitef : controladorMultiEC.getDadosEstabelecimentosMultiEC().getListEstabelecimentoMultiECs()) {
                        EstabelecimentoMultiECResposta estabelecimentoResposta = new EstabelecimentoMultiECResposta();
                        estabelecimentoResposta.setEstabelecimento(estabelecimentoApitef.getEstabelecimento());
                        estabelecimentoResposta.setLoja(estabelecimentoApitef.getLoja());
                        estabelecimentoResposta.setDescricao(estabelecimentoApitef.getDescricao());
                        estabelecimentoResposta.setIdentificadorEstabelecimento(estabelecimentoApitef.getIdentificadorEstabelecimento());
                        listEstabelecimentosResposta.add(estabelecimentoResposta);
                    }
                }
                respostaMultiEC.setListEstabelecimentosComerciais(listEstabelecimentosResposta);
                saidaCTFClient.setRespostaConsultaEstabelecimentosMultiEC(respostaMultiEC);
            } else if (operacao == OperationEnum.OP_CREDITO.getKey()) {
                if (entrada.isExecutaConsultaFinanciamentoAutorizadora() && saidaCTFClient.getDadosConsultaFinanciamento() != null) {
                    respostaBypass = new RespostaBypass();
                    respostaBypass.setValue(saidaCTFClient.getDadosConsultaFinanciamento());
                    saidaCTFClient.setRespostaBypass(respostaBypass);
                }
            } else if (operacao == OperationEnum.OP_CONSULTA_CARTAO_PREPAGO_DIGITAL.getKey()) {
                List<CartaoPrepagoDigital> listCartaoPrepagoDigital = saidaApiTef.getListCartaoPrepagoDigital();
                if (listCartaoPrepagoDigital != null) {
                    ArrayList<CartaoPrepagoDigitalResposta> listCartaoResposta = new ArrayList<CartaoPrepagoDigitalResposta>();
                    for (CartaoPrepagoDigital cartaoPrepago : listCartaoPrepagoDigital) {
                        CartaoPrepagoDigitalResposta cartaoPrepagoResposta = new CartaoPrepagoDigitalResposta();
                        cartaoPrepagoResposta.setCodigoEAN(cartaoPrepago.getCodigoEAN());
                        cartaoPrepagoResposta.setDescricao(cartaoPrepago.getDescricao());
                        cartaoPrepagoResposta.setValor(cartaoPrepago.getValor());
                        listCartaoResposta.add(cartaoPrepagoResposta);
                    }
                    RespostaConsultaCartaoPrepagoDigital resposta = new RespostaConsultaCartaoPrepagoDigital();
                    resposta.setListCartaoPrepagoDigital(listCartaoResposta);
                    saidaCTFClient.setRespostaConsultaCartaoPrepagoDigital(resposta);
                }
            } else if (!(operacao != OperationEnum.OP_QR_CODE_GENERICO.getKey() && operacao != OperationEnum.OP_CANCELAMENTO_GENERICO.getKey() && operacao != OperationEnum.OP_CANCELAMENTO_CRED.getKey() && operacao != OperationEnum.OP_CANCELAMENTO_DEB.getKey() && operacao != OperationEnum.OP_PIX_PAYMENT.getKey() && operacao != OperationEnum.OP_PIX_QUERY.getKey() || StringUtil.isEmpty(ControladorPersistencia.getInstance().getQrCodeImagePath()))) {
                QrCodeQueryResponse response = new QrCodeQueryResponse();
                response.setQrCodeImagePath(ControladorPersistencia.getInstance().getQrCodeImagePath());
                saidaCTFClient.setQrCodeQueryResponse(response);
            }
        } else if (saidaApiTef.getRetorno() == CodigoRetornoAutomacao.ERRO_INTERNO.getCode()) {
            logger.debug("Verificar CTFClient, altera\u00e7\u00e3o na leitura do chip");
            return this.getSaidaCTFClientErro(ident, entrada, multiplosTerminais, multiTransacao);
        }
        if (Contexto.getContexto().getCartao() != null) {
            Cartao cartao = Contexto.getContexto().getCartao();
            saidaCTFClient.setTipoCapturaCartao(cartao.getModoEntrada().getId());
        }
        if (Contexto.getContexto().getPinInfo() != null) {
            if (Contexto.getContexto().getPinInfo().isCapturadoVerificacaoOnline() || Contexto.getContexto().getPinInfo().isVerificadoOffline()) {
                saidaCTFClient.setVerificacaoPortadorCartao(1);
            } else if (!(Contexto.getContexto().getCartao() != Cartao.CONTACTLESS_TARJA && Contexto.getContexto().getCartao() != Cartao.CONTACTLESS_EMV || Contexto.getContexto().getPinInfo().isCapturadoVerificacaoOnline() || Contexto.getContexto().getPinInfo().isVerificadoOffline() || Contexto.getContexto().getPinInfo().isRequerAssinatura())) {
                saidaCTFClient.setVerificacaoPortadorCartao(3);
            } else {
                saidaCTFClient.setVerificacaoPortadorCartao(2);
            }
        } else if (saidaApiTef.getRetorno() == 0) {
            saidaCTFClient.setVerificacaoPortadorCartao(2);
        }
        if (saidaApiTef.getRetorno() != CodigoRetornoAutomacao.ERRO_INTERNO.getCode()) {
            saidaCTFClient.setMensagemCTF(saidaApiTef.getDisplayCTF());
            saidaCTFClient.setCodigoRetorno(saidaApiTef.getRetorno());
            saidaCTFClient.setCodigoErro(saidaApiTef.getCodigoErro());
        }
        saidaCTFClient.setNsuCTF(saidaApiTef.getNsuCTF());
        saidaCTFClient.setCodigoRespAutorizadora(saidaApiTef.getCodigoRespostaAutorizadora());
        if (saidaApiTef.getNsuAutorizacao() != null) {
            try {
                saidaCTFClient.setNsuAutorizadora(new Long(saidaApiTef.getNsuAutorizacao()));
            }
            catch (Exception cartao) {
                // empty catch block
            }
        }
        saidaCTFClient.setDadosComplementaresTef(saidaApiTef.getDadosComplementaresTef());
        VerifyContentUtil.preencheDadosSaida(saidaApiTef);
        if (saidaApiTef.getDataAutorizadora() != null) {
            saidaCTFClient.setHorarioTransacao(saidaApiTef.getDataAutorizadora());
        } else if (Contexto.getContexto().getDataAutorizadora() != null) {
            saidaCTFClient.setHorarioTransacao(Contexto.getContexto().getDataAutorizadora());
        } else {
            saidaCTFClient.setHorarioTransacao(new Date());
        }
        if (Contexto.getContexto().getCodigoVan() > 0) {
            saidaCTFClient.setCodigoVan(Contexto.getContexto().getCodigoVan());
        }
        if (Contexto.getContexto().getNomeVan() != null) {
            saidaCTFClient.setNomeVan(Contexto.getContexto().getNomeVan());
        }
        if (Contexto.getContexto().getCodigoVanAlfa() != null) {
            saidaCTFClient.setCodigoVanAlfa(Contexto.getContexto().getCodigoVanAlfa());
        }
        if (Contexto.getContexto().getCodigoAutorizadora() != null) {
            saidaCTFClient.setCodigoAutorizadora(Contexto.getContexto().getCodigoAutorizadora());
            saidaCTFClient.setNomeAutorizadora(Contexto.getContexto().getNomeAutorizadora());
        }
        if (Contexto.getContexto().getCodigoInstituicaoFinanceira() > 0) {
            saidaCTFClient.setCodigoInstFinanceira(Contexto.getContexto().getCodigoInstituicaoFinanceira());
            saidaCTFClient.setNomeInstFinanceira(Contexto.getContexto().getNomeInstituicaoFinanceira());
        }
        if (saidaApiTef.getNomeBandeiraProduto() != null) {
            saidaCTFClient.setNomeBandeiraProduto(saidaApiTef.getNomeBandeiraProduto());
        }
        if (saidaApiTef.getNomeRedeAdquirente() != null) {
            saidaCTFClient.setNomeRedeAdquirente(saidaApiTef.getNomeRedeAdquirente());
        }
        if (entradaApiTefC.getOperacao() != null) {
            saidaCTFClient.setCodigoTransacaoCTF(entradaApiTefC.getOperacao());
        }
        saidaCTFClient.setInformacaoCriptografada("");
        saidaCTFClient.setSaldoCliente(saidaApiTef.getSaldoCliente());
        saidaCTFClient.setLogomarca(saidaApiTef.getLogomarca());
        if (entradaApiTefC.getNsuCtf() > 0) {
            saidaCTFClient.setNsuCTFOriginal(entradaApiTefC.getNsuCtf());
        }
        if (Plano.isPlanoParcelado(plano = Contexto.getContexto().getPlano())) {
            saidaCTFClient.setNumeroParcelas(entradaApiTefC.getNumeroParcelas());
        }
        if (plano != null) {
            if (entradaApiTefC.getValorEntrada() != null) {
                saidaCTFClient.setValorEntrada(entradaApiTefC.getValorEntrada());
            }
            if (entradaApiTefC.getDataVencimentoDebito() != null) {
                saidaCTFClient.setData1aParcela(entradaApiTefC.getDataVencimentoDebito());
            } else if (entradaApiTefC.getDataVencimento() != null) {
                saidaCTFClient.setData1aParcela(entradaApiTefC.getDataVencimento());
            }
            if (entradaApiTefC.getValorParcela() != null) {
                saidaCTFClient.setValorParcela(entradaApiTefC.getValorParcela());
            }
            if (plano == Plano.PREDATADO && entradaApiTefC.getTipoGarantia() != -1) {
                saidaCTFClient.setTipoGarantia(entradaApiTefC.getTipoGarantia());
            }
            if (plano == Plano.AVISTA) {
                saidaCTFClient.setValorSaque(entradaApiTefC.getValorCashBack());
            }
        }
        if (Contexto.getContexto().getParcelas() != null) {
            saidaCTFClient.setConsultaParcelas(Contexto.getContexto().getParcelas());
        }
        if (Contexto.getContexto().getValorDescontoMonetario() != null) {
            saidaCTFClient.setValorDesconto(Contexto.getContexto().getValorDescontoMonetario());
        }
        if (multiplosTerminais && multiTransacao) {
            saidaCTFClient.setCodigoMultitransacao(IdentTerminal.parseCodigoMultitransacao(ident));
        }
        if (saidaCTFClient.getValorTransacao() == null && entradaApiTefC.getValorTransacao() != null) {
            saidaCTFClient.setValorTransacao(entradaApiTefC.getValorTransacao());
        }
        if (!StringUtil.isEmpty(saidaApiTef.getNomeCliente())) {
            saidaCTFClient.setNomeCliente(saidaApiTef.getNomeCliente());
        } else {
            saidaCTFClient.setNomeCliente(Contexto.getContexto().getNomeCliente());
        }
        if (saidaApiTef.getDataVencimento() != null) {
            saidaCTFClient.setDataVencimentoCartao(DateUtil.parse(saidaApiTef.getDataVencimento(), "MMyy"));
        } else if (Contexto.getContexto().getDataVencimento() != null) {
            saidaCTFClient.setDataVencimentoCartao(DateUtil.parse(Contexto.getContexto().getDataVencimento(), "MMyy"));
        } else if (saidaApiTef.getVencimentoCartao() != null && saidaApiTef.getVencimentoCartao().trim().length() == 4) {
            String data = saidaApiTef.getVencimentoCartao();
            saidaCTFClient.setDataVencimentoCartao(data.substring(2) + data.substring(0, 2));
        }
        this.validaSaidaCTFClient(saidaCTFClient);
        logger.info("terminal " + ident + " retorno=" + saidaCTFClient.getCodigoRetorno() + " erro=" + saidaCTFClient.getCodigoErro() + " nsu_ctf=" + saidaCTFClient.getNsuCTF() + " resp_autorizadora=" + saidaCTFClient.getCodigoRespAutorizadora());
        return saidaCTFClient;
    }

    private SaidaCTFClient getSaidaCTFClient(IdentTerminal ident, EntradaCTFClient entrada, SaidaCTFClient saidaCTFClient) {
        if (entrada != null) {
            saidaCTFClient.setOperacao(entrada.getOperacao());
            saidaCTFClient.setDocumento(entrada.getNumeroCupom());
        }
        if (ident != null) {
            saidaCTFClient.setEstabelecimento(ident.getEstabelecimento());
            saidaCTFClient.setLoja(ident.getLoja());
            saidaCTFClient.setTerminal(ident.getTerminal());
        }
        return saidaCTFClient;
    }

    private void trataByPass(EntradaCTFClientCtrl entradaIntegracaoCtrl) {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entradaIntegracaoCtrl.isValorTransacaoCtrl()) {
            entradaApiTefC.setValorTransacao(entradaApiTefC.getValorTransacao());
        } else {
            entradaApiTefC.setValorTransacao(null);
        }
        if (entradaApiTefC.getInfo() == null && entradaIntegracaoCtrl.isInfoCtrl()) {
            entradaApiTefC.setInfo(entradaIntegracaoCtrl.getInfo());
        }
        if (entradaApiTefC.getValorDesconto() == null && entradaIntegracaoCtrl.isValorDescontoCtrl()) {
            entradaApiTefC.setValorDesconto(entradaIntegracaoCtrl.getValorDesconto());
        }
        if (entradaApiTefC.getValorAcrescimo() == null && entradaIntegracaoCtrl.isValorAcrescimoCtrl()) {
            entradaApiTefC.setValorAcrescimo(entradaIntegracaoCtrl.getValorAcrescimo());
        }
        if (Contexto.getContexto().getCartao() == null && entradaIntegracaoCtrl.isModoEntradaCartaoCtrl()) {
            entradaApiTefC.setModoEntrada(entradaIntegracaoCtrl.getModoEntradaCartao());
        }
        if (Contexto.getContexto().getPlano() == null && entradaIntegracaoCtrl.isNumeroParcelasCtrl()) {
            int numeroParcelas = entradaIntegracaoCtrl.getNumeroParcelas();
            if (numeroParcelas > 1) {
                if (entradaIntegracaoCtrl.isValorEntradaCtrl()) {
                    Contexto.getContexto().setPlano(Plano.CDC);
                    entradaApiTefC.setValorEntrada(entradaIntegracaoCtrl.getValorEntrada());
                    entradaApiTefC.setNumeroParcelas(numeroParcelas);
                } else {
                    Contexto.getContexto().setPlano(Plano.ADMINISTRADORA);
                    entradaApiTefC.setNumeroParcelas(numeroParcelas);
                }
            } else if (numeroParcelas == 1) {
                Contexto.getContexto().setPlano(Plano.AVISTA);
                if (entradaIntegracaoCtrl.isValorSaqueCtrl()) {
                    entradaApiTefC.setValorCashBack(entradaIntegracaoCtrl.getValorSaque());
                }
                entradaApiTefC.setNumeroParcelas(1);
            } else {
                entradaApiTefC.setNumeroParcelas(0);
            }
        }
        if (entradaApiTefC.getNsuCtf() == 0 && entradaIntegracaoCtrl.isNsuCTFCtrl()) {
            entradaApiTefC.setNsuCtf(entradaIntegracaoCtrl.getNsuCTF());
        }
        if (entradaApiTefC.getValorTaxaEmbarque() == null && entradaIntegracaoCtrl.isValorTaxaEmbarqueCtrl()) {
            entradaApiTefC.setValorTaxaEmbarque(entradaIntegracaoCtrl.getValorTaxaEmbarque());
        }
        if (entradaApiTefC.getValorTaxaServico() == null && entradaIntegracaoCtrl.isValorTaxaServicoCtrl()) {
            entradaApiTefC.setValorTaxaServico(entradaIntegracaoCtrl.getValorTaxaServico());
        }
    }

    private Process getProcess(EntradaCTFClientCtrl entradaIntegracao) {
        OperationEnum operation = OperationEnum.getEnumByKey(entradaIntegracao.getOperacao());
        int numeroTransacao = 1;
        ProcessConstructorArguments processConstructorArguments = new ProcessConstructorArguments(auttarLoggerFactory, this.qrCodeGenerator, operation);
        switch (operation) {
            case OP_CRED_CARTAO_QUALIDADE: {
                return new ProcessCreditoCartaoQualidade(processConstructorArguments, entradaIntegracao);
            }
            case OP_PIX_PAYMENT: {
                return new ProcessPixPayment(processConstructorArguments);
            }
            case OP_PIX_QUERY: {
                return new ProcessPixQuery(processConstructorArguments);
            }
            case OP_QR_CODE_GENERICO: {
                return new ProcessQrCodeGenerico(processConstructorArguments, entradaIntegracao);
            }
            case OP_CONSULTA_CPF_PROMOCAO_SHELL: {
                return new ProcessConsultaCPFPromocaoShell(processConstructorArguments, entradaIntegracao);
            }
            case OP_RESGATE_PREMIO_SHELL: {
                return new ProcessResgatePremiosShell(processConstructorArguments, entradaIntegracao);
            }
            case OP_ATUALIZACAO_PARTICIPANTE: {
                return new ProcessAtualizacaoParticipante(processConstructorArguments, entradaIntegracao);
            }
            case OP_GERACAO_BENEFICIO: {
                return new ProcessGeracaoBeneficio(processConstructorArguments, entradaIntegracao);
            }
            case OP_CONFIRMACAO: {
                return new ProcessConfirmacao(processConstructorArguments, entradaIntegracao);
            }
            case OP_DESFAZIMENTO: {
                if (controladorConfCTFClient.getConfig().isIntegracaoTefIP() || controladorConfCTFClient.getConfig().isIntegracaoTefDisc()) {
                    numeroTransacao = entradaIntegracao.getNumeroTransacao();
                } else {
                    entradaIntegracao.setNumeroTransacao(numeroTransacao);
                }
                return new ProcessDesfazimento(processConstructorArguments, entradaIntegracao, numeroTransacao);
            }
            case OP_DESFAZIMENTO_TODAS_TRANS: {
                entradaIntegracao.setNumeroTransacao(numeroTransacao);
                return new ProcessDesfazimentoGeral(processConstructorArguments, entradaIntegracao, numeroTransacao);
            }
            case OP_DEBITO: 
            case OP_DEB_PRE_DATADO: 
            case OP_DEB_PARCELADO_COM_PARC_AVISTA: 
            case OP_DEB_PARCELADO_SEM_PARC_AVISTA: 
            case OP_DEB_CDC_COM_PARC_AVISTA: 
            case OP_DEB_CDC_SEM_PARC_AVISTA: 
            case OP_DEB_CDC_GENERICO: {
                if (entradaIntegracao.isAutenticacaoEmissor()) {
                    return new ProcessEcommerceAutenticado(processConstructorArguments, entradaIntegracao);
                }
                return new ProcessTransacoesGenericas(processConstructorArguments, entradaIntegracao.getNumeroTransacao(), entradaIntegracao, OperationEnum.OP_DEBITO_GENERICO.getDescription());
            }
            case OP_DEBITO_GENERICO: 
            case OP_OUTRAS_TRANSACOES: {
                return new ProcessTransacoesGenericas(processConstructorArguments, entradaIntegracao.getNumeroTransacao(), entradaIntegracao.getValorTransacao(), entradaIntegracao.getNumeroCupom(), operation.getDescription(), OrigemTransacaoEnum.DEFAULT);
            }
            case OP_DEB_VOUCHER: 
            case OP_CREDIARIO_DE_DEBITO: 
            case OP_CREDIARIO_DE_CREDITO: 
            case OP_SIMULACAO_CREDIARIO_DE_CREDITO: 
            case OP_CREDITO: 
            case OP_CRED_PARC_COM_JUROS: 
            case OP_CRED_PARC_SEM_JUROS: {
                return new ProcessTransacoesGenericas(processConstructorArguments, entradaIntegracao.getNumeroTransacao(), entradaIntegracao, operation.getDescription());
            }
            case OP_VOUCHER: {
                return new ProcessVoucher(processConstructorArguments, entradaIntegracao);
            }
            case OP_CONSULTA_CDC_GENERICO: 
            case OP_CONSULTA_CDC_SEM_PARC_AVISTA: 
            case OP_CONSULTA_CDC_COM_PARC_AVISTA: {
                return new ProcessTransacoesGenericas(processConstructorArguments, entradaIntegracao.getNumeroTransacao(), entradaIntegracao, OperationEnum.OP_CONSULTA_CDC_COM_PARC_AVISTA.getDescription());
            }
            case OP_CRED_DIGITADO: 
            case OP_CRED_DIGITADO_PARC_COM_JUROS: 
            case OP_CRED_DIGITADO_PARC_SEM_JUROS: {
                if (entradaIntegracao.isAutenticacaoEmissor()) {
                    return new ProcessEcommerceAutenticado(processConstructorArguments, entradaIntegracao);
                }
                if (entradaIntegracao.isMultiTerminal()) {
                    return new ProcessCreditoMultiTerminal(processConstructorArguments, entradaIntegracao);
                }
                return new ProcessTransacoesGenericas(processConstructorArguments, entradaIntegracao.getNumeroTransacao(), entradaIntegracao, OperationEnum.OP_CREDITO_GENERICO.getDescription());
            }
            case OP_CREDITO_GENERICO: {
                Contexto.getContexto().getEntradaApiTefC().setValorTransacao(entradaIntegracao.getValorTransacao());
                return new ProcessTransacoesGenericas(processConstructorArguments, entradaIntegracao.getNumeroTransacao(), entradaIntegracao.getValorTransacao(), entradaIntegracao.getNumeroCupom(), operation.getDescription(), entradaIntegracao.getOrigemTransacao());
            }
            case OP_CRED_PRIVATE_LABEL: 
            case OP_CRED_PRIVATE_LABEL_DIGITADO: 
            case OP_CONSULTA_PRIVATE_LABEL: 
            case OP_CONSULTA_PRIVATE_LABEL_DIGITADO: {
                return new ProcessCreditoPrivateLabel(processConstructorArguments, entradaIntegracao, operation.getDescription());
            }
            case OP_CASH_PRIVATE_LABEL_ROTATIVO_OU_PARC: {
                return new ProcessCashPrivateLabel(processConstructorArguments, entradaIntegracao, 1);
            }
            case OP_CONSULTA_CASH_PRIVATE_LABEL: {
                return new ProcessCashPrivateLabel(processConstructorArguments, entradaIntegracao, 2);
            }
            case OP_CRED_IATA_GENERICO: 
            case OP_CRED_IATA: 
            case OP_CRED_IATA_COM_JUROS: 
            case OP_CRED_IATA_SEM_JUROS: 
            case OP_CRED_DIGITADO_IATA: 
            case OP_CRED_DIGITADO_IATA_COM_JUROS: 
            case OP_CRED_DIGITADO_IATA_SEM_JUROS: {
                return new ProcessCreditoIATA(processConstructorArguments, entradaIntegracao);
            }
            case OP_AUT_IATA_GENERICO: 
            case OP_AUT_IATA: 
            case OP_AUT_IATA_DIGITADO: 
            case OP_AUT_IATA_DIGITADO_SEM_JUROS: 
            case OP_AUT_IATA_SEM_JUROS: {
                return new ProcessAutorizacaoIATA(processConstructorArguments, entradaIntegracao);
            }
            case OP_CONFIRMACAO_PRE_AUT_GENERICO: 
            case OP_CONFIRMACAO_PRE_AUT: 
            case OP_CONFIRMACAO_PRE_AUT_COM_JUROS: 
            case OP_CONFIRMACAO_PRE_AUT_SEM_JUROS: 
            case OP_CONFIRMACAO_PRE_AUT_DIGITADO: 
            case OP_CONFIRMACAO_PRE_AUT_DIGITADO_COM_JUROS: 
            case OP_CONFIRMACAO_PRE_AUT_DIGITADO_SEM_JUROS: {
                if (entradaIntegracao.isMultiTerminal()) {
                    if (entradaIntegracao.getTipoCapturaPreAutorizacao() == 1) {
                        return new ProcessCreditoMultiTerminal(processConstructorArguments, entradaIntegracao);
                    }
                    return new ProcessConfirmacaoPreAutorizacaoWEB(processConstructorArguments, entradaIntegracao);
                }
                return new ProcessConfirmacaoPreAutorizacao(processConstructorArguments, entradaIntegracao);
            }
            case OP_CANCELAMENTO_CRED: 
            case OP_CANCELAMENTO_DEB: 
            case OP_CANCELAMENTO_GENERICO: 
            case OP_CANCELAMENTO_PRE_AUT: 
            case OP_CANCELAMENTO_DIGITADO: {
                if (operation == OperationEnum.OP_CANCELAMENTO_DIGITADO) {
                    entradaIntegracao.setOperacao(operation.getKey());
                } else {
                    entradaIntegracao.setOperacao(OperationEnum.OP_CANCELAMENTO_GENERICO.getKey());
                }
                String operationStr = operation == OperationEnum.OP_CANCELAMENTO_PRE_AUT ? operation.getDescription() : OperationEnum.OP_CANCELAMENTO_GENERICO.getDescription();
                if (entradaIntegracao.isMultiTerminal()) {
                    return new ProcessCancelamentoMultiTerminal(processConstructorArguments, entradaIntegracao);
                }
                return new ProcessCancelamento(processConstructorArguments, entradaIntegracao, operationStr);
            }
            case OP_ESTORNO_PAG: {
                if (entradaIntegracao.isMultiTerminal()) {
                    return new ProcessCancelamentoMultiTerminal(processConstructorArguments, entradaIntegracao);
                }
                return new ProcessCancelamento(processConstructorArguments, entradaIntegracao);
            }
            case OP_CONSULTA_AVS: {
                if (entradaIntegracao.isMultiTerminal()) {
                    return new ProcessConsultaAvsMultiTerminal(processConstructorArguments, entradaIntegracao);
                }
                return new ProcessConsultaAvs(processConstructorArguments, entradaIntegracao);
            }
            case OP_REIMPRESSAO_OUTRO_COMPROVANTE: {
                return new ProcessReimpressaoComprovante(processConstructorArguments, entradaIntegracao);
            }
            case OP_CONSULTA_FICHA_COMPENSACAO: 
            case OP_CONSULTA_CONVENIO: 
            case OP_PGTO_FICHA_COMPENSACAO: 
            case OP_PGTO_CONVENIO: 
            case OP_PGTO_CONVENIO_COM_CONSULTA: 
            case OP_PGTO_FICHA_COMPENSACAO_COM_CONSULTA: {
                return new ProcessCorrespondenteBancario(processConstructorArguments, entradaIntegracao, operation.getDescription());
            }
            case OP_CONSULTA_CHEQUE: 
            case OP_GARANTIA_CHEQUE: {
                return new ProcessConsultaCheque(processConstructorArguments, entradaIntegracao, entradaIntegracao.getNumeroTransacao(), operation.getDescription());
            }
            case OP_PAGUE_CONTAS_CONCECIONARIA: 
            case OP_PAGUE_CONTAS_FICHA_COMPENSACAO: {
                return new ProcessPagamentoContas(processConstructorArguments, entradaIntegracao, false);
            }
            case OP_CONSULTA_FATURA_CARTAO: 
            case OP_CONSULTA_FATURA_CARTAO_DETALHADA: 
            case OP_PAGAMENTO_FATURA_CARTAO: {
                return new ProcessPagamentoFaturaCartao(processConstructorArguments, entradaIntegracao, null, operation.getDescription());
            }
            case OP_PRE_AUT_CRED_GENERICO: 
            case OP_PRE_AUT_CRED: 
            case OP_PRE_AUT_CRED_DIGITADO: {
                if (entradaIntegracao.isMultiTerminal()) {
                    return new ProcessPreAutorizacaoWEB(processConstructorArguments, entradaIntegracao);
                }
                return new ProcessPreAutorizacao(processConstructorArguments, entradaIntegracao);
            }
            case OP_CARGA_TABELA: {
                return new ProcessCargaTabelaForcadaTest(processConstructorArguments);
            }
            case OP_CONSULTA_VALORES_CREDITO_DIGITAL: 
            case OP_COMPRA_CREDITO_DIGITAL: {
                if (entradaIntegracao.isMultiTerminal()) {
                    return new ProcessCreditoDigitalMultiTerminal(processConstructorArguments, entradaIntegracao, operation.getDescription());
                }
                return new ProcessCreditoDigital(processConstructorArguments, entradaIntegracao, entradaIntegracao.getNumeroTransacao(), operation.getDescription());
            }
            case OP_INICIO_DIA: {
                return new ProcessInicioDia(processConstructorArguments, entradaIntegracao);
            }
            case OP_CONSULTA_CARTAO: {
                return new ProcessConsultaCartao(processConstructorArguments, entradaIntegracao, entradaIntegracao.getNumeroTransacao());
            }
            case OP_BYPASS: 
            case OP_VENDA_PBM_GETNET_AVISTA: 
            case OP_VENDA_PBM_GETNET_SEM_JUROS: 
            case OP_VENDA_PBM_GETNET_COM_JUROS: {
                return new ProcessBypass(processConstructorArguments, entradaIntegracao, entradaIntegracao.getNumeroTransacao());
            }
            case OP_CREDITO_CELULAR_AVISTA: 
            case OP_CREDITO_CELULAR_PARC_LOJISTA: 
            case OP_CREDITO_CELULAR_PARC_ADMINISTRADORA: {
                return new ProcessCreditoCelular(processConstructorArguments, entradaIntegracao, entradaIntegracao.getNumeroTransacao());
            }
            case OP_COMPRA_VALE_GAS: {
                return new ProcessValeGas(processConstructorArguments, entradaIntegracao, entradaIntegracao.getNumeroTransacao(), entradaIntegracao.getNumeroCupom());
            }
            case OP_TROCO_SURPRESA: {
                return new ProcessTroco(processConstructorArguments, entradaIntegracao, entradaIntegracao.getNumeroTransacao(), entradaIntegracao.getNumeroCupom(), operation.getDescription());
            }
            case OP_RESGATE_PREMIO: {
                return new ProcessResgatePremio(processConstructorArguments, entradaIntegracao, entradaIntegracao.getNumeroTransacao());
            }
            case OP_ESTATISTICA_MANUAL: {
                return new ProcessEstatisticaManual(processConstructorArguments, entradaIntegracao);
            }
            case OP_BAIXA_TECNICA_MANUAL: {
                return new ProcessBaixaTecnicaManual(processConstructorArguments, entradaIntegracao.getNumeroTransacao());
            }
            case OP_CONSULTA_FINANCIAMENTO_CREDITO: 
            case OP_CONSULTA_CREDITO_DIGITADO: {
                logger.info("transa\u00e7\u00e3o " + operation.getKey().toString() + " redirecionada para " + (Object)((Object)OperationEnum.OP_CONSULTA_FINANCIAMENTO_CREDITO));
                if (entradaIntegracao.isMultiTerminal()) {
                    return new ProcessConsultaFinanciamentoCreditoWeb(processConstructorArguments, entradaIntegracao);
                }
                return new ProcessConsultaFinanciamentoCredito(processConstructorArguments, entradaIntegracao);
            }
            case OP_SAQUE_CREDITO: 
            case OP_SAQUE_DEBITO: 
            case OP_SIMULACAO_SAQUE_CREDITO: {
                return new ProcessSaqueCartao(processConstructorArguments, entradaIntegracao, operation.getDescription());
            }
            case OP_TEF_IP_MENU_ADM: {
                return new ProcessTefIPFuncoesADM(processConstructorArguments, entradaIntegracao);
            }
            case OP_TEF_IP_VENDA_CARTAO: {
                return new ProcessTefIPVendaCartao(processConstructorArguments, entradaIntegracao);
            }
            case OP_TEF_IP_CHEQUE: {
                return new ProcessTefIPOperacoesCheque(processConstructorArguments, entradaIntegracao);
            }
            case OP_TEF_IP_ENVIO_FACIL: {
                return new ProcessTefIpEnvioFacil(processConstructorArguments, entradaIntegracao);
            }
            case OP_TEF_IP_VENDA_QR_CODE: {
                return new ProcessTefIPVendaQrCode(processConstructorArguments, entradaIntegracao);
            }
            case OP_FUEL_CONTROL: 
            case OP_RESERVA_FUEL_CONTROL: {
                Contexto.getContexto().setTipoOperacao(operation.getDescription());
                return new ProcessFuelControl(processConstructorArguments, entradaIntegracao);
            }
            case OP_REIMPRESSAO_ULTIMO_COMPROVANTE: {
                return new ProcessUltimoComprovante(processConstructorArguments);
            }
            case OP_CONFIGURACAO_TERMINAL: {
                return new ProcessConfigurarTerminal(processConstructorArguments);
            }
            case OP_CONSULTA_DROGAO_COM_CARTAO: 
            case OP_CONSULTA_DROGAO_COM_CPF: 
            case OP_PAGAMENTO_EMS_DROGAO: {
                return new ProcessOperacoesDrogao(processConstructorArguments, entradaIntegracao, entradaIntegracao.getNumeroTransacao(), operation.getDescription());
            }
            case OP_CONSULTA_SAQUE_DEBITO: 
            case OP_CONSULTA_SAQUE_CREDITO: {
                return new ProcessConsultaSaldo(processConstructorArguments, entradaIntegracao, operation.getDescription());
            }
            case OP_SAQUE_TRANSFERENCIA_CREDITO: 
            case OP_SIMULACAO_SAQUE_TRANSFERENCIA_CREDITO: {
                return new ProcessSaqueTransferencia(processConstructorArguments, entradaIntegracao, operation.getDescription());
            }
            case OP_RESGATE_FIDELIDADE: {
                return new ProcessResgateFidelidade(processConstructorArguments, entradaIntegracao);
            }
            case OP_RECARGA_CARTAO_PREPAGO: {
                return new ProcessRecargaCartaoPrePago(processConstructorArguments, entradaIntegracao);
            }
            case OP_RECARGA_CARTAO_PREPAGO_POSA: {
                return new ProcessRecargaCartaoPrePagoPOSA(processConstructorArguments, entradaIntegracao);
            }
            case OP_RESGATE_CARTAO_PREPAGO_POSA: {
                return new ProcessResgateCartaoPrePagoPOSA(processConstructorArguments, entradaIntegracao);
            }
            case OP_CONSULTA_ANALITICA_SPC: {
                if (entradaIntegracao.isMultiTerminal()) {
                    return new ProcessConsultaAnaliticaSpcWeb(processConstructorArguments, entradaIntegracao, entradaIntegracao.getNumeroTransacao(), entradaIntegracao.getNumeroCupom(), entradaIntegracao.getIdentTerminal());
                }
                return new ProcessConsultaAnaliticaSpc(processConstructorArguments, entradaIntegracao, entradaIntegracao.getNumeroTransacao(), entradaIntegracao.getNumeroCupom(), entradaIntegracao.getIdentTerminal());
            }
            case OP_INJECAO_MANUAL_CHAVE_DUKPT: {
                return new ProcessCriptografiaDUKPT(processConstructorArguments, operation.getDescription(), entradaIntegracao, 0, OrigemTransacaoEnum.DEFAULT);
            }
            case OP_CONSULTA_CARTAO_PRESENTE: 
            case OP_RECARGA_CARTAO_PRESENTE: 
            case OP_ATIVACAO_CARTAO_PRESENTE: {
                return new ProcessCartaoPresente(processConstructorArguments, operation.getDescription(), entradaIntegracao, entradaIntegracao.getNumeroTransacao(), entradaIntegracao.getNumeroCupom());
            }
            case OP_DEPOSITO_COM_DOCUMENTO: {
                return new ProcessDepositoConta(processConstructorArguments, entradaIntegracao);
            }
            case OP_DEPOSITO_COM_CARTAO: {
                return new ProcessDepositoCartao(processConstructorArguments, entradaIntegracao);
            }
            case OP_CARGA_PRODUTOS_PROMOCIONAIS: {
                return new ProcessCargaProdutosPromocionais(processConstructorArguments, entradaIntegracao, entradaIntegracao.getNumeroTransacao(), entradaIntegracao.getNumeroCupom());
            }
            case OP_DESCONTO_PRODUTOS_PROMOCIONAIS: {
                return new ProcessDescontoProdutosPromocionais(processConstructorArguments, entradaIntegracao, entradaIntegracao.getNumeroTransacao(), entradaIntegracao.getNumeroCupom(), entradaIntegracao.getIdentTerminal());
            }
            case OP_CONSULTA_PENDENCIAS: {
                return new ProcessConsultaPendencia(processConstructorArguments, entradaIntegracao);
            }
            case OP_TROCA_SENHA: {
                return new ProcessTrocaSenha(processConstructorArguments, entradaIntegracao, entradaIntegracao.getNumeroTransacao());
            }
            case OP_CONFIRMACAO_PRE_VENDA: {
                return new ProcessConfirmacaoPreVenda(processConstructorArguments, entradaIntegracao);
            }
            case OP_CONFIRMACAO_NSU_CTF: 
            case OP_DESFAZIMENTO_NSU_CTF: {
                return new ProcessConfirmacaoDesfazimentoNSUCTF(processConstructorArguments, entradaIntegracao, entradaIntegracao.getNumeroTransacao(), operation.getDescription());
            }
            case OP_CONVENIO_COMBUSTIVEL_PRE_VALIDACAO: 
            case OP_CONVENIO_COMBUSTIVEL_AUTORIZACAO: {
                return new ProcessConvenioCombustivel(processConstructorArguments, entradaIntegracao, operation.getDescription());
            }
            case OP_CONSULTA_TELEFONE_CREDITO_DIGITAL: {
                return new ProcessConsultaTelefoneCreditoDigital(processConstructorArguments, entradaIntegracao);
            }
            case OP_CAPTURA_CREDITO: {
                return new ProcessCapturaCredito(processConstructorArguments, entradaIntegracao);
            }
            case OP_DOTZ_ACUMULO: 
            case OP_DOTZ_RESGATE: 
            case OP_DOTZ_CONSULTA_SALDO: 
            case OP_DOTZ_CONSULTA_EXTRATO: {
                return new ProcessDotz(processConstructorArguments, entradaIntegracao, operation.getDescription());
            }
            case OP_IDENTIFICACAO_CARTAO_ASSOCIADO: 
            case OP_IDENTIFICACAO_CARTAO_ASSOCIADO_DIGITADO: {
                return new ProcessIdentificacaoAssociado(processConstructorArguments);
            }
            case OP_ATIVACAO_CARTAO_PREPAGO: 
            case OP_PRE_AUTORIZACAO_CARTAO_PREPAGO: 
            case OP_DESATIVACAO_CARTAO_PREPAGO: 
            case OP_VENDA_FASTPIN: 
            case OP_RETORNO_FASTPIN: {
                return new ProcessCartaoPrepago(processConstructorArguments, false, entradaIntegracao);
            }
            case OP_ATIVACAO_PRE_AUTORIZACAO_CARTAO_PREPAGO: {
                return new ProcessCartaoPrepago(processConstructorArguments, true, entradaIntegracao);
            }
            case OP_ATUALIZACAO_CHIP: {
                return new ProcessAtualizacaoChip(processConstructorArguments);
            }
            case OP_AUTO: 
            case OP_AUTO_CONSULTA_SALDO: {
                return new ProcessAuto(processConstructorArguments, operation.getDescription());
            }
            case OP_CAPTURA_DADO_PINPAD: {
                return new ProcessCapturaDadosPinpad(processConstructorArguments, entradaIntegracao);
            }
            case OP_EMISSAO_VALE_TROCA: 
            case OP_RESGATE_VALE_TROCA: 
            case OP_CONSULTA_REIMPRESSAO_VALE_TROCA: 
            case OP_REIMPRESSAO_VALE_TROCA: 
            case OP_CONSULTA_GARANTIA_ESTENDIDA: 
            case OP_CONSULTA_GARANTIA_ROUBO_FURTO: 
            case OP_PAGAMENTO_GARANTIA_EXTENDIDA: 
            case OP_PAGAMENTO_GARANTIA_ROUBO_FURTO: 
            case OP_CONSULTA_RESGATE_GARANTIA_NAO_MAGNETICA: 
            case OP_COMPRA_RESGATE_GARANTIA_NAO_MAGNETICA: 
            case OP_CONSULTA_ASSOCIADO: 
            case OP_COMPRA_ASSOCIADO: 
            case OP_CARGA_HABILITACAO_CARTAO_PRESENTE: 
            case OP_RESGATE_CARTAO_PRESENTE_SAA: 
            case OP_CONSULTA_CARTAO_PRESENTE_SAA: 
            case OP_CARGA_HABILITACAO_CUPONAGEM: 
            case OP_CONSULTA_CUPONAGEM: 
            case OP_RESGATE_CUPONAGEM: {
                return new ProcessTransacoesSAA(processConstructorArguments, operation.getDescription());
            }
            case OP_CONSULTA_ESTABELECIMENTOS_MULTI_EC: {
                return new ProcessConsultaEstabelecimentosMultiEC(processConstructorArguments, entradaIntegracao);
            }
            case OP_RESGATE_FACIL: 
            case OP_RESGATE_FACIL_EXTRATO: {
                Contexto.getContexto().setTipoOperacao(operation.getDescription());
                return new ProcessResgateFacil(processConstructorArguments, entradaIntegracao.getNumeroTransacao());
            }
            case OP_ECO: {
                return new ProcessECO(processConstructorArguments);
            }
            case OP_ATIVACAO_SERVICO_SOLUCAO_CERTA: {
                return new ProcessAtivacaoSolucaoCerta(processConstructorArguments);
            }
            case OP_CONSULTA_FIDELIDADE_MILHAS: 
            case OP_PRECIFICACAO_FIDELIDADE_EM_MILHAS: {
                return new ProcessFidelidadeMilhas(processConstructorArguments, entradaIntegracao, operation.getDescription());
            }
            case OP_ALTERACAO_PRE_AUT: {
                return new ProcessAlteracaoPreAutorizacao(processConstructorArguments, entradaIntegracao);
            }
            case OP_CREDITO_4ALL: 
            case OP_DEBITO_4ALL: {
                return new ProcessCreditoDebito4All(processConstructorArguments, entradaIntegracao, operation.getDescription());
            }
            case OP_DESBLOQUEIO_CARTAO: {
                return new ProcessDesbloqueioCartao(processConstructorArguments, entradaIntegracao);
            }
            case OP_CONSULTA_CARTAO_PREPAGO_DIGITAL: 
            case OP_CARTAO_PREPAGO_DIGITAL: {
                return new ProcessCartaoPrepagoDigital(processConstructorArguments, entradaIntegracao, operation.getDescription());
            }
            case OP_CONSULTA_CONTA: 
            case OP_CONSULTA_CONTA_CREDITO: {
                return new ProcessConsultaContaCartao(processConstructorArguments, entradaIntegracao);
            }
            case OP_SIMULACAO_EMPRESTIMO: 
            case OP_EMPRESTIMO: {
                return new ProcessEmprestimo(processConstructorArguments, entradaIntegracao);
            }
            case OP_PAGAMENTO_FATURA_CARTAO_CREDITO: 
            case OP_PAGAMENTO_CONTA_BANCARIA: 
            case OP_PAGAMENTO_CONTA_CONCESSIONARIA: {
                return new ProcessCredito(processConstructorArguments, entradaIntegracao, operation.getDescription());
            }
            case OP_PAGAMENTO_VCMAIS: {
                return new ProcessVcMais(processConstructorArguments);
            }
            case OP_ADESAO_SEGURO: {
                return new ProcessAdesaoSeguro(processConstructorArguments, entradaIntegracao);
            }
            case OP_PRE_AUTORIZACAO_ADICIONAL: {
                return new ProcessPreAutorizacaoAdicional(processConstructorArguments, entradaIntegracao);
            }
            case OP_TESTE_COMUNICACAO_5N: {
                return new ProcessTesteComunicacao(processConstructorArguments);
            }
            case OP_RESGATE_BR_PREMMIA: {
                return new ProcessResgateBrPremmia(processConstructorArguments);
            }
            case OP_PAGAMENTO_DINHEIRO_BR_PREMMIA: {
                return new ProcessPagamentoDinheiroBrPremmia(processConstructorArguments);
            }
            case OP_AUTENTICACAO_TERMINAL: {
                return new ProcessAutenticacaoTerminal(processConstructorArguments);
            }
            case OP_GENERICA: {
                return new ProcessTransacoesGenericas(processConstructorArguments, entradaIntegracao.getNumeroTransacao(), entradaIntegracao, "");
            }
        }
        logger.error(String.format("Processo %d n\u00e3o encontrado...", operation.getKey()));
        return null;
    }

    private Process executeProcess(Process process) {
        process.setApitef(ControladorApitefC.newInstancia());
        process.setPerifericos(controladorPerifericos);
        ProcessManager.getInstance().process(process);
        return process;
    }

    private boolean validaGrupoTransacao(int operacaoOLD, int operacao) {
        if (operacaoOLD == OperationEnum.OP_DEBITO.getKey()) {
            return operacao == OperationEnum.OP_DEBITO.getKey() || operacao == OperationEnum.OP_DEB_PRE_DATADO.getKey() || operacao == OperationEnum.OP_DEB_PARCELADO_COM_PARC_AVISTA.getKey() || operacao == OperationEnum.OP_DEB_PARCELADO_SEM_PARC_AVISTA.getKey() || operacao == OperationEnum.OP_DEB_CDC_COM_PARC_AVISTA.getKey() || operacao == OperationEnum.OP_DEB_CDC_SEM_PARC_AVISTA.getKey();
        }
        if (operacaoOLD == OperationEnum.OP_CREDITO.getKey() || operacaoOLD == OperationEnum.OP_CRED_DIGITADO.getKey()) {
            return operacao == OperationEnum.OP_CREDITO.getKey() || operacao == OperationEnum.OP_CRED_PARC_COM_JUROS.getKey() || operacao == OperationEnum.OP_CRED_PARC_SEM_JUROS.getKey() || operacao == OperationEnum.OP_CRED_DIGITADO.getKey() || operacao == OperationEnum.OP_CRED_DIGITADO_PARC_COM_JUROS.getKey() || operacao == OperationEnum.OP_CRED_DIGITADO_PARC_SEM_JUROS.getKey() || operacao == OperationEnum.OP_CREDITO_CELULAR_AVISTA.getKey() || operacao == OperationEnum.OP_CREDITO_CELULAR_PARC_ADMINISTRADORA.getKey() || operacao == OperationEnum.OP_CREDITO_CELULAR_PARC_LOJISTA.getKey();
        }
        if (operacaoOLD == OperationEnum.OP_CRED_IATA.getKey()) {
            return operacao == OperationEnum.OP_CRED_IATA.getKey() || operacao == OperationEnum.OP_CRED_IATA_COM_JUROS.getKey() || operacao == OperationEnum.OP_CRED_IATA_SEM_JUROS.getKey() || operacao == OperationEnum.OP_CRED_DIGITADO_IATA.getKey() || operacao == OperationEnum.OP_CRED_DIGITADO_IATA_COM_JUROS.getKey() || operacao == OperationEnum.OP_CRED_DIGITADO_IATA_SEM_JUROS.getKey();
        }
        if (operacaoOLD == OperationEnum.OP_CRED_PRIVATE_LABEL.getKey()) {
            return operacao == OperationEnum.OP_CRED_PRIVATE_LABEL.getKey() || operacao == OperationEnum.OP_CRED_PRIVATE_LABEL_DIGITADO.getKey();
        }
        if (operacaoOLD == OperationEnum.OP_DEB_VOUCHER.getKey()) {
            return operacao == OperationEnum.OP_DEB_VOUCHER.getKey();
        }
        if (operacaoOLD == OperationEnum.OP_CONSULTA_CDC_GENERICO.getKey()) {
            return operacao == OperationEnum.OP_CONSULTA_CDC_GENERICO.getKey() || operacao == OperationEnum.OP_CONSULTA_CDC_SEM_PARC_AVISTA.getKey() || operacao == OperationEnum.OP_CONSULTA_CDC_COM_PARC_AVISTA.getKey();
        }
        if (operacaoOLD == OperationEnum.OP_CONSULTA_CARTAO.getKey()) {
            return true;
        }
        if (operacaoOLD == OperationEnum.OP_CREDITO_CELULAR_AVISTA.getKey() || operacaoOLD == OperationEnum.OP_CREDITO_CELULAR_PARC_ADMINISTRADORA.getKey() || operacaoOLD == OperationEnum.OP_CREDITO_CELULAR_PARC_LOJISTA.getKey()) {
            return operacao == OperationEnum.OP_CREDITO.getKey() || operacao == OperationEnum.OP_CRED_PARC_COM_JUROS.getKey() || operacao == OperationEnum.OP_CRED_PARC_SEM_JUROS.getKey();
        }
        if (operacaoOLD == OperationEnum.OP_CONSULTA_DROGAO_COM_CARTAO.getKey()) {
            return operacao == OperationEnum.OP_CONSULTA_DROGAO_COM_CARTAO.getKey();
        }
        if (operacaoOLD == OperationEnum.OP_CONSULTA_DROGAO_COM_CPF.getKey()) {
            return operacao == OperationEnum.OP_CONSULTA_DROGAO_COM_CPF.getKey();
        }
        if (operacaoOLD == OperationEnum.OP_ATIVACAO_CARTAO_PREPAGO.getKey()) {
            return operacao == OperationEnum.OP_ATIVACAO_CARTAO_PREPAGO.getKey();
        }
        if (operacaoOLD == OperationEnum.OP_RECARGA_CARTAO_PREPAGO_POSA.getKey()) {
            return operacao == OperationEnum.OP_RECARGA_CARTAO_PREPAGO_POSA.getKey();
        }
        if (operacaoOLD == OperationEnum.OP_RESGATE_CARTAO_PREPAGO_POSA.getKey()) {
            return operacao == OperationEnum.OP_RESGATE_CARTAO_PREPAGO_POSA.getKey();
        }
        if (operacaoOLD == OperationEnum.OP_QR_CODE_GENERICO.getKey() && operacao == operacaoOLD) {
            return true;
        }
        if (operacaoOLD == OperationEnum.OP_PIX_PAYMENT.getKey() && operacao == operacaoOLD) {
            return true;
        }
        if (operacaoOLD == OperationEnum.OP_CONSULTA_FINANCIAMENTO_CREDITO.getKey() && operacao == operacaoOLD) {
            return true;
        }
        if (operacaoOLD == OperationEnum.OP_CONSULTA_CREDITO_DIGITADO.getKey() && operacao == operacaoOLD) {
            return true;
        }
        return (operacaoOLD == OperationEnum.OP_CANCELAMENTO_GENERICO.getKey() || operacaoOLD == OperationEnum.OP_CANCELAMENTO_CRED.getKey() || operacaoOLD == OperationEnum.OP_CANCELAMENTO_DEB.getKey()) && operacao == operacaoOLD;
    }

    private long getIdentConsulta(ContextoCTFClient contexto) {
        if (contexto.getEntradaIntegracao() != null && contexto.getEntradaIntegracao().getOperacao() == OperationEnum.OP_CONSULTA_CARTAO.getKey().intValue()) {
            if (contexto.getSaidaApiTefC() != null && contexto.getSaidaApiTefC().getDataAutorizadora() != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(contexto.getSaidaApiTefC().getDataAutorizadora());
                return calendar.getTimeInMillis();
            }
            logger.warn("Consulta n\u00e3o efetuada ou data n\u00e3o recuperada, a captura do timestamp n\u00e3o p\u00f4de ser realizada");
            return 0L;
        }
        return contexto.hashCode();
    }

    private SaidaCTFClient getSaidaCTFClientErro(IdentTerminal ident, EntradaCTFClient entradaCTFClient, boolean multiplosTerminais, boolean multiTransacao) {
        return this.getSaidaCTFClientErro(CodigoRetornoAutomacao.ERRO_INTERNO.getCode(), "5331", "TENTE NOVAMENTE", ident, entradaCTFClient, multiplosTerminais, multiTransacao);
    }

    private SaidaCTFClient getSaidaCTFClientErro(int retorno, String erro, String mensagem, IdentTerminal ident, EntradaCTFClient entradaCTFClient, boolean multiplosTerminais, boolean multiTransacao) {
        return this.getSaidaCTFClientErro(retorno, erro, new String[]{mensagem}, ident, entradaCTFClient, multiplosTerminais, multiTransacao);
    }

    private SaidaCTFClient getSaidaCTFClientErro(int retorno, String erro, String[] mensagem, IdentTerminal ident, EntradaCTFClient entradaCTFClient, boolean multiplosTerminais, boolean multiTransacao) {
        EntradaApiTefC entradaApiTefC;
        SaidaCTFClient saida = new SaidaCTFClient(retorno, erro, mensagem);
        logger.info("transa\u00e7\u00e3o recusada: " + ident + " retorno=" + retorno + " erro=" + erro);
        if (entradaCTFClient != null) {
            saida.setOperacao(entradaCTFClient.getOperacao());
            saida.setDocumento(entradaCTFClient.getNumeroCupom());
        }
        if (ident != null) {
            saida.setEstabelecimento(ident.getEstabelecimento());
            saida.setLoja(ident.getLoja());
            saida.setTerminal(ident.getTerminal());
        }
        if (multiplosTerminais && multiTransacao && ident != null) {
            saida.setCodigoMultitransacao(IdentTerminal.parseCodigoMultitransacao(ident));
        }
        if ((entradaApiTefC = Contexto.getContexto().getEntradaApiTefC()) != null && entradaApiTefC.getValorTransacao() != null) {
            saida.setValorTransacao(entradaApiTefC.getValorTransacao());
        } else if (entradaCTFClient != null && entradaCTFClient.getValorTransacao() != null) {
            saida.setValorTransacao(entradaCTFClient.getValorTransacao());
        }
        this.validaSaidaCTFClient(saida);
        return saida;
    }

    private void validaSaidaCTFClient(SaidaCTFClient saida) {
        if (saida.getTaxaJuros() == null) {
            saida.setTaxaJuros(new BigDecimal(0));
        }
        if (saida.getValorParcela() == null) {
            saida.setValorParcela(new BigDecimal(0));
        }
        if (saida.getValorTransacao() == null) {
            saida.setValorTransacao(new BigDecimal(0));
        }
        if (saida.getValorTotal() == null) {
            saida.setValorTotal(new BigDecimal(0));
        }
        if (saida.getNomeVan() == null) {
            saida.setNomeVan("");
        }
        if (saida.getNomeCliente() == null) {
            saida.setNomeCliente("");
        }
        if (saida.getNomeOperacao() == null) {
            saida.setNomeOperacao("");
        }
        if (saida.getCodigoAprovacao() == null) {
            saida.setCodigoAprovacao("");
        }
        if (saida.getMensagemCTF() == null) {
            saida.setMensagemCTF(new String[]{""});
        }
    }

    static {
        dataAtual = null;
        confPerifericos = null;
        controladorPerifericos = null;
        controladorConfCTFClient = null;
        terminalManager = null;
    }
}

