/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.servicos;

import br.com.auttar.AuttarLogger;
import br.com.auttar.AuttarLoggerFactoryLog4j;
import br.com.auttar.QrCodeGeneratorJavaSE;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClient;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.servicos.SaidaCTFClient;
import com.csi.ctfclient.tools.util.StringUtil;

public class CTFClient {
    private static CTFClient instance;
    private CTFClientCore core;
    private static final AuttarLogger logger;

    private CTFClient() throws ExcecaoApiAc {
        AuttarLoggerFactoryLog4j alf = new AuttarLoggerFactoryLog4j();
        this.core = CTFClientCore.getInstancia(alf, new QrCodeGeneratorJavaSE());
    }

    public static synchronized CTFClient getInstancia() throws ExcecaoApiAc {
        if (instance == null) {
            try {
                instance = new CTFClient();
            }
            catch (Throwable t) {
                CTFClient.excecaoErroFatal(t);
            }
        }
        return instance;
    }

    public void config(ConfCTFClient config) throws ExcecaoApiAc {
        try {
            this.core.config(config);
        }
        catch (Throwable t) {
            CTFClient.excecaoErroFatal(t);
        }
    }

    public ConfCTFClient getConfig() throws ExcecaoApiAc {
        try {
            return this.core.getConfig();
        }
        catch (Throwable t) {
            CTFClient.excecaoErroFatal(t);
            return null;
        }
    }

    public SaidaCTFClient efetuarTransacao(IdentTerminal ident, EntradaCTFClient entrada) {
        try {
            return this.core.efetuarTransacao(ident, entrada);
        }
        catch (Throwable t) {
            return CTFClient.saidaErroFatal(t, ident, entrada);
        }
    }

    public SaidaCTFClient efetuarConsulta(IdentTerminal ident, EntradaCTFClient entrada) {
        try {
            return this.core.efetuarConsulta(ident, entrada);
        }
        catch (Throwable t) {
            return CTFClient.saidaErroFatal(t, ident, entrada);
        }
    }

    public SaidaCTFClient efetuarTransacao(IdentTerminal ident, EntradaCTFClient entrada, long identConsulta) {
        try {
            return this.core.efetuarTransacao(ident, entrada, identConsulta);
        }
        catch (Throwable t) {
            return CTFClient.saidaErroFatal(t, ident, entrada);
        }
    }

    private static void excecaoErroFatal(Throwable t) throws ExcecaoApiAc {
        logger.error(t);
        throw t instanceof ExcecaoApiAc ? (ExcecaoApiAc)t : new ExcecaoApiAc(t, "EX99", t.getMessage());
    }

    private static SaidaCTFClient saidaErroFatal(Throwable t, IdentTerminal ident, EntradaCTFClient entrada) {
        logger.error(String.format("ident = %s", ident != null ? ident : "null"));
        logger.error(String.format("entrada = %s", StringUtil.objectToString(entrada)));
        logger.error((Object)"ERRO", t);
        SaidaCTFClient saida = new SaidaCTFClient();
        saida.setCodigoRetorno(18);
        return saida;
    }

    static {
        logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClient.class);
    }
}

