/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.util;

import com.csi.ctfclient.tools.util.StringUtil;

public class MascaraCartaoUtil {
    public static final int FORMATO_VISANET = 1;
    public static final int FORMATO_REDECARD = 2;

    public static String getNumeroFormatado(String numeroCartao) {
        StringBuilder sb = new StringBuilder();
        String separador = "";
        if (numeroCartao != null) {
            for (int i = 0; i < numeroCartao.length(); i += 4) {
                sb.append(separador).append(numeroCartao, i, i + 4);
                separador = "-";
            }
            return sb.toString();
        }
        return null;
    }

    public static String getNumeroMascara(String numeroCartao, int formatoCartao) {
        String numeroCartaoFormatado;
        if ((numeroCartao = numeroCartao.trim()).length() < 6) {
            throw new IllegalArgumentException("N\u00famero do cart\u00e3o n\u00e3o cont\u00e9m o n\u00famero m\u00ednimo de d\u00edgitos");
        }
        if (formatoCartao == 1) {
            numeroCartaoFormatado = numeroCartao.substring(0, 4) + numeroCartao.substring(4, 6) + "-" + numeroCartao.substring(numeroCartao.length() - 4);
        } else if (formatoCartao == 2) {
            numeroCartaoFormatado = numeroCartao.substring(0, 4) + numeroCartao.substring(4, 6) + "******" + numeroCartao.substring(numeroCartao.length() - 4);
        } else {
            throw new IllegalArgumentException("Tipo do formato do n\u00famero do cart\u00e3o inesperado");
        }
        return numeroCartaoFormatado;
    }

    public static String getNumeroMascaradoLegado(String pan) {
        if (pan != null) {
            pan = pan.trim();
            return StringUtil.completaString(pan.substring(0, 6), pan.length(), '*', 4);
        }
        return null;
    }

    public static String getNumeroMascaradoLegado4UltimosDigitos(String pan) {
        if (pan != null && pan.trim().length() >= 10) {
            pan = pan.trim();
            return StringUtil.completaString(pan.substring(0, 6), pan.length() - 4, '*', 4) + pan.substring(pan.length() - 4);
        }
        if (pan == null) {
            return null;
        }
        return pan.trim();
    }
}

