/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model.controller;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.model.EstabelecimentoMultiEC;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.model.DadosEstabelecimentosMultiEC;
import com.csi.ctfclient.operacoes.model.controller.IdentificadorMultiECNaoEncontradoException;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.util.Base36Util;
import com.csi.ctfclient.tools.util.PersistenciaObjetos;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class ControladorMultiEC {
    private static final String PATH_NAME = "estabelecimentos_multi_ec.dat";
    private static final String KEY_LISTA_ESTABELECIMENTOS = "KEY_LISTA_ESTABELECIMENTOS";
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(ControladorMultiEC.class);
    private static ControladorMultiEC instance;
    private PersistenciaObjetos persistencia;
    private DadosEstabelecimentosMultiEC dadosEstabelecimentosMultiEC;
    private Map<String, EstabelecimentoMultiEC> mapEstabelecimentoMultiEC;

    private ControladorMultiEC() {
        block3: {
            String pathComplementar = "";
            if (ControladorConfCTFClient.getDiretorioTrabalho() != null) {
                pathComplementar = ControladorConfCTFClient.getDiretorioTrabalho();
            }
            try {
                this.persistencia = new PersistenciaObjetos(pathComplementar + PATH_NAME);
            }
            catch (ExcecaoApiAc e) {
                logger.warn("Erro ao ler o arquivo: " + pathComplementar + PATH_NAME + ", apagando arquivo... (Desc: " + e.getMessage() + ")");
                File file = new File(pathComplementar + PATH_NAME);
                if (file.delete()) break block3;
                logger.warn("N\u00e3o foi poss\u00edvel remover o arquivo de persist\u00eancia: " + file.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ControladorMultiEC getInstance() {
        if (instance != null) return instance;
        Class<ControladorMultiEC> clazz = ControladorMultiEC.class;
        synchronized (ControladorMultiEC.class) {
            if (instance != null) return instance;
            instance = new ControladorMultiEC();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clean() {
        Class<ControladorMultiEC> clazz = ControladorMultiEC.class;
        synchronized (ControladorMultiEC.class) {
            File file;
            String pathComplementar = "";
            if (ControladorConfCTFClient.getDiretorioTrabalho() != null) {
                pathComplementar = ControladorConfCTFClient.getDiretorioTrabalho();
            }
            if ((file = new File(pathComplementar + PATH_NAME)).exists() && !file.delete()) {
                logger.warn("N\u00e3o foi poss\u00edvel remover o arquivo: " + file.getAbsolutePath());
            }
            instance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static IdentTerminal criarTerminalComumMultiEC(int codigoGrupo) {
        IdentTerminal ident = new IdentTerminal();
        ident.setEstabelecimento("_MULT");
        ident.setLoja("I_EC");
        ident.setTerminal(Base36Util.converteBase36Terminal(codigoGrupo));
        return ident;
    }

    public static boolean isTerminalComumMultiEC(IdentTerminal identTerminalParam) {
        IdentTerminal identTerminalComum = ControladorMultiEC.criarTerminalComumMultiEC(0);
        if (identTerminalComum == identTerminalParam) {
            return true;
        }
        if (identTerminalParam == null) {
            return false;
        }
        return identTerminalComum.getEstabelecimento() != null && identTerminalComum.getEstabelecimento().equals(identTerminalParam.getEstabelecimento()) && identTerminalComum.getLoja() != null && identTerminalComum.getLoja().equals(identTerminalParam.getLoja());
    }

    public DadosEstabelecimentosMultiEC getDadosEstabelecimentosMultiEC() {
        if (this.dadosEstabelecimentosMultiEC == null) {
            try {
                this.dadosEstabelecimentosMultiEC = (DadosEstabelecimentosMultiEC)this.persistencia.get(KEY_LISTA_ESTABELECIMENTOS);
                this.mapEstabelecimentoMultiEC = this.dadosEstabelecimentosMultiEC != null ? this.criarMapEstabelecimentosMultiEC(this.dadosEstabelecimentosMultiEC) : null;
            }
            catch (Exception e) {
                logger.error("Erro ao ler a lista de Estabelecimentos Multi-EC" + e.getMessage());
            }
        }
        return this.dadosEstabelecimentosMultiEC;
    }

    public void setDadosEstabelecimentosMultiEC(DadosEstabelecimentosMultiEC dadosEstabelecimentosMultiEC) throws ExcecaoNaoLocal {
        this.persistencia.save(KEY_LISTA_ESTABELECIMENTOS, dadosEstabelecimentosMultiEC);
        this.persistencia.persist(true);
        this.dadosEstabelecimentosMultiEC = dadosEstabelecimentosMultiEC;
        this.mapEstabelecimentoMultiEC = this.criarMapEstabelecimentosMultiEC(dadosEstabelecimentosMultiEC);
    }

    private Map<String, EstabelecimentoMultiEC> criarMapEstabelecimentosMultiEC(DadosEstabelecimentosMultiEC dadosEstabelecimentosMultiEC) {
        HashMap<String, EstabelecimentoMultiEC> mapEstabelecimentoMultiEC = new HashMap<String, EstabelecimentoMultiEC>(dadosEstabelecimentosMultiEC.getListEstabelecimentoMultiECs().size());
        for (EstabelecimentoMultiEC estabMultiEC : dadosEstabelecimentosMultiEC.getListEstabelecimentoMultiECs()) {
            mapEstabelecimentoMultiEC.put(estabMultiEC.getIdentificadorEstabelecimento(), estabMultiEC);
        }
        return mapEstabelecimentoMultiEC;
    }

    public IdentTerminal determinarTerminal(String identificadorEstabelecimento) throws IdentificadorMultiECNaoEncontradoException {
        if (this.dadosEstabelecimentosMultiEC == null || this.dadosEstabelecimentosMultiEC.getCodigoGrupo() == null || this.dadosEstabelecimentosMultiEC.getListEstabelecimentoMultiECs() == null || this.dadosEstabelecimentosMultiEC.getListEstabelecimentoMultiECs().size() == 0) {
            throw new IdentificadorMultiECNaoEncontradoException("Lista de estabelecimentos Multi-EC nula");
        }
        if (this.mapEstabelecimentoMultiEC.containsKey(identificadorEstabelecimento)) {
            EstabelecimentoMultiEC estab = this.mapEstabelecimentoMultiEC.get(identificadorEstabelecimento);
            String pdvBase36 = Base36Util.converteBase36Terminal(this.dadosEstabelecimentosMultiEC.getCodigoGrupo());
            logger.info(String.format("Foi determinado o terminal %s%s.%s para o identificador: %s", estab.getEstabelecimento(), estab.getLoja(), pdvBase36, identificadorEstabelecimento));
            IdentTerminal ident = new IdentTerminal();
            ident.setEstabelecimento(estab.getEstabelecimento());
            ident.setLoja(estab.getLoja());
            ident.setTerminal(pdvBase36);
            return ident;
        }
        logger.warn("Identificador do terminal Multi-EC n\u00e3o encontrado: " + identificadorEstabelecimento);
        throw new IdentificadorMultiECNaoEncontradoException();
    }
}

