/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model.controller;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.CardApplicationTypeEnum;
import com.csi.ctfclient.apitef.model.Aid;
import com.csi.ctfclient.apitef.model.IdRedeIndiceTabela;
import com.csi.ctfclient.servicos.CTFClientCore;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ControladorAIDs {
    private static final String TABELA_PARAMETROS_X_AID = "1";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);
    private List<String> redesPPNoApplication;
    private Map<String, List<Aid>> mapListAIDs = new HashMap<String, List<Aid>>();

    public ControladorAIDs(List<String> redesPPNoApplication) {
        this.redesPPNoApplication = redesPPNoApplication;
    }

    public static String getRedeTabela(String tabela) {
        if (tabela != null && tabela.length() > 42 && tabela.substring(3, 4).equals(TABELA_PARAMETROS_X_AID)) {
            return tabela.substring(4, 6);
        }
        return null;
    }

    public void addLinhaCargaTabelas(String linhaCarga, boolean prioritario) {
        if (linhaCarga != null && linhaCarga.length() > 175 && linhaCarga.substring(3, 4).equals(TABELA_PARAMETROS_X_AID)) {
            Aid aid = this.buildAidByLinhaCarga(linhaCarga, prioritario);
            List<Aid> listTipoAplicacao = this.mapListAIDs.get(aid.getTipoAplicacao());
            if (listTipoAplicacao == null) {
                logger.trace("Inicializando lista de tipo de aplica\u00e7\u00e3o para " + aid.getTipoAplicacao());
                listTipoAplicacao = new LinkedList<Aid>();
                this.mapListAIDs.put(aid.getTipoAplicacao(), listTipoAplicacao);
            }
            if (!listTipoAplicacao.contains(aid)) {
                logger.trace("Lista de tipo de aplica\u00e7\u00e3o n\u00e3o contem o AID");
                if (!this.redesPPNoApplication.contains(aid.getRede())) {
                    listTipoAplicacao.add(aid);
                    logger.info("AID adicionado: " + aid.getApplicationId() + " do tipo: " + (Object)((Object)CardApplicationTypeEnum.getEnumByCode(aid.getTipoAplicacao())));
                } else {
                    logger.info("AID nao suportado pelo pinpad:   " + aid.getApplicationId());
                }
            } else {
                logger.trace("Lista de tipo de aplica\u00e7\u00e3o contem o AID");
                if (aid.getRede() != null && aid.getIndice() != null) {
                    logger.trace("adicionado rede/indice como similar do AID");
                    Aid aidInserido = listTipoAplicacao.stream().filter(a -> a.getApplicationId().equals(aid.getApplicationId())).findFirst().get();
                    IdRedeIndiceTabela idRedeIndiceTabela = aid.convertToIdRedIndTab();
                    aidInserido.addAidSimilar(aid);
                    logger.info("AID j\u00e1 inserido " + aid.getApplicationId() + " - indice/rede " + idRedeIndiceTabela.getIdRedIndTab() + " adicionado como similar");
                } else {
                    logger.info("AID j\u00e1 inserido " + aid.getApplicationId() + " - indice/rede parcialmente presente ou ausente");
                }
                logger.debug("idRedeIndice ignorado - rede=" + aid.getRede() + " indice=" + aid.getIndice() + ", aid=" + aid.getApplicationId());
            }
        }
    }

    private Aid buildAidByLinhaCarga(String linhaCarga, boolean prioritario) {
        String rede = linhaCarga.substring(4, 6);
        String indice = linhaCarga.substring(6, 8);
        String applicationId = linhaCarga.substring(10, 10 + Integer.parseInt(linhaCarga.substring(8, 10)) * 2);
        Aid aid = new Aid(rede, indice, applicationId);
        aid.setPrioritario(prioritario);
        aid.setRede(rede);
        aid.setIndice(indice);
        aid.setApplicationId(applicationId);
        aid.setTipoAplicacao(linhaCarga.substring(42, 44));
        aid.setContactless(linhaCarga.charAt(166) != '0' && linhaCarga.charAt(166) != ' ');
        aid.setLimiteTransacionalContactless(new BigDecimal(0));
        aid.setLimiteTransacionalContactlessMobile(new BigDecimal(0));
        logger.trace("Verifica se o AID \u00e9 contactless");
        if (aid.isContactless()) {
            logger.trace("AID \u00e9 contactless");
            String contactlessTransactionLimit = linhaCarga.substring(167, 175);
            if (!contactlessTransactionLimit.contains(" ")) {
                logger.trace("Realizou o setLimiteTransacionalContactless");
                aid.setLimiteTransacionalContactless(new BigDecimal(Long.parseLong(contactlessTransactionLimit, 16)));
            }
            if (linhaCarga.length() == 340) {
                String contactlessTransactionLimitMobile = linhaCarga.substring(331, 339);
                logger.trace("Validando se linhacarga tem contactless");
                if (!contactlessTransactionLimitMobile.contains(" ")) {
                    logger.trace("Realizou o setLimiteTransacionalContactlessMobile");
                    aid.setLimiteTransacionalContactlessMobile(new BigDecimal(Long.parseLong(contactlessTransactionLimitMobile, 16)));
                }
            }
        }
        if (aid.getTipoAplicacao().equals(CardApplicationTypeEnum.PRIVATE_LABEL.getCode())) {
            logger.debug("Substituindo AID tipo: " + aid.getTipoAplicacao() + " pelo tipo: " + CardApplicationTypeEnum.CREDIT.getCode());
            aid.setTipoAplicacao(CardApplicationTypeEnum.CREDIT.getCode());
        } else if (aid.getTipoAplicacao().equals(CardApplicationTypeEnum.COIN_ACCEPTOR_OR_CDC.getCode()) || aid.getTipoAplicacao().equals(CardApplicationTypeEnum.PURCHASE_AND_WITHDRAWAL.getCode())) {
            logger.debug("Substituindo AID tipo: " + aid.getTipoAplicacao() + " pelo tipo: " + CardApplicationTypeEnum.DEBIT_OR_VOUCHER.getCode());
            aid.setTipoAplicacao(CardApplicationTypeEnum.DEBIT_OR_VOUCHER.getCode());
        }
        logger.debug("Terminou de ser processado o AID " + aid.getApplicationId());
        return aid;
    }

    public Map<String, List<Aid>> getMapAIDs() {
        return this.mapListAIDs;
    }
}

