/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.EMVResponseCode;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericosHandler;
import com.csi.ctfclient.operacoes.model.ControladorEstatistica;
import com.csi.ctfclient.operacoes.model.DadosEstatistica;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoMensagem;
import com.csi.ctfclient.tools.devices.PerifericoEntradaDadosListener;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.EventoLeitorCartao;
import com.csi.ctfclient.tools.util.ClassUtil;
import java.text.MessageFormat;
import org.apache.commons.lang3.ObjectUtils;

public class PerifericoEventHandler
implements PerifericoEntradaDadosListener {
    public static final int CARTAO_MAGNETICO = 0;
    public static final int CARTAO_EMV = 3;
    public static final int CARTAO_EASY_ENTRY = 4;
    private static boolean active;
    private final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(PerifericoEventHandler.class);
    private static ControladorPerifericosHandler perifericosHandler;
    private static PerifericoEventHandler perifericoEventHandler;

    private PerifericoEventHandler(ControladorPerifericosHandler perifericosHandler) {
        PerifericoEventHandler.perifericosHandler = perifericosHandler;
    }

    public static PerifericoEventHandler getInstance(ControladorPerifericosHandler perifericosHandler) {
        if (perifericoEventHandler == null) {
            perifericoEventHandler = new PerifericoEventHandler(perifericosHandler);
        } else if (ObjectUtils.notEqual(PerifericoEventHandler.perifericosHandler, perifericosHandler)) {
            PerifericoEventHandler.perifericosHandler = perifericosHandler;
        }
        return perifericoEventHandler;
    }

    public static synchronized void setActive(boolean a) {
        active = a;
    }

    @Override
    public void eventoOcorrido(EventoDispositivoEntrada evt) {
        this.logger.debug("Recebendo novo: {} active: {}...", ClassUtil.getSimpleClassName(evt), active);
        if (evt instanceof EventoMensagem && active) {
            EventoMensagem eventoMensagem = (EventoMensagem)evt;
            try {
                this.logger.debug("mensagem: " + eventoMensagem.getMensagem());
                LayoutDisplay displayModel = new LayoutDisplay(eventoMensagem.getMensagem());
                perifericosHandler.imprimeDisplay(displayModel);
            }
            catch (Exception displayModel) {}
        } else if (evt instanceof EventoLeitorCartao) {
            EventoLeitorCartao evento = (EventoLeitorCartao)evt;
            try {
                boolean persistirDados = false;
                ControladorEstatistica controladorEstatistica = ControladorEstatistica.getInstance();
                DadosEstatistica dadosEstatistica = controladorEstatistica.getDadosEstatistica();
                if (!evento.getCartaoComErro() && evento.getErroCodigo() == 0) {
                    if (evento.getTipoCartao() == 0) {
                        this.logger.debug("Cartao magnetico");
                        dadosEstatistica.addLeituraMagnetico();
                        persistirDados = true;
                    } else if (evento.getTipoCartao() == 3) {
                        this.logger.debug("Cartao chip EMV");
                        dadosEstatistica.addLeituraSmart();
                        persistirDados = true;
                    } else if (evento.getTipoCartao() == 4) {
                        this.logger.debug("Cartao Easy Entry (Smart)");
                        dadosEstatistica.addLeituraSmart();
                        persistirDados = true;
                    }
                } else {
                    this.logger.debug("ErroCodigo: " + evento.getErroCodigo());
                    switch (EMVResponseCode.getEnumByKey(evento.getErroCodigo())) {
                        case PP_MCDATAERR: {
                            dadosEstatistica.addErroLeituraMagnetico();
                            persistirDados = true;
                            break;
                        }
                        case PP_DUMBCARD: {
                            break;
                        }
                    }
                }
                this.logger.debug("persistirDados: " + persistirDados);
                if (persistirDados) {
                    controladorEstatistica.persistirDados(dadosEstatistica);
                }
            }
            catch (ExcecaoApiAc e) {
                this.logger.error((Object)("Erro ao contabilizar estat\u00edstica em PerifericoEventHandler: " + e.getMessage()), e);
            }
        } else {
            this.logger.warn(MessageFormat.format("O evento {0} \u00e9 desconhecido!", evt));
        }
    }
}

