/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.generic.Ansi98Crypto;
import com.csi.ctfclient.tools.devices.generic.Des;
import com.csi.ctfclient.tools.services.exceptions.ExcecaoLocal;

public class ControladorModeloPinPad {
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(ControladorModeloPinPad.class);
    private static Criptografia criptografia = null;
    private static ControladorModeloPinPad controladorModeloPinPad = null;

    private ControladorModeloPinPad() throws ExcecaoNaoLocal {
        try {
            criptografia = this.createCriptografia();
        }
        catch (Exception e) {
            logger.error(e, e);
            throw new ExcecaoNaoLocal(e, "CMPP01", "Erro ao Criar Criptografia");
        }
    }

    public static ControladorModeloPinPad getInstance() throws ExcecaoNaoLocal {
        if (controladorModeloPinPad == null) {
            controladorModeloPinPad = new ControladorModeloPinPad();
        }
        return controladorModeloPinPad;
    }

    private static String decriptografa(String workingKey) {
        byte[] workingKeyBytes = Ansi98Crypto.chaveStrHex2Bin(workingKey);
        byte[] chaveBytes = Ansi98Crypto.chaveStrHex2Bin("9212470633610598");
        String workingKeyDecriptografada = Ansi98Crypto.chaveBin2StrHex(Des.decrypt(chaveBytes, workingKeyBytes), 8);
        return workingKeyDecriptografada;
    }

    @Deprecated
    public Criptografia getCriptografia(PinEMV pinEMV) throws ExcecaoLocal {
        return this.getCriptografia();
    }

    public Criptografia getCriptografia() throws ExcecaoLocal {
        if (criptografia != null) {
            return criptografia;
        }
        logger.error("Fabricante ou modelo de PinPad n\u00e3o compativel com CTFClient");
        throw new ExcecaoLocal("CMPP02", "Erro ao localizar configura\u00e7\u00f5es de Criptografia", "criptografia = null");
    }

    private Criptografia createCriptografia() {
        return new Criptografia(0, 0, ControladorModeloPinPad.decriptografa("109DD7F3A6F44DE4"), true);
    }
}

