/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model;

import com.csi.ctfclient.operacoes.model.AbstractCodigoPagamento;
import java.math.BigDecimal;
import java.util.Date;

public class CodigoPagamentoTitulo
extends AbstractCodigoPagamento {
    private String banco;
    private String moeda;
    private String digito;
    private String fator;
    private BigDecimal valor;
    private Date dataVencimento;

    public CodigoPagamentoTitulo(String codigoPagamento) {
        super(codigoPagamento);
        if (codigoPagamento != null && codigoPagamento.length() >= 44) {
            if (codigoPagamento.substring(0, 1).equals("8")) {
                throw new IllegalArgumentException("O c\u00f3digo de barras informado n\u00e3o \u00e9 um t\u00edtulo");
            }
        } else {
            throw new IllegalArgumentException("C\u00f3digo de barras nulo ou de tamanho inv\u00e1lido");
        }
        this.setTipoConta(1);
        this.banco = codigoPagamento.substring(0, 3);
        this.moeda = codigoPagamento.substring(3, 4);
        this.digito = codigoPagamento.substring(4, 5);
    }

    @Override
    public BigDecimal getValor() {
        return this.valor;
    }

    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    public String getBanco() {
        return this.banco;
    }

    public void setBanco(String banco) {
        this.banco = banco;
    }

    public Date getDataVencimento() {
        return this.dataVencimento;
    }

    public void setDataVencimento(Date dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    public String getDigito() {
        return this.digito;
    }

    public void setDigito(String digito) {
        this.digito = digito;
    }

    public String getFator() {
        return this.fator;
    }

    public void setFator(String fator) {
        this.fator = fator;
    }

    public String getMoeda() {
        return this.moeda;
    }

    public void setMoeda(String moeda) {
        this.moeda = moeda;
    }
}

