/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.model.TabelaCriptografia;
import com.csi.ctfclient.operacoes.entrada.ICriptografiaDUKPT;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.util.CriptografiaUtil;

public class MicVerificacaoTentativaInjecao {
    public static final String REFAZER_TENTATIVA_INJECAO = "REFAZER_TENTATIVA_INJECAO";
    public static final String TENTATIVAS_ESGOTADAS = "TENTATIVAS_ESGOTADAS";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(ICriptografiaDUKPT dados) {
        String mensagemLog = "Tentativa de inje\u00e7\u00e3o " + dados.getTentativaInjecao() + " no total de " + dados.getNumeroMaximoTentativasInjecaoDUKPT() + ". ";
        if (dados.getNumeroMaximoTentativasInjecaoDUKPT() > 0 && dados.getTentativaInjecao() < dados.getNumeroMaximoTentativasInjecaoDUKPT()) {
            logger.info(mensagemLog + "Uma nova tentativa de inje\u00e7\u00e3o ser\u00e1 realizada.");
            dados.setTentativaInjecao(dados.getTentativaInjecao() + 1);
            return REFAZER_TENTATIVA_INJECAO;
        }
        logger.info(mensagemLog + "Tentativas esgotadas.");
        TabelaCriptografia tabelaCriptografia = ControladorCriptografia.getTabelaCriptografia();
        CriptografiaUtil.utilizaCriptografiaContingenciaDUKPT(tabelaCriptografia, logger);
        return TENTATIVAS_ESGOTADAS;
    }
}

