/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.util.emv.CryptoKeyType;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.TabelaCriptografia;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.OrigemTransacaoEnum;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.util.ChavesCriptografiaUtil;
import com.csi.ctfclient.tools.util.CriptografiaUtil;
import com.csi.ctfclient.tools.util.StringUtil;

public class MicVerificacaoCriptografia3DES
extends MicAbstractBase {
    public static final String SUCCESS_3DES = "SUCCESS_3DES";
    public static final String SUCCESS = "SUCCESS";
    public static final String SUCCESS_CRIPTOGRAFIA_CONTINGENCIA = "SUCCESS_CRIPTOGRAFIA_CONTINGENCIA";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String NO_PINPAD = "NO_PINPAD";
    public static final String ERROR = "ERROR";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        PinEMV pinpad;
        boolean delivery;
        boolean multiTerminal = false;
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaIntegracao != null) {
            multiTerminal = entradaIntegracao.isMultiTerminal();
            delivery = entradaIntegracao.getOrigemTransacao() == OrigemTransacaoEnum.TELEFONE;
        } else {
            boolean bl = delivery = entradaApiTefC.getOrigemTransacao() == OrigemTransacaoEnum.TELEFONE;
        }
        if (multiTerminal || delivery) {
            return NOT_REQUIRED;
        }
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        TabelaCriptografia tabelaCriptografia = null;
        if (saida != null) {
            tabelaCriptografia = ControladorCriptografia.getTabelaCriptografia();
        }
        if ((pinpad = this.tryGetPin()) == null) {
            return NO_PINPAD;
        }
        if (tabelaCriptografia != null) {
            boolean utiliza3DESDados = tabelaCriptografia.getCriptografiaDadosPrincipal() != null && tabelaCriptografia.getCriptografiaDadosPrincipal().getAlgoritmo() == 1;
            boolean utiliza3DESSenha = tabelaCriptografia.getCriptografiaSenhaPrincipal() != null && tabelaCriptografia.getCriptografiaSenhaPrincipal().getAlgoritmo() == 1;
            this.logger.info("derivedExecute :: utiliza3DESSenha: " + utiliza3DESSenha);
            this.logger.info("derivedExecute :: utiliza3DESDados: " + utiliza3DESDados);
            if ((utiliza3DESSenha || utiliza3DESDados) && !(pinpad instanceof BibliotecaPinpad)) {
                this.logger.info("Biblioteca compartilhada n\u00e3o utilizada, ignorando o tratamento de suporte da criptografia 3DES");
                return NO_PINPAD;
            }
            boolean tripleDESOk = false;
            if (utiliza3DESDados) {
                try {
                    ChavesCriptografiaUtil.validatePinpadKey(this.logger, dados.getPerifericos(), tabelaCriptografia, CryptoKeyType.DATA);
                    tripleDESOk = true;
                }
                catch (ExcecaoPerifericos e) {
                    this.logger.warn("Nao foi possivel validar chaves do pin: " + e.getMessage());
                    this.logger.debug("Tentando utilizar m\u00e9todo alternativo");
                    try {
                        BibliotecaPinpad pinCompartilhado = (BibliotecaPinpad)pinpad;
                        pinCompartilhado.encryptBuffer(1, tabelaCriptografia.getCriptografiaDadosPrincipal().getIndiceMasterKey(), tabelaCriptografia.getCriptografiaDadosPrincipal().getWorkingKey(), StringUtil.asciiToByteArray("1234567890123456"), null);
                        tripleDESOk = true;
                    }
                    catch (ExcecaoPerifericos e1) {
                        this.logger.warn("Erro ao tentar 3DES, \u00edndice: " + tabelaCriptografia.getCriptografiaDadosPrincipal().getIndiceMasterKey() + ". Desc: " + e1.getMessage());
                    }
                }
                if (!tripleDESOk) {
                    CriptografiaUtil.utilizaCriptografiaContingenciaDados(tabelaCriptografia, this.logger);
                    return SUCCESS_CRIPTOGRAFIA_CONTINGENCIA;
                }
                this.logger.debug("Criptografia 3DES suportada pelo Pinpad");
            } else {
                this.logger.debug("3DES n\u00e3o utilizado para criptografia de dados");
            }
            if (utiliza3DESSenha) {
                try {
                    ChavesCriptografiaUtil.validatePinpadKey(this.logger, dados.getPerifericos(), tabelaCriptografia, CryptoKeyType.PIN);
                }
                catch (ExcecaoPerifericos excecaoPerifericos) {
                    this.logger.error("Nao foi possivel abrir o periferico para pesquisar a chave K3 de dados: " + excecaoPerifericos.getMessage());
                    return ERROR;
                }
            } else {
                this.logger.debug("3DES n\u00e3o utilizado para criptografia de dados");
            }
            if (tripleDESOk) {
                return SUCCESS_3DES;
            }
            return SUCCESS;
        }
        if (Contexto.getContexto().getSaidaApiTefC() != null) {
            Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
        }
        this.logger.error("Tabela de criptografia n\u00e3o carregada para tentativa de uso de cripto 3DES");
        return ERROR;
    }
}

