/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.util.StringUtil;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class MicVerificaUltimoComprovante
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        IdentTerminal identTerminal = this.getIdentTerminal();
        String path = identTerminal.getEstabelecimento().substring(1) + identTerminal.getLoja() + "." + identTerminal.getTerminal();
        if (ControladorConfCTFClient.getDiretorioTrabalho() != null) {
            path = ControladorConfCTFClient.getDiretorioTrabalho() + path + File.separator;
        }
        boolean ultimoCupom = false;
        int numTrans = 1;
        this.logger.info("Iniciando busca por cupons");
        while (!ultimoCupom) {
            String cupom3Atual = path + "CUPOMCTF.3" + StringUtil.completaString(numTrans + "", 2, '0', 3);
            File fileCupom3Atual = new File(cupom3Atual);
            if (fileCupom3Atual.exists()) {
                this.logger.info("Cupom ".concat(cupom3Atual).concat(" encontrado!"));
                String cupom3Proximo = path + "CUPOMCTF.3" + StringUtil.completaString(numTrans + 1 + "", 2, '0', 3);
                File fileCupom3Proximo = new File(cupom3Proximo);
                if (fileCupom3Proximo.exists()) {
                    ++numTrans;
                    continue;
                }
                if (numTrans > 1) {
                    String cupom = path + "CUPOMCTF.3" + StringUtil.completaString("1", 2, '0', 3);
                    File fileCupom = new File(cupom);
                    this.copiaCupom(fileCupom3Atual, fileCupom);
                    String cupom4Atual = path + "CUPOMCTF.4" + StringUtil.completaString(numTrans + "", 2, '0', 3);
                    File fileCupom4Atual = new File(cupom4Atual);
                    String cupom4 = path + "CUPOMCTF.4" + StringUtil.completaString("1", 2, '0', 3);
                    File fileCupom4 = new File(cupom4);
                    if (fileCupom4Atual.exists()) {
                        this.copiaCupom(fileCupom4Atual, fileCupom4);
                    }
                }
                SaidaApiTefC saidaApiTefC = new SaidaApiTefC();
                saidaApiTefC.setRetorno(0);
                Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
                EntradaApiTefC entradaApiTefC = new EntradaApiTefC();
                entradaApiTefC.setOperacao("F7");
                Contexto.getContexto().atualizaEntradaApiTefC(entradaApiTefC);
                ultimoCupom = true;
                continue;
            }
            this.logger.error("Cupom ".concat(cupom3Atual).concat(" n\u00e3o encontrado!"));
            return ERROR;
        }
        return SUCCESS;
    }

    private void copiaCupom(File cupom, File novoCupom) {
        try {
            int c;
            FileReader in = new FileReader(cupom);
            if (cupom.exists() && !cupom.delete()) {
                this.logger.warn("N\u00e3o foi poss\u00edvel remover o cupom: " + cupom.getAbsolutePath());
            }
            FileWriter out = new FileWriter(novoCupom);
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            this.logger.error("Erro durante a c\u00f3pia do cupom: " + e.getMessage());
        }
    }
}

