/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.DadosEstabelecimentosMultiEC;
import com.csi.ctfclient.operacoes.model.controller.ControladorMultiEC;
import com.csi.ctfclient.operacoes.model.controller.IdentificadorMultiECNaoEncontradoException;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;

public class MicVerificaTerminalMultiEC {
    public static final String TERMINAL_DETERMINED = "TERMINAL_DETERMINED";
    public static final String TERMINAL_ALREADY_DETERMINED = "TERMINAL_ALREADY_DETERMINED";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String SUCCESS_CONSULTA_MULTIEC = "SUCCESS_CONSULTA_MULTIEC";
    public static final String CONSULTAR_ESTABELECIMENTOS = "CONSULTAR_ESTABELECIMENTOS";
    public static final String ERROR_AC = "ERROR_AC";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        IdentTerminal identTerminal;
        ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
        if (!config.isMultiEC()) {
            return NOT_REQUIRED;
        }
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaIntegracao != null && (entradaIntegracao.getOperacao() == OperationEnum.OP_CONFIGURACAO_TERMINAL.getKey().intValue() || entradaIntegracao.getOperacao() == OperationEnum.OP_CAPTURA_DADO_PINPAD.getKey().intValue())) {
            return NOT_REQUIRED;
        }
        ControladorMultiEC controladorMultiEC = ControladorMultiEC.getInstance();
        DadosEstabelecimentosMultiEC dadosEstabelecimentosMultiEC = controladorMultiEC.getDadosEstabelecimentosMultiEC();
        if (dadosEstabelecimentosMultiEC == null || dadosEstabelecimentosMultiEC.getCodigoGrupo() == null || dadosEstabelecimentosMultiEC.getListEstabelecimentoMultiECs() == null) {
            logger.info("Os estabelecimentos Multi-EC ainda n\u00e3o foram consultados, a consulta ser\u00e1 efetuada");
            return CONSULTAR_ESTABELECIMENTOS;
        }
        if (dadosEstabelecimentosMultiEC.getListEstabelecimentoMultiECs().size() == 0) {
            logger.info("O Multi-EC n\u00e3o possui nenhum terminal, a consulta ser\u00e1 efetuada");
            return CONSULTAR_ESTABELECIMENTOS;
        }
        if (!dadosEstabelecimentosMultiEC.getCodigoGrupo().equals(config.getCodigoGrupoMultiEC())) {
            logger.info("O grupo persistido (" + dadosEstabelecimentosMultiEC.getCodigoGrupo() + ") difere do grupo configurado ()");
            return CONSULTAR_ESTABELECIMENTOS;
        }
        if (OperationEnum.OP_CONSULTA_ESTABELECIMENTOS_MULTI_EC.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            SaidaApiTefC saida = new SaidaApiTefC();
            saida.setListEstabelecimentosMultiEC(dadosEstabelecimentosMultiEC.getListEstabelecimentoMultiECs());
            saida.setCodigoRespostaCTF("00");
            saida.setRetorno(0);
            Contexto.getContexto().setSaidaApiTefC(saida);
            return SUCCESS_CONSULTA_MULTIEC;
        }
        if (!ControladorMultiEC.isTerminalComumMultiEC(entradaIntegracao.getIdentTerminal())) {
            return TERMINAL_ALREADY_DETERMINED;
        }
        if (entradaIntegracao == null || !entradaIntegracao.isIdentificadorMultiECCtrl() || entradaIntegracao.getIdentificadorMultiEC() == null || entradaIntegracao.getIdentificadorMultiEC().length() == 0) {
            logger.error("Identificador do terminal Multi-EC n\u00e3o enviado, enviar o campo 102");
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.IDENTIFICADOR_TERMINAL_MULTI_EC_NAO_ENVIADO, "IDENTIFICADOR DO TERMINAL MULTI-EC NAO ENVIADO PELA AUTOMACAO"));
            return ERROR_AC;
        }
        try {
            identTerminal = controladorMultiEC.determinarTerminal(entradaIntegracao.getIdentificadorMultiEC());
        }
        catch (IdentificadorMultiECNaoEncontradoException e) {
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.IDENTIFICADOR_TERMINAL_MULTI_EC_NAO_ENCONTRADO, "IDENTIFICADOR DO TERMINAL MULTI-EC NAO ENCONTRADO, EC ENVIADO PELA AUTOMACAO: " + entradaIntegracao.getIdentificadorMultiEC()));
            return ERROR_AC;
        }
        entradaIntegracao.setIdentTerminal(identTerminal);
        IdentApiTefC identApiTefC = Contexto.getContexto().getIdentApiTefC();
        identApiTefC.setNumeroEstabelecimento(identTerminal.getEstabelecimento());
        identApiTefC.setNumeroLoja(identTerminal.getLoja());
        identApiTefC.setNumeroPdv(identTerminal.getTerminal());
        return TERMINAL_DETERMINED;
    }
}

