/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicVerificaResultadoTrocaSenha {
    public static final String SUCCESS_APPROVED = "SUCCESS_APPROVED";
    public static final String SUCCESS_DENIED = "SUCCESS_DENIED";
    public static final String UNECESSARY = "UNECESSARY";
    private static final String TROCA_SENHA_OK = "2";
    private static final String TROCA_SENHA_FALHA = "1";
    private static final String MSG_TROCA_SENHA_OK = "SUCESSO NA TROCA DE SENHA";
    private static final String MSG_TROCA_SENHA_FALHA = "FALHA NA TROCA DE SENHA";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) {
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        if (Contexto.getContexto().getPinInfo().getDecisaoFinishChip() == 0) {
            String isr = entrada.getIssuerScriptResult();
            if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_TROCA_SENHA.getDescription())) {
                if (isr != null && isr.length() > 0) {
                    if (isr.substring(0, 1).equals(TROCA_SENHA_OK)) {
                        this.montaMsgDisplay(saida, MSG_TROCA_SENHA_OK);
                        return SUCCESS_APPROVED;
                    }
                    if (isr.substring(0, 1).equals(TROCA_SENHA_FALHA)) {
                        Contexto.getContexto().getSaidaApiTefC().setRetorno(5);
                        Contexto.getContexto().setRemoveCardMessage(InternacionalizacaoUtil.getInstance().getMessage(MessageEnum.REMCAR_TRANS_NAO_APROV));
                        this.montaMsgDisplay(saida, MSG_TROCA_SENHA_FALHA);
                        return SUCCESS_DENIED;
                    }
                    logger.warn("Saida inesperada do ISR: '" + isr.substring(0, 1) + "'");
                    return UNECESSARY;
                }
                logger.info("ISR vazio");
                return UNECESSARY;
            }
            logger.info("Valida\u00e7\u00e3o do ISR n\u00e3o ser\u00e1 realizada");
            return UNECESSARY;
        }
        return UNECESSARY;
    }

    public void montaMsgDisplay(SaidaApiTefC saida, String msg) {
        if (msg != null && msg.length() > 0) {
            String tam = String.valueOf(msg.length());
            tam = StringUtil.completaString(tam, 4, '0', 3);
            msg = tam + msg;
            saida.setDisplayCTF(msg);
        }
    }
}

