/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.CardApplicationTypeEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.contexto.ContextoCTFClient;
import com.csi.ctfclient.operacoes.model.controller.ControladorAIDsGetCard;
import com.csi.ctfclient.operacoes.model.controller.ControladorMultiEC;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.servicos.OrigemTransacaoEnum;
import java.util.Objects;

public class MicVerificaLeituraCartaoCancelamento {
    public static final String CARD = "CARD";
    public static final String TELEPHONE = "TELEPHONE";
    public static final String CPF = "CPF";
    public static final String QUALIDADE = "QUALIDADE";
    public static final String QR_CODE = "QRCODE";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String OPERATION_NOT_ALLOWED = "OPERATION_NOT_ALLOWED";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        SaidaApiTefC saida1G = Contexto.getContexto().getSaidaConsulta();
        if (saida1G.isCancelamentoLeituraCartao()) {
            String codigoTransacaoCancelamento;
            if (saida1G.getCodigoTransacao() != null && (codigoTransacaoCancelamento = saida1G.getCodigoTransacao()) != null && (codigoTransacaoCancelamento.equals("12") || codigoTransacaoCancelamento.equals("10"))) {
                boolean delivery;
                boolean multiTerminal = false;
                EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
                EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
                if (entradaIntegracao != null) {
                    multiTerminal = entradaIntegracao.isMultiTerminal();
                    delivery = entradaIntegracao.getOrigemTransacao() == OrigemTransacaoEnum.TELEFONE;
                } else {
                    delivery = entradaApiTefC.getOrigemTransacao() == OrigemTransacaoEnum.TELEFONE;
                }
                ConfCTFClient config = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
                boolean multiEC = config.isMultiEC();
                IdentTerminal identTerminal = multiEC ? ControladorMultiEC.criarTerminalComumMultiEC(config.getCodigoGrupoMultiEC()) : (entradaIntegracao != null && (multiTerminal || delivery) ? entradaIntegracao.getIdentTerminal() : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal()));
                String tipoAplicacao = codigoTransacaoCancelamento.equals("12") ? CardApplicationTypeEnum.CREDIT.getCode() : CardApplicationTypeEnum.DEBIT_OR_VOUCHER.getCode();
                ControladorAIDsGetCard controladorAIDsGetCard = ControladorAIDsGetCard.getInstance(identTerminal);
                if (controladorAIDsGetCard.getMapAid() != null) {
                    Contexto.getContexto().setListAID(controladorAIDsGetCard.getMapAid().get(tipoAplicacao));
                }
            }
            return CARD;
        }
        if (saida1G.isCancelamentoSemCartao()) {
            Contexto.getContexto().setErrorCode(-1);
            Contexto.getContexto().setTransacaoSemCartao(true);
            return NOT_REQUIRED;
        }
        if (saida1G.isCancelamentoLeituraTelefone()) {
            Contexto.getContexto().setTransacaoSemCartao(true);
            return TELEPHONE;
        }
        if (saida1G.isCancelamentoLeituraCpf()) {
            Contexto.getContexto().setTransacaoSemCartao(true);
            return CPF;
        }
        if (saida1G.isCancelamentoLeituraQrCode()) {
            Contexto.getContexto().setTransacaoSemCartao(true);
            return QR_CODE;
        }
        if (saida1G.isCancelamentoQualidade()) {
            ContextoCTFClient context = Contexto.getContexto();
            context.setCardQualidade(Boolean.TRUE);
            return QUALIDADE;
        }
        throw new IllegalArgumentException("Flag de tipo de leitura de dado no cancelamento inv\u00e1lido");
    }
}

