/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.TabelaCriptografia;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.OrigemTransacaoEnum;

public class MicVerificaCriptografiaPinpad
extends MicAbstractBase {
    public static final String VERIFY_DUKPT_3DES = "VERIFY_DUKPT_3DES";
    public static final String VERIFY_3DES = "VERIFY_3DES";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String ERROR = "ERROR";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        boolean delivery;
        if (Contexto.getContexto().getCartao() == null || Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
            return NOT_REQUIRED;
        }
        boolean multiTerminal = false;
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaIntegracao != null) {
            multiTerminal = entradaIntegracao.isMultiTerminal();
            delivery = entradaIntegracao.getOrigemTransacao() == OrigemTransacaoEnum.TELEFONE;
        } else {
            boolean bl = delivery = entradaApiTefC.getOrigemTransacao() == OrigemTransacaoEnum.TELEFONE;
        }
        if (multiTerminal || delivery) {
            return NOT_REQUIRED;
        }
        if (this.tryGetPin() == null) {
            return NOT_REQUIRED;
        }
        TabelaCriptografia tabelaCriptografia = null;
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        if (saida != null) {
            tabelaCriptografia = ControladorCriptografia.getTabelaCriptografia();
        }
        if (tabelaCriptografia != null) {
            if (tabelaCriptografia.getCriptografiaSenhaPrincipal() != null && tabelaCriptografia.getCriptografiaSenhaPrincipal().getAlgoritmo() == 3 || tabelaCriptografia.getCriptografiaDadosPrincipal() != null && tabelaCriptografia.getCriptografiaDadosPrincipal().getAlgoritmo() == 3) {
                return VERIFY_DUKPT_3DES;
            }
            if (tabelaCriptografia.getCriptografiaSenhaPrincipal() != null && tabelaCriptografia.getCriptografiaSenhaPrincipal().getAlgoritmo() == 1 || tabelaCriptografia.getCriptografiaDadosPrincipal() != null && tabelaCriptografia.getCriptografiaDadosPrincipal().getAlgoritmo() == 1) {
                return VERIFY_3DES;
            }
            return NOT_REQUIRED;
        }
        return ERROR;
    }
}

