/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.operacoes.model.DadosPersistencia;
import com.csi.ctfclient.operacoes.model.controller.ControladorPersistencia;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.util.DateUtil;
import java.util.Date;

public class MicVerificaConsultaOperadoras {
    public static final String REQUIRED = "REQUIRED";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
        Date today = new Date();
        ControladorPersistencia controladorPersistencia = ControladorPersistencia.getInstance();
        DadosPersistencia persistencia = null;
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        boolean multiTerminal = entradaIntegracao != null && entradaIntegracao.isMultiTerminal();
        boolean multiEC = config.isMultiEC();
        IdentTerminal identTerminal = null;
        identTerminal = entradaIntegracao != null && (multiTerminal || multiEC) ? entradaIntegracao.getIdentTerminal() : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
        ControladorInicioDia controladorInicioDia = ControladorInicioDia.getInstance();
        DadosInicioDia dadosInicioDia = controladorInicioDia.getDadosInicioDia(identTerminal);
        if (Contexto.getContexto().getTipoOperadora() == "8" && !dadosInicioDia.isConsultaOperadorasCD()) {
            return NOT_REQUIRED;
        }
        try {
            persistencia = controladorPersistencia.getDadosPersistencia(identTerminal);
            if ("3".equals(Contexto.getContexto().getTipoOperadora())) {
                return DateUtil.equalsData(persistencia.getListOperadorasValeGas().getUltimaAtualizacao(), today) ? NOT_REQUIRED : REQUIRED;
            }
            if ("4".equals(Contexto.getContexto().getTipoOperadora())) {
                return DateUtil.equalsData(persistencia.getListOperadorasTelefonia().getUltimaAtualizacao(), today) ? NOT_REQUIRED : REQUIRED;
            }
            if ("8".equals(Contexto.getContexto().getTipoOperadora())) {
                return DateUtil.equalsData(persistencia.getListaOperadorasRecarga().getUltimaAtualizacao(), today) ? NOT_REQUIRED : REQUIRED;
            }
            if ("A".equals(Contexto.getContexto().getTipoOperadora())) {
                return DateUtil.equalsData(persistencia.getListOperadorasPrepagoDigital().getUltimaAtualizacao(), today) ? NOT_REQUIRED : REQUIRED;
            }
            throw new IllegalArgumentException("Operadora a ser consultada inv\u00e1lida");
        }
        catch (ExcecaoApiAc e) {
            return REQUIRED;
        }
    }
}

