/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import br.com.auttar.util.operation.TransactionOperationRules;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.DisplayFisicoCSILanguage;
import com.csi.ctfclient.tools.util.internacionalizacao.Formatter;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;

public class MicVerificaComunicacaoCTF
extends MicAbstractBase {
    private static final String INTERNAL_ERROR_MESSAGE = "ERRO INTERNO";
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String ERRO_RETURN_AC = "ERRO_RETURN_AC";
    public static final String USER_CANCEL_1F = "USER_CANCEL_1F";
    private InternacionalizacaoUtil inter;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String derivedExecute(Process dado) throws ExcecaoNaoLocal {
        ConfCTFClient confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        ControladorPerifericos periferico = dado.getPerifericos();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        this.inter = InternacionalizacaoUtil.getInstance();
        if (saida == null) {
            this.setIntegrationError(CodigoErroIntegracaoEnum.ERRO_20, INTERNAL_ERROR_MESSAGE);
            return ERRO;
        }
        if (this.isErroSaidaInterrompeTransacao(saida)) {
            Contexto.getContexto().setRemoveCardMessage(InternacionalizacaoUtil.getInstance().getMessage(MessageEnum.REMCAR_TRANS_NAO_APROV));
        }
        int key = saida.getRetorno();
        String msg = "";
        if (key <= 0) return SUCESS;
        switch (key) {
            case 1: {
                msg = "TENTE DE NOVO-TO";
                break;
            }
            case 2: {
                msg = "TEF NAO INICIALIZADO";
                break;
            }
            case 3: {
                msg = "TRANSACAO EXCEDE LIMITE";
                break;
            }
            case 4: {
                msg = "ERRO NOS PARAMETROS: " + Contexto.getContexto().getSaidaApiTefC().getCodigoErro();
                break;
            }
            case 5: {
                break;
            }
            case 9: {
                msg = "AUTORIZADORA OFF-LINE";
                break;
            }
            case 10: {
                msg = "ERRO DE COMUNICACAO: " + saida.getCodigoErro();
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                msg = "ERRO NO INTERTEF: " + saida.getCodigoErro();
                break;
            }
            case 13: {
                return SUCESS;
            }
            case 16: {
                msg = "ERRO DE CRIPTOGRAFIA";
                break;
            }
            default: {
                this.logger.debug("Retorno SaidaApiTefC: ERRO APITEF - " + key);
            }
        }
        if (!msg.trim().isEmpty()) {
            this.logger.info("ApiWebCtf retorno: " + msg);
            if (!this.isMultiTerminalViaIntegracao()) {
                periferico.limpaDisplay();
            }
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null) {
            if (msg.length() > 0) {
                if (Contexto.getContexto().getEntradaApiTefC() != null && (Contexto.getContexto().getEntradaApiTefC().getOperacao().equals("2N") || Contexto.getContexto().getEntradaApiTefC().getOperacao().equals("1F"))) {
                    if (this.isTransacaoRetornaAC()) {
                        this.montaMsgDisplay(saida, msg);
                        return ERRO_RETURN_AC;
                    }
                    if (this.isTransacaoFallBack(Contexto.getContexto().getSaidaApiTefC())) {
                        return ERRO;
                    }
                    this.exibeMensagemDisplay(periferico, msg);
                } else {
                    this.montaMsgDisplay(saida, msg);
                }
            } else if (Contexto.getContexto().getEntradaApiTefC().getOperacao().equals("1F")) {
                String resposta;
                if (this.isTransacaoRetornaAC()) return ERRO_RETURN_AC;
                if (this.isTransacaoFallBack(Contexto.getContexto().getSaidaApiTefC())) {
                    return ERRO;
                }
                this.montaMsgDisplay(periferico, saida);
                if (this.exibeMensagemDisplay(periferico, saida.getDisplayCTF()).equals("VOLTA") && this.isRespAutorizadoraTransacaoSemLog(resposta = saida.getCodigoRespostaAutorizadora())) {
                    return USER_CANCEL_1F;
                }
            }
        } else if (Contexto.getContexto().getEntradaApiTefC().getOperacao().equals("1F") || Contexto.getContexto().getEntradaApiTefC().getOperacao().equals("2M")) {
            if (this.isTransacaoFallBack(Contexto.getContexto().getSaidaApiTefC())) {
                return ERRO;
            }
            if (msg.trim().equals("")) {
                this.montaMsgDisplay(periferico, saida);
            } else {
                this.exibeMensagemDisplay(periferico, msg);
            }
        } else {
            this.montaMsgDisplay(saida, msg);
        }
        if (TransactionOperationRules.isTypedOperation() || confCTFClient.isIntegracaoWeb() || this.tryGetPin() == null) return ERRO;
        this.montaMsgPinpad(saida);
        return ERRO;
    }

    private boolean isErroSaidaInterrompeTransacao(SaidaApiTefC saida) {
        return saida.getRetorno() != 0 && (!Contexto.getContexto().isFluxoEmv() || !saida.isCapturaDadosChip() || saida.isFluxoEMVSemFinishChip() || Contexto.getContexto().getPinInfo() == null && (!this.isRespAutorizadoraTransacaoSemLog(saida.getCodigoRespostaAutorizadora()) || this.isMultiTerminalViaIntegracao()));
    }

    private boolean isRespAutorizadoraTransacaoSemLog(String resposta) {
        return "0F0".equals(resposta) || "F0".equals(resposta);
    }

    private void montaMsgPinpad(SaidaApiTefC saida) {
        String[] mensagens = saida.getMensagemDisplayPin().split("#");
        StringBuilder msgPinPad = new StringBuilder();
        for (String mensagen : mensagens) {
            msgPinPad.append(StringUtil.completaString(mensagen, 16, ' ', false));
        }
        if (msgPinPad.toString().trim().length() > 0) {
            this.exibePinpadComDelay(msgPinPad.toString());
        }
    }

    private void exibePinpadComDelay(String msg) {
        this.tryShowMessagePinpad(msg);
        try {
            Thread.sleep(ControladorConfCTFClient.TIME_OUT_DELAY);
        }
        catch (InterruptedException e) {
            this.logger.info("Espera do pinpad foi interrompida: " + e.getMessage());
        }
        PinEMV pin = this.tryGetPin();
        if (pin != null) {
            this.tryShowMessagePinpad(pin.getMsgPrompt());
        }
    }

    private void montaMsgDisplay(ControladorPerifericos periferico, SaidaApiTefC saida) throws ExcecaoNaoLocal {
        boolean display = this.exibeGrupoMensagens(periferico, saida.getDisplayCTF());
        if (!display && !saida.getCodigoAutorizadora().equals("00") && saida.getCodigoRespostaAutorizadora() != null) {
            this.exibeMensagemDisplay(periferico, "ERRO: " + saida.getCodigoRespostaAutorizadora());
        }
    }

    private void montaMsgDisplay(SaidaApiTefC saida, String msg) {
        if (msg != null && msg.length() > 0) {
            String tam = String.valueOf(msg.length());
            tam = StringUtil.completaString(tam, 4, '0', 3);
            msg = tam + msg;
            saida.setDisplayCTF(msg);
        }
    }

    private boolean exibeGrupoMensagens(ControladorPerifericos periferico, String[] mensagens) throws ExcecaoNaoLocal {
        boolean retorno = false;
        if (mensagens != null && mensagens.length > 0) {
            for (String mensagen : mensagens) {
                String[] msgs = this.inter.getLanguage() instanceof DisplayFisicoCSILanguage ? Formatter.formatMsgDisplayFisico(mensagen) : mensagen.split("#");
                this.exibeMensagemComDelay(periferico, msgs, ControladorConfCTFClient.TIME_OUT_DELAY, Boolean.FALSE);
            }
            retorno = true;
        }
        return retorno;
    }

    private void exibeMensagemComDelay(ControladorPerifericos periferico, String[] msg, long delay, boolean cancelarDelay) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(delay, cancelarDelay);
        msg = Objects.nonNull(msg) ? msg : ArrayUtils.EMPTY_STRING_ARRAY;
        this.logger.info("exibeMensagemComDelay: {}", ArrayUtils.toString(msg));
        for (String s : msg) {
            displayModel.addLinha(new Linha(s));
        }
        periferico.imprimeDisplay(displayModel);
    }

    private void exibeMensagemDisplay(ControladorPerifericos periferico, String msg) throws ExcecaoNaoLocal {
        String[] msgs = this.inter.getLanguage() instanceof DisplayFisicoCSILanguage ? Formatter.formatMsgDisplayFisico(msg) : new String[]{msg};
        this.exibeMensagemComDelay(periferico, msgs, 10000L, Boolean.TRUE);
    }

    private String exibeMensagemDisplay(ControladorPerifericos periferico, String[] msgs) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay();
        msgs = Objects.nonNull(msgs) ? msgs : ArrayUtils.EMPTY_STRING_ARRAY;
        this.logger.info("exibeMensagemDisplay: {}", Arrays.asList(msgs));
        for (String msg : msgs) {
            String[] msgLinha;
            for (String s : msgLinha = msg.split("#")) {
                displayModel.addLinha(new Linha(s));
            }
        }
        EventoTeclado evt = (EventoTeclado)periferico.confirmaDado(displayModel);
        return evt.getTeclaFinalizadora();
    }

    private boolean isTransacaoRetornaAC() {
        int operacao = Contexto.getContexto().getEntradaIntegracao().getOperacao();
        if (this.isMultiTerminalViaIntegracao()) {
            return true;
        }
        if (operacao == OperationEnum.OP_CRED_DIGITADO.getKey() || operacao == OperationEnum.OP_CRED_DIGITADO_IATA.getKey() || operacao == OperationEnum.OP_CRED_DIGITADO_IATA_COM_JUROS.getKey() || operacao == OperationEnum.OP_CRED_DIGITADO_IATA_SEM_JUROS.getKey() || operacao == OperationEnum.OP_CRED_DIGITADO_PARC_COM_JUROS.getKey() || operacao == OperationEnum.OP_CRED_DIGITADO_PARC_SEM_JUROS.getKey() || operacao == OperationEnum.OP_CRED_PRIVATE_LABEL_DIGITADO.getKey() || operacao == OperationEnum.OP_AUT_IATA_DIGITADO.getKey() || operacao == OperationEnum.OP_AUT_IATA_DIGITADO_SEM_JUROS.getKey() || operacao == OperationEnum.OP_CONFIRMACAO_PRE_AUT_DIGITADO.getKey() || operacao == OperationEnum.OP_CONFIRMACAO_PRE_AUT_DIGITADO_COM_JUROS.getKey() || operacao == OperationEnum.OP_CONFIRMACAO_PRE_AUT_DIGITADO_SEM_JUROS.getKey() || operacao == OperationEnum.OP_CONSULTA_CREDITO_DIGITADO.getKey() || operacao == OperationEnum.OP_CONSULTA_PRIVATE_LABEL_DIGITADO.getKey() || operacao == OperationEnum.OP_PGTO_CONVENIO.getKey() || operacao == OperationEnum.OP_PGTO_FICHA_COMPENSACAO.getKey()) {
            return true;
        }
        if (TransactionOperationRules.isBarCodeFilled()) {
            return true;
        }
        return Contexto.getContexto().getEntradaIntegracao().isNumeroCartaoCtrl();
    }

    private boolean isTransacaoFallBack(SaidaApiTefC saida) {
        if (saida != null && saida.getCodigoRespostaAutorizadora() != null) {
            String codigoResposta = saida.getCodigoRespostaAutorizadora();
            return codigoResposta.equals("F3") || codigoResposta.equals("0F3");
        }
        return false;
    }

    private boolean isMultiTerminalViaIntegracao() {
        return Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isMultiTerminal();
    }
}

