/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.util.operation.TransactionOperationRules;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.operacoes.model.controller.ControladorAIDsGetCard;
import com.csi.ctfclient.operacoes.model.controller.ControladorMultiEC;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import java.util.Objects;

public class MicValidaTabelasPin
extends MicAbstractBase {
    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        PinEMV pinEMV;
        String result = "SUCCESS";
        if (TransactionOperationRules.isTypedOperation() || !TransactionOperationRules.requiresPinpadTables()) {
            result = "UNNECESSARY";
            return result;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        LayoutDisplay layoutDisplay = new LayoutDisplay();
        layoutDisplay.addLinha(new Linha("AGUARDE..."));
        perifericos.imprimeDisplay(layoutDisplay);
        try {
            pinEMV = perifericos.getPinpad();
        }
        catch (Exception e) {
            this.logger.error("Nao foi possivel carregar o driver do pinpad: " + e.getMessage());
            return this.trataErroComunicacaoPinPad("ERROR", "CONFIGURE_PINPAD");
        }
        ConfCTFClient config = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        CMOSPinPad cmosPinPad = CMOSPinPad.getInstance();
        boolean multiEC = config.isMultiEC();
        try {
            IdentTerminal identTerminal = multiEC ? ControladorMultiEC.criarTerminalComumMultiEC(config.getCodigoGrupoMultiEC()) : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
            ControladorAIDsGetCard controladorAIDsGetCard = ControladorAIDsGetCard.getInstance(identTerminal);
            if (controladorAIDsGetCard.getMapAid() != null) {
                String cmosTimestamp = cmosPinPad.getTimeStamp(0);
                String pinpadTimestamp = pinEMV.getTimeStampTabelas();
                this.logger.info("Vers\u00e3o carga de tabelas - CMOS=" + cmosTimestamp + " PINPAD=" + pinpadTimestamp);
                if (cmosTimestamp == null || pinpadTimestamp == null || !cmosTimestamp.equals(pinpadTimestamp)) {
                    this.logger.info("NECESSITA REALIZAR CARGA DE TABELA - Carga de tabelas desatualizada");
                    result = "CARGA_TABELAS_NECESSARIA";
                }
            } else {
                this.logger.info("NECESSITA REALIZAR CARGA DE TABELA - Terminal n\u00e3o possui mapa de AIDs");
                result = "CARGA_TABELAS_NECESSARIA";
            }
        }
        catch (Exception e) {
            this.logger.warn("N\u00e3o foi poss\u00edvel validar cache da carga de tabelas. ERRO: " + e.getMessage());
        }
        return result;
    }
}

