/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import java.net.InetAddress;
import java.net.NetworkInterface;

public class MicValidaSplitPagamento {
    public static final String SUCCESS = "SUCCESS";
    public static final String UNNECESSARY = "UNNECESSARY";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) {
        EntradaCTFClientCtrl entrada = Contexto.getContexto().getEntradaIntegracao();
        if (this.isSplitPagamentoMissing(entrada)) {
            logger.info("Sem informa\u00e7\u00f5es de split de pagamento.");
            return UNNECESSARY;
        }
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        entradaApiTefC.setProdutoSplitPagamentoSellerId(entrada.getProdutoSplitPagamentoSellerId());
        entradaApiTefC.setProdutosSplitPagamento(entrada.getProdutosSplitPagamento());
        if (entrada.getProdutoSplitPagamentoMacAddress() != null) {
            entradaApiTefC.setMacAddress(entrada.getProdutoSplitPagamentoMacAddress());
        } else {
            entradaApiTefC.setMacAddress(this.getMacAddress());
        }
        return SUCCESS;
    }

    protected String getMacAddress() {
        try {
            InetAddress ip = InetAddress.getLocalHost();
            logger.info("Current IP address : " + ip.getHostAddress());
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            byte[] mac = network.getHardwareAddress();
            StringBuilder sb = new StringBuilder();
            for (byte b : mac) {
                sb.append(String.format("%02X%s", b, ""));
            }
            String macAddress = sb.toString();
            logger.info("Current MAC address : " + macAddress);
            return macAddress;
        }
        catch (Exception e) {
            logger.info("Erro na captura do mac address.");
            return null;
        }
    }

    private boolean isSplitPagamentoMissing(EntradaCTFClientCtrl entrada) {
        return entrada.getProdutosSplitPagamento() == null || entrada.getProdutosSplitPagamento().isEmpty();
    }
}

