/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoCodigoInvalido;
import com.csi.ctfclient.excecoes.ExcecaoDigitoInvalido;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.tiposgerais.CodigoFebraban;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.FormatoCodigoBarrasEnum;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.AbstractCodigoPagamento;
import com.csi.ctfclient.operacoes.model.CodigoBarrasConvenio;
import com.csi.ctfclient.operacoes.model.CodigoBarrasTitulo;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.CodigoPagamentoTitulo;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.operacoes.model.LinhaDigitavelTitulo;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.codigobarras.CalculadorDigito;
import com.csi.ctfclient.tools.util.codigobarras.CodigoBarrasUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class MicValidaCodigoBarras {
    public static final String SUCESS = "SUCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String BARCODE_BYPASS = "BARCODE_BYPASS";
    public static final String INVALID_CODE = "INVALID_CODE";
    public static final String DOCUMENT_ALREADY_READ = "DOCUMENT_ALREADY_READ";
    public static final String CONTINUE_READING = "CONTINUE_READING";
    public static final String ERROR_AC = "ERROR_AC";
    public static final int INICIO_PRIMEIROS_DIGITOS_DOC_CONVENIO = 810;
    private final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String execute(Process dados) throws ExcecaoNaoLocal {
        int tipoConta;
        String numeroDocumentoComDigitos;
        String numeroDocumento;
        ConfCTFClient confCTFClient;
        EntradaCTFClientCtrl entradaIntegracao;
        EntradaApiTefC entradaApiTefC;
        block53: {
            String numeroDocumentoUltimoDigitado;
            if (Contexto.getContexto().isSubProcessConsulta()) {
                return UNECESSARY;
            }
            InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
            ControladorPerifericos perifericos = dados.getPerifericos();
            entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
            entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
            confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
            if (entradaApiTefC.getCodigoBarras() == null && entradaApiTefC.getLinhaDigitavel() == null) {
                this.logger.error("C\u00f3digo para pagamento n\u00e3o informado!");
                throw new IllegalArgumentException("C\u00f3digo para pagamento n\u00e3o informado!");
            }
            numeroDocumento = numeroDocumentoUltimoDigitado = entradaApiTefC.getCodigoBarras() != null ? entradaApiTefC.getCodigoBarras() : entradaApiTefC.getLinhaDigitavel();
            numeroDocumentoComDigitos = null;
            this.logger.debug("numeroDocumentoUltimoDigitado: " + numeroDocumentoUltimoDigitado);
            int numeroBloco = Contexto.getContexto().getNumeroBloco();
            this.logger.debug("numeroBloco: " + numeroBloco);
            if (numeroBloco > 1) {
                numeroDocumento = entradaApiTefC.getCodigoBarrasParcial() + numeroDocumentoUltimoDigitado;
                this.logger.debug("CodigoBarrasParcial + numeroDocumentoUltimoDigitado: " + numeroDocumento);
            }
            if (entradaApiTefC.getCodigoBarras() != null && !entradaApiTefC.getFormatoCodigoBarrasEnum().isValidacaoCodHabilitada()) {
                this.logger.debug("Barcode Bypass: Nao valida o codigo de barras quando iniciado com: " + entradaApiTefC.getFormatoCodigoBarrasEnum().getId());
                if (numeroDocumentoUltimoDigitado.length() > 48) {
                    this.logger.trace("numeroDocumento.length()>48");
                    return this.limpaCodBarrasRetornaSaidaMic(entradaApiTefC, entradaIntegracao, perifericos);
                }
                this.logger.debug("ModoEntradaCodigoBarras: " + entradaApiTefC.getFormatoCodigoBarrasEnum().getId());
                numeroDocumento = StringUtil.completaString(entradaApiTefC.getCodigoBarras(), 48, '0', 3);
                this.logger.debug("numeroDocumento bypass: " + numeroDocumento);
                entradaApiTefC.setCodigoBarras(numeroDocumento);
                return BARCODE_BYPASS;
            }
            if (numeroBloco == 1) {
                tipoConta = this.obtemTipoConta(numeroDocumento);
                if (tipoConta == 0) {
                    return this.limpaCodBarrasRetornaSaidaMic(entradaApiTefC, entradaIntegracao, perifericos);
                }
                if (entradaIntegracao != null) {
                    this.logger.debug("Operacao: {}", entradaIntegracao.getOperacao());
                    if (!this.isOperacaoValidaParaDocumento(entradaIntegracao.getOperacao(), tipoConta)) {
                        Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.OPERACAO_NAO_PERMITIDA, inter.getMessage(MessageEnum.VALCODBAR_OPERACAO_NAO_PERMITIDA)));
                        return ERROR_AC;
                    }
                }
                Contexto.getContexto().setTipoConta(tipoConta);
            }
            tipoConta = Contexto.getContexto().getTipoConta();
            this.logger.debug("Tipo Conta: " + tipoConta);
            this.logger.debug("ModoEntradaCodigoBarras: " + entradaApiTefC.getFormatoCodigoBarrasEnum().getId());
            if (tipoConta == 1 && entradaApiTefC.getFormatoCodigoBarrasEnum().equals((Object)FormatoCodigoBarrasEnum.CNAB_DIGITADO) && numeroBloco == 5 && numeroDocumentoUltimoDigitado.length() <= 10) {
                numeroDocumento = entradaApiTefC.getCodigoBarrasParcial() + StringUtil.completaString(numeroDocumentoUltimoDigitado, 14, '0', 3);
                this.logger.debug("codigo completo com zeros a esquerda: numeroDocumento: " + numeroDocumento);
            }
            if (numeroDocumento.length() < 44) {
                this.logger.trace("numeroDocumento.length()<44");
                if (tipoConta == 2 && numeroBloco == 4) {
                    this.logger.trace("CONVENIO:QUANTIDADE_BLOCOS_CONVENIO");
                    if (numeroDocumento.length() != 12) {
                        this.logger.trace("numeroDocumento.length()!=12");
                        return this.limpaCodBarrasRetornaSaidaMic(entradaApiTefC, entradaIntegracao, perifericos);
                    }
                    this.logger.trace("numeroDocumento.length()==12");
                    try {
                        CodigoFebraban.validaDigitoGrupo(numeroDocumento);
                    }
                    catch (ExcecaoDigitoInvalido e) {
                        return this.limpaCodBarrasRetornaSaidaMic(entradaApiTefC, entradaIntegracao, perifericos);
                    }
                }
                if (tipoConta == 1 && numeroBloco == 5) {
                    this.logger.trace("TITULO:QUANTIDADE_BLOCOS_TITULO");
                    if (numeroDocumento.length() != 10) {
                        this.logger.trace("numeroDocumento.length()!=10");
                        return this.limpaCodBarrasRetornaSaidaMic(entradaApiTefC, entradaIntegracao, perifericos);
                    }
                    this.logger.trace("numeroDocumento.length()==10");
                    try {
                        CodigoFebraban.validaDigitoGrupo("00" + numeroDocumento);
                    }
                    catch (ExcecaoDigitoInvalido e) {
                        return this.limpaCodBarrasRetornaSaidaMic(entradaApiTefC, entradaIntegracao, perifericos);
                    }
                }
            }
            boolean isCapturouCodigoCompleto = false;
            try {
                int i;
                if (entradaApiTefC.getFormatoCodigoBarrasEnum().equals((Object)FormatoCodigoBarrasEnum.CNAB_DIGITADO) && tipoConta == 2) {
                    this.logger.trace("CAPTURA_TECLADO:CONVENIO");
                    if (numeroBloco == 1 && numeroDocumento.length() == 48) {
                        this.logger.debug("numeroBloco == 1 && numeroDocumento.ength() == 48 ");
                        for (i = 1; i < 5; ++i) {
                            CodigoBarrasUtil.validaBlocoParcialConvenio(numeroDocumento, i);
                        }
                        numeroBloco = 4;
                    } else {
                        if (numeroBloco == 1 && numeroDocumento.length() != 12) {
                            this.logger.debug("numeroBloco == 1 && numeroDocumento.length() != 12");
                            Contexto.getContexto().setTipoConta(0);
                            return this.limpaCodBarrasRetornaSaidaMic(entradaApiTefC, entradaIntegracao, perifericos);
                        }
                        this.logger.trace("validaBlocoParcialConvenio");
                        CodigoBarrasUtil.validaBlocoParcialConvenio(numeroDocumento, numeroBloco);
                    }
                    if (entradaApiTefC.getCodigoBarrasParcial() == null) {
                        this.logger.trace("entradaApiTefC.getCodigoBarrasParcial() == null");
                        entradaApiTefC.setCodigoBarrasParcial("");
                    }
                    this.logger.debug("CodigoBarrasParcial: " + entradaApiTefC.getCodigoBarrasParcial() + numeroDocumentoUltimoDigitado);
                    entradaApiTefC.setCodigoBarrasParcial(entradaApiTefC.getCodigoBarrasParcial() + numeroDocumentoUltimoDigitado);
                    this.logger.debug("numeroBloco: " + ++numeroBloco);
                    Contexto.getContexto().setNumeroBloco(numeroBloco);
                    if (Contexto.getContexto().getNumeroBloco() <= 4) {
                        return CONTINUE_READING;
                    }
                    isCapturouCodigoCompleto = true;
                    numeroDocumentoComDigitos = numeroDocumento;
                    numeroDocumento = AbstractCodigoPagamento.retiraDigitos(numeroDocumento);
                }
                if (tipoConta == 2) {
                    CodigoFebraban.validaDigitoGeral(numeroDocumento);
                    break block53;
                }
                if (entradaApiTefC.getFormatoCodigoBarrasEnum().equals((Object)FormatoCodigoBarrasEnum.CNAB_LIDO)) {
                    this.logger.trace("CAPTURA_SCANNER : CAPTURA_SCANNER_OU_LEITOR_DOCUMENTOS");
                    this.logger.trace("CalculadorDigito.validaDigitoModulo11");
                    CalculadorDigito.validaDigitoModulo11(numeroDocumento, 5, 1);
                    break block53;
                }
                if (entradaApiTefC.getFormatoCodigoBarrasEnum().equals((Object)FormatoCodigoBarrasEnum.CNAB_DIGITADO)) {
                    this.logger.trace("CAPTURA_TECLADO");
                    if (numeroBloco == 1 && numeroDocumento.length() >= 33) {
                        this.logger.trace("numeroBloco == 1 && numeroDocumento.length() >= 33");
                        numeroDocumento = CodigoBarrasUtil.formataLinhaDigitavelTitulo(numeroDocumento);
                        for (i = 1; i < 6; ++i) {
                            CodigoBarrasUtil.validaBlocoParcialTituloDigitavel(numeroDocumento, i);
                        }
                        numeroBloco = 5;
                    } else {
                        this.logger.trace("Captura Bloco: " + numeroBloco);
                        if (numeroBloco == 1 && numeroDocumento.length() != 10) {
                            Contexto.getContexto().setTipoConta(0);
                            return this.limpaCodBarrasRetornaSaidaMic(entradaApiTefC, entradaIntegracao, perifericos);
                        }
                        CodigoBarrasUtil.validaBlocoParcialTituloDigitavel(numeroDocumento, numeroBloco);
                    }
                    if (entradaApiTefC.getCodigoBarrasParcial() == null) {
                        entradaApiTefC.setCodigoBarrasParcial("");
                    }
                    entradaApiTefC.setCodigoBarrasParcial(entradaApiTefC.getCodigoBarrasParcial() + numeroDocumentoUltimoDigitado);
                    Contexto.getContexto().setNumeroBloco(++numeroBloco);
                    if (numeroBloco <= 5) {
                        return CONTINUE_READING;
                    }
                }
            }
            catch (ExcecaoDigitoInvalido e) {
                this.logger.debug((Object)"ExcecaoDigitoInvalido: ", e);
                if (numeroBloco <= 4) return this.limpaCodBarrasRetornaSaidaMic(entradaApiTefC, entradaIntegracao, perifericos);
                if (!isCapturouCodigoCompleto) return this.limpaCodBarrasRetornaSaidaMic(entradaApiTefC, entradaIntegracao, perifericos);
                Contexto.getContexto().setNumeroBloco(1);
                entradaApiTefC.setCodigoBarrasParcial(null);
                return this.limpaCodBarrasRetornaSaidaMic(entradaApiTefC, entradaIntegracao, perifericos);
            }
            catch (ExcecaoCodigoInvalido e) {
                this.logger.debug((Object)"ExcecaoCodigoInvalido: ", e);
                if (tipoConta == 1 && numeroBloco == 5) {
                    Contexto.getContexto().setNumeroBloco(1);
                    entradaApiTefC.setCodigoBarras(null);
                    entradaApiTefC.setCodigoBarrasParcial(null);
                    Contexto.getContexto().setTipoConta(0);
                    return this.limpaCodBarrasRetornaSaidaMic(entradaApiTefC, entradaIntegracao, perifericos);
                }
                if (numeroBloco != 1) return this.limpaCodBarrasRetornaSaidaMic(entradaApiTefC, entradaIntegracao, perifericos);
                Contexto.getContexto().setTipoConta(0);
                return this.limpaCodBarrasRetornaSaidaMic(entradaApiTefC, entradaIntegracao, perifericos);
            }
        }
        AbstractCodigoPagamento codigoPagamento = null;
        if (tipoConta == 1) {
            codigoPagamento = entradaApiTefC.getFormatoCodigoBarrasEnum().equals((Object)FormatoCodigoBarrasEnum.CNAB_LIDO) ? new CodigoBarrasTitulo(numeroDocumento) : new LinhaDigitavelTitulo(numeroDocumento);
        } else if (tipoConta == 2) {
            codigoPagamento = new CodigoBarrasConvenio(numeroDocumento);
        }
        this.logger.debug("codigoPagamento: {}", codigoPagamento);
        if (codigoPagamento != null && codigoPagamento.getValor() != null && !codigoPagamento.getValor().equals(new BigDecimal("0.00"))) {
            entradaApiTefC.setValorDocumento(codigoPagamento.getValor());
            Contexto.getContexto().setConfirmaValorDocumento(true);
            Contexto.getContexto().setValorDocumentoCapturado(true);
        } else {
            Contexto.getContexto().setValorDocumentoCapturado(false);
        }
        if (tipoConta == 1) {
            ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
            boolean multiTerminal = entradaIntegracao != null && entradaIntegracao.isMultiTerminal();
            boolean multiEC = config.isMultiEC();
            IdentTerminal identTerminal = entradaIntegracao != null && (multiTerminal || multiEC) ? Contexto.getContexto().getEntradaIntegracao().getIdentTerminal() : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
            ControladorInicioDia controladorInicioDia = ControladorInicioDia.getInstance();
            DadosInicioDia dadosInicioDia = controladorInicioDia.getDadosInicioDia(identTerminal);
            this.logger.debug("IgnorarAusenciaDadosCodigoBarras: {}", dadosInicioDia.isIgnorarAusenciaDadosCodigoBarras());
            if (dadosInicioDia.isIgnorarAusenciaDadosCodigoBarras()) {
                if (entradaApiTefC.getDataVencimentoCorBan() == null && ((CodigoPagamentoTitulo)codigoPagamento).getDataVencimento() == null) {
                    entradaApiTefC.setDataVencimentoCorBan(new Date());
                    Contexto.getContexto().setVencimentoCorBanCapturado(true);
                    Contexto.getContexto().setConfirmaVencimentoCorBan(false);
                }
                this.logger.debug("isValorDocumentoCapturado: {}", Contexto.getContexto().isValorDocumentoCapturado());
                if (!Contexto.getContexto().isValorDocumentoCapturado()) {
                    entradaApiTefC.setValorDocumento(new BigDecimal("0.00"));
                    Contexto.getContexto().setConfirmaValorDocumento(false);
                    Contexto.getContexto().setValorDocumentoCapturado(true);
                }
            }
            this.logger.debug("DataVencimentoCorBan: {}", entradaApiTefC.getDataVencimentoCorBan());
            if (entradaApiTefC.getDataVencimentoCorBan() == null) {
                entradaApiTefC.setDataVencimentoCorBan(((CodigoPagamentoTitulo)codigoPagamento).getDataVencimento());
                Contexto.getContexto().setVencimentoCorBanCapturado(entradaApiTefC.getDataVencimentoCorBan() != null);
                Contexto.getContexto().setConfirmaVencimentoCorBan(true);
            }
        } else if (tipoConta == 2) {
            entradaApiTefC.setDataVencimentoCorBan(new Date());
            Contexto.getContexto().setVencimentoCorBanCapturado(true);
            Contexto.getContexto().setConfirmaVencimentoCorBan(false);
        }
        if (entradaApiTefC.getFormatoCodigoBarrasEnum().equals((Object)FormatoCodigoBarrasEnum.CNAB_DIGITADO) && tipoConta == 2) {
            numeroDocumento = numeroDocumentoComDigitos;
            this.logger.debug("numeroDocumentoComDigitos: {}", numeroDocumento);
        }
        this.logger.debug("CapturaApenasLinhaDigitavel: {}", confCTFClient.isCapturaApenasLinhaDigitavel());
        if (!confCTFClient.isCapturaApenasLinhaDigitavel()) {
            entradaApiTefC.setCodigoBarras(numeroDocumento);
            return SUCESS;
        }
        if (!entradaApiTefC.getFormatoCodigoBarrasEnum().equals((Object)FormatoCodigoBarrasEnum.CNAB_DIGITADO)) return SUCESS;
        String novoCodigo = tipoConta == 1 ? CodigoBarrasUtil.converteLinhaDigitavelTitulo(numeroDocumento) : CodigoBarrasUtil.converteLinhaDigitavelConvenio(numeroDocumento);
        entradaApiTefC.setCodigoBarras(novoCodigo);
        entradaApiTefC.setFormatoCodigoBarrasEnum(FormatoCodigoBarrasEnum.CNAB_LIDO);
        this.logger.debug("CodigoBarras: {}", novoCodigo);
        this.logger.debug("ModoEntradaCodigoBarras: {}", FormatoCodigoBarrasEnum.CNAB_LIDO.getId());
        return SUCESS;
    }

    private int obtemTipoConta(String numeroDocumento) {
        if (numeroDocumento.length() < 3) {
            return 0;
        }
        try {
            int primeirosDigitos = Integer.parseInt(numeroDocumento.substring(0, 3));
            int tipoConta = primeirosDigitos >= 810 ? 2 : 1;
            this.logger.debug("primeirosDigitos: {}", primeirosDigitos);
            return tipoConta;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private boolean isOperacaoValidaParaDocumento(int keyOperacao, int tipoConta) {
        if (tipoConta == 2) {
            return keyOperacao == OperationEnum.OP_PAGUE_CONTAS_CONCECIONARIA.getKey() || keyOperacao == OperationEnum.OP_CONSULTA_CONVENIO.getKey() || keyOperacao == OperationEnum.OP_PGTO_CONVENIO.getKey() || keyOperacao == OperationEnum.OP_PGTO_CONVENIO_COM_CONSULTA.getKey();
        }
        if (tipoConta == 1) {
            return keyOperacao == OperationEnum.OP_PAGUE_CONTAS_FICHA_COMPENSACAO.getKey() || keyOperacao == OperationEnum.OP_CONSULTA_FICHA_COMPENSACAO.getKey() || keyOperacao == OperationEnum.OP_PGTO_FICHA_COMPENSACAO.getKey() || keyOperacao == OperationEnum.OP_PGTO_FICHA_COMPENSACAO_COM_CONSULTA.getKey() || keyOperacao == OperationEnum.OP_CONSULTA_FATURA_CARTAO.getKey() || keyOperacao == OperationEnum.OP_PAGAMENTO_FATURA_CARTAO.getKey() || keyOperacao == OperationEnum.OP_CONSULTA_FATURA_CARTAO_DETALHADA.getKey();
        }
        return false;
    }

    private void exibeMensagemErro(ControladorPerifericos perifericos, String mensagem) throws ExcecaoNaoLocal {
        this.logger.debug("exibeMensagemErro: " + mensagem);
        LayoutDisplay displayModel = new LayoutDisplay(mensagem);
        perifericos.confirmaDado(displayModel);
    }

    private String limpaCodBarrasRetornaSaidaMic(EntradaApiTefC entradaApiTefC, EntradaCTFClientCtrl entradaIntegracao, ControladorPerifericos perifericos) throws ExcecaoNaoLocal {
        this.logger.trace("limpaCodBarrasRetornaSaidaMic");
        this.exibeMensagemErro(perifericos, InternacionalizacaoUtil.getInstance().getMessage(MessageEnum.VALCODBAR_ERRO_COD_INVALIDO));
        entradaApiTefC.setCodigoBarras(null);
        if (Objects.nonNull(entradaIntegracao) && StringUtils.isEmpty(entradaIntegracao.getCodigoBarras())) {
            this.logger.debug("limpaCodBarrasRetornaSaidaMic:CodigoBarras: " + entradaIntegracao.getCodigoBarras());
            return INVALID_CODE;
        }
        return ERROR_AC;
    }
}

