/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessPixPayment;
import com.csi.ctfclient.operacoes.action.ProcessQrCodeGenerico;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import java.util.ArrayList;

public class MicTefIPOperacaoQrCode {
    public String execute(Process dados) throws Exception {
        ControladorPerifericos perifericos = dados.getPerifericos();
        String OP_QR_CODE_PAYMENT = "PAGAMENTO QR CODE";
        String OP_MENU_PIX_PAYMENT = "PAGAMENTO PIX";
        ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        IdentTerminal identTerminal = new IdentTerminal(confCTFClient.getEstabelecimento(), confCTFClient.getLoja(), confCTFClient.getTerminal());
        DadosInicioDia dadosInicioDia = ControladorInicioDia.getInstance().getDadosInicioDia(identTerminal);
        boolean enableQrCode = false;
        if (dadosInicioDia != null) {
            enableQrCode = dadosInicioDia.isQrCode();
        }
        ArrayList<String> options = new ArrayList<String>();
        if (enableQrCode) {
            options.add("PAGAMENTO QR CODE");
        }
        options.add("PAGAMENTO PIX");
        int opcao = perifericos.showSingleChoiceMenu(dados, "MEIO DE PAGAMENTO", options);
        if (opcao == -1) {
            return "USER_CANCEL";
        }
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        ProcessManager processManager = ProcessManager.getInstance();
        int state = -1;
        String itemMenu = (String)options.get(opcao);
        if (itemMenu.equals("PAGAMENTO QR CODE")) {
            int currentOp = Contexto.getContexto().getEntradaIntegracao().getOperacao();
            Contexto.getContexto().getEntradaIntegracao().setOperacao(OperationEnum.OP_QR_CODE_GENERICO.getKey());
            ProcessQrCodeGenerico reroute = new ProcessQrCodeGenerico(dados.getProcessConstructorArguments(), entradaIntegracao);
            reroute.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), reroute);
            dados.setErro(reroute.getErro());
            Contexto.getContexto().getEntradaIntegracao().setOperacao(currentOp);
            state = reroute.getState();
        } else if (itemMenu.equals("PAGAMENTO PIX")) {
            int currentOp = Contexto.getContexto().getEntradaIntegracao().getOperacao();
            Contexto.getContexto().getEntradaIntegracao().setOperacao(OperationEnum.OP_PIX_PAYMENT.getKey());
            ProcessPixPayment reroute = new ProcessPixPayment(dados.getProcessConstructorArguments());
            reroute.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), reroute);
            dados.setErro(reroute.getErro());
            Contexto.getContexto().getEntradaIntegracao().setOperacao(currentOp);
            state = reroute.getState();
        }
        if (state == 1) {
            return "ERROR";
        }
        if (state == 0) {
            return "SUCCESS";
        }
        if (state == 3) {
            return "USER_CANCEL_INTERNAL";
        }
        if (state == 6) {
            return "ERROR_AC";
        }
        return "SUCCESS";
    }
}

