/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessCancelamento;
import com.csi.ctfclient.operacoes.action.ProcessConfirmacaoPreAutorizacao;
import com.csi.ctfclient.operacoes.action.ProcessConsultaCDC;
import com.csi.ctfclient.operacoes.action.ProcessConsultaSaldo;
import com.csi.ctfclient.operacoes.action.ProcessCreditoDigital;
import com.csi.ctfclient.operacoes.action.ProcessFidelidadeMilhas;
import com.csi.ctfclient.operacoes.action.ProcessPagamentoDinheiroBrPremmia;
import com.csi.ctfclient.operacoes.action.ProcessPing;
import com.csi.ctfclient.operacoes.action.ProcessPixQuery;
import com.csi.ctfclient.operacoes.action.ProcessReimpressaoComprovante;
import com.csi.ctfclient.operacoes.action.ProcessResgateBrPremmia;
import com.csi.ctfclient.operacoes.action.ProcessResgateFacil;
import com.csi.ctfclient.operacoes.action.ProcessResgatePremio;
import com.csi.ctfclient.operacoes.action.ProcessTransacoesGenericas;
import com.csi.ctfclient.operacoes.action.ProcessValeGas;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.fusion.ControladorFusion;
import com.csi.ctfclient.tools.util.StringUtil;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Objects;

public class MicTefIPOperacaoADM
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    public static final String ERROR_AC = "ERROR_AC";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        Process process;
        int opcao;
        ControladorPerifericos perifericos = dados.getPerifericos();
        ConfCTFClient confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        IdentTerminal identTerminal = new IdentTerminal(confCTFClient.getEstabelecimento(), confCTFClient.getLoja(), confCTFClient.getTerminal());
        DadosInicioDia dadosInicioDia = ControladorInicioDia.getInstance().getDadosInicioDia(identTerminal);
        boolean isResgateFacil = false;
        boolean isResgateFidelidadeMilhas = false;
        if (dadosInicioDia != null) {
            isResgateFacil = dadosInicioDia.isResgateFacil();
            isResgateFidelidadeMilhas = dadosInicioDia.isResgateFidelidadeMilhas();
        }
        String OP_OPERACOES_ADMINISTRATIVAS = "OPERACOES ADMINISTRATIVAS";
        String OP_CANCELAMENTO = "CANCELAMENTO";
        String OP_CONSULTA_CDC = "CONSULTA CDC";
        String OP_VOUCHER = "VOUCHER";
        String OP_CAPTURA_AUTORIZACAO = "CAPTURA-AUTORIZACAO";
        String OP_RECARGA_CELULAR = "RECARGA CELULAR";
        String OP_REIMPRESSAO = "REIMPRESSAO";
        String OP_CONSULTA_SALDO = "CONSULTA SALDO";
        String OP_RESGATE_DE_PREMIO = "RESGATE DE PREMIO";
        String OP_COMUNICACAO_FUSION = "COMUNICACAO FUSION";
        String OP_VALE_GAS = "VALE GAS";
        String OP_MENU_EXTRATO_RESGATE_FACIL = "EXTRATO RESGATE FACIL";
        String OP_CONSULTA_FIDELIDADE_MILHAS = "CONSUL. FIDELIDADE MILHAS";
        String OP_CASH_PREMMIA = "PAG DINHEIRO PREMMIA";
        String OP_RESGATE_BR_PREMMIA = "RESGATE BR PREMIA";
        String OP_CONSULTA_PIX = "CONSULTA PIX";
        LayoutMenu layoutMenu = new LayoutMenu(OP_OPERACOES_ADMINISTRATIVAS, true);
        layoutMenu.addItem(new ItemMenu(OP_CANCELAMENTO, "1"));
        layoutMenu.addItem(new ItemMenu(OP_CONSULTA_CDC, "2"));
        layoutMenu.addItem(new ItemMenu(OP_VOUCHER, "3"));
        layoutMenu.addItem(new ItemMenu(OP_CAPTURA_AUTORIZACAO, "4"));
        layoutMenu.addItem(new ItemMenu(OP_RECARGA_CELULAR, "5"));
        layoutMenu.addItem(new ItemMenu(OP_REIMPRESSAO, "6"));
        layoutMenu.addItem(new ItemMenu(OP_CONSULTA_SALDO, "7"));
        layoutMenu.addItem(new ItemMenu(OP_RESGATE_DE_PREMIO, "8"));
        layoutMenu.addItem(new ItemMenu(OP_COMUNICACAO_FUSION, "9"));
        layoutMenu.addItem(new ItemMenu(OP_VALE_GAS, "10"));
        layoutMenu.addItem(new ItemMenu("PAG DINHEIRO PREMMIA", "11"));
        layoutMenu.addItem(new ItemMenu("RESGATE BR PREMIA", "12"));
        layoutMenu.addItem(new ItemMenu("CONSULTA PIX", "13"));
        String proximaTecla = "14";
        if (isResgateFacil) {
            layoutMenu.addItem(new ItemMenu(OP_MENU_EXTRATO_RESGATE_FACIL, proximaTecla));
            proximaTecla = "15";
        }
        if (isResgateFidelidadeMilhas) {
            layoutMenu.addItem(new ItemMenu(OP_CONSULTA_FIDELIDADE_MILHAS, proximaTecla));
        }
        if ((opcao = perifericos.imprimeMenu(layoutMenu)) == -1) {
            return USER_CANCEL;
        }
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        ProcessManager processManager = ProcessManager.getInstance();
        int operacaoAtual = entradaIntegracao.getOperacao();
        ItemMenu itemMenu = layoutMenu.getItens().get(opcao - 1);
        int state = 0;
        if (itemMenu.getTexto().equalsIgnoreCase(OP_CANCELAMENTO)) {
            Contexto.getContexto().getEntradaIntegracao().setOperacao(OperationEnum.OP_CANCELAMENTO_GENERICO.getKey());
            ProcessCancelamento processCancelamento = new ProcessCancelamento(dados.getProcessConstructorArguments(), entradaIntegracao.getNumeroTransacao());
            processCancelamento.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), processCancelamento);
            dados.setErro(processCancelamento.getErro());
            state = processCancelamento.getState();
        } else if (itemMenu.getTexto().equals(OP_CONSULTA_CDC)) {
            entradaIntegracao.setNumeroTransacao(0);
            Contexto.getContexto().getEntradaIntegracao().setOperacao(OperationEnum.OP_CONSULTA_CDC_GENERICO.getKey());
            ProcessConsultaCDC processConsultaCDC = new ProcessConsultaCDC(dados.getProcessConstructorArguments(), entradaIntegracao);
            processConsultaCDC.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), processConsultaCDC);
            dados.setErro(processConsultaCDC.getErro());
            state = processConsultaCDC.getState();
        } else if (itemMenu.getTexto().equals(OP_VOUCHER)) {
            Contexto.getContexto().getEntradaIntegracao().setOperacao(OperationEnum.OP_DEB_VOUCHER.getKey());
            ProcessTransacoesGenericas processGenerico = new ProcessTransacoesGenericas(dados.getProcessConstructorArguments(), entradaIntegracao.getNumeroTransacao(), entradaIntegracao, OperationEnum.OP_DEB_VOUCHER.getDescription());
            processGenerico.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), processGenerico);
            dados.setErro(processGenerico.getErro());
            state = processGenerico.getState();
        } else if (itemMenu.getTexto().equals(OP_CAPTURA_AUTORIZACAO)) {
            Contexto.getContexto().getEntradaIntegracao().setOperacao(OperationEnum.OP_CONFIRMACAO_PRE_AUT_GENERICO.getKey());
            ProcessConfirmacaoPreAutorizacao processConfirmacaoPreAutorizacao = new ProcessConfirmacaoPreAutorizacao(dados.getProcessConstructorArguments(), entradaIntegracao.getNumeroTransacao());
            processConfirmacaoPreAutorizacao.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), processConfirmacaoPreAutorizacao);
            dados.setErro(processConfirmacaoPreAutorizacao.getErro());
            state = processConfirmacaoPreAutorizacao.getState();
        } else if (itemMenu.getTexto().equals(OP_RECARGA_CELULAR)) {
            Contexto.getContexto().getEntradaIntegracao().setOperacao(OperationEnum.OP_COMPRA_CREDITO_DIGITAL.getKey());
            ProcessCreditoDigital processCreditoDigital = new ProcessCreditoDigital(dados.getProcessConstructorArguments(), entradaIntegracao, entradaIntegracao.getNumeroTransacao(), OperationEnum.OP_COMPRA_CREDITO_DIGITAL.getDescription());
            processCreditoDigital.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), processCreditoDigital);
            dados.setErro(processCreditoDigital.getErro());
            state = processCreditoDigital.getState();
        } else if (itemMenu.getTexto().equals(OP_REIMPRESSAO)) {
            LayoutMenu layoutMenuReimpressao = new LayoutMenu("OPERACOES DE REIMPRESSAO", true);
            layoutMenuReimpressao.addItem(new ItemMenu("ULTIMO COMPROVANTE", "1"));
            layoutMenuReimpressao.addItem(new ItemMenu("OUTROS COMPROVANTES", "2"));
            int opcaoReimpressao = perifericos.imprimeMenu(layoutMenuReimpressao);
            if (opcaoReimpressao == -1) {
                return USER_CANCEL;
            }
            if (opcaoReimpressao == 1) {
                String path = identTerminal.getEstabelecimento().substring(1) + identTerminal.getLoja() + "." + identTerminal.getTerminal() + "/";
                if (ControladorConfCTFClient.getDiretorioTrabalho() != null) {
                    path = ControladorConfCTFClient.getDiretorioTrabalho() + path;
                }
                boolean ultimoCupom = false;
                int numTrans = 1;
                while (!ultimoCupom) {
                    String cupom3Atual = path + "CUPOMCTF.3" + StringUtil.completaString(numTrans + "", 2, '0', 3);
                    File fileCupom3Atual = new File(cupom3Atual);
                    if (fileCupom3Atual.exists()) {
                        String cupom3Proximo = path + "CUPOMCTF.3" + StringUtil.completaString(numTrans + 1 + "", 2, '0', 3);
                        File fileCupom3Proximo = new File(cupom3Proximo);
                        if (fileCupom3Proximo.exists()) {
                            ++numTrans;
                            continue;
                        }
                        if (numTrans > 1) {
                            String cupom = path + "CUPOMCTF.3" + StringUtil.completaString("1", 2, '0', 3);
                            File fileCupom = new File(cupom);
                            this.copiaCupom(fileCupom3Atual, fileCupom);
                            String cupom4Atual = path + "CUPOMCTF.4" + StringUtil.completaString(numTrans + "", 2, '0', 3);
                            File fileCupom4Atual = new File(cupom4Atual);
                            String cupom4 = path + "CUPOMCTF.4" + StringUtil.completaString("1", 2, '0', 3);
                            File fileCupom4 = new File(cupom4);
                            if (fileCupom4Atual.exists()) {
                                this.copiaCupom(fileCupom4Atual, fileCupom4);
                            }
                        }
                        SaidaApiTefC saidaApiTefC = new SaidaApiTefC();
                        saidaApiTefC.setRetorno(0);
                        Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
                        EntradaApiTefC entradaApiTefC = new EntradaApiTefC();
                        entradaApiTefC.setOperacao("F7");
                        Contexto.getContexto().atualizaEntradaApiTefC(entradaApiTefC);
                        state = 0;
                    } else {
                        state = this.executaReimpressaoOutrosComprovantes(dados, entradaIntegracao);
                    }
                    ultimoCupom = true;
                }
            } else {
                state = this.executaReimpressaoOutrosComprovantes(dados, entradaIntegracao);
            }
        } else if (itemMenu.getTexto().equals(OP_CONSULTA_SALDO)) {
            entradaIntegracao.setNumeroTransacao(0);
            Contexto.getContexto().getEntradaIntegracao().setOperacao(OperationEnum.OP_CONSULTA_SAQUE_CREDITO.getKey());
            ProcessConsultaSaldo processConsultaSaldo = new ProcessConsultaSaldo(dados.getProcessConstructorArguments(), entradaIntegracao, OperationEnum.OP_CONSULTA_SAQUE_CREDITO.getDescription());
            processConsultaSaldo.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), processConsultaSaldo);
            dados.setErro(processConsultaSaldo.getErro());
            state = processConsultaSaldo.getState();
        } else if (itemMenu.getTexto().equals(OP_RESGATE_DE_PREMIO)) {
            Contexto.getContexto().getEntradaIntegracao().setOperacao(OperationEnum.OP_RESGATE_PREMIO.getKey());
            ProcessResgatePremio processResgate = new ProcessResgatePremio(dados.getProcessConstructorArguments(), entradaIntegracao, 1);
            processResgate.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), processResgate);
            dados.setErro(processResgate.getErro());
            state = processResgate.getState();
        } else if (itemMenu.getTexto().equals(OP_COMUNICACAO_FUSION)) {
            ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
            if (conf.getIpFusion() != null && conf.getPortaFusion() != 0) {
                LayoutDisplay displayModel = new LayoutDisplay();
                displayModel.addLinha(new Linha("VERIFICANDO STATUS CTF..."));
                perifericos.imprimeDisplay(displayModel);
                boolean ctfOk = this.testaComunicacaoCTF(dados);
                displayModel.addLinha(new Linha("VERIFICANDO STATUS CONEXAO"));
                displayModel.addLinha(new Linha("CONCENTRADOR DE BOMBAS..."));
                perifericos.imprimeDisplay(displayModel);
                ControladorFusion.setParametrosInicializacao(conf.getIpFusion(), conf.getPortaFusion());
                ControladorFusion fusion = ControladorFusion.getInstancia();
                boolean fusionOk = fusion.eco();
                this.logger.info("Comunica\u00e7\u00e3o com o Fusion: " + fusionOk);
                displayModel = new LayoutDisplay();
                displayModel.addLinha(new Linha("COMUNICACAO COM O CTF:      " + (ctfOk ? "SIM" : "NAO")));
                displayModel.addLinha(new Linha("COMUNICACAO COM O FUSION:   " + (fusionOk ? "SIM" : "NAO")));
                displayModel.addLinha(new Linha("UTILIZANDO CONTINGENCIA:    " + (ControladorFusion.isModoContingencia() ? "SIM" : "NAO")));
                displayModel.addLinha(new Linha(""));
                displayModel.addLinha(new Linha(""));
                displayModel.addLinha(new Linha("SELECIONE A CONFIGURACAO DESEJADA"));
                displayModel.addLinha(new Linha(""));
                displayModel.addLinha(new Linha("[1] - UTILIZAR FUSION " + (!ControladorFusion.isModoContingencia() ? "(ATUAL)" : "")));
                displayModel.addLinha(new Linha("[2] - UTILIZAR CONTINGENCIA " + (ControladorFusion.isModoContingencia() ? "(ATUAL)" : "")));
                EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, true, ConstantesApiAc.CAP_QUESTIONAMENTO_CONTINGENCIA_FUSION);
                if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                    this.logger.info("Tecla volta pressionada");
                } else {
                    String value = eventoTeclado.getStringLida();
                    if (value.equals("1")) {
                        ControladorFusion.setModoContingencia(false);
                        displayModel = new LayoutDisplay();
                        displayModel.addLinha(new Linha("APLICATIVO UTILIZARA"));
                        displayModel.addLinha(new Linha("INTEGRACAO FUSION"));
                        displayModel.setDelay(1500L);
                        perifericos.imprimeDisplay(displayModel);
                    } else {
                        if (!value.equals("2")) throw new IllegalArgumentException("op\u00e7\u00e3o inv\u00e1lida");
                        ControladorFusion.setModoContingencia(true);
                        displayModel = new LayoutDisplay();
                        displayModel.addLinha(new Linha("APLICATIVO ENTROU EM"));
                        displayModel.addLinha(new Linha("MODO DE CONTINGENCIA"));
                        displayModel.setDelay(1500L);
                        perifericos.imprimeDisplay(displayModel);
                    }
                }
            } else {
                this.logger.info("Fusion n\u00e3o configurado");
                LayoutDisplay displayModel = new LayoutDisplay();
                displayModel.addLinha(new Linha("FUSION NAO CONFIGURADO"));
                displayModel.setDelay(1500L);
                perifericos.imprimeDisplay(displayModel);
            }
            SaidaApiTefC saidaApiTefC = new SaidaApiTefC();
            saidaApiTefC.setRetorno(0);
            Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
            EntradaApiTefC entradaApiTefC = new EntradaApiTefC();
            entradaApiTefC.setOperacao("6N");
            Contexto.getContexto().atualizaEntradaApiTefC(entradaApiTefC);
            state = 0;
        } else if (itemMenu.getTexto().equals(OP_VALE_GAS)) {
            ProcessValeGas processValeGas = new ProcessValeGas(dados.getProcessConstructorArguments(), entradaIntegracao, 1, entradaIntegracao.getNumeroCupom());
            processValeGas.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), processValeGas);
            dados.setErro(processValeGas.getErro());
            state = processValeGas.getState();
        }
        if (itemMenu.getTexto().equals(OP_MENU_EXTRATO_RESGATE_FACIL)) {
            Contexto.getContexto().setTipoOperacao(OperationEnum.OP_RESGATE_FACIL_EXTRATO.getDescription());
            ProcessResgateFacil processResgateFacil = new ProcessResgateFacil(dados.getProcessConstructorArguments(), entradaIntegracao.getNumeroTransacao());
            processResgateFacil.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), processResgateFacil);
            dados.setErro(processResgateFacil.getErro());
            state = processResgateFacil.getState();
        } else if (itemMenu.getTexto().equals(OP_CONSULTA_FIDELIDADE_MILHAS)) {
            ProcessFidelidadeMilhas processFidelidadeMilhas = new ProcessFidelidadeMilhas(dados.getProcessConstructorArguments(), entradaIntegracao, OperationEnum.OP_CONSULTA_FIDELIDADE_MILHAS.getDescription());
            processFidelidadeMilhas.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), processFidelidadeMilhas);
            dados.setErro(processFidelidadeMilhas.getErro());
            state = processFidelidadeMilhas.getState();
        } else if (itemMenu.getTexto().equals("PAG DINHEIRO PREMMIA")) {
            Contexto.getContexto().getEntradaIntegracao().setOperacao(OperationEnum.OP_PAGAMENTO_DINHEIRO_BR_PREMMIA.getKey());
            process = new ProcessPagamentoDinheiroBrPremmia(dados.getProcessConstructorArguments());
            process.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), process);
            dados.setErro(process.getErro());
            state = process.getState();
        } else if (itemMenu.getTexto().equals("RESGATE BR PREMIA")) {
            Contexto.getContexto().getEntradaIntegracao().setOperacao(OperationEnum.OP_RESGATE_BR_PREMMIA.getKey());
            process = new ProcessResgateBrPremmia(dados.getProcessConstructorArguments());
            process.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), process);
            dados.setErro(process.getErro());
            state = process.getState();
        } else if (itemMenu.getTexto().equals("CONSULTA PIX")) {
            process = new ProcessPixQuery(dados.getProcessConstructorArguments());
            process.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), process);
            dados.setErro(process.getErro());
            state = process.getState();
        }
        Contexto.getContexto().getEntradaIntegracao().setOperacao(operacaoAtual);
        if (state == 1) {
            return ERROR;
        }
        if (state == 0) {
            return SUCCESS;
        }
        if (state == 3) {
            return USER_CANCEL_INTERNAL;
        }
        if (state != 6) return SUCCESS;
        return ERROR_AC;
    }

    private int executaReimpressaoOutrosComprovantes(Process dados, EntradaCTFClientCtrl entradaIntegracao) throws ExcecaoNaoLocal {
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessReimpressaoComprovante processReimpressao = new ProcessReimpressaoComprovante(dados.getProcessConstructorArguments(), entradaIntegracao);
        processReimpressao.setParent(dados);
        processManager.subProcess(dados.getIdProcess(), processReimpressao);
        dados.setErro(processReimpressao.getErro());
        if (Contexto.getContexto().getSaidaApiTefC().getRetorno() == 0) {
            String cupom2;
            File fileCupom2;
            processReimpressao.getApitef().getCupom();
            Contexto.getContexto().getEntradaApiTefC().setNumeroTransacao(0);
            ConfCTFClient confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
            IdentTerminal identTerminal = new IdentTerminal(confCTFClient.getEstabelecimento(), confCTFClient.getLoja(), confCTFClient.getTerminal());
            String path = identTerminal.getEstabelecimento().substring(1) + identTerminal.getLoja() + "." + identTerminal.getTerminal() + File.separator;
            if (ControladorConfCTFClient.getDiretorioTrabalho() != null) {
                path = ControladorConfCTFClient.getDiretorioTrabalho() + path;
            }
            String cupom3 = path + "CUPOMCTF.3" + StringUtil.completaString(entradaIntegracao.getNumeroTransacao() + "", 2, '0', 3);
            File fileCupom3 = new File(cupom3);
            String cupom1 = path + "CUPOMCTF.1" + StringUtil.completaString(entradaIntegracao.getNumeroTransacao() + "", 2, '0', 3);
            File fileCupom1 = new File(cupom1);
            if (fileCupom1.exists()) {
                this.copiaCupom(fileCupom1, fileCupom3);
            }
            if ((fileCupom2 = new File(cupom2 = path + "CUPOMCTF.2" + StringUtil.completaString(entradaIntegracao.getNumeroTransacao() + "", 2, '0', 3))).exists()) {
                String cupom4 = path + "CUPOMCTF.4" + StringUtil.completaString(entradaIntegracao.getNumeroTransacao() + "", 2, '0', 3);
                File fileCupom4 = new File(cupom4);
                this.copiaCupom(fileCupom2, fileCupom4);
            }
        }
        return processReimpressao.getState();
    }

    private void copiaCupom(File cupom, File novoCupom) {
        FileReader in = null;
        FileWriter out = null;
        try {
            int c;
            in = new FileReader(cupom);
            if (cupom.exists() && !cupom.delete()) {
                this.logger.warn("N\u00e3o foi poss\u00edvel remover o arquivo " + cupom.getAbsolutePath());
            }
            out = new FileWriter(novoCupom);
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.close();
            in = null;
            out = null;
        }
        catch (IOException e) {
            this.logger.warn("N\u00e3o foi poss\u00edvel copiar o cupom: " + e.getMessage());
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e2) {
                this.logger.warn("N\u00e3o foi poss\u00edvel fechar o arquivo de origem do cupom: " + e2.getMessage());
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e2) {
                this.logger.warn("N\u00e3o foi poss\u00edvel fechar o arquivo de destino do cupom: " + e2.getMessage());
            }
        }
    }

    private boolean testaComunicacaoCTF(Process dados) {
        String terminalOriginal = Contexto.getContexto().getEntradaIntegracao().getIdentTerminal().getTerminal();
        Contexto.getContexto().getEntradaIntegracao().getIdentTerminal().setTerminal("ZZZ");
        Contexto.getContexto().getEntradaIntegracao().setMultiTerminal(true);
        ProcessManager processManager = ProcessManager.getInstance();
        boolean retorno = false;
        ProcessPing processPing = new ProcessPing(dados.getProcessConstructorArguments());
        processPing.setParent(dados);
        try {
            processManager.subProcess(dados.getIdProcess(), processPing);
            if (Contexto.getContexto().getSaidaApiTefC().getRetorno() != 1 && Contexto.getContexto().getSaidaApiTefC().getRetorno() != 10) {
                retorno = true;
            }
        }
        catch (Exception e) {
            this.logger.warn("Erro ao definir subprocesso: " + e.getMessage());
        }
        Contexto.getContexto().getEntradaIntegracao().setMultiTerminal(false);
        Contexto.getContexto().getEntradaIntegracao().getIdentTerminal().setTerminal(terminalOriginal);
        return retorno;
    }
}

