/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.util.apitef.ParcelUtils;
import br.com.auttar.util.exceptions.InvalidCtfDataException;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessConstructorArguments;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessSimulacaoCrediarioCredito;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;

public class MicSubProcessSimulacaoCrediario
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    public static final String ERROR_IGNORED = "ERROR_IGNORED";
    public static final String UNNECESSARY = "UNNECESSARY";

    @Override
    public String derivedExecute(Process processo) throws ExcecaoNaoLocal {
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        try {
            int minimumParcels = ParcelUtils.getMininumParcels(saidaApiTefC);
            int maximumParcels = ParcelUtils.getMaximumParcels(saidaApiTefC);
            if (minimumParcels <= 0 && maximumParcels <= 0) {
                this.logger.info("N\u00famero de parcelas (SC0499) enviado zerado ou negativo, pulando simula\u00e7\u00e3o");
                return UNNECESSARY;
            }
        }
        catch (InvalidCtfDataException e) {
            this.logger.info("Pulando simula\u00e7\u00e3o de credi\u00e1rio: " + e.getMessage());
            return UNNECESSARY;
        }
        this.logger.info("Executando o subprocesso simula\u00e7\u00e3o de credi\u00e1rio");
        ProcessSimulacaoCrediarioCredito subprocesso = this.createProcessSimulacaoCrediarioCredito(processo.getProcessConstructorArguments());
        ProcessManager.getInstance().subProcess(processo.getIdProcess(), subprocesso);
        Contexto.getContexto().setTipoOperacao(Contexto.getContexto().getTipoOperacao());
        if (subprocesso.getState() == 3) {
            return USER_CANCEL;
        }
        if (subprocesso.getState() == 1) {
            if (saidaApiTefC.isCriticarRetornoConsulta()) {
                return ERROR;
            }
            return ERROR_IGNORED;
        }
        if (subprocesso.getState() == 5) {
            return USER_CANCEL_INTERNAL;
        }
        Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
        return SUCCESS;
    }

    protected ProcessSimulacaoCrediarioCredito createProcessSimulacaoCrediarioCredito(ProcessConstructorArguments args) {
        return new ProcessSimulacaoCrediarioCredito(args);
    }
}

