/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessPixQuery;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;

public class MicSubProcessPixQuery
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String UNNECESSARY = "UNNECESSARY";
    private static final String CONFIRMATION_MSG = "TIMEOUT NA COMUNICACAO DESTE PIX. DESEJA CONSULTA-LO NOVAMENTE?";
    private static final int CTF_TIMEOUT_CODE = 1;
    private static final int CTF_COMMUNICATION_ERROR_CODE = 10;

    @Override
    public String derivedExecute(Process processData) throws ExcecaoNaoLocal {
        if (Contexto.getContexto().getSaidaApiTefC() == null) {
            this.logger.info("Nao existe dados da transacao anterior, pulando consulta.");
            return ERROR;
        }
        int returnCode = Contexto.getContexto().getSaidaApiTefC().getRetorno();
        if (returnCode != 1 && returnCode != 10) {
            this.logger.info("Nao executando consulta em transacao rejeitada.");
            return UNNECESSARY;
        }
        boolean userConfirmation = processData.getPerifericos().perguntaSimNao(processData, CONFIRMATION_MSG);
        if (!userConfirmation) {
            this.logger.info("Usuario negou a consulta da operacao pix.");
            return UNNECESSARY;
        }
        ProcessPixQuery processPixQuery = new ProcessPixQuery(processData.getProcessConstructorArguments());
        ProcessManager processManager = ProcessManager.getInstance();
        processManager.subProcess(processPixQuery.getIdProcess(), processPixQuery);
        if (processPixQuery.getState() == 0 && Contexto.getContexto().getSaidaApiTefC().getRetorno() == 0) {
            return SUCCESS;
        }
        return ERROR;
    }
}

