/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.EMVResponseCode;
import br.com.auttar.model.constants.MotiveCvv;
import br.com.auttar.util.emv.PinpadPasswordMessageFormatter;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.TabelaCriptografia;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessLeituraPin;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.ControladorModeloPinPad;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.operacoes.model.RegistroCriptografia;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.tools.devices.emv.DadoSolicitaPin;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.services.exceptions.ExcecaoLocal;
import com.csi.ctfclient.tools.util.CriptografiaUtil;
import com.csi.ctfclient.tools.util.StringUtil;
import java.math.BigDecimal;

public class MicSubProcessLeituraPin
extends MicAbstractBase {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String USERCANCEL_INTERNAL = "USERCANCEL_INTERNAL";
    public static final String NOTREQUIRED = "NOTREQUIRED";
    private static final String CVV2_ALREADY_READ = "CVV2_ALREADY_READ";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        Criptografia criptografia;
        int indiceCriptografia;
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        PinEMV pin = this.tryGetPin();
        if (!saida.isPedeSenha() || pin == null) {
            return NOTREQUIRED;
        }
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        TabelaCriptografia tabelaCriptografia = ControladorCriptografia.getTabelaCriptografia();
        RegistroCriptografia registroCriptografia = tabelaCriptografia.getCriptografiaSenhaPrincipal();
        if (saida.isPedeSenhaOpcional() && !entradaApiTefC.isCvv2Blank() && entradaApiTefC.getCvv2().getMotivo() != MotiveCvv.INSISTENT.getValue() && entradaApiTefC.getCvv2().getMotivo() != MotiveCvv.ILLEGIBLE.getValue()) {
            return CVV2_ALREADY_READ;
        }
        int modoCriptografia = registroCriptografia.getAlgoritmo();
        String workingKey = StringUtil.completaString(registroCriptografia.getWorkingKey().trim(), 32, '0', false);
        int n = indiceCriptografia = registroCriptografia.getIndiceMasterKey() == 42 ? 0 : registroCriptografia.getIndiceMasterKey();
        if (indiceCriptografia == 0 && !saida.isChaveAuttarWkAutorizadora()) {
            ControladorModeloPinPad controlador = ControladorModeloPinPad.getInstance();
            try {
                criptografia = controlador.getCriptografia(pin);
            }
            catch (ExcecaoLocal excecaoLocal) {
                this.logger.error("Erro ao definir tipo de criptografia do pinpad: " + excecaoLocal.getCodigoMensagem());
                return ERRO;
            }
        } else {
            criptografia = new Criptografia(modoCriptografia, indiceCriptografia, workingKey, saida.isChaveAuttarWkAutorizadora());
        }
        BigDecimal valorTotal = entradaApiTefC.getValorTransacao();
        if (entradaApiTefC.getValorTaxaEmbarque() != null) {
            valorTotal = valorTotal.add(entradaApiTefC.getValorTaxaEmbarque());
        }
        if (entradaApiTefC.getValorTaxaServico() != null) {
            valorTotal = valorTotal.add(entradaApiTefC.getValorTaxaServico());
        }
        if (Contexto.getContexto().getPlano() != null && Contexto.getContexto().getPlano() == Plano.AVISTA && entradaApiTefC.getValorCashBack() != null) {
            valorTotal = valorTotal.add(entradaApiTefC.getValorCashBack());
        }
        PinpadPasswordMessageFormatter formatter = new PinpadPasswordMessageFormatter();
        String msgDisplay = formatter.passwordMessage(valorTotal, saida.getMensagemSenhaPinpad(), Contexto.getContexto().getTrnAmountType());
        DadoSolicitaPin[] dadoSolicitaPins = new DadoSolicitaPin[]{new DadoSolicitaPin(4, 12, msgDisplay, 0)};
        ProcessManager processManager = ProcessManager.getInstance();
        boolean possuiChaveContingencia = CriptografiaUtil.possuiChaveContingencia(registroCriptografia, tabelaCriptografia.getCriptografiaSenhaContingencia());
        ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(dados.getProcessConstructorArguments(), criptografia, dadoSolicitaPins, true, possuiChaveContingencia);
        processLeituraPin.setActiveDialogUserCancel(false);
        processManager.subProcess(dados.getIdProcess(), processLeituraPin);
        if (processLeituraPin.getState() == 3) {
            return USERCANCEL;
        }
        if (processLeituraPin.getState() == 1) {
            if (Contexto.getContexto().getErrorCode() == EMVResponseCode.PP_ERRPIN.getId().intValue() && possuiChaveContingencia) {
                CriptografiaUtil.utilizaCriptografiaContingenciaSenha(tabelaCriptografia, this.logger);
                CriptografiaUtil.atualizarUsoRestritoCriptografia(tabelaCriptografia, this.logger);
                Contexto.getContexto().setErroIntegracao(null);
                Contexto.getContexto().setErrorCode(-1);
                return "RERUN";
            }
            return ERRO;
        }
        if (processLeituraPin.getState() == 5) {
            return USERCANCEL_INTERNAL;
        }
        PinInfo pinInfo = Contexto.getContexto().getPinInfo();
        entradaApiTefC.setSenha(pinInfo.getPinCriptografado());
        entradaApiTefC.setNumeroSerieChaveSenha(pinInfo.getNumeroSerieChaveDUKPT());
        entradaApiTefC.setSenhaOfflineChip(pinInfo.isVerificadoOffline());
        entradaApiTefC.setAssinaturaChip(pinInfo.isRequerAssinatura());
        entradaApiTefC.setMasterKeyIndex(tabelaCriptografia.getCriptografiaSenhaPrincipal().getIndiceMasterKey());
        entradaApiTefC.setIndiceWorkingKey(tabelaCriptografia.getCriptografiaSenhaPrincipal().getIndiceWorkingKey());
        entradaApiTefC.setMetodoCriptografiaSenha(tabelaCriptografia.getCriptografiaSenhaPrincipal().getAlgoritmo());
        if (tabelaCriptografia.getCriptografiaDadosPrincipal() != null) {
            entradaApiTefC.setMetodoCriptografiaDados(tabelaCriptografia.getCriptografiaDadosPrincipal().getAlgoritmo());
        }
        return SUCESS;
    }
}

