/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.EMVResponseCode;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.TabelaCriptografia;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessGoOnChip;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.operacoes.model.RegistroCriptografia;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.util.CriptografiaUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.math.BigDecimal;

public class MicSubProcessGoOnChip {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String ERROR_FALLBACK = "ERROR_FALLBACK";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String USERCANCEL_INTERNAL = "USERCANCEL_INTERNAL";
    public static final String NOTREQUIRED = "NOTREQUIRED";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        if (!saida.isCapturaDadosChip()) {
            return NOTREQUIRED;
        }
        TabelaCriptografia tabelaCriptografia = ControladorCriptografia.getTabelaCriptografia();
        RegistroCriptografia registroCriptografia = tabelaCriptografia.getCriptografiaSenhaPrincipal();
        int modoCriptografia = registroCriptografia.getAlgoritmo();
        String workingKey = registroCriptografia.getWorkingKey();
        int indiceCriptografia = registroCriptografia.getIndiceMasterKey() == 42 ? 0 : registroCriptografia.getIndiceMasterKey();
        Criptografia criptografia = new Criptografia(modoCriptografia, indiceCriptografia, workingKey);
        BigDecimal valorTotal = entradaApiTefC.getValorTransacao();
        BigDecimal valorSaque = new BigDecimal(0);
        if (Contexto.getContexto().getCartao() != Cartao.CONTACTLESS_EMV) {
            if (entradaApiTefC.getValorTaxaServico() != null) {
                valorTotal = valorTotal.add(entradaApiTefC.getValorTaxaServico());
            }
            if (saida.isEnviaTaxaEmbarqueGoOnChip() && entradaApiTefC.getValorTaxaEmbarque() != null) {
                valorTotal = valorTotal.add(entradaApiTefC.getValorTaxaEmbarque());
            }
        }
        if (Contexto.getContexto().getPlano() != null && Contexto.getContexto().getPlano() == Plano.AVISTA && entradaApiTefC.getValorCashBack() != null) {
            if (Contexto.getContexto().getCartao() != Cartao.CONTACTLESS_EMV) {
                valorTotal = valorTotal.add(entradaApiTefC.getValorCashBack());
            }
            valorSaque = entradaApiTefC.getValorCashBack();
        }
        boolean possuiChaveContingencia = CriptografiaUtil.possuiChaveContingencia(registroCriptografia, tabelaCriptografia.getCriptografiaSenhaContingencia());
        possuiChaveContingencia = false;
        ProcessGoOnChip processGoOnChip = new ProcessGoOnChip(dados.getProcessConstructorArguments(), criptografia, valorTotal, valorSaque, possuiChaveContingencia);
        processGoOnChip.setActiveDialogUserCancel(false);
        ProcessManager manager = ProcessManager.getInstance();
        manager.subProcess(dados.getIdProcess(), processGoOnChip);
        if (processGoOnChip.getState() == 3) {
            Contexto.getContexto().setRemoveCardMessage(InternacionalizacaoUtil.getInstance().getMessage(MessageEnum.REMCAR_PINPAD_CANCEL));
            return USERCANCEL;
        }
        if (processGoOnChip.getState() == 1) {
            if (saida != null && saida.isPermiteFallbackGoonchip() && (Contexto.getContexto().getErrorCode() == EMVResponseCode.PP_SAMERR.getId().intValue() || Contexto.getContexto().getErrorCode() == EMVResponseCode.PP_DUMBCARD.getId().intValue() || Contexto.getContexto().getErrorCode() == EMVResponseCode.PP_ERRCARD.getId().intValue() || Contexto.getContexto().getErrorCode() == EMVResponseCode.PP_CARDAPPNAV.getId().intValue() || Contexto.getContexto().getErrorCode() == EMVResponseCode.PPC_ERRFALBACK.getId().intValue())) {
                Contexto.getContexto().resetCartao();
                Contexto.getContexto().setSaidaApiTefC(null);
                Contexto.getContexto().setPlano(null);
                entradaApiTefC.setValorCashBack(null);
                entradaApiTefC.setValorTaxaEmbarque(null);
                entradaApiTefC.setValorTaxaServico(null);
                entradaApiTefC.setNumeroCiclos(-1);
                entradaApiTefC.setCodigoAutorizacao(null);
                entradaApiTefC.setCodigoVoucherCtah(null);
                return ERROR_FALLBACK;
            }
            if (Contexto.getContexto().getErrorCode() == EMVResponseCode.PP_ERRPIN.getId().intValue() && possuiChaveContingencia) {
                CriptografiaUtil.utilizaCriptografiaContingenciaSenha(tabelaCriptografia, logger);
                Contexto.getContexto().setErroIntegracao(null);
                Contexto.getContexto().setErrorCode(-1);
                return "RERUN";
            }
            return ERRO;
        }
        if (processGoOnChip.getState() == 5) {
            Contexto.getContexto().setRemoveCardMessage(InternacionalizacaoUtil.getInstance().getMessage(MessageEnum.REMCAR_PINPAD_CANCEL));
            return USERCANCEL_INTERNAL;
        }
        PinInfo pinInfo = Contexto.getContexto().getPinInfo();
        entradaApiTefC.setSenhaOfflineChip(pinInfo.isVerificadoOffline());
        entradaApiTefC.setAssinaturaChip(pinInfo.isRequerAssinatura());
        entradaApiTefC.setChipBloqueadoOffline(pinInfo.isOfflineBloqueado());
        entradaApiTefC.setDecisaoChip(pinInfo.getDecisaoTomada());
        entradaApiTefC.setDadosChip(pinInfo.getDadosCampo55());
        if (pinInfo.isCapturadoVerificacaoOnline()) {
            entradaApiTefC.setSenha(pinInfo.getPinCriptografado());
            entradaApiTefC.setNumeroSerieChaveSenha(pinInfo.getNumeroSerieChaveDUKPT());
        }
        Contexto.getContexto().setTagsMandatorias(saida.getGoOnChipMandatoryTags());
        if (tabelaCriptografia != null) {
            entradaApiTefC.setMasterKeyIndex(tabelaCriptografia.getCriptografiaSenhaPrincipal().getIndiceMasterKey());
            entradaApiTefC.setIndiceWorkingKey(tabelaCriptografia.getCriptografiaSenhaPrincipal().getIndiceWorkingKey());
            entradaApiTefC.setMetodoCriptografiaSenha(tabelaCriptografia.getCriptografiaSenhaPrincipal().getAlgoritmo());
            if (tabelaCriptografia.getCriptografiaDadosPrincipal() != null) {
                entradaApiTefC.setMetodoCriptografiaDados(tabelaCriptografia.getCriptografiaDadosPrincipal().getAlgoritmo());
            }
        }
        return SUCESS;
    }
}

