/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessCartaoPrepago;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.contexto.ContextoCTFClient;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.CTFClientCore;

public class MicSubProcessCartaoPrePago {
    public static final String SUCCESS = "SUCCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String ERROR = "ERROR";
    public static final String USERCANCEL = "USERCANCEL";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) {
        ContextoCTFClient contexto = Contexto.getContexto();
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().getOperacao() == OperationEnum.OP_ATIVACAO_PRE_AUTORIZACAO_CARTAO_PREPAGO.getKey().intValue() && contexto.isSubFluxoConsulta()) {
            ProcessCartaoPrepago processCartaoPrepago = new ProcessCartaoPrepago(dados.getProcessConstructorArguments(), false, contexto.getEntradaIntegracao());
            try {
                ProcessManager processManager = ProcessManager.getInstance();
                processManager.subProcess(processCartaoPrepago.getIdProcess(), processCartaoPrepago);
                if (processCartaoPrepago.getState() == 3) {
                    return USERCANCEL;
                }
                if (processCartaoPrepago.getState() == 1) {
                    return ERROR;
                }
                return SUCCESS;
            }
            catch (Exception e) {
                logger.error("Erro durante a execucao do subprocesso de cartao prepago: " + e.getMessage());
                if (Contexto.getContexto().getErroIntegracao() == null) {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.TENTE_NOVAMENTE, "TENTE NOVAMENTE"));
                }
                return ERROR;
            }
        }
        return UNECESSARY;
    }
}

