/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.model.InformacoesAdicionais;
import com.csi.ctfclient.apitef.model.TabelaCriptografia;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.excecoes.InformacaoInvalidaException;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessLeituraPin;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.microoperacoes.UserCancelException;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.operacoes.model.RegistroCriptografia;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.DadoSolicitaPin;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.util.CpfUtil;
import com.csi.ctfclient.tools.util.CriptografiaUtil;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class MicSubProcessCapturaInformacoesAdicionais
extends MicAbstractBase {
    public static final String SUCESS = "SUCESS";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    public static final String ERROR = "ERROR";
    private static final String ZERO_LENGTH = "ZERO_LENGTH";
    private static final String TECLA_VOLTA = "TECLA_VOLTA";
    private final InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        ControladorPerifericos perifericos = dados.getPerifericos();
        List<InformacoesAdicionais> listInformacoesAdicionais = this.getListInformacoesAdicionaisSaida();
        int ordemCaptura = Contexto.getContexto().getOrdemCapturaInformacaoAdicional();
        listInformacoesAdicionais = this.filtrarListPorOrdemCaptura(listInformacoesAdicionais, ordemCaptura);
        for (InformacoesAdicionais informacoesAdicionais : listInformacoesAdicionais) {
            if (this.getListInformacoesAdicionaisEntrada() != null && !this.getListInformacoesAdicionaisEntrada().isEmpty() && this.getListInformacoesAdicionaisEntrada().contains(informacoesAdicionais)) {
                this.logger.info("execute :: Informa\u00e7\u00e3o j\u00e1 capturada: " + informacoesAdicionais);
                continue;
            }
            boolean continuaLendo = true;
            while (continuaLendo) {
                try {
                    String dadoDigitadoConfirmacao;
                    String dadoDigitado = this.capturaDadoAdicional(perifericos, informacoesAdicionais, dados);
                    if (dadoDigitado.equals(USER_CANCEL)) {
                        return USER_CANCEL;
                    }
                    if (dadoDigitado.equals(USER_CANCEL_INTERNAL)) {
                        return USER_CANCEL_INTERNAL;
                    }
                    if (informacoesAdicionais.isDuplaDigitacao() && !dadoDigitado.equals(dadoDigitadoConfirmacao = this.capturaDadoAdicional(perifericos, informacoesAdicionais, dados))) {
                        LayoutDisplay displayModel = new LayoutDisplay(this.inter.getMessage(MessageEnum.CAPINFADI_INVALID_DATA), ControladorConfCTFClient.TIME_OUT_DELAY);
                        perifericos.imprimeDisplay(displayModel);
                        continue;
                    }
                    informacoesAdicionais.setTamanhoInformacaoAdicional(dadoDigitado.length());
                    informacoesAdicionais.setMensagemInformacaoAdicional(dadoDigitado);
                    continuaLendo = false;
                }
                catch (InformacaoInvalidaException e) {
                    LayoutDisplay displayModel = new LayoutDisplay(e.getMensagemDisplay(), ControladorConfCTFClient.TIME_OUT_DELAY);
                    perifericos.imprimeDisplay(displayModel);
                }
                catch (IllegalArgumentException e) {
                    if (e.getMessage().equals(ZERO_LENGTH)) {
                        if (informacoesAdicionais.getTamanhoMinimo() != 0) continue;
                        informacoesAdicionais.setTamanhoInformacaoAdicional(0);
                        informacoesAdicionais.setMensagemInformacaoAdicional("");
                        continuaLendo = false;
                        continue;
                    }
                    if (!e.getMessage().equals(TECLA_VOLTA)) continue;
                    return USER_CANCEL;
                }
            }
        }
        if (this.getListInformacoesAdicionaisEntrada() != null && !this.getListInformacoesAdicionaisEntrada().isEmpty()) {
            this.getListInformacoesAdicionaisEntrada().addAll(listInformacoesAdicionais);
        } else {
            this.setListInformacoesAdicionaisEntrada(listInformacoesAdicionais);
        }
        if (!listInformacoesAdicionais.isEmpty()) {
            return SUCESS;
        }
        return NOT_REQUIRED;
    }

    private String capturaDadoAdicional(ControladorPerifericos perifericos, InformacoesAdicionais informacoesAdicionais, Process dados) throws IllegalArgumentException, ExcecaoNaoLocal {
        String mascaraTamanhoMaximo;
        LayoutDisplay displayModel;
        this.logger.info("execute :: capturaDadoAdicional :: Informa\u00e7\u00f5es Adicionais: " + informacoesAdicionais);
        if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_BOOLEANO)) {
            LayoutMenu menu = new LayoutMenu(informacoesAdicionais.getMensagemDisplay(), true);
            menu.addItem(new ItemMenu("SIM", "1"));
            menu.addItem(new ItemMenu("NAO", "2"));
            int resultado = perifericos.imprimeMenu(menu);
            this.logger.debug("execute :: capturaDadoAdicional :: resultado: " + resultado);
            switch (resultado) {
                case -1: {
                    return USER_CANCEL;
                }
                case 1: {
                    return "1";
                }
                case 2: {
                    return "0";
                }
            }
            return ERROR;
        }
        if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_MENU_SELECAO)) {
            try {
                return this.capturaDadoAdicionalMenuSelecao(perifericos, informacoesAdicionais);
            }
            catch (UserCancelException e) {
                return USER_CANCEL;
            }
        }
        if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_PINPAD)) {
            try {
                return this.capturaDadoAdicionalPinpad(perifericos, informacoesAdicionais, dados);
            }
            catch (UserCancelException e) {
                return USER_CANCEL_INTERNAL;
            }
            catch (Exception e) {
                this.logger.error("Erro durante a captura de dado adicional do pinpad: " + e.getMessage());
                return ERROR;
            }
        }
        ConstantesApiAc.TipoCampo tipoCampo = null;
        if (informacoesAdicionais.getMensagemDisplay().indexOf("#") > 0) {
            String[] linhasSplit;
            ArrayList<Linha> titulosDisplay = new ArrayList<Linha>();
            for (String linhaString : linhasSplit = informacoesAdicionais.getMensagemDisplay().split("#")) {
                titulosDisplay.add(new Linha(linhaString));
            }
            displayModel = new LayoutDisplay(titulosDisplay);
        } else {
            displayModel = new LayoutDisplay(informacoesAdicionais.getMensagemDisplay());
        }
        boolean mascaraSenha = false;
        ConstantesApiAc.TipoCampo mascara = ConstantesApiAc.CAP_INFORMACOES_ADICIONAIS;
        if (informacoesAdicionais.getTamanhoMinimo() == 0 && informacoesAdicionais.getTamanhoMaximo() == 0) {
            mascara = ConstantesApiAc.CAP_INFORMACOES_ADICIONAIS_VAZIA;
        }
        if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_NUMERICO)) {
            tipoCampo = new ConstantesApiAc.TipoCampo(mascara.getCodigo(), mascara.getDescricao(), this.getMascaraNumerico(informacoesAdicionais.getTamanhoMaximo()));
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_INTEIRO) || informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_KEYBOARD_POS)) {
            mascaraTamanhoMaximo = "";
            if (informacoesAdicionais.getTamanhoMaximo() > 0) {
                mascaraTamanhoMaximo = StringUtil.completaString("Z", informacoesAdicionais.getTamanhoMaximo(), 'Z', 4);
            }
            tipoCampo = new ConstantesApiAc.TipoCampo(mascara.getCodigo(), mascara.getDescricao(), mascaraTamanhoMaximo);
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_DATA)) {
            tipoCampo = new ConstantesApiAc.TipoCampo(mascara.getCodigo(), mascara.getDescricao(), "99//99//9999");
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_DATA_DD_MM_AA)) {
            tipoCampo = new ConstantesApiAc.TipoCampo(mascara.getCodigo(), mascara.getDescricao(), "#D9#D9//#M9#M9//#A9#A9");
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_DATA_DD_MM)) {
            tipoCampo = new ConstantesApiAc.TipoCampo(mascara.getCodigo(), mascara.getDescricao(), "#D9#D9//#M9#M9");
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_DATA_MM_AA)) {
            tipoCampo = new ConstantesApiAc.TipoCampo(mascara.getCodigo(), mascara.getDescricao(), "#M9#M9//#A9#A9");
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_ALFA_NUMERICO) || informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_GENERICO)) {
            mascaraTamanhoMaximo = "";
            if (informacoesAdicionais.getTamanhoMaximo() > 0) {
                mascaraTamanhoMaximo = StringUtil.completaString("@", informacoesAdicionais.getTamanhoMaximo(), '@', 4);
            }
            tipoCampo = new ConstantesApiAc.TipoCampo(mascara.getCodigo(), mascara.getDescricao(), mascaraTamanhoMaximo);
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_ALFA_NUMERICO_SIMBOLO)) {
            mascaraTamanhoMaximo = "";
            if (informacoesAdicionais.getTamanhoMaximo() > 0) {
                mascaraTamanhoMaximo = StringUtil.completaString("&", informacoesAdicionais.getTamanhoMaximo(), '&', 4);
            }
            tipoCampo = new ConstantesApiAc.TipoCampo(mascara.getCodigo(), mascara.getDescricao(), mascaraTamanhoMaximo);
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_NUMERICO_TRES_CASAS_DECIMAIS)) {
            tipoCampo = new ConstantesApiAc.TipoCampo(mascara.getCodigo(), mascara.getDescricao(), this.getMascaraNumerico(informacoesAdicionais.getTamanhoMaximo(), 3));
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_CPF)) {
            tipoCampo = new ConstantesApiAc.TipoCampo(mascara.getCodigo(), mascara.getDescricao(), "ZZZ.ZZZ.ZZZ-ZZ");
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_TELEFONE)) {
            tipoCampo = new ConstantesApiAc.TipoCampo(mascara.getCodigo(), mascara.getDescricao(), "(ZZ)ZZZZ-ZZZZZ");
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_INTEIRO_MASCARADO)) {
            mascaraTamanhoMaximo = "";
            if (informacoesAdicionais.getTamanhoMaximo() > 0) {
                mascaraTamanhoMaximo = StringUtil.completaString("Z", informacoesAdicionais.getTamanhoMaximo(), 'Z', 4);
            }
            tipoCampo = new ConstantesApiAc.TipoCampo(mascara.getCodigo(), mascara.getDescricao(), mascaraTamanhoMaximo);
            mascaraSenha = true;
        }
        this.logger.debug("execute :: capturaDadoAdicional :: tipoCampo: " + tipoCampo);
        EventoTeclado eventoTeclado = tipoCampo != null ? (EventoTeclado)perifericos.capturaDado(displayModel, tipoCampo, true, mascaraSenha) : (EventoTeclado)perifericos.capturaDado(displayModel, mascara, informacoesAdicionais.getTamanhoMaximo());
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            throw new IllegalArgumentException(TECLA_VOLTA);
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String dadoDigitado = eventoTeclado.getStringLida().substring(num);
        this.validaInformacoesAdicionais(informacoesAdicionais, dadoDigitado);
        if (!mascaraSenha) {
            this.logger.info("execute :: capturaDadoAdicional :: eventoTeclado.getStringLida():" + eventoTeclado.getStringLida());
            this.logger.info("execute :: capturaDadoAdicional :: dadoDigitado: " + dadoDigitado);
        }
        return dadoDigitado;
    }

    private void validaInformacoesAdicionais(InformacoesAdicionais informacoesAdicionais, String dadoDigitado) {
        if (dadoDigitado.isEmpty()) {
            throw new IllegalArgumentException(ZERO_LENGTH);
        }
        if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_DATA) || informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_DATA_DD_MM_AA) || informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_DATA_DD_MM) || informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_DATA_MM_AA)) {
            boolean dataValida = MicSubProcessCapturaInformacoesAdicionais.isDataValida(informacoesAdicionais, dadoDigitado);
            if (!dataValida) {
                InformacaoInvalidaException e = new InformacaoInvalidaException();
                e.setMensagemDisplay(this.inter.getMessage(MessageEnum.CAPINFADI_INVALID_DATE));
                throw e;
            }
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_CPF)) {
            if (!CpfUtil.validaCpf(dadoDigitado)) {
                InformacaoInvalidaException e = new InformacaoInvalidaException();
                e.setMensagemDisplay(this.inter.getMessage(MessageEnum.CAPINFADI_INVALID_CPF));
                throw e;
            }
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_TELEFONE)) {
            if (dadoDigitado.length() < 10 || dadoDigitado.length() > 11) {
                InformacaoInvalidaException e = new InformacaoInvalidaException();
                e.setMensagemDisplay(this.inter.getMessage(MessageEnum.CAPINFADI_INVALID_TELEPHONE));
                throw e;
            }
        } else if (dadoDigitado.length() < informacoesAdicionais.getTamanhoMinimo()) {
            InformacaoInvalidaException e = new InformacaoInvalidaException();
            e.setMensagemDisplay(this.inter.getMessage(MessageEnum.CAPINFADI_INVALID_SIZE));
            throw e;
        }
    }

    private static boolean isDataValida(InformacoesAdicionais informacoesAdicionais, String dadoDigitado) {
        boolean dataValida = false;
        SimpleDateFormat df = informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_DATA_DD_MM_AA) ? new SimpleDateFormat("ddMMyy") : (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_DATA_DD_MM) ? new SimpleDateFormat("ddMM") : (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_DATA_MM_AA) ? new SimpleDateFormat("MMyy") : new SimpleDateFormat("ddMMyyyy")));
        df.setLenient(false);
        try {
            df.parse(dadoDigitado);
            dataValida = true;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return dataValida;
    }

    private String getMascaraNumerico(int tamanho, int precisaoDecimal) {
        if (tamanho == 0) {
            return "Z.ZZZ.ZZZ.ZZ9,99";
        }
        StringBuilder mascaraTemp = new StringBuilder();
        for (int i = 0; i < tamanho; ++i) {
            if (i < precisaoDecimal + 1) {
                if (i == precisaoDecimal) {
                    mascaraTemp.insert(0, ",");
                }
                mascaraTemp.insert(0, "9");
                continue;
            }
            if ((i - precisaoDecimal) % 3 == 0) {
                mascaraTemp.insert(0, ".");
            }
            mascaraTemp.insert(0, "Z");
        }
        return mascaraTemp.toString();
    }

    private String getMascaraNumerico(int tamanho) {
        return this.getMascaraNumerico(tamanho, 2);
    }

    private List<InformacoesAdicionais> filtrarListPorOrdemCaptura(List<InformacoesAdicionais> listOriginal, int ordemCaptura) {
        if (ordemCaptura == 0) {
            return listOriginal;
        }
        ArrayList<InformacoesAdicionais> listNova = new ArrayList<InformacoesAdicionais>();
        for (InformacoesAdicionais infoAdic : listOriginal) {
            if (infoAdic.getOrdemCaptura() != ordemCaptura) continue;
            listNova.add(infoAdic);
        }
        return listNova;
    }

    protected List<InformacoesAdicionais> getListInformacoesAdicionaisSaida() {
        return Contexto.getContexto().getSaidaApiTefC().getInformacoesAdicionais();
    }

    protected List<InformacoesAdicionais> getListInformacoesAdicionaisEntrada() {
        return Contexto.getContexto().getEntradaApiTefC().getInformacoesAdicionais();
    }

    protected void setListInformacoesAdicionaisEntrada(List<InformacoesAdicionais> listInformacoesAdicionais) {
        Contexto.getContexto().getEntradaApiTefC().setInformacoesAdicionais(listInformacoesAdicionais);
    }

    private String capturaDadoAdicionalMenuSelecao(ControladorPerifericos perifericos, InformacoesAdicionais informacoesAdicionais) throws ExcecaoNaoLocal, UserCancelException {
        int posPrimeiroDelimitador = informacoesAdicionais.getMensagemDisplay().indexOf("@");
        String tituloCaptura = "";
        String[] opcoesMenu = null;
        if (posPrimeiroDelimitador > 0) {
            tituloCaptura = informacoesAdicionais.getMensagemDisplay().substring(0, posPrimeiroDelimitador).trim();
            opcoesMenu = informacoesAdicionais.getMensagemDisplay().substring(posPrimeiroDelimitador + 1).split("@");
        }
        if (posPrimeiroDelimitador == 0 || opcoesMenu == null || opcoesMenu.length == 0) {
            this.logger.error("Erro ao capturar o menu de sele\u00e7\u00e3o nas informa\u00e7\u00f5es adicionais pois o menu \u00e9 inv\u00e1lido ou vazio.");
            throw new IllegalArgumentException("Lista de operadoras nula");
        }
        LayoutMenu layoutMenu = new LayoutMenu(tituloCaptura, true);
        for (int i = 0; i < opcoesMenu.length; ++i) {
            layoutMenu.addItem(new ItemMenu(opcoesMenu[i].substring(2).trim(), String.valueOf(i + 1)));
        }
        int opcaoSelecionada = perifericos.imprimeMenu(layoutMenu);
        if (opcaoSelecionada == -1) {
            throw new UserCancelException();
        }
        return opcoesMenu[opcaoSelecionada - 1].substring(0, 2);
    }

    private String capturaDadoAdicionalPinpad(ControladorPerifericos perifericos, InformacoesAdicionais informacoesAdicionais, Process dados) throws Exception {
        DadoSolicitaPin[] dadoSolicitaPins = new DadoSolicitaPin[1];
        PinEMV pin = perifericos.getPinpad();
        if (pin == null) {
            this.logger.error("Erro ao habilitar o PINPAD");
            return ERROR;
        }
        pin.setCapturaSenha(true);
        dadoSolicitaPins[0] = new DadoSolicitaPin(informacoesAdicionais.getTamanhoMinimo(), informacoesAdicionais.getTamanhoMaximo(), informacoesAdicionais.getMensagemDisplay(), 0);
        TabelaCriptografia tabelaCriptografia = ControladorCriptografia.getTabelaCriptografia();
        RegistroCriptografia registroCriptografia = tabelaCriptografia.getCriptografiaSenhaPrincipal();
        int modoCriptografia = registroCriptografia.getAlgoritmo();
        String workingKey = StringUtil.completaString(registroCriptografia.getWorkingKey().trim(), 32, '0', false);
        int indiceCriptografia = registroCriptografia.getIndiceMasterKey() == 42 ? 0 : registroCriptografia.getIndiceMasterKey();
        Criptografia criptografia = new Criptografia(modoCriptografia, indiceCriptografia, workingKey, registroCriptografia.isIndiceAuttar());
        ProcessManager processManager = ProcessManager.getInstance();
        boolean possuiChaveContingencia = CriptografiaUtil.possuiChaveContingencia(registroCriptografia, tabelaCriptografia.getCriptografiaSenhaContingencia());
        PinInfo pinInfoAnterior = Contexto.getContexto().getPinInfo();
        DadoSolicitaPin dadoSolicitaPin = dadoSolicitaPins[0];
        DadoSolicitaPin[] solicitaPin = new DadoSolicitaPin[]{dadoSolicitaPin};
        ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(dados.getProcessConstructorArguments(), criptografia, solicitaPin, false, possuiChaveContingencia);
        processLeituraPin.setActiveDialogUserCancel(false);
        processLeituraPin.setTituloAguardaPin(dadoSolicitaPin.getMensagemSolicitacao().trim());
        processManager.subProcess(dados.getIdProcess(), processLeituraPin);
        if (processLeituraPin.getState() == 3) {
            throw new UserCancelException();
        }
        if (processLeituraPin.getState() == 5) {
            throw new UserCancelException();
        }
        if (processLeituraPin.getState() == 1) {
            Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
            return null;
        }
        PinInfo pinInfo = Contexto.getContexto().getPinInfo();
        Contexto.getContexto().setPinInfo(pinInfoAnterior);
        return pinInfo.getPinCriptografado();
    }
}

