/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.ConfirmacaoPositiva;
import com.csi.ctfclient.apitef.model.DadosConfirmacaoPositiva;
import com.csi.ctfclient.apitef.model.TabelaCriptografia;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessLeituraPin;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.operacoes.model.RegistroCriptografia;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.tools.devices.emv.DadoSolicitaPin;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.util.CriptografiaUtil;
import com.csi.ctfclient.tools.util.StringUtil;
import java.util.Iterator;
import java.util.List;

public class MicSubProcessCapturaConfirmacaoPositiva
extends MicAbstractBase {
    public static final String SUCESS = "SUCESS";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String FILLED = "FILLED";
    public static final String ERRO = "ERRO";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        if (entradaApiTefC.getConfirmacaoPositiva() != null && entradaApiTefC.getConfirmacaoPositiva().getPinCriptogravado() != null) {
            return FILLED;
        }
        PinEMV pinEMV = this.tryGetPin();
        if (pinEMV == null) {
            this.logger.error("Erro ao habilitar o PINPAD");
            return ERRO;
        }
        DadosConfirmacaoPositiva dadosConfirmacaoPositiva = saida.getConfirmacaoPositiva();
        List<ConfirmacaoPositiva> listConfirmacaoPositiva = dadosConfirmacaoPositiva.getListConfirmacaoPositiva();
        Iterator<ConfirmacaoPositiva> iterator = listConfirmacaoPositiva.iterator();
        DadoSolicitaPin[] dadoSolicitaPins = new DadoSolicitaPin[listConfirmacaoPositiva.size()];
        int iConfirmacaoPositiva = 0;
        while (iterator.hasNext()) {
            ConfirmacaoPositiva confirmacaoPositiva = iterator.next();
            pinEMV.setCapturaSenha(true);
            dadoSolicitaPins[iConfirmacaoPositiva] = new DadoSolicitaPin(confirmacaoPositiva.getTamanhoMinimo(), confirmacaoPositiva.getTamanhoMaximo(), confirmacaoPositiva.getPrompt(), 0);
            ++iConfirmacaoPositiva;
        }
        if (listConfirmacaoPositiva.size() > 0) {
            TabelaCriptografia tabelaCriptografia = ControladorCriptografia.getTabelaCriptografia();
            RegistroCriptografia registroCriptografia = tabelaCriptografia.getCriptografiaSenhaPrincipal();
            int modoCriptografia = registroCriptografia.getAlgoritmo();
            String workingKey = StringUtil.completaString(registroCriptografia.getWorkingKey().trim(), 32, '0', false);
            int indiceCriptografia = registroCriptografia.getIndiceMasterKey() == 42 ? 0 : registroCriptografia.getIndiceMasterKey();
            Criptografia criptografia = new Criptografia(modoCriptografia, indiceCriptografia, workingKey, registroCriptografia.isIndiceAuttar());
            ProcessManager processManager = ProcessManager.getInstance();
            boolean possuiChaveContingencia = CriptografiaUtil.possuiChaveContingencia(registroCriptografia, tabelaCriptografia.getCriptografiaSenhaContingencia());
            PinInfo pinInfoSenha = Contexto.getContexto().getPinInfo();
            if (dadosConfirmacaoPositiva.getVersao() == 1) {
                String numeroSerieChaveDUKPT = null;
                for (int i = 0; i < dadoSolicitaPins.length; ++i) {
                    DadoSolicitaPin dadoSolicitaPin = dadoSolicitaPins[i];
                    DadoSolicitaPin[] solicitaPin = new DadoSolicitaPin[]{dadoSolicitaPin};
                    ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(dados.getProcessConstructorArguments(), criptografia, solicitaPin, false, possuiChaveContingencia);
                    processLeituraPin.setActiveDialogUserCancel(false);
                    processLeituraPin.setTituloAguardaPin(dadoSolicitaPin.getMensagemSolicitacao().trim());
                    processManager.subProcess(dados.getIdProcess(), processLeituraPin);
                    if (processLeituraPin.getState() == 3) {
                        return USER_CANCEL;
                    }
                    if (processLeituraPin.getState() == 5) {
                        return USER_CANCEL_INTERNAL;
                    }
                    if (processLeituraPin.getState() == 1) {
                        if (processLeituraPin.isUtilizarChaveContingencia()) {
                            return "RERUN";
                        }
                        Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
                        return ERRO;
                    }
                    PinInfo pinInfo = Contexto.getContexto().getPinInfo();
                    if (dadosConfirmacaoPositiva.getPinCriptogravado() == null) {
                        dadosConfirmacaoPositiva.setPinCriptogravado(pinInfo.getPinCriptografado());
                    } else {
                        String pinCriptografado = dadosConfirmacaoPositiva.getPinCriptogravado();
                        if (i < listConfirmacaoPositiva.size()) {
                            pinCriptografado = pinCriptografado + "#";
                        }
                        pinCriptografado = pinCriptografado + pinInfo.getPinCriptografado();
                        dadosConfirmacaoPositiva.setPinCriptogravado(pinCriptografado);
                    }
                    numeroSerieChaveDUKPT = pinInfo.getNumeroSerieChaveDUKPT();
                }
                dadosConfirmacaoPositiva.setNumeroSerieChaveDUKPTConfirmacaoPositiva(numeroSerieChaveDUKPT);
                entradaApiTefC.setConfirmacaoPositiva(dadosConfirmacaoPositiva);
            } else {
                ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(dados.getProcessConstructorArguments(), criptografia, dadoSolicitaPins, false, possuiChaveContingencia);
                processLeituraPin.setActiveDialogUserCancel(false);
                processLeituraPin.setTituloAguardaPin(listConfirmacaoPositiva.get(0).getPrompt().trim());
                processManager.subProcess(dados.getIdProcess(), processLeituraPin);
                if (processLeituraPin.getState() == 3) {
                    return USER_CANCEL;
                }
                if (processLeituraPin.getState() == 5) {
                    return USER_CANCEL_INTERNAL;
                }
                if (processLeituraPin.getState() == 1) {
                    if (processLeituraPin.isUtilizarChaveContingencia()) {
                        return "RERUN";
                    }
                    Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
                    return ERRO;
                }
                PinInfo pinInfo = Contexto.getContexto().getPinInfo();
                dadosConfirmacaoPositiva.setPinCriptogravado(pinInfo.getPinCriptografado());
                dadosConfirmacaoPositiva.setNumeroSerieChaveDUKPTConfirmacaoPositiva(pinInfo.getNumeroSerieChaveDUKPT());
                entradaApiTefC.setConfirmacaoPositiva(dadosConfirmacaoPositiva);
            }
            Contexto.getContexto().setPinInfo(pinInfoSenha);
            return SUCESS;
        }
        return NOT_REQUIRED;
    }
}

