/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.microoperacoes.MicTransacoesSAAUtil;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.math.BigDecimal;

public class MicSolicitacaoTransacoesSAA
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
        PinEMV pinEMV = this.tryGetPin();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        entrada.setCodigoProduto(0);
        entrada.setAcSuportaPlataformaPromocional(config.isAcSuportaPlataformaPromocional());
        entrada.setClientSuportaPlataformaPromocional(true);
        entrada.setOperacao(MicTransacoesSAAUtil.getCodigoTransacao());
        entrada.setValorEntrada(BigDecimal.ZERO);
        this.setDadosEntradaApiTefCFromEntradaIntegracao(dados, entrada);
        this.setInfoEntradaApiTefC(entrada);
        this.setTipoPinEntradaApiTefC(pinEMV, entrada);
        this.setTimeoutCtfEntradaApiTefC(entrada);
        this.setValorTransacaoEntradaApiTefC(entrada);
        dados.getPerifericos().imprimeDisplay(this.createLayoutDisplay());
        this.tryShowMessagePinpad(InternacionalizacaoUtil.getInstance().getMessage(MessageEnum.PROCESS_PINPAD_TITLE));
        SaidaApiTefC saida = dados.getApitef().solicitacao(this.createIdentApiTefC(config), entrada);
        Contexto.getContexto().setSaidaApiTefC(saida);
        if (saida.getRetorno() != 0) {
            this.logger.info("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
            return ERROR;
        }
        return SUCCESS;
    }

    protected void setDadosEntradaApiTefCFromEntradaIntegracao(Process dados, EntradaApiTefC entrada) {
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaIntegracao != null) {
            entrada.setDataCliente(entradaIntegracao.getDataAbertura());
            if (entradaIntegracao.getInfoAdicionais() != null) {
                entrada.setAdicionais(entradaIntegracao.getInfoAdicionais());
            }
            if (entradaIntegracao.isModoEntradaCartaoCtrl()) {
                entrada.setModoEntrada(entradaIntegracao.getModoEntradaCartao());
            }
            if (entradaIntegracao.getTipoProduto() != null) {
                entrada.setTipoProduto(entradaIntegracao.getTipoProduto());
            }
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
    }

    protected void setInfoEntradaApiTefC(EntradaApiTefC entrada) {
        String bit62 = this.getBit62();
        String numeroCartaoFixo = MicTransacoesSAAUtil.formataNumeroCartao(bit62);
        if (numeroCartaoFixo != null && numeroCartaoFixo.length() > 0) {
            entrada.setInfo(numeroCartaoFixo);
        }
    }

    private String getBit62() {
        return Contexto.getContexto().getEntradaIntegracao() != null ? Contexto.getContexto().getEntradaIntegracao().getInfoAdicionais() : null;
    }

    protected IdentApiTefC createIdentApiTefC(ConfCTFClient conf) {
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(conf.getEstabelecimento());
        ident.setNumeroLoja(conf.getLoja());
        ident.setNumeroPdv(conf.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        return ident;
    }

    protected LayoutDisplay createLayoutDisplay() {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO1)));
        displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO2)));
        displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO3)));
        return displayModel;
    }

    protected void setTipoPinEntradaApiTefC(PinEMV pinEMV, EntradaApiTefC entrada) {
        if (pinEMV != null) {
            entrada.setTipoPin("16");
        } else {
            entrada.setTipoPin("**");
        }
    }

    protected void setTimeoutCtfEntradaApiTefC(EntradaApiTefC entrada) {
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        if (saida != null && saida.getTimeOutCTF() > 0) {
            entrada.setTimeoutCtf(saida.getTimeOutCTF());
        } else {
            entrada.setTimeoutCtf(30);
        }
    }

    protected void setValorTransacaoEntradaApiTefC(EntradaApiTefC entrada) {
        String tipoOperacao = Contexto.getContexto().getTipoOperacao();
        if (OperationEnum.OP_CONSULTA_REIMPRESSAO_VALE_TROCA.getDescription().equals(tipoOperacao) || OperationEnum.OP_REIMPRESSAO_VALE_TROCA.getDescription().equals(tipoOperacao) || OperationEnum.OP_CONSULTA_CARTAO_PRESENTE_SAA.getDescription().equals(tipoOperacao) || OperationEnum.OP_CARGA_HABILITACAO_CUPONAGEM.getDescription().equals(tipoOperacao) || OperationEnum.OP_CONSULTA_CUPONAGEM.getDescription().equals(tipoOperacao) || OperationEnum.OP_RESGATE_CUPONAGEM.getDescription().equals(tipoOperacao)) {
            entrada.setValorTransacao(BigDecimal.ONE.movePointLeft(2));
        }
    }
}

