/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicSolicitacaoResgateFidelidadeMilhas {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        ControladorPerifericos periferico = dados.getPerifericos();
        boolean multiTerminal = entradaIntegracao != null && entradaIntegracao.isMultiTerminal();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        entrada.setOperacao(this.getCodigoTransacao(dados));
        if (!multiTerminal) {
            entrada.setTimeoutCtf(saida.getTimeOutCTF());
            MessageEnum msg1 = null;
            MessageEnum msg2 = null;
            MessageEnum msg3 = null;
            if (OperationEnum.OP_CONSULTA_FIDELIDADE_MILHAS.getDescription().equals(Contexto.getContexto().getTipoOperacao()) || OperationEnum.OP_PRECIFICACAO_FIDELIDADE_EM_MILHAS.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
                msg1 = MessageEnum.SOLICITACAO_CONSULTA1;
                msg2 = MessageEnum.SOLICITACAO_CONSULTA2;
                msg3 = MessageEnum.SOLICITACAO_CONSULTA3;
            } else if (OperationEnum.OP_RESGATE_FIDELIDADE_EM_MILHAS.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
                msg1 = MessageEnum.ENVTRA_SOLICITACAO1;
                msg2 = MessageEnum.ENVTRA_SOLICITACAO2;
                msg3 = MessageEnum.ENVTRA_SOLICITACAO3;
            }
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage(msg1)));
            displayModel.addLinha(new Linha(inter.getMessage(msg2)));
            displayModel.addLinha(new Linha(inter.getMessage(msg3)));
            periferico.imprimeDisplay(displayModel);
        }
        saida = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        Contexto.getContexto().setSaidaApiTefC(saida);
        if (saida.getRetorno() != 0) {
            logger.info("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
            return ERROR;
        }
        if (OperationEnum.OP_PRECIFICACAO_FIDELIDADE_EM_MILHAS.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            logger.info("Quantidade de milhas a utilizar: " + saida.getValorMilhas());
            entrada.setValorMilhas(saida.getValorMilhas());
            Contexto.getContexto().setTipoOperacao(OperationEnum.OP_RESGATE_FIDELIDADE_EM_MILHAS.getDescription());
        }
        VerifyContentUtil.preencheDadosSaida(saida);
        return SUCCESS;
    }

    private String getCodigoTransacao(Process dados) {
        if (OperationEnum.OP_CONSULTA_FIDELIDADE_MILHAS.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "6Y";
        }
        if (OperationEnum.OP_PRECIFICACAO_FIDELIDADE_EM_MILHAS.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "6W";
        }
        if (OperationEnum.OP_RESGATE_FIDELIDADE_EM_MILHAS.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "6X";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

