/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ModoEntrada;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.constantes.FormatoCodigoBarrasEnum;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.contexto.TrataLegadoUtil;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.CorrespondenteBancario;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emvfull.KeyFactory;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.util.Objects;

public class MicSolicitacaoPagamentoFaturaCartao
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERRO_TRANS_JA_EFETUADA = "ERRO_TRANS_JA_EFETUADA";
    public static final String ERROR = "ERROR";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        String msg3;
        String msg2;
        String msg1;
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        String codigoTransacao = this.getCodigoTransacao();
        ConfCTFClient confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        int modoEntrada = 0;
        FormatoCodigoBarrasEnum modoEntradaInfo = FormatoCodigoBarrasEnum.INEXISTENTE;
        boolean enviaCampoInfo = true;
        String informacaoPagamento = "";
        this.logger.debug("execute :: identificacaoPagamento: " + entradaApiTefC.getIdentificacaoPagamento());
        if (entradaApiTefC.getIdentificacaoPagamento() == 1) {
            if (Contexto.getContexto().getCartao() != null) {
                this.logger.debug("execute :: getCartao: " + (Object)((Object)Contexto.getContexto().getCartao()));
                modoEntrada = Contexto.getContexto().getCartao().getModoEntrada().getId();
                if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
                    modoEntradaInfo = FormatoCodigoBarrasEnum.CNAB_DIGITADO;
                    informacaoPagamento = entradaApiTefC.getPAN();
                } else {
                    if (!KeyFactory.isChaveLocal()) {
                        enviaCampoInfo = false;
                    }
                    modoEntradaInfo = FormatoCodigoBarrasEnum.CNAB_LIDO;
                    if (entradaApiTefC.getInfo() != null) {
                        informacaoPagamento = entradaApiTefC.getInfo();
                    }
                }
            }
        } else if (entradaApiTefC.getIdentificacaoPagamento() == 2) {
            informacaoPagamento = entradaApiTefC.getCodigoBarras();
            modoEntrada = ModoEntrada.CODIGO_DE_BARRAS.getId();
            modoEntradaInfo = entradaApiTefC.getFormatoCodigoBarrasEnum();
        }
        entradaApiTefC.setModoEntrada(modoEntrada);
        if (enviaCampoInfo) {
            String entradaCorrespondenteBancario = CorrespondenteBancario.montaEntrada(modoEntradaInfo, informacaoPagamento, Contexto.getContexto().getTipoPagamento());
            entradaApiTefC.setInfo(entradaCorrespondenteBancario);
        }
        if (entradaApiTefC.getDataVencimentoCorBan() != null) {
            entradaApiTefC.setDataVencimento(entradaApiTefC.getDataVencimentoCorBan());
        }
        entradaApiTefC.setTimeoutCtf(confCTFClient.getTimeOutDefault());
        entradaApiTefC.setOperacao(codigoTransacao);
        entradaApiTefC.setValorTransacao(TrataLegadoUtil.calculaValorTransacao(dados));
        this.logger.debug("execute :: tipoOperacao: " + Contexto.getContexto().getTipoOperacao());
        if (OperationEnum.OP_CONSULTA_CONVENIO.getDescription().equals(Contexto.getContexto().getTipoOperacao()) || OperationEnum.OP_CONSULTA_FICHA_COMPENSACAO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            msg1 = inter.getMessage(MessageEnum.SOLCORBAN_SOLICITACAO_CONSULTA1);
            msg2 = inter.getMessage(MessageEnum.SOLCORBAN_SOLICITACAO_CONSULTA2);
            msg3 = inter.getMessage(MessageEnum.SOLCORBAN_SOLICITACAO_CONSULTA3);
        } else {
            msg1 = inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO1);
            msg2 = inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO2);
            msg3 = inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO3);
        }
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(msg1));
        displayModel.addLinha(new Linha(msg2));
        displayModel.addLinha(new Linha(msg3));
        periferico.imprimeDisplay(displayModel);
        if (saida.getTimeOutCTF() > 0) {
            entradaApiTefC.setTimeoutCtf(saida.getTimeOutCTF());
        }
        IdentApiTefC ident = Contexto.getContexto().getIdentApiTefC();
        saida = dados.getApitef().solicitacao(ident, entradaApiTefC);
        Contexto.getContexto().setSaidaApiTefC(saida);
        if (saida.getRetorno() != 0) {
            this.logger.info("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
            if (saida.getCodigoRespostaAutorizadora().equals("0ER")) {
                return ERRO_TRANS_JA_EFETUADA;
            }
            return ERROR;
        }
        CorrespondenteBancario correspondenteBancario = CorrespondenteBancario.createCorrespondenteBancario(saida.getAdicionais());
        if (correspondenteBancario != null) {
            this.logger.info("execute :: setCorrespondenteBancario");
            Contexto.getContexto().setCorrespondenteBancario(correspondenteBancario);
        }
        return SUCCESS;
    }

    private String getCodigoTransacao() {
        if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_CONSULTA_FATURA_CARTAO.getDescription())) {
            return "FA";
        }
        if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_CONSULTA_FATURA_CARTAO_DETALHADA.getDescription())) {
            return "7J";
        }
        if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_PAGAMENTO_FATURA_CARTAO.getDescription())) {
            return "FB";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

