/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.CorrespondenteBancario;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.util.CriptografiaOperacoesUtil;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicSolicitacaoPagamentoContas
extends MicAbstractBase {
    public static final String SUCESS = "SUCESS";
    public static final String ERROR = "ERROR";
    public static final String ERRO_TRANS_JA_EFETUADA = "ERRO_TRANS_JA_EFETUADA";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        ControladorPerifericos periferico = dados.getPerifericos();
        ControladorBaixaTecnica conBaixaTecnica = ControladorBaixaTecnica.getInstance();
        String codigoTransacao = this.getCodigoTransacao(dados);
        String entradaCorrespondenteBancario = CorrespondenteBancario.montaEntrada(entrada.getFormatoCodigoBarrasEnum(), entrada.getCodigoBarras(), Contexto.getContexto().getTipoPagamento());
        if (Contexto.getContexto().getTipoPagamento() == 1) {
            entrada.setInfo(entradaCorrespondenteBancario);
            entrada.setTimeoutCtf(saida.getTimeOutCTF());
        } else if (Contexto.getContexto().getTipoPagamento() == 4) {
            entrada.setDadosCorrespondenteBancario(entradaCorrespondenteBancario);
            entrada.setTimeoutCtf(saida.getTimeOutCTF());
            if (Contexto.getContexto().getPlano() == Plano.AVISTA) {
                entrada.setNumeroParcelas(1);
            }
            if (this.tryGetPin() != null && conBaixaTecnica.isBaixaTecnicaSolicitada()) {
                entrada.setFlagBaixaTecnicaVisanet('1');
                entrada.setDadosGeraisPin(conBaixaTecnica.montaDadosGeraisPin());
                entrada.setVersaoAc(ControladorConfCTFClient.getInstance().getConfig().getVersaoAC());
                conBaixaTecnica.persisteBaixaTecnica();
            }
        } else {
            return ERROR;
        }
        entrada.setOperacao(codigoTransacao);
        CriptografiaOperacoesUtil.atualizaEntradaCriptografia(ControladorCriptografia.getTabelaCriptografia());
        entrada.setValorTransacao(entrada.getValorDocumento());
        if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO1)));
            displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO2)));
            displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO3)));
            periferico.imprimeDisplay(displayModel);
        }
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(conf.getEstabelecimento());
        ident.setNumeroLoja(conf.getLoja());
        ident.setNumeroPdv(conf.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        saida = dados.getApitef().solicitacao(ident, entrada);
        if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            Contexto.getContexto().setSaidaApiTefC(saida);
            if (saida.getRetorno() != 0) {
                this.logger.info("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
                if (saida.getCodigoRespostaAutorizadora().equals("0ER")) {
                    return ERRO_TRANS_JA_EFETUADA;
                }
                return ERROR;
            }
            VerifyContentUtil.preencheDadosSaida(saida);
            return SUCESS;
        }
        return SUCESS;
    }

    protected String getCodigoTransacao(Process dados) throws IllegalStateException {
        if (Contexto.getContexto().getTipoPagamento() == 1) {
            if (Contexto.getContexto().getTipoConta() == 2) {
                return "E7";
            }
            if (Contexto.getContexto().getTipoConta() == 1) {
                return "E6";
            }
        } else if (Contexto.getContexto().getTipoPagamento() == 4) {
            return "2P";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encontrada");
    }
}

