/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.DadosTelefone;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicSolicitacaoCreditoDigital {
    public static final String SUCESS = "SUCESS";
    public static final String ERROR = "ERROR";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        boolean otimizacaoAndroid;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        ControladorPerifericos periferico = dados.getPerifericos();
        boolean multiTerminal = entradaIntegracao != null && entradaIntegracao.isMultiTerminal();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        DadosTelefone creditoDigital = new DadosTelefone();
        creditoDigital.setCodigoAutorizadora(entrada.getCodigoAutorizadora());
        if (OperationEnum.OP_COMPRA_CREDITO_DIGITAL.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            if (entrada.isCapturaDigito()) {
                creditoDigital.setDigitoVerificadortelefone(entrada.getDigitoVerificadortelefone());
            }
        } else {
            creditoDigital.setDigitoVerificadortelefone(0);
        }
        creditoDigital.setCodigoUsuarioPdv(entrada.getCodigoUsuarioPdv());
        creditoDigital.setTipoCreditoCompra(entrada.getTipoCreditoCompra());
        creditoDigital.setDdd(entrada.getDdd());
        creditoDigital.setTelefone(entrada.getTelefone());
        creditoDigital.setVersaoLayout(conf.getVersaoLayoutCD());
        entrada.setDadosCreditoDigital(creditoDigital);
        entrada.setOperacao(this.getCodigoTransacao(dados));
        if (entradaIntegracao.isTipoRecargaCelularCtrl()) {
            logger.info("Tipo recarga celular: (" + entradaIntegracao.getTipoRecargaCelular() + ")");
            entrada.setTipoRecargaCelular(entradaIntegracao.getTipoRecargaCelular());
        }
        boolean bl = otimizacaoAndroid = conf.isIntegracaoAndroid() && !conf.isCapturaTelefonePinpad();
        if (!multiTerminal && !otimizacaoAndroid) {
            try {
                SaidaGetInfoEMV getInfo = periferico.getPinpad().getInfo();
                entrada.setNumeroSeriePin(getInfo.getNumSeriePinpad());
                entrada.setRetornoGetInfo(getInfo.getRetorno());
                entrada.setTipoPin("16");
            }
            catch (Exception e) {
                logger.warn("Nao foi possivel carregar as informacoes do pin: " + e.getMessage());
                entrada.setTipoPin("**");
            }
            entrada.setTimeoutCtf(35);
            MessageEnum msg1 = null;
            MessageEnum msg2 = null;
            MessageEnum msg3 = null;
            if (OperationEnum.OP_CONSULTA_VALORES_CREDITO_DIGITAL.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
                msg1 = MessageEnum.SOLCREDIG_SOLICITACAO_CONSULTA1;
                msg2 = MessageEnum.SOLCREDIG_SOLICITACAO_CONSULTA2;
                msg3 = MessageEnum.SOLCREDIG_SOLICITACAO_CONSULTA3;
            } else if (OperationEnum.OP_COMPRA_CREDITO_DIGITAL.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
                msg1 = MessageEnum.ENVTRA_SOLICITACAO1;
                msg2 = MessageEnum.ENVTRA_SOLICITACAO2;
                msg3 = MessageEnum.ENVTRA_SOLICITACAO3;
            }
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage(msg1)));
            displayModel.addLinha(new Linha(inter.getMessage(msg2)));
            displayModel.addLinha(new Linha(inter.getMessage(msg3)));
            periferico.imprimeDisplay(displayModel);
        }
        SaidaApiTefC saida = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        Contexto.getContexto().setSaidaApiTefC(saida);
        saida.setOperadoraTelefonia(creditoDigital.getCodigoAutorizadora());
        saida.setDDD(entrada.getDdd());
        saida.setTelefone(entrada.getTelefone());
        if (saida.getRetorno() != 0) {
            logger.info("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
            return ERROR;
        }
        VerifyContentUtil.preencheDadosSaida(saida);
        return SUCESS;
    }

    private String getCodigoTransacao(Process dados) {
        if (OperationEnum.OP_CONSULTA_VALORES_CREDITO_DIGITAL.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "F4";
        }
        if (OperationEnum.OP_COMPRA_CREDITO_DIGITAL.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "F5";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

