/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.excecoes.TamanhoInvalidoEstabelecimentosMultiEcException;
import com.csi.ctfclient.apitef.model.EstabelecimentoMultiEC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.contexto.ContextoCTFClient;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.DadosEstabelecimentosMultiEC;
import com.csi.ctfclient.operacoes.model.controller.ControladorMultiEC;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.util.ArrayList;
import java.util.List;

public class MicSolicitacaoConsultaEstabelecimentosMultiEC {
    public static final String SUCCESS = "SUCCESS";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String ERROR = "ERROR";
    public static final String ERROR_AC = "ERROR_AC";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        SaidaApiTefC saida;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
        ContextoCTFClient contexto = Contexto.getContexto();
        EntradaCTFClientCtrl entradaIntegracao = contexto.getEntradaIntegracao();
        if (!config.isMultiEC()) {
            return NOT_REQUIRED;
        }
        EntradaApiTefC entrada = new EntradaApiTefC();
        if (entradaIntegracao != null) {
            if (entradaIntegracao.getOperacao() == OperationEnum.OP_CONFIGURACAO_TERMINAL.getKey().intValue() || entradaIntegracao.getOperacao() == OperationEnum.OP_CAPTURA_DADO_PINPAD.getKey().intValue()) {
                return NOT_REQUIRED;
            }
            if (!ControladorMultiEC.isTerminalComumMultiEC(entradaIntegracao.getIdentTerminal())) {
                return NOT_REQUIRED;
            }
        } else {
            return ERROR_AC;
        }
        entrada.setDataCliente(entradaIntegracao.getDataAbertura());
        logger.debug("Apagando lista de Estabelecimentos Multi-EC persistida...");
        ControladorMultiEC.clean();
        ControladorPerifericos periferico = dados.getPerifericos();
        entrada.setOperacao(this.getCodigoTransacao(dados));
        entrada.setMultiEC(config.isMultiEC());
        entrada.setCodigoGrupoMultiEC(config.getCodigoGrupoMultiEC());
        if (config.getTimeOutDefault() > 0) {
            entrada.setTimeoutCtf(config.getTimeOutDefault());
        } else {
            entrada.setTimeoutCtf(15);
        }
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.SOLICITACAO_CONSULTA1)));
        displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.SOLICITACAO_CONSULTA2)));
        displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.SOLICITACAO_CONSULTA3)));
        periferico.imprimeDisplay(displayModel);
        IdentApiTefC ident = Contexto.getContexto().getIdentApiTefC();
        int retries = 0;
        int maxRetries = 3;
        boolean continuaCarga = false;
        int indiceConsulta = 0;
        ArrayList<EstabelecimentoMultiEC> listEstabelecimentos = new ArrayList<EstabelecimentoMultiEC>();
        do {
            entrada.setIndiceCargaTabelaPin(indiceConsulta);
            logger.info("Solicitando consulta de estabelecimentos comerciais sequencial: " + indiceConsulta + ".");
            saida = dados.getApitef().solicitacao(ident, entrada);
            continuaCarga = saida.isSolicitaCargaTabela();
            if (saida.getRetorno() == 0) {
                List<EstabelecimentoMultiEC> listEstabelecimentosMultiEC;
                retries = 0;
                indiceConsulta = saida.getIndiceTabelaPinpad();
                try {
                    listEstabelecimentosMultiEC = saida.getListEstabelecimentosMultiEC();
                }
                catch (TamanhoInvalidoEstabelecimentosMultiEcException e) {
                    String mensagem = e.getMessage() != null ? e.getMessage() : "ERRO AO EFETUAR A CONSULTA DE ESTABELECIMENTOS MULTI-EC";
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_5400, mensagem));
                    return ERROR_AC;
                }
                listEstabelecimentos.addAll(listEstabelecimentosMultiEC);
                displayModel = new LayoutDisplay();
                displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.SOLICITACAO_CONSULTA1)));
                displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.SOLICITACAO_CONSULTA2)));
                displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.SOLICITACAO_CONSULTA3) + " (" + indiceConsulta + ")"));
                periferico.imprimeDisplay(displayModel);
                continue;
            }
            logger.warn("Erro na tentativa da consulta. Efetuando tentativa " + ++retries + " de " + maxRetries + ".");
            continuaCarga = true;
        } while (retries < maxRetries && continuaCarga);
        if (saida.getRetorno() != 0) {
            logger.info("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
            Contexto.getContexto().atualizaEntradaApiTefC(entrada);
            Contexto.getContexto().setSaidaApiTefC(saida);
            return ERROR;
        }
        if (listEstabelecimentos.size() == 0) {
            logger.error("Nenhum terminal foi retornado na Consulta de Estabelecimentos Multi-EC");
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_5400, "NENHUM TERMINAL FOI RETORNADO NA CONSULTA MULTI-EC"));
            return ERROR_AC;
        }
        logger.info("Foram recebidos " + listEstabelecimentos.size() + " terminais Multi-EC");
        DadosEstabelecimentosMultiEC dadosEstabelecimentosMultiEC = new DadosEstabelecimentosMultiEC();
        dadosEstabelecimentosMultiEC.setCodigoGrupo(config.getCodigoGrupoMultiEC());
        dadosEstabelecimentosMultiEC.setListEstabelecimentoMultiECs(listEstabelecimentos);
        ControladorMultiEC controladorEstabelecimentosMultiEC = ControladorMultiEC.getInstance();
        controladorEstabelecimentosMultiEC.setDadosEstabelecimentosMultiEC(dadosEstabelecimentosMultiEC);
        return SUCCESS;
    }

    protected String getCodigoTransacao(Process dados) throws IllegalStateException {
        return "GG";
    }
}

