/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicSolicitacaoConsultaDrogao
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        entrada.setOperacao(this.getCodigoTransacao(dados));
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().getDadosComplementaresTef() != null) {
            entrada.setDadosComplementaresTef(Contexto.getContexto().getEntradaIntegracao().getDadosComplementaresTef());
        }
        if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO1)));
            displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO2)));
            displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO3)));
            periferico.imprimeDisplay(displayModel);
        }
        if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            this.tryShowMessagePinpad(inter.getMessage(MessageEnum.PROCESS_PINPAD_TITLE));
        }
        SaidaApiTefC saida = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            Contexto.getContexto().setSaidaApiTefC(saida);
            if (saida.getRetorno() != 0) {
                this.logger.info("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
                return ERROR;
            }
            VerifyContentUtil.preencheDadosSaida(saida);
            return SUCCESS;
        }
        return SUCCESS;
    }

    protected String getCodigoTransacao(Process dado) throws IllegalStateException {
        if (OperationEnum.OP_CONSULTA_DROGAO_COM_CARTAO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "3R";
        }
        if (OperationEnum.OP_CONSULTA_DROGAO_COM_CPF.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "3S";
        }
        if (OperationEnum.OP_PAGAMENTO_EMS_DROGAO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "3T";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

