/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.Cheque;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.text.DecimalFormat;
import java.util.Calendar;

public class MicSolicitacaoConsultaCheque {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO_TRANS_JA_EFETUADA = "ERRO_TRANS_JA_EFETUADA";
    public static final String ERROR = "ERROR";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        ControladorPerifericos periferico = dados.getPerifericos();
        entrada.setOperacao(this.getCodigoTransacao(dados));
        String documento = "";
        if (entrada.getTipoDocumento() == 1) {
            documento = entrada.getCnpj();
        } else if (entrada.getTipoDocumento() == 2) {
            documento = entrada.getCpf();
        }
        String entradaConsultaCheque = Cheque.montaEntradaConsultaCheque(entrada.getNumeroCheque(), entrada.getBanco(), entrada.getAgencia(), entrada.getTipoDocumento(), documento, entrada.getContaCorrente(), entrada.getPracaCompensacao(), entrada.getDdd(), entrada.getTelefone());
        entrada.setInfo(entradaConsultaCheque);
        entrada.setTimeoutCtf(15);
        DecimalFormat df = new DecimalFormat("00");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(entrada.getDataCheque());
        String strDataCheque = String.valueOf(calendar.get(1)) + df.format(calendar.get(2) + 1) + df.format(calendar.get(5));
        entrada.setAdicionais(strDataCheque);
        if (entrada.getCmc7() != null) {
            entrada.setAdicionais(entrada.getCmc7());
        }
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO1)));
        displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO2)));
        displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO3)));
        periferico.imprimeDisplay(displayModel);
        SaidaApiTefC saida = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        Contexto.getContexto().setSaidaApiTefC(saida);
        if (saida.getRetorno() != 0) {
            logger.info("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
            if (saida.getCodigoRespostaAutorizadora().equals("0ER")) {
                return ERRO_TRANS_JA_EFETUADA;
            }
            return ERROR;
        }
        VerifyContentUtil.preencheDadosSaida(saida);
        return SUCESS;
    }

    private String getCodigoTransacao(Process dados) {
        if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_CONSULTA_CHEQUE.getDescription())) {
            return "16";
        }
        if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_GARANTIA_CHEQUE.getDescription())) {
            return "17";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

