/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.util.EntradaApiTefCUtil;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicSolicitacaoConsultaAnaliticaSpc {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private static final String CONSULTA_CREDITO = "1M";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        entrada.setOperacao(this.getCodigoTransacao(dados));
        ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        if (confCTFClient.getTimeOutDefault() > 0) {
            entrada.setTimeoutCtf(confCTFClient.getTimeOutDefault());
        } else {
            entrada.setTimeoutCtf(15);
        }
        entrada.setTipoPin("**");
        String documento = null;
        if (entrada.getTipoDocumento() == 2) {
            documento = entrada.getCpf();
        } else if (entrada.getTipoDocumento() == 1) {
            documento = entrada.getCnpj();
        }
        EntradaApiTefCUtil entradaApiTefCUtil = new EntradaApiTefCUtil();
        entrada.setInfo(entradaApiTefCUtil.montaInfoConsultaAnaliticaSpc(entrada.getCodigoCliente(), entrada.getTipoDocumento(), documento, entrada.getTipoConsultaCredito(), entrada.getCodigoUsuarioPdv()));
        entrada.setAdicionais(entradaApiTefCUtil.montaBit62ConsultaAnaliticaSpc(entrada.getNomeCliente(), entrada.getDataNascimentoCliente()));
        if (!confCTFClient.isIntegracaoWeb()) {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO1)));
            displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO2)));
            displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO3)));
            periferico.imprimeDisplay(displayModel);
        }
        SaidaApiTefC saida = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        Contexto.getContexto().setSaidaApiTefC(saida);
        if (saida.getRetorno() != 0) {
            logger.info("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
            return ERROR;
        }
        return SUCCESS;
    }

    protected String getCodigoTransacao(Process dado) throws IllegalStateException {
        return CONSULTA_CREDITO;
    }
}

