/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.util.CriptografiaOperacoesUtil;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicSolicitacaoCashPrivateLabel {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String ERRO_TRANS_JA_EFETUADA = "ERRO_TRANS_JA_EFETUADA";
    private static final String TRANSACAO_CASH_FININVEST = "DD";
    private static final String TRANSACAO_CONSULTA_CASH_FININVEST = "DE";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    protected String getCodigoTransacao(Process dados) throws IllegalStateException {
        if (OperationEnum.OP_CASH_PRIVATE_LABEL_ROTATIVO_OU_PARC.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return TRANSACAO_CASH_FININVEST;
        }
        if (OperationEnum.OP_CONSULTA_CASH_PRIVATE_LABEL.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return TRANSACAO_CONSULTA_CASH_FININVEST;
        }
        throw new IllegalStateException("Codigo transa\u00e7\u00e3o n\u00e3o encontrada!");
    }

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO1)));
            displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO2)));
            displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO3)));
            periferico.imprimeDisplay(displayModel);
        }
        entrada.setOperacao(this.getCodigoTransacao(dados));
        CriptografiaOperacoesUtil.atualizaEntradaCriptografia(ControladorCriptografia.getTabelaCriptografia());
        if (entrada.getNumeroParcelas() == -1) {
            entrada.setNumeroParcelas(0);
        }
        SaidaApiTefC saidaApiTefC = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
            if (saidaApiTefC.getRetorno() == 0) {
                VerifyContentUtil.preencheDadosSaida(saidaApiTefC);
                return SUCESS;
            }
            logger.info("Resposta autorizadora: " + saidaApiTefC.getCodigoRespostaAutorizadora());
            if (saidaApiTefC.getCodigoRespostaAutorizadora().equals("0ER")) {
                return ERRO_TRANS_JA_EFETUADA;
            }
            return ERRO;
        }
        return SUCESS;
    }
}

