/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractTrataRetornoPadrao;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import java.math.BigDecimal;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;

public class MicSolicitacaoCartaoPrepago
extends MicAbstractTrataRetornoPadrao {
    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        return super.genericExecute(dados);
    }

    @Override
    protected void initEntradaApiTefC(EntradaApiTefC entradaApiTefC, Process dados) {
        super.initEntradaApiTefC(entradaApiTefC, dados);
        if (Contexto.getContexto().getCartao() == null) {
            entradaApiTefC.setModoEntrada(Contexto.getContexto().getModoEntradaCodigoBarrasCartaoPrepago());
        }
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (BooleanUtils.negate(Objects.isNull(entradaIntegracao)).booleanValue()) {
            if (BooleanUtils.negate(this.isPrePagoValorFixo()).booleanValue()) {
                BigDecimal valorPago;
                SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
                BigDecimal valorBonus = saida.getValorBonus();
                BigDecimal valorAtivacao = saida.getValorAcrescimo();
                BigDecimal valorDesconto = saida.getValorDesconto();
                BigDecimal valorOriginal = valorPago = Contexto.getContexto().getValorCartaoPrePagoVariavel();
                if (BooleanUtils.negate(Objects.isNull(entradaIntegracao.getValorTransacao())).booleanValue()) {
                    if (BooleanUtils.negate(Objects.isNull(valorDesconto)).booleanValue()) {
                        valorOriginal = valorOriginal.add(valorDesconto);
                    }
                    if (BooleanUtils.negate(Objects.isNull(valorAtivacao)).booleanValue()) {
                        valorOriginal = valorOriginal.subtract(valorAtivacao);
                    }
                    if (BooleanUtils.negate(Objects.isNull(valorBonus)).booleanValue()) {
                        valorOriginal = valorOriginal.subtract(valorBonus);
                    }
                    entrada.setValorPrepago(valorOriginal);
                }
                entrada.setValorTransacao(null);
                entrada.setValorPrepago(valorOriginal);
            }
            entrada.setDataCliente(entradaIntegracao.getDataAbertura());
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
    }

    private boolean isPrePagoValorFixo() {
        return Objects.isNull(Contexto.getContexto().getValorCartaoPrePagoVariavel());
    }

    @Override
    protected String getCodigoTransacao(Process dado) {
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaIntegracao.getOperacao() == OperationEnum.OP_ATIVACAO_CARTAO_PREPAGO.getKey().intValue()) {
            return "FG";
        }
        if (entradaIntegracao.getOperacao() == OperationEnum.OP_PRE_AUTORIZACAO_CARTAO_PREPAGO.getKey().intValue()) {
            return "FM";
        }
        if (entradaIntegracao.getOperacao() == OperationEnum.OP_RECARGA_CARTAO_PREPAGO_POSA.getKey().intValue()) {
            return "FR";
        }
        if (entradaIntegracao.getOperacao() == OperationEnum.OP_DESATIVACAO_CARTAO_PREPAGO.getKey().intValue()) {
            return "E9";
        }
        if (entradaIntegracao.getOperacao() == OperationEnum.OP_ATIVACAO_PRE_AUTORIZACAO_CARTAO_PREPAGO.getKey().intValue()) {
            if (Contexto.getContexto().isSubFluxoConsulta()) {
                return "FM";
            }
            return "FG";
        }
        if (entradaIntegracao.getOperacao() == OperationEnum.OP_VENDA_FASTPIN.getKey().intValue()) {
            return "FJ";
        }
        if (entradaIntegracao.getOperacao() == OperationEnum.OP_RETORNO_FASTPIN.getKey().intValue()) {
            return "FL";
        }
        if (entradaIntegracao.getOperacao() == OperationEnum.OP_RESGATE_CARTAO_PREPAGO_POSA.getKey().intValue()) {
            return "FN";
        }
        throw new IllegalStateException("C\u00f3digo da transa\u00e7\u00e3o n\u00e3o encontrado");
    }
}

